;===============================================================;
;                                                               ;
; Alien Breed 5                                                 ;
; Sprite routines                                               ;
;                                                               ;
;===============================================================;

#define BOTTOM_CLIP 64
#define RIGHT_CLIP 96

;------------------------------------------------
; putAlignedSprite - Draw an 8x8 aligned sprite
;------------------------------------------------
putAlignedSprite:
        ld      h,0
        add     hl,hl                           ; x2
        add     hl,hl                           ; x4
        add     hl,hl                           ; x8
        add     hl,hl                           ; x16
        add     hl,hl                           ; x32
        ld      b,h
        ld      c,l
        add     hl,hl                           ; x64
        add     hl,bc                           ; x96
        ld      c,a
        ld      b,0
        add     hl,bc
        ld      bc,gbuf
        add     hl,bc                           ; HL => Where to put sprite
        ld      b,8
putASLoop:
        ld      a,(de)
        ld      (hl),a
        inc     de
        push    de
        ld      de,12
        add     hl,de
        pop     de
        djnz    putASLoop
        ret

;------------------------------------------------
; putSprite - Draw an 8x8 sprite to gbuf (using XOR method), no clipping
;------------------------------------------------
putSprite:
        ld      h,0
        ld      b,h
        add     hl,hl                           ; x2
        add     hl,hl                           ; x4
        ld      c,l
        add     hl,hl                           ; x8
        add     hl,bc                           ; x12
        ld      c,a
        srl     c
        srl     c
        srl     c
        add     hl,bc
        ld      bc,gbuf
        add     hl,bc                           ; HL => Where to display sprite
        and     $07
        ld      c,a
        push    de
        pop     ix                              ; IX => Sprite
        ld      b,8
putSLoop:
        ld      d,(ix)
        ld      e,0
        ld      a,c
        or      a
        jr      z,putSSkip
putSLoop2:
        srl     d
        rr      e
        dec     a
        jr      nz,putSLoop2
putSSkip:
        ld      a,(hl)
        xor     d
        ld      (hl),a
        inc     hl
        ld      a,(hl)
        xor     e
        ld      (hl),a
        ld      de,11
        add     hl,de
        inc     ix
        djnz    putSLoop
        ret

;------------------------------------------------
; putClippedSprite - Draw an 8x8 unmasked sprite to gbuf with clipping
;------------------------------------------------
putClippedSprite:
        ld      a,c
        cp      200
        jr      nc,putCSNoBottomClip
        cp      BOTTOM_CLIP
        ret     nc
putCSNoBottomClip:
        ld      a,$FF
        ld      (__putCSClipMask),a
        bit     7,b
        jr      z,putCSCheckRightClip
        ld      a,b
        cp      249
        ret     c
        neg
        push    bc
        ld      b,a
        ld      a,$FF
putCSLeftClip:
        srl     a
        djnz    putCSLeftClip
        ld      (__putCSClipMask),a
        pop     bc
        ld      a,b
        add     a,96
        ld      b,a
        dec     c
        jr      putCSCheckBottomClip
putCSCheckRightClip:
        ld      a,b
        sub     RIGHT_CLIP-7
        jr      c,putCSCheckBottomClip
        push    bc
        ld      b,a
        inc     b
        ld      a,$FF
putCSRightClip:
        add     a,a
        djnz    putCSRightClip
        ld      (__putCSClipMask),a
        pop     bc
putCSCheckBottomClip:
        ld      a,8
        ld      (__putCSRows2Put),a
        bit     7,c
        jr      nz,putCSCheckTopClip
        ld      a,BOTTOM_CLIP-1
        sub     c
        ret     c
        inc     a
        cp      8
        jr      nc,putCSClippingDone
        ld      (__putCSRows2Put),a
        jr      putCSClippingDone
putCSCheckTopClip:
        ld      a,c
        cp      249
        ret     c
        push    bc
        neg
        ld      b,a
        sub     8
        neg
        ld      (__putCSRows2Put),a
putCSTopClip:
        inc     hl
        djnz    putCSTopClip
        pop     bc
        ld      c,0
putCSClippingDone:
        push    hl
        pop     ix                              ; IX => Sprite
#ifndef APP83P
        ld      a,$00
__putCSRows2Put         = $-1
#else
        ld      a,(__putCSRows2Put)
#endif
        push    af
        call    findPixel
        ld      (__putCSBitMask),a
        pop     bc
putCSPutRow:
        push    bc
        push    hl
#ifndef APP83P
        ld      a,$00
__putCSClipMask         = $-1
#else
        ld      a,(__putCSClipMask)
#endif
        ld      e,a
        ld      b,8
        ld      c,(ix)
        inc     ix
putCSPutCol:
        push    bc
#ifndef APP83P
        ld      a,$00
__putCSBitMask          = $-1
#else
        ld      a,(__putCSBitMask)
#endif
        and     (hl)
        rlc     e
        jr      nc,putCSNextBit
        ld      a,(__putCSBitMask)
        rlc     c
        jr      c,putCSBitOn
        jr      putCSNextBit
putCSBitOn:
        or      (hl)
        ld      (hl),a
putCSNextBit:
        ld      a,(__putCSBitMask)
        rrca
        ld      (__putCSBitMask),a
        jr      nc,putCSNoIncHL
        inc     hl
putCSNoIncHL:
        pop     bc
        rlc     c
        djnz    putCSPutCol
        pop     hl
        ld      de,12
        add     hl,de
        pop     bc
        djnz    putCSPutRow
        ret

;------------------------------------------------
; putClippedMaskedSprite - Draw an 8x8 masked sprite to gbuf with clipping
;
; input:    HL => Sprite followed by mask
;           B = x
;           C = y
; output:   none
; thanks to Jimmy Mardell
;------------------------------------------------
putClippedMaskedSprite:
        ld      a,c
        cp      200
        jr      nc,putCMSNoBottomClip
        cp      BOTTOM_CLIP
        ret     nc
putCMSNoBottomClip:
        ld      a,$FF
        ld      (__putCMSClipMask),a
        bit     7,b
        jr      z,putCMSCheckRightClip
        ld      a,b
        cp      249
        ret     c
        neg
        push    bc
        ld      b,a
        ld      a,$FF
putCMSLeftClip:
        srl     a
        djnz    putCMSLeftClip
        ld      (__putCMSClipMask),a
        pop     bc
        ld      a,b
        add     a,96
        ld      b,a
        dec     c
        jr      putCMSCheckBottomClip
putCMSCheckRightClip:
        ld      a,b
        sub     RIGHT_CLIP-7
        jr      c,putCMSCheckBottomClip
        push    bc
        ld      b,a
        inc     b
        ld      a,$FF
putCMSRightClip:
        add     a,a
        djnz    putCMSRightClip
        ld      (__putCMSClipMask),a
        pop     bc
putCMSCheckBottomClip:
        ld      a,8
        ld      (__putCMSRows2Put),a
        bit     7,c
        jr      nz,putCMSCheckTopClip
        ld      a,BOTTOM_CLIP-1
        sub     c
        ret     c
        inc     a
        cp      8
        jr      nc,putCMSClippingDone
        ld      (__putCMSRows2Put),a
        jr      putCMSClippingDone
putCMSCheckTopClip:
        ld      a,c
        cp      249
        ret     c
        push    bc
        neg
        ld      b,a
        sub     8
        neg
        ld      (__putCMSRows2Put),a
putCMSTopClip:
        inc     hl
        djnz    putCMSTopClip
        pop     bc
        ld      c,0
putCMSClippingDone:
        push    hl
        pop     ix                              ; IX => Sprite, Mask
#ifndef APP83P
        ld      a,$00
__putCMSRows2Put        = $-1
#else
        ld      a,(__putCMSRows2Put)
#endif
        push    af
        call    findPixel
        ld      (__putCMSBitMask),a
        pop     bc
putCMSPutRow:
        push    bc
        push    hl
#ifndef APP83P
        ld      a,$00
__putCMSClipMask        = $-1
#else
        ld      a,(__putCMSClipMask)
#endif
        ld      e,a
        ld      a,(ix+8)
        and     e
        ld      e,a
        ld      b,8
        ld      c,(ix)
        inc     ix
putCMSPutCol:
        push    bc
        sla     d
#ifndef APP83P
        ld      a,$00
__putCMSBitMask         = $-1
#else
        ld      a,(__putCMSBitMask)
#endif
        and     (hl)
        rlc     e
        jr      nc,putCMSNextBit
        ld      a,(__putCMSBitMask)
        rlc     c
        jr      c,putCMSBitOn
        cpl
        and     (hl)
        ld      (hl),a
        jr      putCMSNextBit
putCMSBitOn:
        or      (hl)
        ld      (hl),a
putCMSNextBit:
        ld      a,(__putCMSBitMask)
        rrca
        ld      (__putCMSBitMask),a
        jr      nc,putCMSNoIncHL
        inc     hl
putCMSNoIncHL:
        pop     bc
        rlc     c
        djnz    putCMSPutCol
        pop     hl
        ld      de,12
        add     hl,de
        pop     bc
        djnz    putCMSPutRow
        ret

;------------------------------------------------
; findPixel - Get byte and bit offset to a pixel on gbuf
;
; Input:    B = X
;           C = Y
; Output:   HL => Byte in gbuf
;           A = Bitmask
;------------------------------------------------
findPixel:
        ld      a,b
        ld      b,0
        ld      h,b
        ld      l,c                             ; HL = Y x 1
        add     hl,bc                           ; x2
        add     hl,bc                           ; x3
        add     hl,hl                           ; x6
        add     hl,hl                           ; x12
        ld      bc,gbuf
        add     hl,bc
        ld      b,0
        ld      c,a
        and     $07
        srl     c
        srl     c
        srl     c
        add     hl,bc
        ld      b,a
        inc     b
        ld      a,$01
findPixelLoop:
        rrca
        djnz    findPixelLoop
        ret

.end
