;===============================================================;
;                                                               ;
; Alien Breed 5                                                 ;
; Pause routines                                                ;
;                                                               ;
;===============================================================;

;------------------------------------------------
; teacherKey - turn the calc off, and when turned back on, go to the pause screen
;
; input:    none
; output:   none
;------------------------------------------------
teacherKey:
        bcall(_clrscrnfull)
        ld      a,1
        out     (3),a
        halt
        ld      a,11
        out     (3),a
; fall through to pause routine

;------------------------------------------------
; pauseScreen - display the pause screen and wait for either [ENTER] or [CLEAR]
;
; input:    none
; output:   none
;------------------------------------------------
pauseScreen:
        call    saveVideo                       ; save gbuf
        bcall(_grbufclr)
; write text
        ld      hl,strPaused                    ; HL => start of string data
        call    showStrings                     ; show strings
; after this, HL => sprPauseTable (sprite data table for pause screen)
        ld      b,4
pauseSprLoop:
        push    bc                              ; save loop counter
        ld      a,(hl)                          ; A = x pos
        inc     hl                              ; HL => sprite ptr
        ld      e,(hl)
        inc     hl
        ld      d,(hl)                          ; DE => sprite
        inc     hl                              ; HL => next sprite data
        push    hl                              ; save data ptr
        ld      l,8                             ; L = y pos
        call    putSprite                       ; draw sprite
        pop     hl                              ; restore data ptr
        pop     bc                              ; restore loop counter
        djnz    pauseSprLoop

; show health & ammo meters
        call    displayHealthMeter              ; display player health meter
        ld      hl,gbuf+(50*12)+1               ; HL => where on gbuf to start bottom of ammo meter
        ld      a,(ammo)                        ; A = LSB of ammo
        srl     a
        call    displayMeterDiv4                ; hacked version that starts part way into displayHealthMeter that we use to display the ammo meter

; show values for lives, ammo clips, keys & credits
        ld      hl,(lives)
        ld      h,0                             ; HL = lives
        ld      de,50*256+243                   ; DE = penrow, pencol
        call    setShowHL
        ld      hl,(ammo+1)
        ld      h,0                             ; HL = MSB of ammo, which is the number of full clips
        ld      de,50*256+251
        call    setShowHL
        ld      hl,(keys)
        ld      h,0
        ld      de,8*256+26
        call    setShowHL
        ld      hl,(credits)
        ld      de,8*256+66
        call    setShowHL

; show status of weapons & radar
        ld      b,6                             ; B = number of bits to check
        ld      a,(weaponTable)
        ld      c,a                             ; C = bits to check
        ld      hl,strYesNoTable                ; HL => penrow data
pauseWeaponLoop:
        srl     c                               ; CA = weapon owned; NC = weapon not owned
        push    bc                              ; save counter & bit data
        ld      d,(hl)                          ; D = penrow
        push    hl                              ; save penrow data ptr
        ld      hl,strYes
        jr      c,pauseWriteWeaponStatus        ; if weapon owned, display "YES"
        ld      hl,strNo
pauseWriteWeaponStatus:
        ld      e,(hl)                          ; E = pencol
        inc     hl                              ; HL => string
        call    vPuts                           ; display either "YES" or "NO"
        pop     hl                              ; restore penrow data ptr
        inc     hl                              ; next entry
        pop     bc                              ; restore counter & bit data
        djnz    pauseWeaponLoop

; invert top and bottom text lines
        ld      hl,gbuf                         ; HL => where to start inverting
        ld      b,7                             ; B = num gbuf lines to invert
        call    invertLine                      ; invert B lines starting from HL
        ld      hl,gbuf+(57*12)
        ld      b,7
        call    invertLine
        call    libFastCopy                     ; display gbuf
        call    restoreVideo                    ; restore gbuf from start of routine
pauseKeyLoop:
        call    waitKey                         ; wait for a key press
        cp      GK_ENTER                        ; [ENTER]?
        ret     z                               ; if so, leave pause screen
        cp      GK_CLEAR                        ; [CLEAR]?
        jr      nz,pauseKeyLoop                 ; if not, loop again
        pop     hl                              ; pop ret value
        call    drawPlayer                      ; draw the player to gbuf
        call    libFastCopy                     ; show game screen before exploding
        jp      levelExplode

.end
