;===============================================================;
;                                                               ;
; Alien Breed 5                                                 ;
; Main game loop                                                ;
;                                                               ;
;===============================================================;

mainGameLoop:
        xor     a
        ld      (timer),a                       ; reset internal timer (used to make sure game doesn't run too fast)
        ld      hl,frame
        inc     (hl)                            ; inc frame counter

        ld      a,$B7                           ; A = "or a"
        ld      (__dbBlast),a                   ; clear flag to draw machine gun blast effect in drawBullets

; check if player is alive
        ld      hl,playerDead
        ld      a,(hl)
        or      a                               ; is player alive?
        jr      z,afterPlayerDeath              ; if so, skip dead player stuff
        dec     (hl)                            ; dec death spin counter
        jr      nz,afterEndDeathSpin            ; if counter hasn't reached zero, don't try to bring player back to life yet
        ld      a,(lives)
        bit     7,a                             ; check if lives has gone under zero
        jp      nz,gameOver                     ; if it has, game is over
        ld      a,INI_INVINCIBLE
        ld      (playerInv),a                   ; when player first comes back to life, they are temporarily invincible
        ld      a,MAX_HEALTH
        ld      (health),a                      ; fill up player health
afterEndDeathSpin:
        ld      a,(hl)
        and     %00000011
        jr      nz,afterPlayerDeath             ; only update death spin every 4th frame
        ld      hl,(playerDir)
        ld      h,0                             ; HL = player direction
        ld      de,deathSpinTable
        add     hl,de
        ld      a,(hl)                          ; A = new direction
        ld      (playerDir),a                   ; save it

afterPlayerDeath:
        ld      hl,playerInv
        ld      a,(hl)
        or      a                               ; is player invincible?
        jr      z,afterDecPlayerInv             ; if not, no need to dec invincible counter
        dec     (hl)                            ; dec playerInv

afterDecPlayerInv:
; check if level is finished
        ld      a,(objectives)                  ; A = objectives counter
        cp      2                               ; if it's above 2, can't finish the level yet
        jr      nc,levelNotFinished
        call    loadPlayerCollideObject1
        ld      hl,levelFlags                   ; HL => level flags
        bit     LFLAG_FINISHSIZE,(hl)           ; check flag for finish size
        ld      bc,4                            ; offset if large finish
        jr      z,checkLevelFinish
        ld      c,2                             ; offset for small finish (BC = 2)
checkLevelFinish:
        ld      a,c
        add     a,a                             ; A = width & height value to use
        ld      hl,(finishX)
        ld      h,0                             ; HL = finish x (block value)
        add     hl,hl
        add     hl,hl
        add     hl,hl                           ; HL = finish x
        add     hl,bc                           ; centre portion of finish position
        ld      de,collideObject2
        ex      de,hl
        ld      (hl),e                          ; load x LSB
        inc     hl
        ld      (hl),d                          ; load x MSB
        inc     hl
        ld      (hl),a                          ; load width
        inc     hl
        ex      de,hl                           ; DE => collideObject2 y data
        ld      hl,(finishY)
        ld      h,0                             ; HL = finish y (block value)
        add     hl,hl
        add     hl,hl
        add     hl,hl                           ; HL = finish y
        add     hl,bc                           ; centre portion of finish position
        ex      de,hl
        ld      (hl),e                          ; load y LSB
        inc     hl
        ld      (hl),d                          ; load y MSL
        inc     hl
        ld      (hl),a                          ; load height
        call    checkCollision                  ; check if player is colliding with centre of finish position
        jp      c,levelFinished

levelNotFinished:
; check objectives counter & update if necessary
        ld      hl,objectives
        ld      a,(hl)                          ; A = counter value
        cp      20
        jr      z,setObjectivesTo1              ; if it's 20, set it to 1 (destruction mode)
        jr      c,afterCheckDecObjectives       ; if it's lower than 20, then it doesn't need to be decremented
        dec     (hl)                            ; if it's above 20, then it is decremented each frame until it reaches 20, and then goes to 1 (see above)
        jr      afterCheckDecObjectives
setObjectivesTo1:
        ld      (hl),1
afterCheckDecObjectives:
        ld      a,(hl)                          ; A = objectives counter
        dec     a                               ; is it 1?
        jr      nz,afterDestruct                ; if not, skip all the destruct mode stuff
        ld      a,(frame)
        and     %00011111
        jr      nz,afterDestruct                ; only adjust countdown timer every 32nd frame
; if execution has reached here, the destruction sequence is running
; maybe make a random explosion
        ld      a,(time)                        ; A = time left on countdown
        srl     a
        srl     a
        srl     a                               ; A = time / 8
        add     a,5
        ld      b,a
        call    libRandom                       ; A = 0 to (B-1)
        or      a                               ; check if zero
        call    z,randomExplosion               ; if so, make a new random explosion on screen
; decrement and check the countdown timer
        ld      hl,time
        dec     (hl)                            ; decrement timer
        bit     7,(hl)                          ; check if it's gone below 0
        jp      nz,levelExplode                 ; if so, the level explodes and the game is over

afterDestruct:
        call    updateAlienHoles                ; update alien holes
        ld      a,(frame)
        bit     0,a
        call    z,updateAnims                   ; update animations (only every 2nd frame)
        call    moveEnemies                     ; move enemies
        call    moveBullets                     ; move player bullets
        ld      a,(state)
        or      a
        call    nz,moveBoss                     ; move boss if one is active

; check if player is standing on normal floor, or low bare/exposed floor
; this will determine the player/wall collision checking if the player tries to move
        ld      de,(playerX)
        inc     de                              ; DE = player x+1
        ld      hl,(playerY)
        inc     hl                              ; HL = player y+1
        call    getTile                         ; A = tile at top left of player
        call    checkE2Trigger                  ; if the tile is an enemy 2 trigger, check the tile to the right of the player instead
        or      a                               ; is it bare/explosed floor?
        jr      nz,setNormalWallCheck           ; if not, player is considered to be on normal floor
        ld      hl,(playerX)
        ld      de,6
        add     hl,de
        ex      de,hl                           ; DE = player x+6
        ld      hl,(playerY)
        ld      bc,6
        add     hl,bc                           ; HL = player y+6
        call    getTile                         ; A = tile at bottom right of player
        call    checkE2Trigger                  ; if the tile is an enemy 2 trigger, check the tile to the right of the player instead
        or      a                               ; is it bare/exposed floor?
        jr      nz,setNormalWallCheck           ; if not, player is considered to be on normal floor
        ld      a,TILE_FLOOR                    ; any tile that's not bare floor or a ramp will be considered a wall
        jr      setWallCheck
setNormalWallCheck:
        ld      a,TILE_SOLID
setWallCheck:
        ld      (__ctTileType),a                ; modify code in "checkTile" for player/wall collision

        ld      a,(playerHurt)
        or      a                               ; was player hurt last frame?
        jr      nz,afterPlayerMovement
        ld      a,(playerDead)
        or      a                               ; is player dead?
        jr      nz,afterKeyChecks               ; if so, skip key checks this frame

; check key presses
        ld      a,KG_ARROW                      ; check key presses for arrow keys
        call    directIn
        push    af
        bit     DI_UP,a                         ; was [UP] pressed?
        call    z,playerUp                      ; if so, try to move player up
        pop     af
        push    af
        bit     DI_DOWN,a                       ; was [DOWN] pressed?
        call    z,playerDown                    ; if so, try to move player down
        pop     af
        push    af
        bit     DI_LEFT,a                       ; was [LEFT] pressed?
        call    z,playerLeft                    ; if so, try to move player left
        pop     af
        bit     DI_RIGHT,a                      ; was [RIGHT] pressed?
        call    z,playerRight                   ; if so, try to move player right

afterPlayerMovement:
        xor     a
        ld      (playerHurt),a                  ; reset flag for this frame until collision detection later on

        ld      a,KG_1                          ; check key presses for 1st column
        call    directIn
        push    af
        bit     DI_ALPHA,a                      ; [ALPHA]?
        call    z,playerUse                     ; if so, try to use something in front of player
        pop     af
        bit     DI_MATH,a                       ; [MATH]?
        call    z,teacherKey                    ; if so, turn off calc

        ld      a,KG_TOP
        call    directIn                        ; check key presses for top row
        push    af
        bit     DI_Y,a                          ; [Y=]?
        call    z,selectWeapon1                 ; if so, select machine gun
        pop     af
        push    af
        bit     DI_WINDOW,a                     ; [WINDOW]?
        call    z,selectWeapon2                 ; if so, select twin laser
        pop     af
        push    af
        bit     DI_ZOOM,a                       ; [ZOOM]?
        call    z,selectWeapon3                 ; if so, select flame arc
        pop     af
        push    af
        bit     DI_TRACE,a                      ; [TRACE]?
        call    z,selectWeapon4                 ; if so, select plasma rifle
        pop     af
        push    af
        bit     DI_GRAPH,a                      ; [GRAPH]?
        call    z,selectWeapon5                 ; if so, select flamethrower
        pop     af
        push    af
        bit     DI_2ND,a                        ; [2ND]?
        call    z,playerShoot                   ; if so, shoot
        pop     af
        push    af
        bit     DI_DEL,a                        ; [DEL]?
        call    z,viewRadarScanner              ; if so, view it
        pop     af
        bit     DI_MODE,a                       ; [MODE]?
        call    z,pauseScreen                   ; if so, pause

afterKeyChecks:
; check if screen needs to be scrolled horizontally
        ld      a,(__playerScrX)
        push    af
        cp      40
        call    c,scrollRight                   ; only try to scroll right if player has moved too far left on screen
        pop     af
        cp      49
        call    nc,scrollLeft                   ; only try to scroll left if player has moved too far right on screen
; check if screen needs to be scrolled vertically (parameters vary depending on whether fighting a boss or not)
        ld      a,(state)
        or      a
        ld      a,26                            ; first cp value in the case of not fighting a boss
        jr      z,loadVScrollCheck
        ld      a,46                            ; first cp value in the case of fighting a boss
loadVScrollCheck:
        ld      (__vsc1),a                      ; load first cp value
        add     a,5
        ld      (__vsc2),a                      ; load second cp value
        ld      a,(__playerScrY)
        push    af
#ifndef APP83P
        cp      $00                             ; was just loaded
__vsc1                  = $-1
#else
        ld      hl,(__vsc1)                     ; L = (__vsc1)
        cp      l
#endif
        call    c,scrollDown                    ; only try to scroll down if player has moved to far up on screen
        pop     af
#ifndef APP83P
        cp      $00                             ; was just loaded
__vsc2                  = $-1
#else
        ld      hl,(__vsc2)
        cp      l
#endif
        call    nc,scrollUp                     ; only try to scroll up if player has moved too far down on screen

; check collisions
        ld      a,(state)
        or      a                               ; are we fighting a boss?
        jr      z,afterBossCollisions           ; if not, skip boss collision checking
        call    checkBulletBossCollisions       ; check bullet/boss collisions
        call    checkPlayerBossCollisions       ; check player/boss collisions
afterBossCollisions:
        call    checkBulletEnemyCollisions      ; check bullet/enemy collisions
        call    checkPlayerEnemyCollisions      ; check player/enemy collisions

#ifndef APP83P
        nop                                     ; will be set to either "or a" or "scf"
__invincibleCheat       = $-1
#else
        call    __invincibleCheat
#endif
        jr      nc,afterInvincibleCheat
        ld      a,MAX_HEALTH
        ld      (health),a                      ; keep player health at full
        xor     a
        ld      (playerHurt),a                  ; clear player hurt flag
afterInvincibleCheat:
; check if player was hurt, and if so, set showHealth counter
        ld      a,(playerHurt)
        or      a                               ; was player hurt?
        jr      z,afterSetShowHealth
        ld      a,90
        ld      (showHealth),a                  ; set counter to show health meter for the next A frames

afterSetShowHealth:
; check tile that centre of player is on
        ld      de,(playerX)
        inc     de
        inc     de
        inc     de                              ; DE = centre of player x
        ld      hl,(playerY)
        inc     hl
        inc     hl
        inc     hl                              ; HL = centre of player y
        call    getTile                         ; A = tile
        push    af                              ; save tile
        cp      TILE_BOSSTRIGGER                ; is it a boss trigger?
        call    z,iniBoss                       ; if so, initiate boss
        pop     af                              ; A = tile at centre of player
        cp      TILE_AIRDUCT                    ; is it an air duct?
        jr      nz,afterAirDuct                 ; if not, skip this
        ld      hl,playerInv
        ld      a,(hl)
        inc     hl
        or      (hl)                            ; check if player is dead or invincible
        jr      nz,afterAirDuct                 ; if so, air duct won't hurt player this frame
        ld      a,-1
        ld      (health),a                      ; set player as dead
        jr      afterEnergyShield

afterAirDuct:
        ld      hl,frame
        bit     0,(hl)                          ; check if an even frame
        jr      nz,afterEnergyShield            ; if not, don't let an energy shield push player this frame
        cp      TILE_ENERGYSHIELD+4             ; check upper bound if tile is an energy shield
        jr      nc,afterEnergyShield            ; if not, no pushing
        sub     TILE_ENERGYSHIELD               ; check lower bound if tile is an energy shield
        jr      c,afterEnergyShield             ; if not, no pushing to do
        ld      hl,afterEnergyShield            ; HL => where to ret to after push
        push    hl                              ; push it to stack
        or      a                               ; energy shield up?
        jp      z,playerUp                      ; if so, move player up
        dec     a                               ; energy shield down?
        jp      z,playerDown                    ; if so, move player down
        dec     a                               ; left?
        jp      z,playerLeft
        jp      playerRight                     ; must be right

afterEnergyShield:
; save gbuf, draw sprites, copy gbuf to lcd, restore gbuf
        call    saveVideo                       ; save copy of gbuf

        ld      a,(state)
        or      a
        call    nz,drawBoss                     ; draw boss if in boss mode
        call    drawAnims                       ; draw animations to gbuf
        call    drawBullets                     ; draw player bullets to gbuf
        call    drawEnemies                     ; draw enemies to gbuf
        call    drawPlayer                      ; draw player to gbuf
        ld      a,(levelFlags)
        bit     LFLAG_DARKLEVEL,a
        call    nz,drawDarkMask                 ; if a dark level, draw the mask overlay
        ld      a,(objectives)
        dec     a
        call    z,showTimer                     ; if in destruct mode, show countdown timer
        ld      a,(showHealth)
        or      a                               ; check if should be showing health meter
        jr      z,afterDisplayHealthMeter       ; if not, skip it
        dec     a
        ld      (showHealth),a                  ; dec counter and save it
        call    displayHealthMeter

afterDisplayHealthMeter:
        call    libFastCopy
        call    restoreVideo                    ; restore gbuf from before sprites were drawn

        ei                                      ; make sure interrupts are enabled
        ld      hl,timer                        ; HL => internal timer
mainLoopWait:
        ld      a,(hl)
        neg                                     ; timer counts backwards
        cp      FRAME_TIMER                     ; has timer reached FRAME_TIMER
        jr      nc,afterMainLoopWait
        halt
        jr      mainLoopWait

afterMainLoopWait:
; check if player died this frame
        ld      a,(health)
        bit     7,a                             ; if bit 7 is set, player health is under zero
        jp      z,mainGameLoop
        ld      hl,playerDead
        ld      (hl),INI_DEAD                   ; set player as dead with death spin counter
        xor     a
        ld      (health),a                      ; set health to zero so that health meter displays as empty
        ld      hl,lives
        dec     (hl)                            ; take a player life
        jp      mainGameLoop

.end
