;#########################################################
; Direct Input equates for the TI-82/TI-83/TI-83+/TI-85/TI-86
; By James Vernon - Ti-Calculator Programming Alliance
; james@calc.org <> http://tcpa.calc.org <> ICQ#: 71589304
; Created on 11-02-2001 DDMMYYYY
;
; USAGE (TI-82/83/83+):
;  #include "directin.inc"
;
; USAGE (TI-85/86):
;  #define DIRECTIN_8586
;  #include "directin.inc"
;#########################################################

;****************************
; GROUP CODES
; Example:
;       ld      a,$FF
;       out     (1),a           ; Clear keyport
;       ld      a,KG_ARROW
;       out     (1),a           ; Open arrow pad for reading
;****************************
KG_1            = $DF
KG_2            = $EF
KG_3            = $F7
KG_4            = $FB
KG_5            = $FD
KG_ARROW        = $FE
KG_TOP          = $BF

;****************************
; KEY BIT CODES
; Example:
;       ld      a,$FF
;       out     (1),a           ; Clear keyport
;       ld      a,KG_TOP
;       out     (1),a           ; Open top row for reading
;       in      a,(1)           ; Get keypresses from top row
;       bit     DI_MODE,a       ; Is [MODE] being pressed?
;       jr      z,modePressed
;****************************
#ifdef DIRECTIN_8586
DI_F1           = 4
DI_F2           = 3
DI_F3           = 2
DI_F4           = 1
DI_F5           = 0
DI_2ND          = 5
DI_EXIT         = 6
DI_MORE         = 7
#else
DI_Y            = 4
DI_WINDOW       = 3
DI_ZOOM         = 2
DI_TRACE        = 1
DI_GRAPH        = 0
DI_2ND          = 5
DI_MODE         = 6
DI_DEL          = 7
#endif

DI_UP           = 3
DI_DOWN         = 0
DI_LEFT         = 1
DI_RIGHT        = 2
DI_ALPHA        = 7

#ifdef DIRECTIN_8586
DI_XVAR         = 7
DI_DEL          = 7
DI_GRAPH        = 6
DI_TABLE        = 6
DI_PRGM         = 6
DI_CUSTOM       = 6
#else
DI_XTON         = 7
DI_STAT         = 7
DI_MATH         = 6
DI_MATRX        = 6
DI_PRGM         = 6
DI_VARS         = 6
#endif

DI_CLEAR        = 6

#ifdef DIRECTIN_8586
DI_LOG          = 5
#else
DI_X1           = 5     ; X^-1
#endif

DI_SIN          = 5
DI_COS          = 5
DI_TAN          = 5
DI_POWER        = 5     ; ^

#ifdef DIRECTIN_8586
DI_LN           = 4
DI_EE           = 4
#else
DI_X2           = 4     ; X^2
DI_COMMA        = 4     ; ,
#endif

DI_LPAR         = 4     ; (
DI_RPAR         = 4     ; )
DI_DIV          = 4     ; /

#ifdef DIRECTIN_8586
DI_X2           = 3     ; X^2
#else
DI_LOG          = 3
#endif

DI_7            = 3
DI_8            = 3
DI_9            = 3
DI_MUL          = 3     ; *

#ifdef DIRECTIN_8586
DI_COMMA        = 2     ; ,
#else
DI_LN           = 2
#endif

DI_4            = 2
DI_5            = 2
DI_6            = 2
DI_MINUS        = 2     ; -
DI_STO          = 1     ; STO->
DI_1            = 1
DI_2            = 1
DI_3            = 1
DI_PLUS         = 1     ; +
DI_0            = 0
DI_DEC          = 0     ; .
DI_NEG          = 0     ; (-)
DI_ENTER        = 0

.end
