;===============================================================;
;                                                               ;
; Alien Breed 5                                                 ;
; Data                                                          ;
;                                                               ;
;===============================================================;

#include "animspr.asm"                          ; animation sprites
#include "bossspr.asm"                          ; boss sprites
#include "enemyspr.asm"                         ; enemy sprites
#include "playrspr.asm"                         ; player sprites
#include "shootspr.asm"                         ; bullet sprites
#include "tiles.asm"                            ; tile data
#include "timerspr.asm"                         ; timer sprites

titleDat:
#include "title.asm"                            ; compressed title screen data

darkMaskData:
#include "darkmask.asm"                         ; mask for dark levels

bulletMoveTable:
.dw     moveBulletUp, moveBulletDown, moveBulletLeft, moveBulletRight

enemyMoveTable:
.dw     moveEnemyUp, moveEnemyDown, moveEnemyLeft, moveEnemyRight

deathSpinTable:
.db     2,3,1,0

sprMenuItem:
.db %01110000
.db %11111000
.db %11111000
.db %11111000
.db %01110000
.db %00000000
.db %00000000
.db %00000000

sprMapMarker:
.db %11100000
.db %11100000
.db %11100000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000

sprWhiteSpace:
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111

sprHeart:
.db %00000000
.db %00000000
.db %01010000
.db %11111000
.db %11111000
.db %01110000
.db %00100000
.db %00000000

sprDollar:
.db %00100000
.db %01111000
.db %10100000
.db %01110000
.db %00101000
.db %11110000
.db %00100000
.db %00000000

sprAmmoClip:
.db %00001000
.db %00001100
.db %00010110
.db %00101011
.db %11010100
.db %01101000
.db %00110000
.db %00010000

sprElevatorMan:

sprElevatorTL:
.db %00000000
.db %00000011
.db %00000011
.db %00000111
.db %00001111
.db %00011111
.db %00110111
.db %00111111

sprElevatorTR:
.db %00000000
.db %00000000
.db %00000000
.db %10000000
.db %11000000
.db %11010000
.db %11111110
.db %11101000

sprElevatorCL:
.db %00011111
.db %00000111
.db %00001111
.db %00001101
.db %00011100
.db %00011000
.db %00111001
.db %00110001

sprElevatorCR:
.db %11001000
.db %10110000
.db %10000000
.db %11000000
.db %11000000
.db %11000000
.db %11000000
.db %10000000

sprElevatorBL:
.db %11111111
.db %11111111
.db %01111111
.db %00111000
.db %00111000
.db %00010000
.db %00010000
.db %00010000

sprElevatorBR:
.db %11111111
.db %11111111
.db %11111110
.db %00011100
.db %00011100
.db %00001000
.db %00001000
.db %00001000

sprElevatorMan2:

sprElevatorTL2:
.db %00000000
.db %00000011
.db %00000011
.db %00000111
.db %00001111
.db %00011111
.db %00110111
.db %00111111

sprElevatorTR2:
.db %00000000
.db %00000000
.db %00000000
.db %10000000
.db %11000000
.db %11010000
.db %11111110
.db %11101000

sprElevatorCL2:
.db %00011111
.db %00000111
.db %00001111
.db %00001101
.db %00011100
.db %00011000
.db %00111001
.db %00110001

sprElevatorCR2:
.db %11001000
.db %10110000
.db %10000000
.db %11000000
.db %11000000
.db %11000000
.db %11000000
.db %10000000

sprElevatorBL2:
.db %11111111
.db %11111111
.db %01111111
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000

sprElevatorBR2:
.db %11111111
.db %11111111
.db %11111110
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000

wallTable:
.db     0,5,7,1,8,2,10,11,6,9,3,13,4,14,12,15

wallMaskTable:
.db     %10000000,%00001000,%01000000,%00000100,%00000010,%00100000,%00000001,%00010000

wallOffsetTable:
.db     -1,-1,0,-1,1,-1,-1,0,1,0,-1,1,0,1,1,1

wallComplexTable:
.db     %00110000,%11000000,%01010000,%10100000,%11110000

pixelTable:
.db     $01,$80,$40,$20,$10,$08,$04,$02,$01

bulletOffsetTable:
.dw     4,-2,1,7,-2,1,7,4
.dw     4,-4,1,7,-4,1,7,4
.dw     2,-6,-1,7,-6,-1,7,2
.dw     3,-2,0,7,-2,0,7,3
.dw     3,-4,0,7,-4,0,7,3

bulletCentreTable:
.dw     1,1,1,1,1,1,1,1
.dw     1,2,1,2,2,1,2,1
.dw     3,3,3,3,3,3,3,3
.dw     2,1,2,1,1,2,1,2
.dw     2,2,2,2,2,2,2,2

bulletWallAnimTable:
.dw     -2,0,-2,-5,0,-2,-5,-2
.dw     -3,0,-3,-5,0,-3,-5,-3
.dw     -2,1,-2,-4,1,-2,-4,-2
.dw     -3,1,-3,-4,1,-3,-4,-3
.dw     -2,-1,-2,-6,-1,-2,-6,-2
.dw     -3,-1,-3,-6,-1,-3,-6,-3

bulletSizeTable:
.db     3,3,3,3,3,3,3,3
.db     3,5,3,5,5,3,5,3
.db     7,7,7,7,7,7,7,7
.db     5,3,5,3,3,5,3,5
.db     5,5,5,5,5,5,5,5

bulletDamageTable:
.db     1,3,6,5,10

animSpriteTable:
.dw     animExplosion,animVDOpen,animHDOpen

playerUseCoordsTable:
.dw     5,-7,2,14,-7,2,14,5

playerUseTileTable:
.db     TILE_FIREDOORV,TILE_FIREDOORH,TILE_INTEXUL,TILE_INTEXUR,TILE_INTEXBL,TILE_INTEXBR
NUM_USE_TILES           = 6

playerUseRoutines:
.dw     closeFireDoor,closeFireDoor
.dw     loadIntexConsole,loadIntexConsole,loadIntexConsole,loadIntexConsole

tileFixTable:
.db     58,60,61,62
NUM_TILES_FIX           = $-tileFixTable

enemyLevelTable:
.db     4,6,8,10,12,14,16,18                    ; alien 1 ini health
.db     4,6,8,10,12,14,16,18                    ; alien 2 ini health
.db     2,4,6,8,10,12,14,16                     ; face hugger ini health
.db     2,4,6,8,10,12,14,16                     ; worm ini health
.db     1,2,3,4,5,6,7,8                         ; security guard ini health

enemyDamageTable:
.db     16,16,8,8,16

enemySpeedTable:
.db     2,2,2,2,2,2,3,3                         ; alien 1
.db     2,2,2,2,2,2,3,3                         ; alien 2
.db     1,1,1,2,2,2,2,2                         ; face hugger
.db     2,2,2,3,3,3,3,3                         ; worm
.db     2,2,2,2,2,2,2,2                         ; security guard

enemyCounterMask:
.db     %00000000
.db     %00000000
.db     %00000011
.db     %00000011
.db     %00000000

enemySpriteTable:
.dw     sprAlien1Up,sprAlien2Up,sprFaceHuggerUp1,sprWormUp1,sprSecurityGuardUp

bossSpriteTable:
.dw     sprBoss1_1_1,sprBoss2_1_1,sprBoss3_1_1,sprBoss4_1_1

bossLevelTable:
.dw     200,400,700,1000

bossDrawTable:
.db     0,0
.db     0,8
.db     0,16
.db     8,0
.db     8,8
.db     8,16

strJVTIPresents:
.db     28,22,"JVTI presents...",$FF

strNormal:
.db     "NORMAL",0

strTough:
.db     "TOUGH",0

strGameOver:
.db     "G A M E   O V E R",0

str2nd:
.db     $C1,"2nd]",0

episode1SearchStr:
.db     "AB530",0
.db     "AB531",0
.db     "AB532",0
.db     "AB533",0
.db     "AB534",0
.db     "AB535",0

strEpisode1Missing:
.db     "File ZAB5E1F1 missing!",0
.db     "File ZAB5E1F2 missing!",0
.db     "File ZAB5E1F3 missing!",0
.db     "File ZAB5E1F4 missing!",0
.db     "File ZAB5E1F5 missing!",0
.db     "File ZAB5E1F6 missing!",0

tempName:
.db     5,"tmp",0                               ; name of temp program to be created

strPaused:
.db     8
.db     0,37,"PAUSED",0
.db     18,25,"MACHINE GUN:",0
.db     24,25,"TWIN LASER:",0
.db     30,25,"FLAME ARC:",0
.db     36,25,"PLASMA RIFLE:",0
.db     42,25,"FLAMETHROWER:",0
.db     50,25,"RADAR SCANNER:",0
.db     57,2,"ENTER-Play, CLEAR-Retreat",0

sprPauseTable:
.db     2
.dw     sprHeart
.db     9
.dw     sprAmmoClip
.db     29
.dw     tileKeyPass
.db     60
.dw     sprDollar

strYesNoTable:
.db     18,24,30,36,42,50

strYes:
.db     78,"YES",0

strNo:
.db     80,"NO",0

strHighScore:
#ifndef APP83P
.db     10
#else
.db     7
#endif
.db     1,19,"HIGH SCORE TABLE",0
.db     29,21,"by James Vernon",0
.db     36,14,"Based on the original",0
.db     42,13,"ALIEN BREED series by",0
.db     48,35,"TEAM 17",0
.db     56,2,"WWW.JVTI.ORG",0
.db     56,75,"v",VER_MAJOR,".",VER_MINOR,".",VER_REVISION,0

highScoreNames:
#ifdef APP83P
.db     3
#endif
.db     8,13,"1. HICKS     ",0
.db     14,13,"2. VASQUEZ   ",0
.db     20,13,"3. DRAKE     ",0

highScores:
.dw     5000,3000,1000

#ifdef APP83P
hscoreAppvar:
.db     appvarobj,"AB5",0
#endif

strNewHighScore:
.db     2
.db     17,8,"You got a new high score!",0
.db     27,20,"Enter your name:",0

strBlankString:
.db     "__________",0

charTable:
.db     ".........."
.db     "WRMH....VQ"
.db     "LG...ZUPKF"
.db     "C..YTOJEB."
.db     ".XSNIDA..."
.db     "......"

elevatorScrMasks:
.db     $FF,$03,$00,$00,$00,$00,$FF,$C0,$FF,$00,$FF,$00,$FF,$00,$FF,$00,$FF,$00,$FF,$00,$FF,$00,$FF,$00

elevatorScrRandoms:
.db     %11010110,%10100110,%01101101,%00101011

elevatorSprOffsets:
.db     8,0,16,0,8,8,16,8,8,16,16,16

strLevelComplete:
.db     2
.db     18,34,"Level complete",0
.db     25,42,"Press ",$C1,"2nd]",0

strPasscode:
.db     1
.db     33,45,"Passcode:",0

strEnterPasscode:
.db     "Enter passcode:",0

strInvalidPasscode:
.db     "Invalid passcode!",0

passcodeChars:
.db     "ECNJKBHMPFIDLAOG"

passcodeValues:
.db     13,5,1,11,0,9,15,6,10,3,4,12,7,2,14,8

cheatcodes:
.db     4
.db     "CRAZYXENOS"
.db     "IWANTFISHH"
.db     "TOUGHMUTHA"
.db     "INSANEMODE"

cheatTable:
.dw     __insaneModeCheat,__invincibleCheat,__noWallsCheat,__enemySpeedCheat

strScanning:
.db     "SCANNING...",0

intexMainJumpTable:
.dw     intexWeaponMenu,intexToolMenu,intexRadarService,intexMissionObjective,intexEntertainment,intexInfoBase,intexAbort

intexWeaponJumpTable:
.dw     intexBuyTwinLaser,intexBuyFlameArc,intexBuyPlasmaRifle,intexBuyFlamethrower,intexMainMenu

intexToolJumpTable:
.dw     intexBuyKeyPack,intexBuyAmmoClip,intexBuyFirstAid,intexBuyRadarScanner,intexBuyExtraLife,intexMainMenu

strIntexLoad:
.db     10,1,"INTEX NETWORK SYSTEMS",0
.db     17,1,"CONNECTING...",$FF

strIntexAbort:
.db     10,1,"DISCONNECTING...",$FF

strIntexEntertainment:
.db     15,7,"INTEX ENTERTAINMENT IS",0
.db     22,11,"DOWN FOR MAINTENANCE",0
.db     32,12,"CHECK TICALC.ORG FOR",0
.db     39,14,"GREAT TI PROGRAMS :)",$FF

strIntexPurchased:
.db     10,1,"ITEM PURCHASED!",$FF

strIntexAlreadyOwned:
.db     10,1,"YOU ALREADY OWN THAT!",$FF

strIntexNotEnoughCredits:
.db     10,1,"INSUFFICIENT FUNDS!",$FF

strCreditLimit:
.db     56,2,"CREDIT LIMIT:",$FF

intexMainMenuData:
.db     7
.db     0,21,"INTEX MAIN MENU",0
.db     10,9,"INTEX WEAPON SUPPLIES",0
.db     17,13,"INTEX TOOL SUPPLIES",0
.db     24,13,"INTEX RADAR SERVICE",0
.db     31,16,"MISSION OBJECTIVE",0
.db     38,12,"INTEX ENTERTAINMENT",0
.db     45,32,"INFO BASE",0
.db     52,15,"ABORT INTEX SYSTEM",$FF
.db     3,7,7,10,6,26,9

intexWeaponMenuData:
.db     5
.db     0,9,"INTEX WEAPON SUPPLIES",0
.db     10,7,"TWIN LASER",0
.db     10,65,"1000 CR",0
.db     17,7,"FLAME ARC",0
.db     17,65,"2400 CR",0
.db     24,7,"PLASMA RIFLE",0
.db     24,65,"3500 CR",0
.db     31,7,"FLAMETHROWER",0
.db     31,65,"4800 CR",0
.db     38,32,"MAIN MENU",$FF
.db     1,1,1,1,26

intexToolMenuData:
.db     6
.db     0,13,"INTEX TOOL SUPPLIES",0
.db     10,7,"KEY PACK",0
.db     10,69,"500 CR",0
.db     17,7,"AMMO CLIP",0
.db     17,69,"200 CR",0
.db     24,7,"FIRST AID",0
.db     24,69,"500 CR",0
.db     31,7,"RADAR SCANNER",0
.db     31,65,"1000 CR",0
.db     38,7,"EXTRA LIFE",0
.db     38,65,"3000 CR",0
.db     45,32,"MAIN MENU",$FF
.db     1,1,1,1,1,26

intexInfoBaseData:
#ifndef APP83P
.db     7

.db     0,21,"INTEX INFO BASE",0
.db     10,0,$C1,"2nd]=next page",0
.db     17,0,$C1,"mode]=main menu",$FF

.db     0,0,"GAME CONTROLS",0
.db     10,0,"arrow keys=move",0
.db     17,0,$C1,"2nd]=shoot",0
.db     24,0,"top row=select weapon 1-5",0
.db     31,0,$C1,"alpha]=use/activate",0
.db     38,0,$C1,"del]=remote radar scanner",0
.db     45,0,$C1,"mode]=pause",0
.db     52,0,$C1,"math]=teacher key",$FF

.db     0,0,"SECURITY DOORS",0
.db     10,0,"Can be opened with key",0
.db     17,0,"passes, or shot open as a",0
.db     24,0,"last resort.",$FF

.db     0,0,"FIRE DOORS",0
.db     10,0,"Can be closed by pressing",0
.db     17,0,$C1,"alpha], but cannot be",0
.db     24,0,"reopened.",$FF

.db     0,0,"ONE WAY ENERGY BEAMS",0
.db     10,0,"Only allow access in one",0
.db     17,0,"direction as indicated.",$FF

.db     0,0,"AIR DUCTS",0
.db     10,0,"These are dangerous and",0
.db     17,0,"should not be entered",0
.db     24,0,"unless directed to do so.",$FF

.db     0,0,"REMOTE RADAR SCANNER",0
.db     10,0,"This can be purchased and",0
.db     17,0,"then viewed from anywhere",0
.db     24,0,"by pressing ",$C1,"del].",0
.db     31,0,"It will not work during",0
.db     38,0,"auto-destruct sequence.",$FF

#else
.db     1

.db     0,21,"INTEX INFO BASE",0
.db     10,0,"arrow keys=move",0
.db     17,0,$C1,"2nd]=shoot",0
.db     24,0,"top row=select weapon 1-5",0
.db     31,0,$C1,"alpha]=use/activate",0
.db     38,0,$C1,"del]=remote radar scanner",0
.db     45,0,$C1,"mode]=pause",0
.db     52,0,$C1,"math]=teacher key",$FF
#endif

CR_TWINLASER            = 1000
CR_FLAMEARC             = 2400
CR_PLASMARIFLE          = 3500
CR_FLAMETHROWER         = 4800
CR_KEYPACK              = 500
CR_AMMOCLIP             = 200
CR_FIRSTAID             = 500
CR_RADARSCANNER         = 1000
CR_EXTRALIFE            = 3000

.end
