;===============================================================;
;                                                               ;
; Alien Breed 5                                                 ;
; Boss routines                                                 ;
;                                                               ;
;===============================================================;

;------------------------------------------------
; iniBoss - initialise boss mode
;
; input:    HL => trigger in tile level data
; output:   none
;------------------------------------------------
iniBoss:
        ld      (hl),TILE_FLOOR                 ; clear boss trigger in level data
        ld      a,(boss)
        ld      c,a                             ; C = boss data
        and     %00000111                       ; A = boss type
        ld      l,a
        ld      h,0
        add     hl,hl
        ld      de,bossSpriteTable
        add     hl,de
        bcall(_ldhlind)                         ; HL => 1st sprite set for boss
        ld      (__bossSprPtr),hl               ; save ptr
        ld      a,c                             ; A = boss data (C saved from earlier)
        sra     a
        sra     a
        sra     a                               ; A = boss level
        add     a,a                             ; *2
        ld      e,a
        ld      d,0
        ld      hl,bossLevelTable
        add     hl,de
        bcall(_ldhlind)                         ; HL = boss ini health
        ld      (__bossHealth),hl               ; save it
        ld      hl,(bossTileOffset)             ; HL = offset to tile in level data
        ld      de,(tileDataPtr)                ; DE = start of tile level data
        add     hl,de                           ; HL => tile in level data
        ld      a,(bossTileType)                ; A = tile to put
        call    putTile                         ; put tile & update gbuf
        xor     a
        ld      (__bossYCnt),a                  ; reset boss y counter
        ld      (__bossSprCnt),a                ; reset sprite animation counter
        inc     a
        ld      (state),a                       ; set game state to 1 (boss mode)
        ld      (__bossDir),a                   ; set direction to down
        ld      hl,(playerX)
        ld      (__bossX),hl                    ; start boss x at same as player x
        ld      hl,(playerY)
        inc     hl                              ; HL = player y + 1, to ensure we make calculation from the bottom block of the room
        srl     h
        rr      l
        srl     h
        rr      l
        srl     h
        rr      l                               ; HL = block y
        ld      de,-9
        add     hl,de                           ; HL = block y of top of room
        add     hl,hl
        add     hl,hl
        add     hl,hl                           ; HL = absolute y of top of room
        ld      (__bossY),hl                    ; save it
        ret

;------------------------------------------------
; bossDead - kill the boss and return to normal game state
;
; input:    none
; output:   none
;------------------------------------------------
bossDead:
        pop     hl                              ; clearing stack from collision detection routine
        pop     iy                              ; restore system flag ptr
        ei                                      ; and enable interrupts again
        ld      hl,SCORE_BOSS
        call    addScore                        ; add score for killing boss
        xor     a
        ld      (state),a                       ; reset game state to normal
        jp      lowerObjectivesCount

;------------------------------------------------
; drawBoss - draw boss
;
; input:    none
; output:   none
;------------------------------------------------
drawBoss:
#ifndef APP83P
        ld      a,$00                           ; will be initialised during iniBoss routine
__bossSprCnt            = $-1
#else
        ld      a,(__bossSprCnt)
#endif
        sra     a
        sra     a                               ; /4 (animate boss every 4th frame)
        and     %00000011                       ; mask as boss has 4 possible sprites to display
        add     a,a                             ; *2
        add     a,a                             ; *4
        add     a,a                             ; *8
        add     a,a                             ; *16
        add     a,a                             ; *32
        ld      e,a
        ld      d,0                             ; DE = *32
        add     a,a                             ; *64
        ld      l,a
        ld      h,d                             ; HL = *64 (remembering D was 0, shorter way of zeroing H)
        add     hl,de                           ; HL = *96, offset to sprite set
#ifndef APP83P
        ld      de,$0000                        ; will be initialised in iniBoss routine
__bossSprPtr            = $-2
#else
        ld      de,(__bossSprPtr)
#endif
        add     hl,de                           ; HL => sprite set
        ex      de,hl                           ; DE => sprite set
#ifndef APP83P
        ld      hl,$0000                        ; will be initialised in iniBoss routine
__bossX                 = $-2
#else
        ld      hl,(__bossX)
#endif
        ld      bc,(screenX)
        or      a
        sbc     hl,bc                           ; L = x pos on screen (H is irrelevant)
        ld      a,l
        ld      (__bossScrX),a                  ; save it
#ifndef APP83P
        ld      hl,$0000                        ; will be initialised in iniBoss
__bossY                 = $-2
#else
        ld      hl,(__bossY)
#endif
        ld      bc,(screenY)
        or      a
        sbc     hl,bc                           ; L = y pos on screen (H is irrelevant)
        ld      a,l
        ld      (__bossScrY),a                  ; save it
        ld      b,6                             ; B = number of sprites to draw
        ld      hl,bossDrawTable                ; HL = coords offset data
drawBossLoop:
        push    bc                              ; save loop counter
        push    de                              ; save sprite ptr
#ifndef APP83P
        ld      a,$00                           ; will be set earlier
__bossScrX              = $-1
#else
        ld      a,(__bossScrX)
#endif
        add     a,(hl)
        ld      b,a                             ; B = x coord to display this sprite at
        inc     hl                              ; HL => y offset
#ifndef APP83P
        ld      a,$00                           ; will be set earlier
__bossScrY              = $-1
#else
        ld      a,(__bossScrY)
#endif
        add     a,(hl)
        ld      c,a                             ; C = y coord to display this sprite at
        inc     hl                              ; HL => x offset for next sprite
        push    hl                              ; save offset data ptr
        ex      de,hl                           ; HL => sprite
        call    putClippedMaskedSprite          ; draw sprite
        pop     de                              ; DE => x offset for next sprite
        pop     hl                              ; HL => sprite we just drew
        ld      bc,16
        add     hl,bc                           ; HL => next sprite
        ex      de,hl                           ; DE => next sprite; HL => x offset for next sprite
        pop     bc                              ; restore loop counter
        djnz    drawBossLoop
        ret

;-----------------------------------------------
; moveBoss - move the boss
;
; input:    none
; output:   none
;-----------------------------------------------
moveBoss:
        ld      hl,__bossSprCnt
        inc     (hl)                            ; inc sprite animation counter
#ifndef APP83P
        ld      a,$00                           ; initiated during iniBoss
__bossDir               = $-1
#else
        ld      a,(__bossDir)
#endif
        or      a                               ; check boss direction
        ld      hl,(__bossY)
        jr      z,moveBossUp
moveBossDown:
        inc     hl
        ld      (__bossY),hl                    ; save new y
#ifndef APP83P
        ld      a,$00                           ; initiated during iniBoss
__bossYCnt              = $-1
#else
        ld      a,(__bossYCnt)
#endif
        inc     a                               ; inc boss y counter
        ld      (__bossYCnt),a                  ; save it
        sub     8*7                             ; has boss moved down full length of the boss room?
        jr      nz,moveBossX                    ; if not, go straight to x movement
        ld      (__bossDir),a                   ; set direction to up (A = 0 from the sub instruction)
        jr      moveBossX
moveBossUp:
        dec     hl
        ld      (__bossY),hl                    ; save new y
        ld      hl,__bossYCnt
        dec     (hl)                            ; dec boss y counter
        jr      nz,moveBossX                    ; if boss hasn't moved up to top of boss room, go to x movement
        inc     a                               ; A = 1 (it previously equalled 0 from the direction check at start of this routine)
        ld      (__bossDir),a                   ; set direction to down
moveBossX:
        ld      a,(frame)
        bit     0,a
        ret     nz                              ; only move boss horizontally every 2nd frame
        ld      hl,(__bossX)
        push    hl                              ; put __bossX on stack
        ld      de,7
        add     hl,de                           ; HL = boss x + 7
        ld      de,(playerX)
        inc     de
        inc     de
        inc     de                              ; DE = player x + 3
        or      a
        sbc     hl,de                           ; L = difference between centre of boss & player x coords (H is irrelevant)
        ld      a,l                             ; A = difference
        ld      b,0                             ; B = move boss left (if movement is req'd)
        jr      nc,bossPositiveX                ; if difference was already positve, no need to negate it
        neg
        inc     b                               ; B = move boss right (if movement is req'd)
bossPositiveX:
        cp      5                               ; check if difference is less than 5
        pop     hl                              ; HL = __bossX
        ret     c                               ; if so, no need to move horizontally
        ld      a,b                             ; A = horizontal direction to move
        or      a
        jr      nz,moveBossRight
moveBossLeft:
        dec     hl
        jr      saveNewBossX
moveBossRight:
        inc     hl
saveNewBossX:
        ld      (__bossX),hl
        ret

.end
