;===============================================================;
;                                                               ;
; Alien Breed 5                                                 ;
; Animation routines                                            ;
;                                                               ;
;===============================================================;

;------------------------------------------------
; clearAnimTable - clear animTable
;
; input:    none
; output:   none
;------------------------------------------------
clearAnimTable:
        ld      hl,animTable                    ; HL => first byte to clear
        ld      de,animTable+1                  ; DE => where to start copy cleared bytes to
        ld      bc,NUM_ANIMS*ANIM_SIZE-1        ; BC = number of bytes to copy/clear
        ld      (hl),0                          ; clear first byte
        ldir                                    ; copy/clear the rest
        ret

;------------------------------------------------
; newAnim - create a new animation
;
; input:    B = type
;           C = initial counter value
;           DE = x
;           HL = y
; output:   none
;------------------------------------------------
newAnim:
        push    ix                              ; save IX (outside routines use it)
        push    bc
        push    de
; find an empty entry in animTable
        ld      ix,animTable                    ; IX => first entry
        ld      b,NUM_ANIMS                     ; B = max number of entries to check
        ld      de,ANIM_SIZE                    ; DE = size of each entry
findEmptyAnim:
        ld      a,(ix+0)                        ; A = counter
        or      a                               ; is it 0?
        jr      z,foundEmptyAnim                ; if so, this is an empty entry that we can use
        add     ix,de                           ; IX => next entry to check
        djnz    findEmptyAnim                   ; check next entry
        pop     de
        pop     bc
        jr      leaveNewAnim                    ; no empty entries found, so finish up & leave
foundEmptyAnim:
        pop     de
        pop     bc
        ld      (ix+0),c                        ; store initial counter
        ld      (ix+1),b                        ; store animation type
        ld      (ix+2),e
        ld      (ix+3),d                        ; store x
        ld      (ix+4),l
        ld      (ix+5),h                        ; store y
leaveNewAnim:
        pop     ix                              ; restore IX for outside routines
        ret

;------------------------------------------------
; updateAnims - update all active animations
;
; input:    none
; output:   none
;------------------------------------------------
updateAnims:
        ld      ix,animTable                    ; IX => start of animTable
        ld      b,NUM_ANIMS                     ; B = number of entries to check/update
        ld      de,ANIM_SIZE                    ; DE = size of each entry
updateAnimsLoop:
        ld      a,(ix+0)                        ; A = counter
        or      a                               ; is it 0?
        jr      z,endUpdateAnimsLoop            ; if so, no update required for this entry
        dec     (ix+0)                          ; decrement counter
endUpdateAnimsLoop:
        add     ix,de                           ; IX => next entry
        djnz    updateAnimsLoop                 ; loop
        ret

;------------------------------------------------
; drawAnims - draw active animations
;
; input:    none
; output:   none
;------------------------------------------------
drawAnims:
        ld      ix,animTable                    ; IX => start of animTable
        ld      b,NUM_ANIMS                     ; B = number of entries to check/draw
drawAnimsLoop:
        ld      a,(ix+0)                        ; A = counter
        or      a                               ; is it 0?
        jr      z,endDrawAnimsLoop              ; if so, empty entry
        push    bc                              ; save entry counter
        ld      l,(ix+1)
        ld      h,0                             ; HL = animation type
        add     hl,hl                           ; *2
        ld      de,animSpriteTable
        add     hl,de                           ; HL => ptr to sprite set
        ld      e,(hl)
        inc     hl
        ld      d,(hl)                          ; DE => sprite set
        dec     a                               ; A = counter-1
        add     a,a
        add     a,a
        add     a,a                             ; *8
        ld      l,a
        ld      h,0                             ; HL = offset in sprite set
        add     hl,de                           ; HL => sprite
        ex      de,hl                           ; DE => sprite
        ld      l,(ix+4)
        ld      h,(ix+5)                        ; HL = animation y coord
        ld      bc,(screenY)
        or      a                               ; clear carry
        sbc     hl,bc                           ; L = animation y on screen
        push    hl                              ; save it to stack
        ld      l,(ix+2)
        ld      h,(ix+3)                        ; HL = animation y coord
        ld      bc,(screenX)
        or      a
        sbc     hl,bc                           ; L = animation x on screen
        pop     bc                              ; C = animation y on screen
        ld      b,l                             ; B = animation x on screen
        ex      de,hl                           ; HL => sprite
        push    ix                              ; save table ptr
        call    putClippedSprite                ; draw animation
        pop     ix                              ; restore table ptr
        pop     bc                              ; restore entry counter
endDrawAnimsLoop:
        ld      de,ANIM_SIZE                    ; DE = entry size
        add     ix,de                           ; IX => next entry
        djnz    drawAnimsLoop
        ret

.end
