;===============================================================;
;                                                               ;
; Alien Breed 5                                                 ;
; Header file                                                   ;
;                                                               ;
;===============================================================;

;------------------------------------------------
; misc game defines
;------------------------------------------------
VER_MAJOR               = '1'
VER_MINOR               = '1'
VER_REVISION            = '1'

LEVEL_WIDTH             = 60                    ; maximum level width
LEVEL_HEIGHT            = 48                    ; maximum level height
LEVEL_HEADER            = 300                   ; max size of level header
LEVEL_SIZE              = LEVEL_WIDTH*LEVEL_HEIGHT+LEVEL_HEADER ; size of uncompressed level
LEVEL_STATS             = 18
#ifndef APP83P
MEM_NEEDED              = LEVEL_SIZE+9          ; free memory required is size of an uncompressed level, plus 9 bytes for VAT data of temp file
#endif

HIGH_SCORE_NAME_MAX     = 10

NUM_BULLETS             = 8                     ; max number of player bullets
BULLET_SIZE             = 7                     ; size of each bulletTable entry
NUM_ANIMS               = 5                     ; max number of animations
ANIM_SIZE               = 6                     ; size of each animTable entry
NUM_ENEMIES             = 10                    ; max number of enemies
ENEMY_SIZE              = 9                     ; size of each enemyTable entry
NUM_AHOLES              = 3                     ; max number of alien holes
AHOLE_SIZE              = 7                     ; size of each aholeTable entry

TILE_FLOOR              = 5                     ; normal floor tile
TILE_HATCHERY           = 6                     ; hatchery floor tile
TILE_MISCTRIGGER        = 55                    ; misc walk over trigger tile
TILE_AIRDUCT            = 56                    ; air duct tile
TILE_BOMB               = 57                    ; bomb tile
TILE_UNOPENALIENHOLE    = 58                    ; unopen alien hole tile
TILE_OPENALIENHOLE      = 59                    ; open alien hole tile
TILE_ENEMYTRIGGER       = 60                    ; first enemy trigger tile
TILE_BOSSTRIGGER        = 62                    ; boss trigger tile
TILE_FIREDOORV          = 63                    ; vertical open fire door tile
TILE_FIREDOORH          = 64                    ; horizontal open fire door tile
TILE_ENERGYSHIELD       = 67                    ; start of energy shield tiles
TILE_SOLID              = 71                    ; start of solid tiles
TILE_FIRSTWALL          = TILE_SOLID            ; first wall tile
TILE_COMPLEXWALL        = TILE_FIRSTWALL+11     ; start of the "complex" wall tiles that need to be double checked
TILE_LASTWALL           = TILE_FIRSTWALL+20     ; last wall tile
TILE_TRIGGEREDBOMB      = 134                   ; triggered bomb tile
TILE_INTEXUL            = 135                   ; facing up intex console left tile
TILE_INTEXUR            = 136                   ; facing up intex console right tile
TILE_INTEXBL            = 137                   ; facing down intex console left tile
TILE_INTEXBR            = 138                   ; facing down intex console right tile
TILE_POWERDOME          = 145                   ; start of working power dome tiles
TILE_DOOR               = 149                   ; start of normal door tiles

OPEN_DOOR               = 84                    ; difference between closed & open normal door tiles
PICKUPS                 = 49                    ; start of pickup tiles
CLOSE_FIRE_DOOR         = 76                    ; difference between closed & open fire door tiles
ANIM_DOOR               = 64                    ; start of open door tiles minus 1 (to calc animation type)

SCORE_PICKUP            = 5                     ; score for collecting a pickup item
SCORE_ENEMY             = 20                    ; score for killing an enemy
SCORE_BOSS              = 250                   ; score for killing a boss
SCORE_LEVEL             = 200                   ; score for finishing a level

LFLAG_PASSCODE          = 0
LFLAG_FIREDOORS         = 1
LFLAG_POWERDOMES        = 2
LFLAG_DARKLEVEL         = 3
LFLAG_LEVELTYPE         = 4
LFLAG_FINISHSIZE        = 5

HITS_DOOR               = 48
HITS_POWERDOME          = 16

MAX_HEALTH              = 127
INI_INVINCIBLE          = 80
INI_DEAD                = 48
INI_OPENALIENHOLE       = 100
INI_UNOPENALIENHOLE     = -50

E1_MAXLEVEL             = 12

;------------------------------------------------
; TI-83 Ion header
;------------------------------------------------
#ifdef ION83
#define ION
#define TI83
#define NOTMOSDCS
#define STATS
#include "ion.inc"                              ; Ion include file

FRAME_TIMER             = 3
systemBackup            = saferam2              ; 256 bytes to backup system pointers
tempProg                = systemBackup+256      ; store address for temporary memory after systemBackup
vars                    = tempProg+2            ; store game variables after tempProg
vars2                   = saferam3              ; store more game vars in saferam3 (textmem)
videoBuffer             = saferam1              ; 768 bytes for a video buffer

; library defines
libDetect               = ionDetect
libFastCopy             = ionFastCopy
libRandom               = ionRandom

.org    progstart
        ret
        jr      nc,start
.db     " Alien Breed 5",0
#endif

;------------------------------------------------
; TI-83+ Ion Header
;------------------------------------------------
#ifdef ION83P
#define ION
#define TI83P
#define LIB83P
#define NOTMOSDCS
#include "ion.inc"                              ; Ion include file

FRAME_TIMER             = 3
systemBackup            = appBackupScreen       ; 256 bytes to backup system pointers
tempProg                = systemBackup+256      ; store address for temporary memory after systemBack
vars                    = tempProg+2            ; store game variables after tempProg
vars2                   = vars+270
videoBuffer             = saferam1              ; 768 bytes for a video buffer

_enoughMem              = _enoughRam            ; will be called as _enoughMem in program
_flashToRam             = $5017

.org    progstart-2
.db     $BB, $6D                                ; AsmPrgm token
        ret                                     ; TI-OS can't run program
        jr      nc,start                        ; jump to start of program
.db     " Alien Breed 5",0
#endif

;------------------------------------------------
; TI-83+ MirageOS Header
;------------------------------------------------
#ifdef MIRAGE
#define TI83P
#include "ti83plus.inc"                         ; TI-83+ include file
#include "mirage.inc"                           ; MirageOS include file

FRAME_TIMER             = 4
systemBackup            = appBackupScreen       ; 256 bytes to backup system pointers
tempProg                = systemBackup+256      ; store address for temporary memory after systemBack
vars                    = tempProg+2            ; store game variables after tempProg
vars2                   = vars+270
videoBuffer             = SavesScreen           ; 768 bytes for a video buffer

vat                     = progptr               ; will be referred to as vat in program

; library defines
libDetect               = iDetect
libFastCopy             = iFastCopy
libRandom               = iRandom

#define bcallnc(label) jr c,$+5 \ rst 28h \ .dw label

_lcdbusy                = $4051                 ; not defined in mirage.inc

.org    $9D93                                   ; progstart-2
.db     $BB, $6D                                ; AsmPrgm token
        ret                                     ; TI-OS can't run program
.db     1                                       ; MirageOS identifier
.db %00000000, %00000000                        ; program Image
.db %00000000, %00000000
.db %00000000, %00000000
.db %01110000, %00000000
.db %10001000, %00000000
.db %10110100, %00000000
.db %01111100, %00001010
.db %01111110, %01010100
.db %10110111, %00101010
.db %10001000, %01010100
.db %01110000, %00001010
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000

.db     "Alien Breed 5",0
#endif

;------------------------------------------------
; TI-83+ DoorsCS header
;------------------------------------------------
#ifdef DOORS
#define TI83P
#include "ti83plus.inc"                         ; TI=83+ include file
#include "dcs7.inc"                             ; DoorsCS7 include file

FRAME_TIMER             = 3
systemBackup            = appBackupScreen       ; 256 bytes to backup system pointers
tempProg                = systemBackup+256      ; store address for temporary memory after systemBack
vars                    = tempProg+2            ; store game variables after tempProg
vars2                   = vars+270
videoBuffer             = saveSScreen           ; 768 bytes for a video buffer

vat                     = progptr               ; will be referred to as vat in program

; library defines
libDetect               = iDetect
libFastCopy             = iFastCopy
libRandom               = iRandom

#define bcall(label) rst 28h \ .dw label
#define bcallnc(label) jr c,$+5 \ rst 28h \ .dw label

_lcdbusy                = $4051                 ; not defined in DoorsCS include

.org    $9D93                                   ; progstart-2
.db     $BB, $6D                                ; AsmPrgm token
        xor     d                               ; identifies this as a DoorsCS program
        ret                                     ; TI-OS can't run program
        jr      start                           ; jump to start of program

        .dw     description
        .db     $07, $00
        .dw     icon
        .dw     $0000

description:
.db     "Alien Breed 5",0

icon:
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %01110000, %00000000
.db %10001000, %00000000
.db %10110100, %00000000
.db %01111100, %00001010
.db %01111110, %01010100
.db %10110111, %00101010
.db %10001000, %01010100
.db %01110000, %00001010
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
#endif

;------------------------------------------------
; TI-83+ App Header
;------------------------------------------------
#ifdef APP83P
#define TI83P
#define LIB83P
#define NOTMOSDCS
#define STATS
#include "ti83plus.inc"                         ; TI=83+ include file

FRAME_TIMER             = 3
HSCORE_APPVAR_SIZE      = 1+(18*3)
HSCORE_OFFSET           = HSCORE_APPVAR_SIZE-6
MEM_NEEDED              = LEVEL_SIZE+9+HSCORE_APPVAR_SIZE+12 ; free memory required is size of an uncompressed level, plus 9 bytes for VAT data of temp file, plus space for appvar in case it needs to be created
systemBackup            = appBackupScreen       ; 256 bytes to backup system pointers
tempProg                = systemBackup+256      ; store address for temporary memory after systemBack
vars                    = tempProg+2            ; store game variables after tempProg
vars2                   = vars+270
videoBuffer             = saveSScreen           ; 768 bytes for a video buffer
strBuffer               = op1
hscorePtr               = statVars              ; pointer to location of high score appvar in ram

; extra variables that are stored in-code for other versions
; this won't work for a flash app (no write back allowed)
__menuItem              = hscorePtr+2           ; 1
__fixTiles              = __menuItem+1          ; 2
__wallTilePtr           = __fixTiles+2          ; 2
__wallFlags             = __wallTilePtr+2       ; 1
__loadingIndicator      = __wallFlags+1         ; 1
__dlY                   = __loadingIndicator+1  ; 1
__dlX                   = __dlY+1               ; 1
__svA                   = __dlX+1               ; 1
__svgbuf                = __svA+1               ; 2
__svgbufEndRow          = __svgbuf+2            ; 2
__psb                   = __svgbufEndRow+2      ; 1
__ctTileType            = __psb+1               ; 1
__playerScrY            = __ctTileType+1        ; 1
__playerScrX            = __playerScrY+1        ; 1
__vsc1                  = __playerScrX+1        ; 1
__vsc2                  = __vsc1+1              ; 1
__putCMSRows2Put        = __vsc2+1              ; 1
__putCMSClipMask        = __putCMSRows2Put+1    ; 1
__putCMSBitMask         = __putCMSClipMask+1    ; 1
__putCSClipMask         = __putCMSBitMask+1     ; 1
__putCSRows2Put         = __putCSClipMask+1     ; 1
__putCSBitMask          = __putCSRows2Put+1     ; 1
__enemyXTest            = __putCSBitMask+1      ; 2
__enemyYTest            = __enemyXTest+2        ; 2
__bossSprCnt            = __enemyYTest+2        ; 1
__bossSprPtr            = __bossSprCnt+1        ; 2
__bossX                 = __bossSprPtr+2        ; 2
__bossY                 = __bossX+2             ; 2
__bossScrX              = __bossY+2             ; 1
__bossScrY              = __bossScrX+1          ; 1
__bossDir               = __bossScrY+1          ; 1
__bossYCnt              = __bossDir+1           ; 1
__cbecDamage            = __bossYCnt+1          ; 1
__bossHealth            = __cbecDamage+1        ; 2
__cbbcDamage            = __bossHealth+2        ; 1
__intexJumpTable        = __cbbcDamage+1        ; 2
__intexOptions          = __intexJumpTable+2    ; 1
__intexMenuItem         = __intexOptions+1      ; 1
__intexCursorTable      = __intexMenuItem+1     ; 2
__ddmLeftOffset         = __intexCursorTable+2  ; 1
__ddmLineCounter        = __ddmLeftOffset+1     ; 1
__ddmsShiftCounter      = __ddmLineCounter+1    ; 1
__randData              = __ddmsShiftCounter+1  ; 2
__tileShotHits          = __randData+2          ; 1
__tileShotPtr           = __tileShotHits+1      ; 2

; aliases for each 2 byte location in ram that will have a single byte opcode, followed by "ret"
appcalls                = statVars+300
__slTriggerCheck        = appcalls
__srTriggerCheck        = appcalls+2
__svIncDec              = appcalls+4
__svTriggerCheck        = appcalls+6
__dbBlast               = appcalls+8
__enemyPlane            = appcalls+10
__enemySpeedCheat       = appcalls+12
__noWallsCheat          = appcalls+14
__invincibleCheat       = appcalls+16
__insaneModeCheat       = appcalls+18
__intexShowCredits      = appcalls+20
__getStringEnter        = appcalls+22
NUM_APPCALLS            = 12

#define _memfree
#define _enoughRam
#define bcall(label) rst 28h \ .dw label
#define bcallnc(label) jr c,$+5 \ rst 28h \ .dw label

_lcdbusy                = $4051
vat                     = progptr               ; will be referred to as vat in program
gbuf                    = plotsscreen

.org    $4000

; app header
.db 080h, 00Fh
.db 000h, 000h, 000h, 000h
.db 080h, 012h
.db 001h, 004h
.db 080h, 021h
.db 001h
.db 080h, 031h
.db 001h
.db 080h, 048h
.db "AB5     "                                  ; app name
.db 080h, 081h
.db 001h                                        ; # pages
.db 080h, 090h
.db 003h, 026h, 009h, 004h
.db 00Ah, 074h, 02Bh, 00Ah
.db 002h, 00Dh, 040h, 0A1h, 06Bh, 099h, 0F6h, 059h, 0BCh, 067h
.db 0F5h, 085h, 09Ch, 009h, 06Ch, 00Fh, 0B4h, 003h, 09Bh, 0C9h
.db 003h, 032h, 02Ch, 0E0h, 003h, 020h, 0E3h, 02Ch, 0F4h, 02Dh
.db 073h, 0B4h, 027h, 0C4h, 0A0h, 072h, 054h, 0B9h, 0EAh, 07Ch
.db 03Bh, 0AAh, 016h, 0F6h, 077h, 083h, 07Ah, 0EEh, 01Ah, 0D4h
.db 042h, 04Ch, 06Bh, 08Bh, 013h, 01Fh, 0BBh, 093h, 08Bh, 0FCh
.db 019h, 01Ch, 03Ch, 0ECh, 04Dh, 0E5h, 075h
.db 080h, 07Fh
.db 000h, 000h, 000h, 000h
.db 000h, 000h, 000h, 000h
.db 000h, 000h, 000h, 000h
.db 000h, 000h, 000h, 000h
.db 000h, 000h, 000h, 000h
#endif

;------------------------------------------------
; other misc game defines
;------------------------------------------------
#include "vars.asm"                             ; variable definitions

#include "get_key.inc"                          ; GET_KEY equates
#include "directin.inc"                         ; Direct Input equates

#define PUT_ALIGNED_SPRITE                      ; include putAlignedSprite routine from sprite.asm
#define PUT_SPRITE                              ; include putSprite routine from sprite.asm
#define PUT_CLIPPED_SPRITE                      ; include putClippedSprite routine from sprite.asm
#define PUT_CLIPPED_MASKED_SPRITE               ; include putClippedMaskedSprite routine from sprite.asm
#define PS_XOR                                  ; set putSprite routine to XOR instead of OR
#define RIGHT_CLIP 96                           ; define the width of the screen for sprite.asm

#define MOVE9() rst 20h                         ; macro to move 9 bytes from (HL) to OP1

#ifdef ION
apdable                 = 2
apdrunning              = 3
apdflags                = 8
#endif
#ifdef TI83
timer                   = $8009
#endif
#ifdef TI83P
timer                   = $8448
#endif

.end
