;===============================================================;
;                                                               ;
; Alien Breed 5                                                 ;
; Version 1.1.1                                                 ;
;                                                               ;
; Copyright (c)2012-2013 James Vernon                           ;
; jamesv82@live.com.au                                          ;
; http://www.jvti.org                                           ;
;                                                               ;
; You are allowed to use parts of this code as long as you give ;
; credit where it is due :)                                     ;
;                                                               ;
;===============================================================;

#include "ab5.h"                                ; header file

;------------------------------------------------
; Start of program
;------------------------------------------------
start:
#ifdef STATS
        res     statsvalid,(iy+statflags)       ; TI-83 needs this memory area for variables
#endif

#ifdef APP83P
        ld      hl,appcalls                     ; HL => first byte
        ld      (hl),$C9                        ; (HL) = "ret" instruction
        ld      de,appcalls+1                   ; DE => where to start copying
        ld      bc,NUM_APPCALLS*2-1             ; BC = number of bytes to copy
        ldir                                    ; clear all of (appcalls)
#endif

#ifdef TI83P
        im      1                               ; ensure running on im 1 on TI-83+ as mirageos changes to im 2
        set     apdable,(iy+apdflags)           ; ensure apd is enabled as mirageos disables it
#endif

        set     textwrite,(iy+sgrflags)         ; write text to gbuf

        ld      hl,strJVTIPresents              ; HL => intro string
        call    displayPage                     ; type it out
        ld      b,200
        call    wait                            ; wait B times

; clear all cheats
        ld      a,$B7                           ; A = "or a"
        ld      (__enemySpeedCheat),a
        ld      (__noWallsCheat),a
        ld      (__invincibleCheat),a
        ld      (__insaneModeCheat),a

; clear system pointers after gbuf so we have a 1024 byte buffer for huffman decompression routine
        ld      hl,gbuf+768                     ; HL => system pointers
        ld      de,systemBackup                 ; DE => 256 bytes to store them at
        ld      bc,256
        ldir                                    ; save them

#ifdef TI83
        call    _memfree                        ; HL = free memory
        ld      de,MEM_NEEDED
        sbc     hl,de                           ; check if enough free memory
        jp      c,quit                          ; if not, quit
#else
        ld      hl,MEM_NEEDED                   ; HL = required memory
        bcall(_enoughMem)                       ; check free memory
        jp      c,quit                          ; if not enough, quit
#endif
        call    checkTempFile                   ; call routine used at end of program to make sure the temp file doesn't already exist
        ld      hl,LEVEL_SIZE                   ; HL = size of temp program file
        bcall(_createprog)                      ; create it
        inc     de
        inc     de                              ; DE => start of storage inside temp program file
        ld      (tempProg),de                   ; save pointer

#ifdef APP83P
findHscoreAppvar:
        ld      hl,hscoreAppvar
        MOVE9()                                 ; (OP1) = name of appvar to be checked for and created if necessary
        bcall(_chkfindsym)
        jr      nc,hscoreAppvarFound            ; if it's already on the calc, nothing required now
; otherwise, let's create it and put the default high score data in it
        ld      hl,HSCORE_APPVAR_SIZE           ; HL = size of appvar to be created
        bcall(_createappvar)
        push    de                              ; save ptr to appvar data (size bytes)
        inc     de
        inc     de                              ; DE => start of appvar actual data storage
        ld      hl,highScoreNames               ; HL => default high score data
        ld      bc,HSCORE_APPVAR_SIZE           ; BC = bytes to copy
        ldir                                    ; load default high score data into appvar
        pop     de                              ; DE => restore ptr
        jr      hscoreAppvarRam
hscoreAppvarFound:
        ld      a,b                             ; A = rom page (or 0 if in ram)
        or      a                               ; check if in ram
        jr      z,hscoreAppvarRam               ; if so, no need to unarchive
        bcall(_arc_unarc)                       ; unarchive appvar (name is still in OP1)
        jr      findHscoreAppvar                ; go find the appvar again (which will now be in ram)
hscoreAppvarRam:
        inc     de
        inc     de                              ; DE => start of appvar data storage
        ld      (hscorePtr),de                  ; save ptr
#endif

mainMenu:
        xor     a
        ld      (__menuItem),a
        ld      (difficulty),a

mainmenuLoop:
        ld      hl,titleDat                     ; HL => compressed title screen picture
        ld      de,gbuf                         ; DE => where to extract it to
        ld      ix,(tempProg)                   ; IX => 1024 bytes of temp memory for huffExtr
        call    huffExtr                        ; extract the title screen picture

        ld      hl,strNormal                    ; HL => "NORMAL"
        ld      a,(difficulty)
        or      a                               ; difficulty = normal?
        jr      z,dispDifficulty                ; if so, display string that HL is already pointing to
        ld      hl,strTough                     ; HL => "TOUGH"
dispDifficulty:
        ld      de,34*256+29
        call    vPuts                           ; display difficulty (mode) string

        ld      bc,(__menuItem-1)               ; B = __menuItem
        inc     b                               ; we want counter to be 1 for __menuItem=0, 2 for __menuItem=1, etc.
        ld      a,14                            ; A = y position for __menuItem = 0 less 7 pixels
mainmenuIncLoop:
        add     a,7                             ; calc y position of next line on menu
        djnz    mainmenuIncLoop                 ; repeat until A = y coord for sprite
        ld      l,a                             ; L = y coord
        ld      a,3                             ; A = x coord
        ld      de,sprMenuItem                  ; DE => sprite data
        call    putSprite                       ; XOR sprite to gbuf

; invert the gbuf
        ld      hl,gbuf                         ; HL => start of where to invert
        ld      b,64                            ; B = number of lines to invert
        call    invertLine

        call    libFastCopy
        call    waitKey

        cp      GK_2ND                          ; was [2nd] pressed?
        jr      z,mainmenu2nd                   ; if so, check what was selected at the menu
        cp      GK_UP                           ; was [UP] pressed?
        jr      z,mainmenuUp                    ; if so, move selection up
        cp      GK_DOWN                         ; was [DOWN] pressed?
        jr      z,mainmenuDown                  ; if so, move selection down
        jr      mainmenuLoop                    ; otherwise, loop again

mainmenuUp:
        ld      hl,__menuItem                   ; (HL) = __menuItem
        dec     (hl)
        bit     7,(hl)
        jr      z,mainmenuLoop                  ; if it didn't go to -1, no correction needed
        ld      (hl),4                          ; otherwise, go to bottom selection
        jr      mainmenuLoop

mainmenuDown:
        ld      hl,__menuItem                   ; (HL) = __menuItem
        inc     (hl)
        ld      a,(hl)
        cp      5
        jr      nz,mainMenuLoop                 ; if it didn't go to 3, no correction needed
        ld      (hl),0                          ; otherwise, go to top selection
        jp      mainmenuLoop

mainmenu2nd:
#ifndef APP83P
        ld      a,$00                           ; menu selection will be stored here
__menuItem               = $-1
#else
        ld      a,(__menuItem)
#endif
        or      a                               ; does __menuItem = 0?
        jr      z,newGame                       ; if so, start a new game
        dec     a                               ; does __menuItem = 1?
        jp      z,enterPasscode                 ; if so, ask for a passcode to be entered
        dec     a                               ; does __menuItem = 2?
        jr      z,toggleDifficulty              ; if so, toggle difficulty
        dec     a                               ; does __menuItem = 3?
        jp      z,viewHighScores                ; if so, go to high score screen
; otherwise, quit was selected, so fall through to quit

quit:
        ld      hl,systemBackup                 ; HL => backed up system pointers
        ld      de,gbuf+768                     ; DE => where to restore them to
        ld      bc,256
        ldir                                    ; restore them
        res     textwrite,(iy+sgrflags)         ; write text directly to lcd
#ifdef STATS
        set     statsvalid,(iy+statflags)       ; Set statsvalid flag
#endif
#ifdef APP83P
        ld      hl,appQuit
        push    hl                              ; for flash app version, force program to ret to appQuit, so that it can close the program properly
#endif
checkTempFile:
        ld      hl,tempName                     ; HL => temporary program file name
        MOVE9()                                 ; move it to OP1
        bcall(_chkfindsym)                      ; check if it exists
        bcallnc(_delvar)                        ; if so, delete it
        ret

#ifdef APP83P
appQuit:
        ld      hl,hscoreAppvar
        MOVE9()
        bcall(_chkfindsym)                      ; find the high score appvar (which will be in ram if it's on the calc)
        jr      c,hscoreAppvarNoArc
        bcall(_arc_unarc)                       ; archive the high score appvar
hscoreAppvarNoArc:
        bjump(_JForceCmdNoChar)
#endif

toggleDifficulty:
        ld      a,(difficulty)                  ; A = difficulty
        xor     %00000001                       ; toggle it (by toggling bit 0)
        ld      (difficulty),a                  ; save it
        jp      mainmenuLoop                    ; return to main menu

dataFileMissing:
        bcall(_grbufclr)
        ld      hl,(level)
        srl     l                               ; L = level / 2 (2 levels per data file)
        ld      h,23                            ; H = 23 bytes per string
        bcall(_htimesl)
        ld      de,strEpisode1Missing
        add     hl,de
        ld      de,28*256+12
        call    vPuts                           ; "File ZAB5XXXX missing!",0
        call    libFastCopy
        call    waitKey
        jp      checkHighScore

newGame:
        xor     a                               ; A = 0
        ld      h,a
        ld      l,a                             ; HL = 0
        ld      (level),a                       ; start on level 0 (level 1)
        ld      (keys),a                        ; keys = 0
        ld      (credits),hl                    ; credits = 0
        inc     a                               ; A = 1
        ld      (weaponTable),a
        jr      startGame

newPCGame:
        ld      a,5
        ld      (keys),a                        ; keys = 5 if you start with a passcode
; fall through to startGame

startGame:
        xor     a                               ; A = 0
        ld      h,a
        ld      l,a                             ; HL = 0
        ld      (playerDir),a                   ; direction = up
        ld      (score),hl                      ; score = 0
        inc     a                               ; A = 1
        ld      (weapon),a
        ld      a,4
        ld      (lives),a                       ; lives = 4
        ld      a,MAX_HEALTH
        ld      (health),a                      ; health = MAX_HEALTH
        ld      hl,2*256+255                    ; 2*unopened clips + 1*full clip
        ld      (ammo),hl

startLevel:
        call    loadLevel                       ; load level
        jp      mainGameLoop

levelFinished:
        call    fadeOut                         ; fade out lcd
        bcall(_grbufclr)
        call    libFastCopy                     ; clear lcd contents
        call    restoreContrast                 ; restore lcd contrast
        ld      hl,SCORE_LEVEL
        call    addScore                        ; add score for finishing a level
        ld      hl,level
        inc     (hl)                            ; inc level number
        ld      a,(hl)
        cp      E1_MAXLEVEL                     ; has player finished the episode?
        jp      z,episodeFinished               ; if so, go deal with that

; generate & draw the descending elevator screen
        ld      b,64                            ; B = 64 gbuf lines to generate
        ld      de,gbuf                         ; DE => start of gbuf
drawElevatorShaft:
        push    bc                              ; save line counter
        ld      b,12                            ; B = 12 bytes per gbuf line
        ld      hl,elevatorScrMasks             ; HL => AND & OR data to use for the line
drawEShaftLine:
        push    bc                              ; save byte counter
        ld      b,4
        call    libRandom                       ; A = 0-3
        ld      c,a
        ld      b,0                             ; BC = random #
        push    hl                              ; save mask data ptr
        ld      hl,elevatorScrRandoms
        add     hl,bc
        ld      a,(hl)                          ; A = a random byte to display
        pop     hl                              ; restore mask data ptr
        and     (hl)                            ; apply the AND mask
        inc     hl
        or      (hl)                            ; apply the OR mask
        inc     hl                              ; HL => next pair of mask byte data
        ld      (de),a                          ; write byte to gbuf
        inc     de                              ; DE => next byte of gbuf
        pop     bc
        djnz    drawEShaftLine
        pop     bc
        djnz    drawElevatorShaft

; do the animation part
        ld      b,88                            ; B = 88 frames
elevatorAnimLoop:
        push    bc                              ; save frame counter
        ld      a,b
        sub     64
        neg                                     ; A = y coord for this frame
        call    saveVideo                       ; save background
        ld      b,6                             ; B = 6 sprites to draw
        ld      c,a                             ; C = y coord for this frame
        ld      hl,elevatorSprOffsets           ; HL => coord offset data
        ld      de,sprElevatorMan               ; DE => start of sprites
        bit     0,c                             ; check if an even frame
        jr      z,elevatorAnimDraw              ; if so, draw as normal
        ld      de,sprElevatorMan2              ; DE => start of sprites that vary by not showing boosters shooting out of bottom of elevator
elevatorAnimDraw:
        push    bc                              ; save sprite counter & y coord
        ld      b,(hl)                          ; B = x coord
        inc     hl
        ld      a,(hl)                          ; A = y offset
        inc     hl                              ; HL => offset data for next sprite
        add     a,c
        ld      c,a                             ; C = y coord
        ex      de,hl                           ; DE => offset data for next sprite; HL => sprite to draw
        push    de
        push    hl
        call    putClippedSprite                ; draw sprite
        pop     hl
        ld      bc,8
        add     hl,bc                           ; HL => next sprite to draw
        pop     de
        ex      de,hl                           ; DE => next sprite; HL => next offset data
        pop     bc                              ; restore sprite counter & y coord
        djnz    elevatorAnimDraw
        call    libFastCopy                     ; draw frame
        call    restoreVideo                    ; restore background without sprites
        ld      b,1
        call    wait
        pop     bc                              ; restore frame counter
        djnz    elevatorAnimLoop

; white out the text area
        ld      b,32                            ; B = 32 lines to white out
        ld      hl,gbuf+(16*12)+4               ; HL => where to start whiting out
        ld      de,5                            ; DE = number of bytes to skip to get to next line
whiteoutLoop:
        ld      c,7                             ; C = 7 bytes to clear per line
whiteoutLineLoop:
        ld      (hl),0                          ; clear byte of gbuf
        inc     hl                              ; HL => next byte
        dec     c
        jr      nz,whiteoutLineLoop
        add     hl,de                           ; HL => first byte to clear on next line
        djnz    whiteoutLoop

        ld      hl,strLevelComplete
        call    showStrings                     ; show level complete text
        ld      a,(levelFlags)
        bit     LFLAG_PASSCODE,a                ; check to see if player should get a passcode
        jr      z,levelFinishedWait             ; if not, skip generating/showing one
        call    showStrings                     ; show passcode text
; generate a passcode & display it
; first, save the 3 variables (4 bytes) consecutively
        ld      hl,passcodeVars                 ; HL => where to store variables consecutively
        push    hl                              ; save ptr
        ld      a,(level)
        ld      (hl),a                          ; save level number
        inc     hl
        ld      a,(weaponTable)
        ld      (hl),a                          ; save weapon table
        inc     hl
        ld      de,(credits)
        ld      (hl),e                          ; save credits LSB
        inc     hl
        ld      (hl),d                          ; save credits MSB
; now, split the 4 bytes into 8 bytes, effectively stored as 8 nibbles (each byte only uses the 4 lsb's)
        pop     de                              ; DE => start of consecutive vars
        ld      hl,passcode                     ; HL => where to store them
        push    hl                              ; save passcode data ptr
        ld      b,4                             ; B = 4 bytes to split
splitPCVarsLoop:
        ld      a,(de)                          ; A = first byte
        rrca
        rrca
        rrca
        rrca
        and     %00001111                       ; A = first nibble of byte
        ld      (hl),a                          ; save it
        inc     hl
        ld      a,(de)
        and     %00001111                       ; A = second nibble of byte
        ld      (hl),a                          ; save it
        inc     hl
        inc     de
        djnz    splitPCVarsLoop
; get a random key 0-15
        ld      b,16
        call    libRandom                       ; A = random between 0-15 inclusive
        ld      (hl),a                          ; save key
; now add key to all 8 nibbles & calculate checksum as well
        ld      d,a                             ; D = key
        pop     hl                              ; HL => start of nibble data
        push    hl                              ; save ptr again
        ld      bc,8*256+0                      ; B = 8 nibbles to encode; C = reset checksum counter
encodePCLoop:
        ld      a,(hl)                          ; A = nibble
        add     a,d                             ; apply random key
        and     %00001111                       ; mask to get rid of any overflow
        ld      (hl),a                          ; save encoded nibble
        add     a,c
        ld      c,a                             ; update checksum
        inc     hl                              ; update ptr
        djnz    encodePCLoop
        inc     hl                              ; HL => where to store checksum
        ld      a,c
        and     %00001111                       ; mask checksum to get rid of any overflow
        ld      (hl),a                          ; save checksum
; finally, convert encoded nibbles into characters, which is the passcode
        pop     hl                              ; HL => start of passcode data
        push    hl                              ; save ptr again
        ld      b,10                            ; B = 10 nibbles to convert
        ld      de,passcodeChars                ; DE => passcode value to char conversion table
makePCLoop:
        push    hl                              ; save ptr
        ld      l,(hl)
        ld      h,0                             ; HL = nibble data
        add     hl,de                           ; HL => char to use
        ld      a,(hl)
        pop     hl                              ; restore ptr
        ld      (hl),a                          ; save char
        inc     hl                              ; update ptr
        djnz    makePCLoop
        ld      (hl),0                          ; NULL terminator
        pop     hl                              ; HL => generated passcode string
        ld      de,39*256+41
        call    vPuts
levelFinishedWait:
        call    libFastCopy
        call    wait2nd
        jp      startLevel                      ; start at next level

enterPasscode:
        bcall(_grbufclr)
        ld      hl,strEnterPasscode
        ld      de,24*256+22
        call    vPuts                           ; "Enter passcode:"
        ld      hl,passcode                     ; HL => where to store passcode
        ld      a,$BF                           ; A = "or a" (tell getString routine to ignore [ENTER])
        call    getString
; check if a cheat code was entered
        ld      hl,cheatcodes                   ; HL => cheat code data
        ld      b,(hl)                          ; B = number of cheat codes to check
        inc     hl                              ; HL => first cheat code
checkCheatCodes:
        push    bc                              ; save cheat code counter
        ld      bc,10*256+0                     ; B = 10 characters to check; C = clear error flag
        ld      de,passcode                     ; DE => passcode that was entered
checkCheatCodeLoop:
        ld      a,(de)                          ; A = passcode char
        cp      (hl)                            ; compare it to cheat code char
        jr      z,cheatCodeCharOK               ; if they're equal, this char is ok
        inc     c                               ; otherwise, increment the error flag
cheatCodeCharOK:
        inc     de                              ; DE => next passcode char
        inc     hl                              ; HL => next cheatcode char
        djnz    checkCheatCodeLoop
        ld      a,c                             ; A = error flag
        pop     bc                              ; restore cheat code counter
        or      a                               ; check if any errors were registered during this cheat code check
        jr      z,enableCheat                   ; if no errors, this cheat code matched, so enable the cheat
        djnz    checkCheatCodes                 ; otherwise, loop for next cheat code until done
; decode & validate the passcode that was entered
; first, convert characters back to nibble values
        ld      hl,passcode                     ; HL => start of passcode
        push    hl                              ; save ptr for later
        ld      b,10                            ; B = 10 characters to convert
        ld      de,passcodeValues               ; DE => passcode char to value conversion table
unmakePCLoop:
        push    hl                              ; save ptr
        ld      a,(hl)                          ; A = char
        sub     'A'                             ; A = entry in passcodeValues to get
        ld      l,a
        ld      h,0
        add     hl,de                           ; HL => value for nibble
        ld      a,(hl)
        pop     hl                              ; restore ptr
        ld      (hl),a                          ; save value
        inc     hl                              ; update ptr
        djnz    unmakePCLoop
; calculate checksum and sub key value from the 8 nibbles at the same time
        dec     hl
        dec     hl                              ; HL => key
        ld      d,(hl)                          ; D = key value
        pop     hl                              ; HL => start of nibble data
        push    hl                              ; save ptr again
        ld      bc,8*256+0                      ; B = 8 nibbles to decode; C = reset checksum
decodePCLoop:
        ld      a,(hl)                          ; A = encoded nibble
        add     a,c
        ld      c,a                             ; update checksum
        ld      a,(hl)                          ; A = encoded nibble
        sub     d                               ; subtract the key value
        and     %00001111                       ; mask out any underflow
        ld      (hl),a                          ; save decoded nibble
        inc     hl                              ; update ptr
        djnz    decodePCLoop
        inc     hl                              ; HL => saved checksum
        ld      a,c                             ; A = calculated checksum
        and     %00001111                       ; mask out any possible overflow
        cp      (hl)                            ; check if they match
        pop     hl                              ; HL => start of nibble data
        jr      nz,invalidPasscode              ; if not, passcode invalid
; now put nibbles back together to form 4 sequential bytes, which is our variables (level, weaponTable, credits_LSB, credits_MSB)
        ld      de,passcodeVars                 ; DE => where to store variables as 4 bytes
        push    de                              ; save var ptr
        ld      b,4                             ; B = 4 bytes to create
makePCVarsLoop:
        ld      a,(hl)                          ; A = first nibble of byte
        rlca
        rlca
        rlca
        rlca                                    ; A = first nibble stored in 4 msb's
        inc     hl                              ; HL => second nibble of byte
        or      (hl)                            ; A = full byte
        ld      (de),a                          ; save byte
        inc     hl                              ; update nibble ptr
        inc     de                              ; update byte ptr
        djnz    makePCVarsLoop
; save the 4 sequential bytes into their proper variable locations and error-check at the same time
        pop     hl                              ; HL => start of sequential byte data
        ld      a,(hl)                          ; A = level
        ld      (level),a                       ; save it
        cp      E1_MAXLEVEL                     ; check if level value is within range of available levels
        jr      nc,invalidPasscode              ; if not, passcode invalid
        inc     hl
        ld      a,(hl)                          ; A = weapon table
        ld      (weaponTable),a                 ; save it
        and     %11000000                       ; check that no junk data is stored
        jr      nz,invalidPasscode              ; if so, passcode invalid
        inc     hl
        ld      e,(hl)                          ; E = credits LSB
        inc     hl
        ld      d,(hl)                          ; D = credits MSB
        ld      (credits),de                    ; save it
        jp      newPCGame                       ; new game with variables from passcode

invalidPasscode:
        ld      hl,strInvalidPasscode
        ld      de,43*256+19
        call    vPuts                           ; "Invalid passcode!"
        call    libFastCopy
        call    waitKey
        jp      mainMenu

enableCheat:
        ld      a,b
        dec     a                               ; A = cheat number
        add     a,a                             ; x2
        ld      e,a
        ld      d,0
        ld      hl,cheatTable
        add     hl,de
        bcall(_ldhlind)                         ; HL => where to load cheat to
        ld      (hl),$37                        ; load "scf" which will set the cheat
        jp      mainMenu

episodeFinished:
; when code reaches here, the player has just completed the episode
; thus, the final data file for the episode is already available
; the address to start of the data file is located in (levelFilesPtr)
; there are 2 compressed files (levels) per data file, but in the last data file, the epilogue is a 3rd compressed file
        ld      hl,(levelFilesPtr)              ; HL => compressed data file
        ld      de,(tempProg)                   ; DE => where to extract epilogue data to
        ld      ix,gbuf                         ; IX => 1024 of memory for huffExtr
        ld      b,2                             ; B = file number to load
        call    huffExtr                        ; extract epilogue
        ld      hl,(tempProg)                   ; HL => uncompressed epilogue data
        ld      b,(hl)                          ; B = # pages to show
        inc     hl                              ; HL => text data
epilogueLoop:
        push    bc                              ; save page counter
        call    displayPage
        push    hl                              ; save text data ptr
        call    wait2nd
        pop     hl                              ; restore text data ptr
        pop     bc                              ; restore page counter
        djnz    epilogueLoop                    ; loop to show all pages
; fall through to game over screen

gameOver:
        bcall(_grbufclr)
        ld      hl,strGameOver
        ld      de,28*256+28
        call    vPuts                           ; "GAME OVER"
        ld      hl,gbuf
        ld      b,64
        call    invertLine                      ; invert full gbuf
        call    libFastCopy
        call    wait2nd

checkHighScore:
#ifndef APP83P
        ld      hl,highScores                   ; HL => high scores
#else
        ld      hl,(hscorePtr)
        ld      de,HSCORE_OFFSET
        add     hl,de                           ; HL => high scores
#endif
        ld      de,(score)                      ; DE = player score
        ld      b,3                             ; B = max 3 high scores to check
checkHighScoreLoop:
        push    hl                              ; save ptr
        bcall(_ldhlind)                         ; HL = high score to check
        bcall(_cphlde)                          ; check if player score beat this high score
        pop     hl                              ; restore ptr
        jr      c,newHighScore
        inc     hl
        inc     hl                              ; HL => next high score to check
        djnz    checkHighScoreLoop
        jp      mainMenu                        ; no high scores were beaten, return to main menu
newHighScore:
        ld      a,4
        sub     b                               ; A = slot number for high score (1 being the top score, 2 the 2nd, 3 the 3rd)
        cp      3                               ; check if it's the bottom entry on the table
        push    af                              ; save slot number
        jr      z,enterNewHighScore             ; if so, no rearranging required
#ifndef APP83P
        ld      de,highScoreNames+5+16          ; DE => 2nd high score name
        ld      hl,highScores+2                 ; HL => 2nd high score
#else
        ld      hl,(hscorePtr)
        push    hl
        ld      de,5+16
        add     hl,de
        ex      de,hl                           ; DE => 2nd high score name
        pop     hl
        ld      bc,HSCORE_OFFSET+2
        add     hl,bc                           ; HL => 2nd high score
#endif
moveHighScores:
        ld      c,(hl)
        inc     hl
        ld      b,(hl)                          ; BC = high score
        inc     hl
        ld      (hl),c
        inc     hl
        ld      (hl),b                          ; saved to next slot down
        ld      h,d
        ld      l,e                             ; HL => this high score name
        ld      bc,16
        add     hl,bc                           ; HL => where to copy it to
        ex      de,hl
        ld      bc,10                           ; BC = 10 characters to copy
        ldir                                    ; copy name down one slot in table
#ifndef APP83P
        ld      de,highScoreNames+5             ; DE => 1st high score name
        ld      hl,highScores                   ; HL => 1st high score
#else
        ld      hl,(hscorePtr)
        push    hl
        ld      de,6
        add     hl,de
        ex      de,hl                           ; DE => 1st high score name
        pop     hl
        ld      bc,HSCORE_OFFSET
        add     hl,bc                           ; HL => 1st high score
#endif
        dec     a                               ; did player score the top score?
        jr      z,moveHighScores                ; if so, loop again to move top name down to 2nd
enterNewHighScore:
#ifndef APP83P
        ld      hl,highScoreNames+6-16          ; HL => first slot name less 1, as we will be adding the offset at least once
        ld      de,highScores-2                 ; DE => first slot less 1
#else
        ld      hl,(hscorePtr)
        push    hl
        ld      de,HSCORE_OFFSET-2
        add     hl,de
        ex      de,hl                           ; DE => first slot less 1
        pop     hl
        ld      bc,6-16
        add     hl,bc                           ; HL => first slot name less 1
#endif
        pop     bc                              ; B = slot number for new high score
getHighNameSlot:
        push    de
        ld      de,16
        add     hl,de                           ; HL => next slot name
        pop     de
        inc     de
        inc     de                              ; DE => next slot score
        djnz    getHighNameSlot                 ; after this loop is finished: HL => where to store new high score name; DE => where to store new high score value
        push    hl                              ; save ptr for name
        ex      de,hl                           ; HL => where to store score
        ld      bc,(score)
        ld      (hl),c                          ; save score LSB
        inc     hl
        ld      (hl),b                          ; save score MSB
        bcall(_grbufclr)
        ld      hl,strNewHighScore              ; HL => string data to display
        call    showStrings                     ; show strings
        pop     hl                              ; restore ptr
        ld      a,$37                           ; A = "scf" (enables [ENTER] key in the getString routine)
        call    getString                       ; prompt for new high score name and store it
; fall through to viewHighScores

viewHighScores:
        bcall(_grbufclr)
        ld      hl,strHighScore                 ; HL => string data
        call    showStrings                     ; show them
#ifdef APP83P                                   ; app build needs to find the data in the appvar and display that
        ld      hl,(hscorePtr)
        call    showStrings
#endif
; after this, HL => high score data
        ld      d,8                             ; initial penrow
        ld      b,3                             ; B = 3 high scores to show
showHighScores:
        ld      e,63                            ; E = pencol
        ld      (pencol),de                     ; set pencol
        push    bc                              ; save counter
        push    hl                              ; save data ptr
        bcall(_ldhlind)                         ; HL = score to show
        call    showHL                          ; display it
        ld      a,(penrow)
        add     a,6
        ld      d,a                             ; D = new penrow
        pop     hl
        inc     hl
        inc     hl                              ; HL => next high score
        pop     bc
        djnz    showHighScores
        call    libFastCopy
        call    waitKey                         ; wait for any key press
        jp      mainMenu                        ; return to main menu

;------------------------------------------------
; Program routines
;------------------------------------------------
#include "anim.asm"                             ; animation routines
#include "boss.asm"                             ; boss routines
#include "collide.asm"                          ; collision detection routines
#include "enemy.asm"                            ; enemy routines
#include "huffextr.asm"                         ; huffman extraction routine
#include "intex.asm"                            ; intex routines
#include "level.asm"                            ; level routines
#include "maingame.asm"                         ; main game loop
#include "misc.asm"                             ; miscellaneous routines
#include "pause.asm"                            ; pause routines
#include "player.asm"                           ; player routines
#include "scroll.asm"                           ; screen scrolling routines
#include "shoot.asm"                            ; shooting routines
#include "sprite.asm"                           ; sprite drawing routines

startData:

;------------------------------------------------
; Start of data
;------------------------------------------------
#include "data.asm"                             ; data

.end
