; utility.asm
;  created 10/11/02

waitUntilKEYup:
 ei
 halt

 ld a,0ffh 			;resets the keypad.
 out (1),a			;'Required syntax' :)
 ld a,0bfh 			;Enable group 1.
 out (1),a 			
 in a,(1) 			;'Required Syntax'

 cp 255
 jr nz,waitUntilKEYup
 ret

delay:
 push bc
 ld b,10
 ei
delayLOP:
 halt
 djnz delayLOP
 pop bc
 ret

loadTitle:
 ld hl,title
 ld de,plotsscreen+1
 ld bc,338
 ldir
 ret

putsApp:
 ld a,(hl)
 inc hl
 or a
 ret z
 B_CALL PutC
 jr putsApp

vputsApp:
 ld a,(hl)
 inc hl
 or a
 ret z
 push hl
 B_CALL VPutMap
 pop hl
 jr vputsApp

showHL:
 ld e,(hl)
 inc hl
 ld d,(hl)
 ex de,hl
 B_CALL setxxxxop2
 B_CALL op2toop1 
 ld a,5
 B_CALL dispop1a
 ret

getrand:
	 push hl
	 push bc
    push de
     ld hl,(randseed)
     ld   a,l
     ld   e,h
     add  a,h
     ld   h,a
     adc  a,e
     sub  h
     
     ld   de,4476
     add  hl,de
     adc  a,0
     
     ex   de,hl
     ld   l,d
     ld   h,a
     xor  a
     
     add  hl,hl
     adc  a,a
     add  hl,hl
     adc  a,a
     add  hl,hl
     adc  a,a
     
     ld   l,a
     ld   a,h
     add  a,e
     ld   e,a
     ld   a,l
     adc  a,d
     and  01Fh
     
     ld   l,e
     ld   h,a
     ld   (randseed),hl
	  ld a,e
     pop  de
	  pop bc
	  pop hl
     ret

invertScreen:
 ld hl,plotsscreen
 ld c,3
invertScreenOuter:
 ld b,0
invertScreenInner:
  ld a,(hl)
  xor 11111111b
  ld (hl),a
  inc hl
  djnz invertScreenInner

  dec c
  jr nz,invertScreenOuter
  ret



;*************************************
;* MODIFIED movax's routine for this
;*************************************
; displays 4x4 sprite on a 16x24 grid
;  a= x, e=y
;**********

sprite:
 push    hl             ; Save sprite address

 ld hl,0
 ld d,0
 add hl,de
 add hl,de		; y*2..
 add hl,de		; y*3...
 add hl,hl		; y*6
 add hl,hl		; y*12

 add hl,hl		; y*24
 add hl,hl		; y*48

 ld      e,a		; x/2
 srl     e
 add     hl,de

 ld      de,plotsscreen
 add     hl,de          ; Add address to graphbuf


 and 1b			; is it odd?
 jr z,ALIGN

 ;we can cheat since its always 4 off.

 pop de
 ld b,4
NOTALIGNED:
 ld a,(de)	; de->sprite location
 srl a
 srl a
 srl a
 srl a		; slide it over 4 bytes
 or (hl)
 ld (hl),a
 inc de
 push bc
 ld bc,12
 add hl,bc
 pop bc
 djnz NOTALIGNED
 ret

ALIGN:
 pop     de              ; de->sprite
 ld      b,4
ALOP1:
 ld      a,(de)
 or      (hl)            ; xor=erase/blit
 ld      (hl),a
 inc     de
 push    bc
 ld      bc,12
 add     hl,bc
 pop     bc
 djnz    ALOP1
 ret
