; enemy.asm
;  started 10/15/02

; Purpose: AI, Display and Creation of enemies

loadEnemies:
 ld a,(enemies)
 ld b,a
 ld hl,enemy_array
LEloop:
 push bc
 push hl

loadEnemiesStartover:
 call getrand
 and 11111b
 cp 23
 jr nc,loadEnemiesStartover
 inc a
 ld (enemyTempX),a
 
 call getrand
 and 1111b
 ld (enemyTempY),a

 call isEnemyValid
 jr nc,loadEnemiesStartover

 pop hl

 ld a,(enemyTempX)
 ld (hl),a
 inc hl
 ld a,(enemyTempY)
 ld (hl),a
 inc hl

 pop bc
 djnz LEloop
 ret

showEnemies:
 ld a,(enemies)
 ld b,a
 ld hl,enemy_array
showEnemyLoop:
 push bc

  inc hl
  ld a,(hl) ; y
  ld e,a
  dec hl
  ld a,(hl) ; x
  inc hl
  inc hl

  push hl
   ld hl,enemySprite
   call sprite
  pop hl
 pop bc
 djnz showEnemyLoop
 ret 

moveEnemies:
 ld hl,enemy_array
 ld a,(enemies)
 ld b,a
moveEnemyLoop:
 push bc
  ld a,(hl)
  ld (enemyTempX),a
  inc hl
  ld a,(hl)
  ld (enemyTempY),a
  dec hl

  call getrand
  ld b,a

  ; lets move IT!!!
  bit 3,a
  jr z,moveEnemyX

  rr b
  inc hl
  ld a,(hl)
  adc a,0

  rr b
  sbc a,0
  ld (enemyTempY),a
  jr dontMoveEnemy

moveEnemyX:
  rl b
  ld a,(hl)
  adc a,0

  rl b
  sbc a,0
  ld (enemyTempX),a
  inc hl
dontMoveEnemy:
  push hl
   ; is it okay?
   call isEnemyValid
   jr nc,continueMoveEnemy   ; not OK?

   ; its okay... set the vars
  pop hl

  dec hl
  ld a,(enemyTempX)
  or a
  jr z,dontMoveEnemy2
  cp 23
  jr nc,dontMoveEnemy2
  ld (hl),a
  inc hl
  ld a,(enemyTempY)
  or a
  jr z,dontMoveEnemy3
  cp 15
  jr nc,dontMoveEnemy3
  ld (hl),a
  push hl
  jr continueMoveEnemy

dontMoveEnemy2:
 inc hl
dontMoveEnemy3:
  push hl
continueMoveEnemy:
  pop hl
  inc hl
 pop bc
 djnz moveEnemyLoop
 ret
