;=======================================================================================
; PrintString4x5 - tr1p1ea(20/08/2004 - dd/mm/yyyy):
; --------------------------------------------------
; Prints a custom 4x5 font zero-terminated string to gBuf (with char-wrapping
; and invalid char check) ASCII chars 32-126, basically anything you can type
; on a keyboard :). 127 is used for an invalid character, or a solid block.
;
; <space>!"#$%&'()*+,-./012345
; 6789:;<->?@ABCDEFGHIJKLMNOPQ
; RSTUVWXYZ[\]^_`abcdefghijklm
; nopqrstuvwxyz{|}~<block>
;
; Usage:
; Include "prntS4x5.inc" in your source and call PrintString4x5 with the
; following inputs:
;
; Input:
; textCol = x coord
; textRow = y coord
; hl = string_pointer
; 
; Output:
; text written to gBuf
;
; Destroys:
; af,bc,de,hl,ix
;
; This routine has been tested and no bugs have been found. Still it does not come
; with a warranty of any kind, use at your own risk.
;
; In the event that you do come across a bug, or you have a suggestion you can
; contact me by email - tr1p1ea@yahoo.com.au
;
; I have no problem with anyone using this routine as long as you credit me
; properly. Please dont try to modify and/or pass this routine off as your
; own with out first gaining my consent.
;=======================================================================================

PrintString4x5:			; print a string with a custom 4x5 font
	ld a,(textCol)		; get text x coord
	bit 7,a			; check if < 0
	jr z,c_check_ux		; jump accordingly
	xor a				; reset a
	ld (textCol),a		; save
c_check_ux:				;
	sub 93			; sub 93
	call nc,psResetCol	; test if it is out of bounds and act
	ld a,(textRow)		; get text y coord
	bit 7,a			; check if < 0
	ret nz			; return if < 0
	sub 60			; sub 60
	ret nc			; return if out of bounds
	push hl			; save string pointer
	add a,60		; restore text y coord
	ld l,a			;
	ld e,a			;
	ld h,0			;
	ld d,h			; store in hl and de
	add hl,hl		; x 2
	add hl,de		; x 3
	add hl,hl		; x 6
	add hl,hl		; x 12
	ld a,(textCol)		; get text x coord
	and %11111000		; mask off the lower 3 bits
	srl a			; shift right ( / 2 )
	srl a			; shift right ( / 4 )
	srl a			; shift right ( / 8 )
	ld e,a			; store in de
	add hl,de		; hl = (y * 12) + x
	ex de,hl		; hl <-> de
	ld ix,gBuf		; load graph buffer in de
	add ix,de		; ix now points to correct byte in gbuf
	pop hl			; restore string pointer
	ld a,(hl)		; get current letter
	or a			; test for end of string
	ret z			; return if end of string
	push hl			; save string pointer
	call ps_checkRange	; check that char is within our range (ascii 32-127)
	sub 32			; sub 32 as our font data starts at ascii #32
	and %00000001		; test to see if char is 1st or 2nd nibble
	ld c,a			; c is our indicator
	ld a,(hl)		; reaquire current letter
	call ps_checkRange	; check that char is within our range (ascii 32-127)
	sub 32			; sub 32 as our font data starts at ascii #32
	sra a			; divide by 2 as its 2 chars per sprite
	ld l,a			;
	ld e,a			;
	ld h,0			;
	ld d,h			; store in hl and de
	add hl,hl		; x 2
	add hl,hl		; x 4
	add hl,de		; x 5 as our char is 5 pixels high
	ld de,fontData		; load our fontData
	add hl,de		; hl now points to correct byte in font data
	ld b,5			; we want to draw 5 rows
drawChar_l:
	ld a,c			; load our nibble indicator
	or a			; test for 1st or 2nd nibble
	jr nz,_2nd_nib		; jump accordingly
_1st_nib:			;
	ld a,(hl)		; get current char byte
	and %11110000		; mask off lower 4 bits
	jr end_aq_nib		; jump over 2nd nib stuff
_2nd_nib:			;
	ld a,(hl)		; get current char byte
	and %00001111		; mask off upper 4 bits
	sla a			; shift left
	sla a			; shift left
	sla a			; shift left
	sla a			; shift left
end_aq_nib:			;
	ld d,a			;
	ld e,0			; de = current char byte
	ld a,(textCol)		; get text x coord
	and %00000111		; mask off upper 5 bits
	or a			; test for aligned sprite
	jr z,align_nib		; jump accordingly
adjust_nib:			;
	srl d			; shift char byte right
	rr e			; bring in carried bit
	dec a			; dec number of shifts
	jr nz,adjust_nib	; loop
align_nib:			;
	ld a,(ix)		; get byte from ix (gBuf)
	or d			; or 1st part of char
	ld (ix),a		; write back to ix (gBuf)
	inc ix			; move to next byte in ix (gBuf)
	ld a,(ix)		; get byte from ix (gBuf)
	or e			; or 2nd part of char
	ld (ix),a		; write back to ix (gBuf)
	ld de,11		; screenwidth-1 in de
	add ix,de		; ix points to next row
	inc hl			; hl points to next byte in char
	djnz drawChar_l		; loop 5 times (draw the char)
	ld c,0			; reset c
	pop hl			; restore string pointer
	ld a,(hl)		; get current char
	cp 32			; is it space?
	jr nz,next_ch_nspc	; jump if not space
	ld c,2			; if its space we only inc 2 pixels
next_ch_nspc:			;
	ld a,(textCol)		; load text x coord
	add a,4			; increase by 4
	sub c			; take 2 if its a space
	ld (textCol),a		; save text x coord
	inc hl			; increase to next character
	jp PrintString4x5	; jump back to start
psResetCol:			;
	xor a			;
	ld (textCol),a		; reset text x coord
	ld a,(textRow)		;
	add a,6			; text y coord + 6
	ld (textRow),a		; store text y coord
	ret			; return
ps_checkRange:			;
	sub 32			; take 32 (ascii)
	jr nc,ps_check_u	; if >= 0 check upper
	ld a,127		; invalid character char
	ret			; return
ps_check_u:			;
	add a,32		; restore char number
	bit 7,a			; check bit 7
	ret z			; return as it will be < 128
	ld a,127		; otherwise load invalid character char
	ret			; return

textCol:			; text x coord
	.db 0
textRow:			; text y coord
	.db 0

				; 4x5 font by tr1p1ea - ASCII 32-126, 127 is invalid char (block)
fontData:			; packed into nibbles - 2 chars = 5 bytes (128 chars = 320 bytes)
  .db $04,$04,$04,$00,$04	; <space> !
  .db $AA,$AE,$0A,$0E,$0A	; " #
  .db $6A,$C2,$E4,$68,$CA	; $ %
  .db $44,$E4,$C0,$A0,$E0	; & '
  .db $24,$42,$42,$42,$24	; ( )
  .db $00,$A4,$4E,$A4,$00	; * +
  .db $00,$00,$0E,$40,$80	; , -
  .db $02,$02,$04,$08,$88	; . /
  .db $4C,$A4,$A4,$A4,$4E	; 0 1
  .db $CE,$22,$44,$82,$EE	; 2 3
  .db $AE,$A8,$EC,$22,$2C	; 4 5
  .db $6E,$82,$E4,$A4,$E4	; 6 7
  .db $EE,$AA,$4E,$A2,$EC	; 8 9
  .db $00,$44,$00,$44,$08	; : ;
  .db $20,$4E,$80,$4E,$20	; < =
  .db $8C,$42,$24,$40,$84	; > ?
  .db $44,$AA,$EE,$8A,$6A	; @ A
  .db $EE,$A8,$C8,$A8,$EE	; B C
  .db $CE,$A8,$AC,$A8,$CE	; D E
  .db $E6,$88,$CA,$8A,$8E	; F G
  .db $AE,$A4,$E4,$A4,$AE	; H I
  .db $2A,$2A,$2C,$AA,$EA	; J K
  .db $8A,$8E,$8E,$8A,$EA	; L M
  .db $CE,$AA,$AA,$AA,$AE	; N O
  .db $EE,$AA,$EA,$8E,$8E	; P Q
  .db $CE,$A8,$CE,$A2,$AE	; R S
  .db $EA,$4A,$4A,$4A,$4E	; T U
  .db $AA,$AA,$AE,$AE,$4A	; V W
  .db $AA,$AA,$4E,$A4,$A4	; X Y
  .db $E6,$24,$44,$84,$E6	; Z [
  .db $86,$82,$42,$22,$26	; \ ]
  .db $40,$A0,$00,$00,$0E	; ^ _
  .db $80,$40,$0E,$0A,$06	; ` a
  .db $00,$80,$C6,$A8,$C6	; b c
  .db $00,$24,$6A,$AC,$66	; d e
  .db $00,$24,$4A,$66,$4C	; f g
  .db $00,$84,$C0,$A4,$A4	; h i
  .db $40,$08,$4A,$4C,$8A	; j k
  .db $00,$40,$4E,$4E,$2A	; l m
  .db $00,$00,$CE,$AA,$AE	; n o
  .db $00,$44,$AA,$C6,$82	; p q
  .db $00,$04,$28,$44,$48	; r s
  .db $00,$40,$6A,$4A,$26	; t u
  .db $00,$00,$AA,$AE,$4E	; v w
  .db $00,$00,$AA,$46,$AC	; x y
  .db $06,$84,$48,$84,$46	; z {
  .db $0C,$44,$42,$44,$4C	; | }
  .db $0E,$2E,$EE,$8E,$0E	; ~ <block>
