.NOLIST
#define	B_CALL(call_name) rst 28h \ .dw call_name
#define	RunIndicOff	4570h
#define RunIndicOn	456Dh	; Since TASM doesn't like
#define	GetCSC		4018h	; the TI-83+ include file,
#define	SetXXXXOP2	4792h	; I had to manually define
#define	OP2ToOP1	4156h	; all the ROM calls, etc.
#define	StoX		4AD1h
.LIST
.org	9D93h
	.db	$BB,$6D		; Assembly identifier token
	B_CALL(RunIndicOff)	; Turn off run indicator
	im 1			; TI-OS routine only
	ei			; Enable interrupts
sleep:
	halt			; Save some battery power.
	halt			; Rather than polling, wait
	halt			; for five interrupt clock
	halt			; ticks each iteration.
	halt
	bit	4,(iy+09)	; Check for on interrupt
	jr	z,no_on_int
	res	4,(iy+09)	; Clear the interrupt
	ld	a,101		; getKey code for [ON] is 101
	jr	setx
no_on_int:
	B_CALL(GetCSC)
	cp	0
	jr	z,sleep		; If no key pressed, sleep
	ld	b,0
	ld	c,a		; Use the scan code to index
	ld	hl,key_table	; into the getKey code table
	add	hl,bc
	ld	a,(hl)
setx:				; Assign getKey code to variable X
	ld	h,0
	ld	l,a
	B_CALL(SetXXXXOP2)	; Convert hl to TI's real format (in OP2)
	B_CALL(OP2ToOP1)	; Move it to OP1
	B_CALL(StoX)		; Store OP1 to X
	B_CALL(RunIndicOn)	; Turn on run indicator
	ret			; Return

key_table:			; Table mapping scan codes to getKey codes
;		  01 02 03 04
	.db	0,34,24,26,25,0,0,0
;		  09  0A 0B 0C 0D 0E 0F
	.db	0,105,95,85,75,65,55,45
;		  11  12 13 14 15 16 17
	.db	0,104,94,84,74,64,54,44
;		  19  1A 1B 1C 1D 1E 1F
	.db	0,103,93,83,73,63,53,43
;		20 21  22 23 24 25 26 27
	.db	33,102,92,82,72,62,52,42
;		28   2A 2B 2C 2D 2E 2F
	.db	32,0,91,81,71,61,51,41
;		30 31 32 33 34 35 36 37 38
	.db	31,15,14,13,12,11,21,22,23

.end