;ports
sLSB0     = 00h
sMSB0     = 01h
sX0       = 02h
sY0       = 03h
sMethod0  = 04h
sLSB1     = 05h
sMSB1     = 06h
sX1       = 07h
sY1       = 08h
sMethod1  = 09h
sLSB2     = 0Ah
sMSB2     = 0Bh
sX2       = 0Ch
sY2       = 0Dh
sMethod2  = 0Eh
sLSB3     = 0Fh
sMSB3     = 10h
sX3       = 11h
sY3       = 12h
sMethod3  = 13h
sLSB4     = 14h
sMSB4     = 15h
sX4       = 16h
sY4       = 17h
sMethod4  = 18h
sLSB5     = 19h
sMSB5     = 1Ah
sX5       = 1Bh
sY5       = 1Ch
sMethod5  = 1Dh
sLSB6     = 1Eh
sMSB6     = 1Fh
sX6       = 20h
sY6       = 21h
sMethod6  = 22h
sLSB7     = 23h
sMSB7     = 24h
sX7       = 25h
sY7       = 26h
sMethod7  = 27h
key0      = 28h
key1      = 29h
key2      = 2Ah
key3      = 2Bh
key4      = 2Ch
key5      = 2Dh
key6      = 2Eh
indbyte   = 2Fh
sMask     = 30h
status    = 31h     ;bit 7 set means turn the system off, bit 0 = LCD update

;RAM equates
stackptr  = 32h
PClow     = 33h+saveSScreen
PChigh    = 34h+saveSScreen

stackbase = 80h+saveSScreen

lcdupdatebit       = 0
spriteupdatebit    = 1


#define    lda_(addr1  , addr2)     .db 0,addr1,addr2
#define    adda_(addr1 , addr2)     .db 1,addr1,addr2
#define    adca_(addr1 , addr2)     .db 2,addr1,addr2
#define    suba_(addr1 , addr2)     .db 3,addr1,addr2
#define    sbca_(addr1 , addr2)     .db 4,addr1,addr2
#define    xora_(addr1 , addr2)     .db 5,addr1,addr2
#define    ora_(addr1  , addr2)     .db 6,addr1,addr2
#define    anda_(addr1 , addr2)     .db 7,addr1,addr2
#define    cpa_(addr1  , addr2)     .db 8,addr1,addr2
#define    inc_(addr)               .db 9,addr
#define    rotl_(addr)              .db 10,addr
#define    shftl_(addr)             .db 11,addr
#define    pusha_(addr)             .db 12,addr
#define    pop_(addr)               .db 13,addr
#define    inv_(addr)               .db 14,addr
#define    ldira_(addr,size)        .db 15,addr,size

#define    ldc_(addr  , const)      .db 16,addr,const
#define    addc_(addr , const)      .db 17,addr,const
#define    adcc_(addr , const)      .db 18,addr,const
#define    subc_(addr , const)      .db 19,addr,const
#define    sbcc_(addr , const)      .db 20,addr,const
#define    xorc_(addr , const)      .db 21,addr,const
#define    orc_(addr  , const)      .db 22,addr,const
#define    andc_(addr , const)      .db 23,addr,const
#define    cpc_(addr  , const)      .db 24,addr,const
#define    dec_(addr)               .db 25,addr
#define    rotr_(addr)              .db 26,addr
#define    shftr_(addr)             .db 27,addr
#define    pushc_(const)            .db 28,const
#define    ex_(addr1,addr2)         .db 29,addr1,addr2
#define    bits_(addr,const)        .db 30,addr,const
#define    ldirc_(addr,size)        .db 31,addr,size

#define    ret_()                   .db 32
#define    setz_()                  .db 33
#define    setc_()                  .db 34
#define    togz_()                  .db 35
#define    togc_()                  .db 36
#define    jp1_(Addr)               .db 37,Addr
#define    jp2_(Addr)               .db 38,Addr
#define    jrf_(offset)             .db 39,offset-1-$
#define    jrb_(offset)             .db 40,1-offset+$
#define    call1_(Addr)             .db 41,Addr
#define    call2_(Addr)             .db 42,Addr
#define    callf_(offset)           .db 43,offset-1-$
#define    callb_(offset)           .db 44,1-offset+$

#define    ind1_()                  .db 46
#define    ind2_()                  .db 47

#define    ldac_(addr1  , addr2)     .db 64+0,addr1,addr2
#define    addac_(addr1 , addr2)     .db 64+1,addr1,addr2
#define    adcac_(addr1 , addr2)     .db 64+2,addr1,addr2
#define    subac_(addr1 , addr2)     .db 64+3,addr1,addr2
#define    sbcac_(addr1 , addr2)     .db 64+4,addr1,addr2
#define    xorac_(addr1 , addr2)     .db 64+5,addr1,addr2
#define    orac_(addr1  , addr2)     .db 64+6,addr1,addr2
#define    andac_(addr1 , addr2)     .db 64+7,addr1,addr2
#define    cpac_(addr1  , addr2)     .db 64+8,addr1,addr2
#define    incc_(addr)               .db 64+9,addr
#define    rotlc_(addr)              .db 64+10,addr
#define    shftlc_(addr)             .db 64+11,addr
#define    pushac_(addr)             .db 64+12,addr
#define    popc_(addr)               .db 64+13,addr
#define    invc_(addr)               .db 64+14,addr
#define    ldirac_(addr,size)        .db 64+15,addr,size

#define    ldcc_(addr  , const)      .db 64+16,addr,const
#define    addcc_(addr , const)      .db 64+17,addr,const
#define    adccc_(addr , const)      .db 64+18,addr,const
#define    subcc_(addr , const)      .db 64+19,addr,const
#define    sbccc_(addr , const)      .db 64+20,addr,const
#define    xorcc_(addr , const)      .db 64+21,addr,const
#define    orcc_(addr  , const)      .db 64+22,addr,const
#define    andcc_(addr , const)      .db 64+23,addr,const
#define    cpcc_(addr  , const)      .db 64+24,addr,const
#define    decc_(addr)               .db 64+25,addr
#define    rotrc_(addr)              .db 64+26,addr
#define    shftrc_(addr)             .db 64+27,addr
#define    pushcc_(const)            .db 64+28,const
#define    exc_(addr1,addr2)         .db 64+29,addr1,addr2
#define    bitsc_(addr,const)        .db 64+30,addr,const
#define    ldircc_(addr,size)        .db 64+31,addr,size

#define    retc_()                   .db 64+32
#define    setzc_()                  .db 64+33
#define    setcc_()                  .db 64+34
#define    togzc_()                  .db 64+35
#define    togcc_()                  .db 64+36
#define    jp1c_(Addr)               .db 64+37,Addr
#define    jp2c_(Addr)               .db 64+38,Addr
#define    jrfc_(offset)             .db 64+39,offset-1-$
#define    jrbc_(offset)             .db 64+40,1-offset+$
#define    call1c_(Addr)             .db 64+41,Addr
#define    call2c_(Addr)             .db 64+42,Addr
#define    callfc_(offset)           .db 64+43,offset-1-$
#define    callbc_(offset)           .db 64+44,1-offset+$

#define    ind1c_()                 .db 110
#define    ind2c_()                 .db 111

#define    ldaz_(addr1  , addr2)     .db 128+0,addr1,addr2
#define    addaz_(addr1 , addr2)     .db 128+1,addr1,addr2
#define    adcaz_(addr1 , addr2)     .db 128+2,addr1,addr2
#define    subaz_(addr1 , addr2)     .db 128+3,addr1,addr2
#define    sbcaz_(addr1 , addr2)     .db 128+4,addr1,addr2
#define    xoraz_(addr1 , addr2)     .db 128+5,addr1,addr2
#define    oraz_(addr1  , addr2)     .db 128+6,addr1,addr2
#define    andaz_(addr1 , addr2)     .db 128+7,addr1,addr2
#define    cpaz_(addr1  , addr2)     .db 128+8,addr1,addr2
#define    incz_(addr)               .db 128+9,addr
#define    rotlz_(addr)              .db 128+10,addr
#define    shftlz_(addr)             .db 128+11,addr
#define    pushaz_(addr)             .db 128+12,addr
#define    popz_(addr)               .db 128+13,addr
#define    invz_(addr)               .db 128+14,addr
#define    ldiraz_(addr,size)        .db 128+15,addr,size

#define    ldcz_(addr  , const)      .db 128+16,addr,const
#define    addcz_(addr , const)      .db 128+17,addr,const
#define    adccz_(addr , const)      .db 128+18,addr,const
#define    subcz_(addr , const)      .db 128+19,addr,const
#define    sbccz_(addr , const)      .db 128+20,addr,const
#define    xorcz_(addr , const)      .db 128+21,addr,const
#define    orcz_(addr  , const)      .db 128+22,addr,const
#define    andcz_(addr , const)      .db 128+23,addr,const
#define    cpcz_(addr  , const)      .db 128+24,addr,const
#define    decz_(addr)               .db 128+25,addr
#define    rotrz_(addr)              .db 128+26,addr
#define    shftrz_(addr)             .db 128+27,addr
#define    pushcz_(const)            .db 128+28,const
#define    exz_(addr1,addr2)         .db 128+29,addr1,addr2
#define    bitsz_(addr,const)        .db 128+30,addr,const
#define    ldircz_(addr,size)        .db 128+31,addr,size

#define    retz_()                   .db 128+32
#define    setzz_()                  .db 128+33
#define    setcz_()                  .db 128+34
#define    togzz_()                  .db 128+35
#define    togcz_()                  .db 128+36
#define    jp1z_(Addr)               .db 128+37,Addr
#define    jp2z_(Addr)               .db 128+38,Addr
#define    jrfz_(offset)             .db 128+39,offset-1-$
#define    jrbz_(offset)             .db 128+40,1-offset+$
#define    call1z_(Addr)             .db 128+41,Addr
#define    call2z_(Addr)             .db 128+42,Addr
#define    callfz_(offset)           .db 128+43,offset-1-$
#define    callbz_(offset)           .db 128+44,1-offset+$
#define    ind1z_()                 .db 174
#define    ind2z_()                 .db 175

jkDown     = %11111110
jkRight    = %11111101
jkLeft     = %11111011
jkUp       = %11110111
jkClear    = %10111111

