;Program Manager v2.0
;(c)2006 Robbie McElrath

#include "../ti83plus.inc"

#define	m1	AppBackUpScreen

#define	page			m1+0	;address of prog at top of page
#define	cur			m1+2	;0-7, offset of cursor on page
#define	cur_max		m1+3	;0-7, maximun value cur can hold
#define	getprevs		m1+4  ;used in getprev routine
#define	cur_loc		m1+6  ;used in delete routine
#define	prog_name		m1+8  ;used to store name of program

.org $9D93
.db $BB,$6D
 xor a
 jr nc,Start
Descript:
.db "Program Manager  v2.0",0

Start:
	res	0,(iy+18)
	ld	hl,op1+1
	ld	de,prog_name
	ld	bc,10
	ldir
	call	getfirst
	jr	nz,Start2
no_progs:
	res	textwrite,(iy+sgrflags)
	bcall(_clrlcdfull)
	ld	de,$1D10
	ld	(PenCol),de
	ld	hl,txt_no_progs
	bcall(_vputs)
	bcall(_getkey)
	jp	quit
Start2:
	set	textwrite,(iy+sgrflags)
	ld	(page),hl
	xor	a
	ld	(cur),a
	#include "display.asm"
Main_Loop:
	bcall(_getcsc)
	cp	skUp		\ jr  z,Up
	cp	skDown	\ jr  z,Dn
	cp	skYequ	\ jr  z,F1
	cp	skWindow	\ jr  z,F2
	cp	skZoom	\ jr  z,F3
	cp	skTrace	\ jp  z,F4
	cp	skGraph	\ jr nz,Main_Loop
quit:	bcall(_clrlcdfull)
	res	2,(iy+2)
	ret

Up:
	ld	a,(cur)
	or	a \ jr z,Up2
	dec	a
	ld	(cur),a
	jp	disp_all
Up2:	ld	hl,(page)
	call	getprev
	jr	z,Main_Loop
	ld	(page),hl
	jp	disp_all

Dn:
	ld	a,(cur_max)
	ld	b,a
	ld	a,(cur)
	cp	b \ jr z,Dn2
	inc	a
	ld	(cur),a
	jp	disp_all
Dn2:	call	get_cur
	call	getnext
	jr	z,Main_Loop
	ld	hl,(page)
	call	getnext
	ld	(page),hl
	jp	disp_all

F1:
;Lock Program
	call	get_cur
	ld	a,3
	xor	(hl)
	ld	(hl),a
	jp	disp_all

F2:
;Archive Program
	call	get_cur
	jp	c,Main_Loop
	errhandon(F2_)
	call	get_cur
	call	name2op1
	bcall(_arc_unarc)
F2_:	errhandoff()
	jp	disp_all

F3:
;Hide Program
	call	get_cur
	jp	c,Main_Loop
	ld	de,-7
	add	hl,de
	ld	a,$40
	xor	(hl)
	ld	(hl),a
	ld	de,6
	add	hl,de ;hl = t2
	ld	a,$80
	xor	(hl)
	ld	(hl),a
	jp	disp_all

F4:
;Delete Program
	call	get_cur
	jp	c,Main_Loop
	ld	hl,disp_all
	push	hl
	call	get_cur
	ld	(cur_loc),hl
	call	getnext
	jr	nz,delete
	ld	a,(cur)
	or	a \ jr z,f42
	dec	a
	ld	(cur),a
	jr	delete
f42:	ld	hl,(page)
	call	getprev
	jr	z,f4_last
	ld	(page),hl
delete:
	ld	hl,(cur_loc)
	call	name2op1
	bcall(_chkfindsym)
	bcall(_delvararc)
	ld	hl,(page)
	call	getfirst+3
	ld	(page),hl
	ret
f4_last:
	pop	hl ;fix stack
	ld	hl,no_progs
	push	hl ;when 'ret' will goto no_progs
	jr	delete

#include "routines.asm"
#include "data.asm"

.end
END
