.module TextInput

.var uword, StringLocation
.var ubyte, Length
.var ubyte, EditMode
.var ubyte, ValidModes
; curRow is LOWER in memory.

.enum Modes, Free, Decimal, Hex, Program

GetString
	ld (ValidModes),a
	ld a,b
	ld (StringLocation),hl
	ld (Length),a

	; Clear everything to zero...	
-	ld a,(hl)
	inc hl
	or a
	jr z,FoundNul
	djnz {-}
	jr NoNul
FoundNul
	dec b
	jr z,NoNul
-	ld (hl),0
	inc hl
	djnz {-}
NoNul

	ld a,$E2
	ld (EditMode),a

InputLoopTextChanged
	ld hl,(curRow)
	push hl
	
	ld hl,(StringLocation)
	ld a,(Length)
	ld b,a
	
-	ld a,(hl)
	or a
	jr z,FinishedString
	inc hl
	push hl
	bcall(_PutC)
	pop hl
	djnz {-}
FinishedString

	push bc
	ld a,(EditMode)
	bcall(_PutC)
	pop bc
	
	ld a,b
	or a
	jr z,{+}
	dec b
	jr z,{++}
-	ld a,"…"
	bcall(_PutC)
	djnz {-}
++	ld a,' '
	bcall(_PutC)	
+	
	
	pop hl
	ld (curRow),hl

InputLoop
	bcall(_GetCSC)
	halt
	cp skEnter
	ret z
	cp sk2nd
	ret z
	or a
	jr z,InputLoop
	
	cp skClear
		jr nz,DoNotClearString
		
		ld a,(Length)
		ld hl,(StringLocation)
		ld b,a
	-	ld (hl),0
		inc hl
		djnz {-}
		jr InputLoopTextChanged	
	DoNotClearString

	cp skAlpha
		jr nz,DoNotChangeEdit	
		ld a,(EditMode)
		inc a
		and $E3
		ld (EditMode),a
		jr InputLoopTextChanged
	DoNotChangeEdit
	
	cp skDel
		jr nz,DoNotDelete
		ld hl,(StringLocation)
		ld a,(hl)
		or a
		jr z,InputLoop
		ld a,(Length)
		ld b,a
	-	ld a,(hl)
		inc hl
		or a
		jr z,FoundLastChar
		djnz {-}
		inc hl
	FoundLastChar
		dec hl
		dec hl
		ld (hl),0
		jp InputLoopTextChanged
	DoNotDelete

	call SafeScancodeToChar
	jr nz,InputLoop
	
	ld c,a
	ld hl,(StringLocation)
	ld a,(Length)
	ld b,a
	
-	ld a,(hl)
	inc hl
	or a
	jr z,FoundLocation
	djnz {-}
	jr NoSpace
FoundLocation
	dec hl
	ld (hl),c
NoSpace	
	jp InputLoopTextChanged


SafeScancodeToChar
	ld b,4
-	push bc
	push af
	call ScancodeToChar
	jr z,Success
	ld a,(EditMode)
	inc a
	and $E3
	ld (EditMode),a
	pop af
	pop bc
	djnz {-}
	inc b
	ret
	
Success
	pop bc
	pop bc
	ret

ScancodeToChar
	ld hl,ScancodeTable
	ld bc,ScancodeTableLength
	cpir
	ret nz
	
	ld a,(EditMode)
	and 3
	rrca
	rrca
	rrca

	ld e,a
	ld d,0
	
	ld a,l
	sub ScancodeTable+1
	ld l,a
	ld h,0
	add hl,de

	ld de,Characters
	add hl,de
	ld a,(hl)
	
	push af
	
	ld a,(ValidModes)
	or a
	jr z,{+}

	dec a
	ld b,a
	add a,a
	add a,b
	ld l,a
	ld h,0
	ld de,ModeTable
	add hl,de
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld c,(hl)
	ld b,0
	ex de,hl
	
	pop af
	cpir
	ret

+	pop af
	cp a
	ret

ScancodeTable
	.db skMath, $27, skPrgm
	.db skRecip, skSin, skCos, skTan, skPower
	.db skSquare, skComma, skLParen, skRParen, skDiv
	.db skLog, sk7, sk8, sk9, skMul
	.db skLn, sk4, sk5, sk6, skSub
	.db skStore, sk1, sk2, sk3, skAdd
	.db sk0, skDecPnt, $11
ScancodeTableLength = $-ScancodeTable

Characters
	.db 0,0,0
	.db $11,0,0,0,"^"
	.db $12,",()/"
	.db 0,"789*"
	.db 0,"456-"
	.db "→123+"
	.db "0.",$1A,0
	
	.db "=°",0
	.db 0,0,0,0,"π"
	.db "√",$1B,"{}e"
	.db $1D,"uvw["
	.db 0,0,0,0,"]"
	.db 0,0,0,0,0,
	.db 0,$D7,0,0
	
	.db "ABC"
	.db "DEFGH"
	.db "IJKLM"
	.db "NOPQR"
	.db "STUVW"
	.db "XYZθ\""
	.db " :?",0
	
	.db "abc"
	.db "defgh"
	.db "ijklm"
	.db "nopqr"
	.db "stuvw"
	.db "xyzθ'"
	.db " ;!",0
	
ModeTable
.dw Decimal \ .db DecimalLength
.dw Hex \ .db HexLength
.dw Program \ .db ProgramLength

Decimal .db "0123456789"
DecimalLength = $-Decimal
Hex .db "0123456789ABCDEF"
HexLength = $-Hex
Program .db "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZθ"
ProgramLength = $-Program

.echoln "TextInput: {0} bytes.", $-GetString

.endmodule