.module Program
.var ubyte[16], Protocol
.var ubyte[128], Signal

.var uword, FilePointer

.global \ Debug = 0 \ .endglobal

; ---------------------------------------------------------
; Main -> Program entry point.
; ---------------------------------------------------------
Main
	; Initial setup.
	im 1
	ld hl,0
	ld (curRow),hl
	set appAutoScroll,(iy+appFlags)
	call ClearScreen
	
	call Dialogs.SaveFlags
	
	; Display "Beta" warning dialog.
	ld a,Resources.Dialogs.Beta
	call ShowDialogDelay
	call ClearScreen
	
	; Check if we have any files saved:
	call ProgramEditor.SetupSearch
	ld hl,Resources.ProgramHeader
	call ProgramEditor.FindNextHeadered
	jr nc,{+}
	
	ld a,Resources.Dialogs.NoExisting
	call ShowDialogDelay
	call ClearScreen
	call NewFileWizard
	ret nz
+
	call ClearScreen

; ---------------------------------------------------------
; HomeScreen -> Default view.
; ---------------------------------------------------------
HomeScreen
	bcall(_GrBufClr)

	ld hl,0
	ld (curRow),hl
	call ProgramEditor.OpenReadOnly
	ld hl,2+9
	add hl,de
	ld (FilePointer),hl
	
	; Display the name of the remote control file on the display:
		
	ld b,-1
-	ld a,(hl)
	inc hl
	or a
	jr z,{+}
	ld a,b
	add a,6
	ld b,a	
	jr {-}
+	
	ld a,95
	sub b
	srl a
	ld (penCol),a
	ld a,25
	ld (penRow),a
	ld hl,(FilePointer)
	set textWrite,(iy+sGrFlags)
	set fracDrawLFont,(iy+fontFlags)
	bcall(_VPutS)
	res fracDrawLFont,(iy+fontFlags)

	; Last but not least:
	ld hl,Resources.SoftkeyBars.HomeScreen
	call DrawSoftkeyBar
	
	call ionFastCopy
	
	; Load the protocol descriptor:
	ld hl,(FilePointer)
	ld de,16
	add hl,de
	ld de,Protocol
	ld bc,16
	ldir
	
HomeScreenLoop
	
	; Is a key being pressed?
	call Keys.GetPressed
	jr nz,{+}
	
	call GetKeyDataAddress
	
	push hl
	
-	ld a,(hl)
	or a
	jr nz,GotSomeData
	inc hl
	djnz {-}
	pop hl
	jr HomeScreenLoop

GotSomeData
	
	call Dialogs.Dither
	ld a,Resources.Dialogs.Transmitting
	call ShowDialog

	pop hl
	ld de,saveSScreen
	ld ix,Protocol
	call Infrared.Decompress
	
--	ld b,3	
-	push bc
	ld hl,saveSScreen
	call Infrared.Play
	pop bc
	djnz {-}
	call Keys.GetPressed
	jr z,{--}
	jp HomeScreen
+

	; Now for some normality. :)
	
	bcall(_GetCSC)
	
	; Search for the next layout.	
	cp skYEqu
	jr nz,{+}
	ld hl,Resources.ProgramHeader
	call ProgramEditor.FindNextHeaderedLoop
	jp HomeScreen
+
	
	; Create a new layout file.
	cp skWindow
	jr nz,{+}
	call NewFileWizard
	jp HomeScreen
+

	; Enter the editor.
	cp skZoom
	jr z,Editor

	; Show the about dialog.
	cp skTrace
	jr nz,{+}
	xor a
	call ShowDialogDitherDelay
	jp HomeScreen
+

	; Check for Quit.
	cp skGraph
	jr nz,HomeScreenLoop
	
	call Dialogs.ReloadFlags
	ret

; ---------------------------------------------------------
; Editor -> Editor view.
; ---------------------------------------------------------
Editor
	ld a,Resources.Dialogs.EditAKey
	call SetupEditor
EditorLoop
	bcall(_GetCSC)
	; Quit
EditorFeedKey
	cp skGraph
	jp z,HomeScreen

	; Delete
	cp skWindow
	jr nz,NotDelete
DeleteKey
	
	ld a,Resources.Dialogs.DeleteAKey
	call SetupEditor

DeleteLoop
	call Keys.GetPressed
	jr nz,{+}

	; We have a key to delete	
	push af
	call OpenReadWriteWarnArchived
	pop af
	push af
	
	; Perform the deletion:
	call GetKeyDataAddress
-	ld (hl),0
	inc hl
	djnz {-}
	
	; Show confirmation.
	call Dialogs.Dither
	pop af
	
	call Keys.GetName
	ld de,ExpandedInfo
	call AppendString
	ld hl,Resources.Strings.Deleted
	call AppendString
	ld hl,ExpandedInfo	
	xor a
	call Dialogs.DrawMessage	
	call ionFastCopy
	call Dialogs.WaitKey
-	call Keys.GetPressed
	jr z,{-}	
	jr DeleteKey
	
+	bcall(_GetCSC)
	or a
	jr z,DeleteLoop
	
	push af
	ld a,Resources.Dialogs.EditAKey
	call SetupEditor
	pop af
	jr EditorFeedKey
	
NotDelete
	
	cp skZoom
	jr nz,NotProtocol
	
	ld a,Resources.Dialogs.RemoteDelay
	call ShowDialogDitherDelay
	call Dialogs.Dither
	ld a,Resources.Dialogs.Waiting
	call ShowDialog
	
	.tvar ubyte[16], NewProtocol
	ld ix,NewProtocol
	ld hl,saveSScreen
	call Infrared.DecipherProtocol
	
	jr z,SuccessfulNewProtocol
	
	ld a,Resources.Dialogs.ErrorDecipherProtocol
	call ShowDialogDitherDelay
	jp Editor	
SuccessfulNewProtocol
	ld a,(NewProtocol+1)
	ld b,a
	ld a,(Protocol+1)
	cp b
	jr z,BitCountGood
	
	; Mismatched bit counts!
	ld a,Resources.Dialogs.ErrorMismatchedBits
	call ShowDialogDitherDelay
	jp Editor	
BitCountGood

	call OpenReadWriteWarnArchived
	
	ld hl,(FilePointer)
	ld de,16
	add hl,de
	ld bc,16
	ex de,hl
	ld hl,NewProtocol
	ldir
	
	call OpenReadWriteWarnArchived
	
	call ShowProtocolInfo
	call Dialogs.WaitKey
		
	jp Editor

NotProtocol

	; Rename the device:
	cp skTrace
	jr nz,{+}
	call OpenReadWriteWarnArchived
	
	call Dialogs.Dither
	
	ld hl,4+30*256
	ld de,90+40*256
	ld bc,Resources.Strings.Rename
	call Dialogs.DrawWithTitle
	call ionFastCopy

	ld hl,4+1*256
	ld (curRow),hl

	ld hl,(FilePointer)
	ld a,TextInput.Modes.Free
	ld b,13
	call TextInput.GetString	
	jp HomeScreen	
+
	

	
	call Keys.GetPressed
	jp nz,EditorLoop
	
	; A key has been pressed!
	push af
	push af
	
	call Dialogs.Dither
	
	pop af	
	call Keys.GetName
	
	push hl
	ld hl,Resources.Strings.Key
	ld de,ExpandedInfo
	call AppendString
	pop hl

	call AppendString
	ld hl,ExpandedInfo
	
	xor a
	call Dialogs.DrawMessage
	call ionFastCopy
	
	ld hl,saveSScreen
	ld de,Signal
	ld ix,Protocol
	call Infrared.ReadBits
	
	jr z,GotRemoteBits

	ld a,Resources.Dialogs.ErrorReadBits
	call ShowDialogDitherDelay
	
-	call Keys.GetPressed
	jr z,{-}

	pop af	
	jp Editor

GotRemoteBits

	call OpenReadWriteWarnArchived
	
	pop af
	call GetKeyDataAddress
	
	ld c,b
	ld b,0
	
	ex de,hl
	ld hl,Signal
	ldir
	jp Editor
	
	
SetupEditor
	push af
	bcall(_GrBufClr)
		
	ld hl,Resources.SoftkeyBars.Editor
	call DrawSoftkeyBar
	pop af
	jp ShowDialog


; ---------------------------------------------------------
; GetKeyDataAddress -> Get the bitstream address and length
;                      for an associated calculator key.
; ---------------------------------------------------------
; Inputs:   a = key number.
; Outputs:  hl -> data.
;           b  =  data length.
; ---------------------------------------------------------
GetKeyDataAddress
	ld l,a
	ld a,(Protocol+1)
	add a,7
	srl a
	srl a
	srl a
	push af
	ld h,a
	bcall(_HTimesL)
	ld de,(FilePointer)
	add hl,de
	ld de,32
	add hl,de
	pop bc	
	ret

; ---------------------------------------------------------
; NewFileWizard -> Create a new remote control file using
;                  a wizard.
; ---------------------------------------------------------
; Outputs:  z on success, nz on failure.
; ---------------------------------------------------------
NewFileWizard
	ld hl,plotSScreen
	bcall(_SaveDisp)
	call Dialogs.Dither
	; First, prompt for a filename:
	ld hl,4+30*256
	ld de,90+40*256
	ld bc,Resources.Strings.New
	call Dialogs.DrawWithTitle
	call ionFastCopy

	ld hl,1*256+4
	ld (curRow),hl
	ld hl,Resources.Strings.Name
	bcall(_PutS)
	bcall(_ZeroOP1)
	ld a,ProtProgObj
	ld (OP1),a
	ld hl,OP1+1
	ld b,8
	ld a,TextInput.Modes.Program
	call TextInput.GetString
	
	; Save current screen image to plotSScreen
	ld hl,plotSScreen
	bcall(_SaveDisp)
	
	; Check a name was entered at all:
	ld a,(OP1+1)
	or a
	jr nz,GotName
	
	ld a,Resources.Dialogs.ErrorFilename
	call ShowDialogDitherDelay
	inc a
	ret
GotName

	; Does it start with a number (which is naughty).
	ld a,(OP1+1)
	ld hl,TextInput.Decimal
	ld bc,TextInput.DecimalLength
	cpir
	jr nz,{+}
	ld a,Resources.Dialogs.ErrorBadFilename
	call ShowDialogDitherDelay
	inc a
	ret
+
	; Check if file already exists:
	bcall(_ChkFindSym)
	jr c,{+}
	ld a,Resources.Dialogs.ErrorFileAlreadyExists
	call ShowDialogDitherDelay
	inc a
	ret
+	

	; Store program name away for future reference.
	.tvar ubyte[9], ProgramName
	ld hl,OP1
	ld de,ProgramName
	ld bc,9
	ldir
	
	; Now we have a valid filename, we need to work out 
	; the remote control's protocol.
	
	; Prompt for a delay.
	ld a,Resources.Dialogs.RemoteDelay
	call ShowDialog
	call Dialogs.WaitKey

	; Display "Waiting" dialog, then get the protocol.
	call Dialogs.Dither
	ld a,Resources.Dialogs.Waiting
	call ShowDialog

	ld ix,Protocol
	ld hl,saveSScreen
	call Infrared.DecipherProtocol
	jr z,GotProtocol
	

	; Couldn't get protocol:
	call ClearScreen
	ld a,Resources.Dialogs.ErrorDecipherProtocol
	call ShowDialogDelay
	inc a
	ret

GotProtocol
	; Display a summary of results:
	call Dialogs.Dither
	call ShowProtocolInfo
	call Dialogs.WaitKey
	
	; Now what we really need to know is whether we have
	; enough RAM for the program...
	
	; Header size:
	; 8 bytes (Infrared) + 
	; 1 byte (version) +
	; 16 bytes (description) +
	; 16 bytes (protocol descriptor).
	
	; Program size:
	; Header + 45 * bytes/record.
	
	
	ld a,(Protocol+1)
	add a,7
	srl a
	srl a
	srl a
	ld l,a
	ld h,45
	bcall(_HTimesL)
	
	ld de,8+1+16+16
	add hl,de
	
	; HL = program size.
	push hl
	ld de,32
	add hl,de
	bcall(_EnoughMem)	
	pop hl
	
	jr nc,CanCreateProg
	
	; Insufficient RAM :(
	ld a,Resources.Dialogs.ErrorInsufficientRam
	call ShowDialogDitherDelay
	inc a
	ret	

CanCreateProg
	push hl
	ld hl,ProgramName
	rst rMOV9TOOP1	
	pop hl
	push hl	
	bcall(_CreateProtProg)
	
	pop bc
	
	inc de
	inc de
	
	push de
	ld h,d \ ld l,e
	bcall(_MemClear)
	pop de
	
	; de->program
	ld hl,Program.Resources.ProgramHeader
	ld bc,Program.Resources.ProgramHeaderSize
	ldir
	
	; Now copy in the name:
	ld hl,OP4+1
	ld bc,8
	ldir
	
	ld hl,8
	add hl,de
	ex de,hl
	
	; Next; protocol descriptor:
	ld hl,Protocol
	ld bc,16
	ldir
	
	; Let the program editor know about the file we just created.
	
	ld hl,OP4
	ld bc,9
	ld de,ProgramEditor.Name
	ldir

	; FINALLY, I think we're there!
	
	xor a
	ret


; ---------------------------------------------------------
; ShowProtocolInfo -> Display a protocol information
;                     dialog.
; ---------------------------------------------------------
; Inputs:   Protocol.
; ---------------------------------------------------------
ShowProtocolInfo
.var ubyte[100], ExpandedInfo
	ld ix,Protocol
	ld hl,Resources.ProtocolInfoBox
	ld de,ExpandedInfo
	
	; Bits
	call AppendString
	ld a,(ix+1)
	call StringA

	; Length
	call AppendString

	push hl
	ld l,(ix+2)
	ld h,(ix+3)
	call StringHL
	pop hl

	ld b,6
-	push bc
	
	; BitX On
	call AppendString
	push hl
	ld l,(ix+4)
	ld h,(ix+5)
	call StringHL
	pop hl
	inc ix
	inc ix
	
	pop bc
	djnz {-}

	xor a
	ld hl,ExpandedInfo
	call Dialogs.DrawMessage
	jp ionFastCopy

; ---------------------------------------------------------
; StringA -> Append a (formatted a string) to de.
; ---------------------------------------------------------
; Inputs:   a  =  value to print.
;           de -> string to print to.
; ---------------------------------------------------------
StringA
	push hl
	ld l,a
	ld h,0
	call StringHL
	pop hl
	ret

; ---------------------------------------------------------
; StringHL -> Append hl (formatted a string) to de.
; ---------------------------------------------------------
; Inputs:   hl =  value to print.
;           de -> string to print to.
; ---------------------------------------------------------
StringHL
	push de
	bcall(_SetXXXXOP2)
	bcall(_OP2ToOP1)
	ld a,10
	bcall(_FormEReal)
	pop de
	ld hl,OP3
	; Run on...
	
; ---------------------------------------------------------
; AppendString -> Append two strings.
; ---------------------------------------------------------
; Inputs:   hl -> string to append.
;           de -> string to append to.
; Remarks:  hl points to the next string after the first.
; ---------------------------------------------------------
AppendString
	bcall(_StrCopy)
	inc hl
	ret

; ---------------------------------------------------------
; ClearScreen -> Clear the graph buffer and LCD.
; ---------------------------------------------------------
ClearScreen
	bcall(_GrBufClr)
	jp ionFastCopy

; ---------------------------------------------------------
; ShowDialogDitherDelay -> Show a dialog on a dithered
;                          background and wait for a key.
; ---------------------------------------------------------
; Inputs:   a = dialog index.
; ---------------------------------------------------------
ShowDialogDitherDelay
	push af
	call Dialogs.Dither
	pop af
	; Run on...

; ---------------------------------------------------------
; ShowDialogDelay -> Show a dialog and wait for a key.
; ---------------------------------------------------------
; Inputs:   a = dialog index.
; ---------------------------------------------------------
ShowDialogDelay
	call ShowDialog
	jp Dialogs.WaitKey

; ---------------------------------------------------------
; ShowDialog -> Show a dialog.
; ---------------------------------------------------------
; Inputs:   a = dialog index.
; ---------------------------------------------------------
ShowDialog
	ld hl,Resources.Dialogs
	call Dialogs.DrawMessageFromTable
	call ionFastCopy
	ret

; ---------------------------------------------------------
; DrawSoftkeyBar -> Draw a softkey bar.
; ---------------------------------------------------------
; Inputs:   hl = softkey bar text.
; ---------------------------------------------------------
DrawSoftkeyBar
	set fullScrnDraw,(iy+apiFlg4)
	push hl
	ld hl,57*256
	ld (penCol),hl
	pop hl
	bcall(_VPutS)
	push hl

	ld hl,plotSScreen+57*12
	or a
	ld b,7*12	
-	ld a,(hl)
	rra
	cpl
	ld (hl),a
	inc hl
	djnz {-}
	
	pop hl
	ret

; ---------------------------------------------------------
; OpenReadWriteWarnArchived -> Open the file for read/write
;                              access.
; ---------------------------------------------------------
; Remarks:  Pops up a dialog box if the program has to be
;           unarchived.
; ---------------------------------------------------------
OpenReadWriteWarnArchived
	call ProgramEditor.OpenReadWrite
	push af
	ld hl,11
	add hl,de
	pop af
	ld (FilePointer),hl
	ld de,16
	add hl,de
	ld bc,16
	ld de,Protocol
	ldir
	ret z
	ld a,Resources.Dialogs.Unarchived
	jp ShowDialogDitherDelay


.include "Infrared.asm"
.include "Dialogs.asm"
.include "TextInput.asm"
.include "ProgramEditor.asm"
.include "Keys.asm"
.include "Resources/Resources.inc"
.endmodule