; =========================================================
; Module: Keys
; =========================================================
; Description:
;     Key-related functions.
; =========================================================

.module Keys

; ---------------------------------------------------------
; GetPressed -> Gets the code of a pressed key.
; ---------------------------------------------------------
; Outputs:  z if a key pressed, nz if no key pressed.
;           a = key code.
; Destroys: af, bc, hl.
; Remarks:  Ignores softkeys.
; ---------------------------------------------------------
GetPressed
	ld bc,5*256 + %11011111
	ld l,0         ; Start with key number 0.
	
--	ld h,%01111111 ; First key to test for.
	
	ld a,b
	cp 3
	jr nc,{+}
	rrc h
+
	
	ld a,$FF
	out (1),a
	ld a,c
	out (1),a
	nop
	in a,(1)
	
-	cp h
	jr z,FoundKey
	inc l
	rrc h
	jr c,{-}

	rrc c
	djnz {--}
	
	; No key found... yet!
	
	ld a,$FF
	out (1),a
	ld a,%10111111 ; Top row
	out (1),a
	nop
	in a,(1)
	
	ld h,%11011111	; Normally not required, but we want to ignore the top five keys.
	
-	cp h
	jr z,FoundKey
	inc l
	rlc h ; Usuall rrc h
	jr c,{-}
	
	; Still no key in the top group...
	
	ld a,$FF
	out (1),a
	ld a,%11111110 ; Pad
	out (1),a
	nop
	in a,(1)
	
	ld h,%11110111
-	cp h
	jr z,FoundKey
	inc l
	rrc h
	jr c,{-}

	; No key pressed on the pad, so finally check the On button.

	ld l,7 ; On key.
	in a,(4)
	bit 3,a
	jr z,FoundKey
	
	; Not even the On key is pressed!

	inc b
	ret
FoundKey
	ld a,l
	cp a
	ret
	
; ---------------------------------------------------------
; GetName -> Gets the name of a key from its code.
; ---------------------------------------------------------
; Inputs:   a = key code.
; Outputs:  hl -> NUL terminated string of the key name.
; Destroys: af, b.
; ---------------------------------------------------------	
GetName
	ld hl,KeyNames
	or a
	ret z
	ld b,a
-	ld a,(hl)
	inc hl
	or a
	jr nz,{-}
	djnz {-}
	ret

	
KeyNames
	.db "Alpha",0
	.db "Math",0
	.db "x",$11,0
	.db "x²",0
	.db "Log",0
	.db "Ln",0
	.db "Sto",$05,0
	.db "On",0
	
	.db "XTθn",0
	.db "Apps",0
	.db "Sin",0
	.db ",",0
	.db "7",0
	.db "4",0
	.db "1",0
	.db "0",0
	
	.db "Stat",0
	.db "Prgm",0
	.db "Cos",0
	.db "(",0
	.db "8",0
	.db "5",0
	.db "2",0
	.db ".",0
	
	.db "Vars",0
	.db "Tan",0
	.db ")",0
	.db "9",0
	.db "6",0
	.db "3",0
	.db "(-)",0
	
	.db "Clear",0
	.db "^",0
	.db "/",0
	.db "*",0 ;"×",0
	.db "-",0
	.db "+",0
	.db "Enter",0
	
	.db "2nd",0
	.db "Mode",0
	.db "Del",0
	.db "Up",0
	.db "Right",0
	.db "Left",0
	.db "Down",0

.echoln "Keys: {0} bytes.", $-GetPressed
.endmodule