.nolist
#include "tse.inc"
.list
.org    usermem-3
.db     $BB,$6D
 ret
.db "TSE",1              ; header
prgtitle:
.db " Pacman 99", 0 ; title
.dw 300
TEXT_MEM  = $8508
APD_BUF   = $86EC
 .db 0

; *************** Variables************************************************
#DEFINE GRAPH_MEM       plotsscreen
#DEFINE LOCATE(xc,yc)    ld de,(xc*256)+yc \ ld (CURROW),de

NUM_LEVELS        =8

 ; -------------- TITLE SCREEN ----------------------------------------------
StartG:
 res 1,(iy+13)
 call GAME
 ld hl,TEXT_MEM
 ld (hl),0
 ld de,TEXT_MEM+1
 ld bc,127
 ldir
 set 1,(iy+13)
 ret

GAME:                                    
         ld       hl,GRAPH_MEM-384    ;Address of memory to restore
         ld       de,APD_BUF+384      ;Address of save buffer
         ld       bc,384           ;Number of bytes to copy
         ldir
   
         ld       (game_finish+1),sp                     
         ld       (iy+13),0


         ld       a,(saved_flag)
         or       a
         jp       nz,now

display_ttl_scr:
         bcall(_clrlcdfull)
         ld       de,0
         ld       hl,title
	   call DTX

         ld       de,$0714
         call DMX

         ld       de,$0E16
         call DMX
         
         ld       de,$1520
         call DMX

         ld       de,$200C
         call DMX

         ld       de,$280C
         call DMX

         ld       de,$300C
         call DMX

intro_loop:
       ld       hl,curspos                 ; Redraw arrow
       ld       a,(hl)
       cp       255
       jr       c,duh
       ld       a,2
duh:
       cp       3
       jr       c,position_ok
       ld  a,0
position_ok:
         ld       (hl),a

        LD a,(curspos)
         inc a
         inc a
         inc a 
 ld d,$01
 add a,d
 ld e,a
 	  ld a,5
 	  ld (CURROW),de
        bcall(_putc)

       bcall(_getkey)  ; Read and process keystrokees

no__cheat:
         ld       hl,curspos
         cp       $31
         jp       z,end_game
         cp       $05
         jr       z,selected
         cp       $03
         jr       nz,no_up
         call ClearArrow
         dec      (hl)

no_up:   cp       $04
         jr       nz,intro_loop
         call ClearArrow
         inc      (hl)
         jr       intro_loop

selected:
         ld       a,(curspos)
         or       a
         jr       z,toggle_speed
         dec      a
         jr       z,toggle_numen
         jp       start

toggle_speed:
         ld       hl,speed
         ld       a,(hl)
         or       a
         jr       z,speed_slow
         ld       (hl),0
         ld       hl,speedtext_fast
         jr       speed_set
         ret
speed_slow:
         ld       (hl),1
         ld       hl,speedtext_slow
speed_set:
         ld       de,speed_text
         ld       bc,4
         ldir
         jp       display_ttl_scr

toggle_numen:
         ld       hl,numen
         ld       a,(hl)
         or       a
         jr       z,numen_three
         ld       (hl),0
         ld       a,'4'
         jr       numen_set
numen_three:
         ld       (hl),1
         ld       a,'3'
numen_set:
         ld       (number_text),a
         jp       display_ttl_scr
ClearArrow:
 ld a,(curspos)
 inc a
 inc a
 inc a 
 inc a
 ld e,a
 ld d,$01
 ld a,32
 ld (CURROW),de
 bcall(_putc)
 ret

         
start:   ld       de,easy_enemy_data
         ld       hl,900
         ld       a,(numen)
         or       a
         jr       nz,three_enemies
         ld       de,default_enemy_data
         ld       hl,1400
three_enemies:
         ld       (enemy_setup+1),de
         ld       a,(speed)
         or       a
         jr       z,fast_speed
         ld       de,-900
         add      hl,de
fast_speed:
         ld       (score),hl
now:
         call     play_game
now2:
         call     do_scores
         bcall(_clrlcdfull)
         ld       de,0
         ld       hl,hstitle
         call     DTX
	   LOCATE(11,1)
         ld       de,hsdata
         ld       b,7                                        
high_display_loop:                         ;Display high scores
	ld       a,(de)
	ld       l,a
	inc      de
	ld       a,(de)
	ld       h,a
	inc      de
	push     de
	bcall(_disphl)
      ld hl,CURCOL
      ld (hl),0
	pop      hl
	bcall(_puts)
	ex       de,hl
      ld hl,CURROW
      inc (hl)
      ld a,11
      ld (CURCOL),a
	djnz     high_display_loop
      jp wait_key
wait_key
         call     OTH_PAUSE
         jr       end_game

save_the_game:
         ld       de,saved_flag
         ld       a,3
         ld       (de),a
end_game:
         ld       de,GRAPH_MEM-384    ;Address of memory to restore
         ld       hl,APD_BUF+384      ;Address of save buffer
         ld       bc,384           ;Number of bytes to copy
         ldir
                                       ;system data was there.
game_finish:
         ld       sp,0                ;This restores the original
                                       ;stack pointer.  The value
                                       ;loaded will have been
                                       ;modified by the startup code.
	call _tseForceYield
	jp startG
 ; -------------- SCORING ---------------------------------------------------
do_scores:
         ld       hl,(lowest)      ;See if ya got a hi-score
         ld       de,(score)
         bcall(_CPHLDE)
         ret      nc
         bcall(_clrlcdfull)
         ld       de,0
         ld       hl,hi_score_str
         call     DTX
         ld       hl,lowest+2
         ld       (temp),hl
         ld       b,11
space_loop:
         ld       (hl),32
         inc      hl
         djnz     space_loop
         ld       ix,(temp)
         ld       b,0
enter_name_loop:
	   push bc
         bcall(_getcsc)
	   pop bc
         or       a
         jr       z,enter_name_loop
         cp       skDel
         jr       z,backup
         cp       skEnter
         jr       z,nomore
         ld       c,a
         ld       a,10
         cp       b
         jr       z,enter_name_loop
         ld       hl,chartable-10
         ld       e,c
         ld       d,0
         add      hl,de
         ld       a,(hl)
         ld       (ix),a
         bcall(_putc) 
         inc      b
         inc      ix
         jr       enter_name_loop
backup:  dec      b
         ld       a,255
         cp       b
         jr       z,too_far
         dec      ix
         ld       (ix),32
         ld       hl,CURCOL
         dec      (hl)
         ld       a,32
         bcall(_putc)
         dec      (hl)
         jr       enter_name_loop
too_far: inc      b
         jr       enter_name_loop
nomore:
         ld       hl,lowest
         ld       de,(score)
         ld       (hl),e
         push     hl
         inc      hl
         ld       (hl),d
         pop      ix              ; hiscore table
         ld       b,6
sort_scores:
         ld       e,(ix)
         ld       d,(ix+1)
         ld       l,(ix-14)
         ld       h,(ix-13)
         bcall(_CPHLDE)
         ret      nc
         push     bc
         ld       b,14
         ld       d,0
exg_loop:ld       e,(ix)
         ld       c,(ix-14)
         ld       (ix),c
         ld       (ix-14),e
         inc      ix
         inc      hl
         djnz     exg_loop
         ld       de,-28
         add      ix,de
         pop      bc
         djnz     sort_scores
	   ret

 ; -------------- THE ACTUAL GAME -------------------------------------------

play_game:
         ld       hl,saved_flag
         ld       a,(hl)
         ld       (hl),0
         or       a
         jr       nz,main_loop

         LD       hl,lives
         ld       (hl),9
         ld       a,1
         ld       (level),a
level_start:
         call     make_level
         call     prepare_to_play_level
main_loop:
         call     render_background
         call     do_you
         call     do_enemies
         call     display_data
         call     speed_delay
         call     toggle_autopilot
         call     misc_keys
         ld       a,(pills)
         or       a
         jr       z,you_won
         bcall(_getcsc)
         cp      skClear
         jr       nz,main_loop
         ret
you_won:
         ld       hl,level
         inc      (hl)
         ld       b,100
         ld       a,(lives)
         ld       e,a
         ld       d,0
         ld       hl,(score)
loopis:  add      hl,de
         ld       (score),hl
         djnz     loopis
         ld       a,(level)
nlev:
         cp       NUM_LEVELS+1
         jr       z,win
         jr       level_start
win:
         ld       hl,(score)
         ld       de,1000
         add      hl,de
         ld       (score),hl
         ld       b,3
loop_flickerw:
         push     bc
         call     display_data
         ld       bc,0
lww1:    dec      bc
         ld       a,b
         or       c
         jr       nz,lww1
         ld       de,$0303
         ld       hl,youwin
         call     DTX
         ld       bc,0
lww2:    dec      bc
         ld       a,b
         or       c
         jr       nz,lww2
         pop      bc
         djnz     loop_flickerw        
         ret
youwin:  .db      "YOU WIN!!!!",0
 ; -------------- RENDER THE BACKGROUND -------------------------------------
render_background:
         ld       ix,GRAPH_MEM-384
         ld       hl,data
         ld       b,12
line_loop:
         push     bc
         ld       b,12
blocks_loop:

         xor      a
         ld       e,a                        ;E = Middle
         ld       c,a                        ;C = Top
         ld       d,a                        ;D = Bottom

         ld       a,(hl)
         inc      hl

         rra
         jr       nc,notop
         ld       c,%11111111
notop:

         rra
         jr       nc,noleft
         set      7,c
         ld       d,%10000000
         ld       e,%10000000
noleft:

         rra
         jr       nc,nobottom
         ld       d,%11111111
nobottom:

         rra
         jr       nc,noright
         inc      e
         set      0,c
         set      0,d
noright:

         ld       (ix),c
         ld       (ix+12),e
         ld       (ix+24),e
         ld       (ix+60),e
         ld       (ix+72),e
         ld       (ix+84),d

         rra
         jr       nc,no_small_pill
         set      3,e
         set      4,e
         jr       no_large_pill
no_small_pill:

         rra
         jr       nc,no_large_pill
      
         set      3,e
         set      4,e
         ld       d,e
         ld       (ix+24),d
         ld       (ix+60),d
         set      5,e
         set      2,e

no_large_pill:      

         ld       (ix+36),e
         ld       (ix+48),e

         inc      ix

         djnz     blocks_loop
         ld       bc,84
         add      ix,bc
         pop      bc
         djnz     line_loop
         ret
 ; -------------- COPY THE IMAGE TO THE SCREEN ------------------------------
bottom_of_buffer:
         ld       hl,GRAPH_MEM
         jr       dispi
display_data:
         di
         ld       hl,GRAPH_MEM-384
         ld       a,(y)
         bit      6,a
         jr       nz,bottom_of_buffer
         sub      32
         jr       z,dispi
         jp       m,dispi
         ld       b,a
         ld       de,12
lfa:     add      hl,de
         djnz     lfa
dispi:
 	 call DISP_DELAY
	 ld       a,7
	 out      (16),a

	 ld       c,17
	 ld       a,$80
loop_display:
	 call DISP_DELAY
	 out      (16),a
	 inc      a
	 ld       e,a
	 ld       a,$20
	 call DISP_DELAY
	 out      (16),a
	 ld       a,e
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 call DISP_DELAY \ outi
	 cp       $c0
	 jr       nz,loop_display
	 ei
	 ret

DISP_DELAY:
 push hl
 pop hl
 ret


; -------------- SET UP A LEVEL --------------------------------------------
make_level:
         ld       de,144
         ld       hl,level_maps-144
         ld       a,(level)
         ld       b,a
lfld:    add      hl,de
         djnz     lfld
         ld       bc,144
         ld       de,data
         ld       b,144
         ld       c,0
loop_make_level_map:
         ld       a,(hl)
         bit      4,a
         jr       z,nph
         inc      c
nph:     ld       (de),A
         INC      HL
         INC      DE
         djnz     loop_make_level_map
         ld       a,c
         ld       (pills),a
         ret

prepare_to_play_level:
         call     render_background      
         ld       hl,image_right
         ld       (image),hl
         ld       hl,0
         ld       (x),hl
         ld       (xv),hl
         ld       (nxv),hl
         ld       a,$5f
         ld       (bitsmc+1),a
         ld       b,3
loop_flicker:
         push     bc
         call     display_data
         ld       bc,0
lw1:     dec      bc
         ld       a,b
         or       c
         jr       nz,lw1
         ld       de,$0303
         ld       hl,getready
         call     DTX
         ld       bc,0
lw2:     dec      bc
         ld       a,b
         or       c
         jr       nz,lw2
         pop      bc
         djnz     loop_flicker
         ld       de,enemies
enemy_setup:
         ld       hl,default_enemy_data
         ld       bc,20
         ldir
         ret
 ; -------------- SPRITE RENDERING ROUTINE ----------------------------------
offsets_table:
         .db      128,64,32,16,8,4,2,1
drw_spr: ld       a,d
         and      7
         ld       hl,offsets_table
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         ld       (smc1+1),a

         ld       hl,GRAPH_MEM-384          ;Calculate byte number
         ld       a,e
         add      a,a
         add      a,a
         add      a,a
         rl       b
         add      a,a
         rl       b
         srl      d
         srl      d
         srl      d
         or       d
         ld       c,a
         add      hl,bc                                    
          
         ld       d,(ix)       
         ld       b,(ix+1)        
oloop:   push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix+2)            ;Load one line of image
         inc      ix
smc1     ld       a,1               ;Load pixel mask
iloop:   sla      c                 ;Test leftmost pixel
         jr       nc,noplot         ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
noplot:  rrca
         jr       nc,notedge        ;Test if edge of byte reached
         inc      hl                ;Go to next byte
notedge: djnz     iloop
         pop      hl                ;Restore address
         ld       bc,16             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     oloop
         ret
drw_spr96:
         ld       a,d
         and      7
         ld       hl,offsets_table
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         ld       (_smc1+1),a

         ld       hl,GRAPH_MEM-384           ;Calculate byte number

         ld       a,e
         add      a,a
         add      a,e
         rl       b
         add      a,a
         rl       b
         add      a,a
         rl       b
         srl      d
         srl      d
         srl      d
         add      a,d
         jr       nc,n1
         inc      b
n1:      ld       c,a
         add      hl,bc                                    
          
         ld       d,(ix)       
         ld       b,(ix+1)        
_oloop:  push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix+2)            ;Load one line of image
         inc      ix
_smc1    ld       a,1               ;Load pixel mask
_iloop:  sla      c                 ;Test leftmost pixel
         jr       nc,_noplot        ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
_noplot: rrca
         jr       nc,_notedge       ;Test if edge of byte reached
         inc      hl                ;Go to next byte
_notedge:djnz     _iloop
         pop      hl                ;Restore address
         ld       bc,12             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     _oloop
         ret
 ; -------------- DO STUFF ABOUT YOU ----------------------------------------
do_you:
         ld       ix,(image)
         ld       hl,x
         ld       d,(hl)
         inc      hl
         ld       e,(hl)
         call     drw_spr96
         ld       hl,x
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         dec      hl
         dec      hl
         ld       (hl),a
         inc      hl
         ld       b,a
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         ld       (y),a
         or       b
         and      7
         jr       nz,read_arrows
 ; -------------- POSSIBLY CHANGE YOUR MOVEMENT ------------------------------
autop:   ld       a,0
         or       a
         jr       z,km
         ld       hl,0
         ld       (nxv),hl
km:
         call     read_arrows
         ld       hl,(nxv)
         ld       (xv),hl
         ld       hl,x
         ld       c,(hl)            ;C = X
         srl      c                 ;C = X / 2
         srl      c                 ;C = X / 4
         srl      c                 ;C = X / 8
         inc      hl                ;HL -> Y
         ld       a,(hl)            ;A = Y
         ld       b,a               ;B = Y
         srl      a                 ;A = Y / 2
         add      a,b               ;A = 12 * Y / 8
         add      a,c               ;A = (X / 8) + (12 * Y / 8)
         ld       hl,data          ;HL -> MAP
         ld       c,a               ;C = (X / 8) + (12 * Y / 8)
         ld       b,0               ;BC = (X / 8) + (12 * Y / 8)
         add      hl,bc             ;HL -> MAP + (X / 8) + (12 * Y / 8)
         ld       a,(hl)

         bit      4,a
         jr       z,nopill
         push     hl
         ld       hl,pills
         dec      (hl)
         ld       hl,(score)
         inc      hl
         ld       (score),hl
         pop      hl
nopill:  bit      5,a
         jr       z,nospill
         push     af
         push     hl
         ld       hl,enemies
         ld       de,5
         ld       B,4
lse:     ld       a,(hl)
         cp       3
         jr       nz,cste
         ld       (hl),6
cste:    add      hl,de
         djnz     lse
         ld       a,160
         ld       (countdown),a
         ld       hl,(score)
         add      hl,de
         ld       (score),hl
         pop      hl
         pop      af
         nop
nospill: and      15
         ld       (hl),a

bitsmc:  bit      3,a
         ret      z
         ld       hl,0
         ld       (xv),hl
         ret
read_arrows:
         LD       A,%1111110
         ld       ix,bitsmc+1
         OUT      (1),a
         in       a,(1)
         srl      a
         jr       c,no_down
         ld       hl,image_down
         ld       (image),hl
         ld       hl,$0100
         ld       (nxv),hl
         ld       (ix),$57
no_down: srl      a
         jr       c,no_left
         ld       hl,image_left
         ld       (image),hl
         ld       hl,$00ff
         ld       (nxv),hl
         ld       (ix),$4f
no_left: srl      a
         jr       c,no_right
         ld       hl,image_right
         ld       (image),hl
         ld       hl,$0001
         ld       (nxv),hl
         ld       (ix),$5f
no_right:srl      a
         ret      c
         ld       hl,image_up
         ld       (image),hl
         ld       hl,$ff00
         ld       (nxv),hl
         ld       (ix),$47
         ret

 ; -------------- TOGGLE AUTOPILOT ------------------------------------------
toggle_autopilot:
         ld       a,%111111
         out      (1),a
         ld       hl,jp2nd
         in       a,(1)
         bit      5,a
         jr       nz,notpressed
         ld       a,(hl)
         or       a
         ret      nz
         ld       a,(autop+1)
         cpl
         ld       (autop+1),a

         ret
notpressed:
         ld       (hl),0
         ret
misc_keys:
         bcall(_getcsc)
         cp      skMode
         jp      z,pause
         cp      skStat
         jp      z,save_the_game
         cp      skClear
         jp      z,now2
         ret
 ; -------------- STUFF RELATED TO ENEMIES ----------------------------------
do_enemies:
         ld       a,(countdown)
         or       a
         jr       z,ncd
         dec      a
         ld       (countdown),a
ncd:
         ld       hl,enemies
         ld       b,4
enemy_loop:
         push     bc
         push     hl
         ld       b,0
         ld       c,(hl)
         ld       ix,enemy_routine_table
         add      ix,bc
         jp       (ix)
eback:   pop      hl
         pop      bc
         ld       de,5
         add      hl,de
         djnz     enemy_loop
         ret
enemy_routine_table:
         jp       eback
         jp       enemy_normal
         jp       enemy_scared
         jp       enemy_dead_r
enemy_dead_l:
         inc      hl
         dec      (hl)
         jr       z,enemy_restore
enemy_draw:
         ld       d,(hl)
         inc      hl
         ld       e,(hl)
         ld       ix,image_ghost_dead
         call     drw_spr96
         jr       eback
enemy_dead_r:
         inc      hl
         inc      (hl)
         ld       a,(hl)         
         cp       88
         jr       z,enemy_restore
         jr       enemy_draw
enemy_restore:
         dec      hl
         ld       (hl),3
         jr       eback

rand:    ld       de,0
         ld       a,(de)
         xor      e
         inc      de
         res      7,d
         ld       (rand+1),de
         ret


 ; -------------- NORMAL ENEMY ---------------------------------------------
enemy_normal:
         inc      hl
         ld       a,(hl)
         inc      hl
         or       (hl)
         and      7
         scf
         call     z,enemy_pseudo_intelligence
         call     nc,change_enemy_related_stuff

         ld       a,(y)
         sub      (hl)
         dec      hl
         add      a,5
         jp       m,nocoll1
         cp       10
         jr       nc,nocoll1
         ld       a,(x)
         sub      (hl)
         add      a,5
         jp       m,nocoll1
         cp       10
         jr       nc,nocoll1
         inc      sp
         inc      sp
         inc      sp
         inc      sp
         inc      sp
         inc      sp
         ld       hl,lives
         dec      (hl)
         ret      z
         call     prepare_to_play_level
         jp       main_loop
nocoll1:
      
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(Hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       d,a
         inc      hl
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       e,A
         ld       ix,image_ghost
         call     drw_spr96
         jp       eback
 ; -------------- SCARED ENEMY ---------------------------------------------
slow:    inc      hl
         ld       d,(hl)
         inc      hl
         ld       e,(Hl)
         jr       drawit         
btn:     ld       (hl),3
         jp       enemy_normal
enemy_scared:
         ld       a,(countdown)
         or       a
         jr       z,btn
         rra
         jr       nc,slow
         inc      hl
         ld       a,(hl)
         inc      hl
         or       (hl)
         and      7
         scf
         call     z,enemy_pseudo_intelligence_2
         call     nc,change_enemy_related_stuff

         ld       a,(y)
         sub      (hl)
         dec      hl
         add      a,5
         jp       m,nocoll2
         cp       10
         jr       nc,nocoll2
         ld       a,(x)
         sub      (hl)
         add      a,5
         jp       m,nocoll2
         cp       10
         jr       nc,nocoll2
         ld       a,(hl)
         dec      hl
         ld       (hl),12
         sub      44
         jp       p,ec1
         ld       (hl),9
ec1:     inc      hl
         inc      hl
         ld       a,(hl)
         and      %11111000
         ld       (hl),a
         inc      hl
         ld       (hl),0
         inc      hl
         ld       (hl),0
         ld       hl,(score)
         ld       de,50
         add      hl,de
         ld       (score),hl
         jp       eback
nocoll2:
                
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(Hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       d,a
         inc      hl
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       e,A
drawit:
         ld       ix,image_ghost_scared
         call     drw_spr96
         jp       eback
 ; -------------- CHANGE ENEMY DIRECTION -----------------------------------
enemy_pseudo_intelligence:
         push     hl
         call     rand    
         rra
         jr       c,_updown
_leftright:
         dec      hl
         ld       a,(x)
         sub      (hl)
         jp       p,right__
         jr       left__
_updown:
         ld       a,(y)
         sub      (hl)
         jp       m,up__
_down:   jr       down__
enemy_pseudo_intelligence_2:
         push     hl
         call     rand
         rra
         jr       c,__updown
         dec      hl
         ld       a,(x)
         sub      (hl)
         jp       m,right__
         jr       left__
__updown:
         ld       a,(y)
         sub      (hl)
         jp       p,up__
         jr       down__
change_enemy_related_stuff:
         push     hl
         ld       a,r
         and      3
         dec      a
         jr       z,left__
         dec      a
         jr       z,right__
         dec      a
         jr       z,up__
down__:  ld       a,$57
         ld       bc,$0100
         jr       enemy_continue
left__:  ld       a,$4f
         ld       bc,$00ff
         jr       enemy_continue
right__: ld       a,$5f
         ld       bc,1
         jr       enemy_continue
up__:    ld       a,$47
         ld       bc,$ff00
enemy_continue:
         ld       hl,smcebit+1
         ld       (hl),a
         pop      hl
         inc      hl
         ld       (hl),c
         inc      hl
         ld       (hl),b
         dec      hl
         dec      hl

         ld       a,(hl)            ;A = Y
         push     hl
         dec      hl
         ld       c,(hl)            ;C = X
         srl      c                 ;C = X / 2
         srl      c                 ;C = X / 4
         srl      c                 ;C = X / 8
         ld       b,a               ;B = Y
         srl      a                 ;A = Y / 2
         add      a,b               ;A = 12 * Y / 8
         add      a,c               ;A = (X / 8) + (12 * Y / 8)
         ld       hl,data          ;HL -> MAP
         ld       c,a               ;C = (X / 8) + (12 * Y / 8)
         ld       b,0               ;BC = (X / 8) + (12 * Y / 8)
         add      hl,bc             ;HL -> MAP + (X / 8) + (12 * Y / 8)
         ld       a,(hl)
         pop      hl
         scf
smcebit: bit      0,a
         ret      z
         inc      hl
         ld       (hl),0
         inc      hl
         ld       (hl),0
         dec      hl
         dec      hl
         scf
         ccf
         ret
 ; -------------- GAME DATA -------------------------------------------------
 ; -------------- VARIABLE ADDRESSES ----------------------------------------

saved_flag:
         .db      0

cheat    .db      0
lives    .db      0
x        .db      0
y        .db      0                     
xv       .db      0                     
yv       .db      0                     
level    .db      0                     
image    .dw      0                     
pills    .dw      0             
enemies  .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
jp2nd    .db      0
nxv      .db      0        
nyv      .db      0    
cdown    .dw      0     
score    .dw      0
speed    .db      0
numen    .db      0
curspos  .db      0
countdown .db 0

data:    .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
stored_data_end:

scrlstart         =TEXT_MEM
scrlpos           =TEXT_MEM+2
temp              =TEXT_MEM+4
;countdown         =TEXT_MEM+10

; -------------- IMAGES ----------------------------------------------------
image_right:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01110110
         .db      %01111100
         .db      %01111000
         .db      %01111110
         .db      %00111100
image_up:
         .db      7,7
         .db      %00000000
         .db      %00100100
         .db      %01110110
         .db      %01011110
         .db      %01111110
         .db      %01111110
         .db      %00111100
image_left:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01101110
         .db      %00111110
         .db      %00011110
         .db      %01111110
         .db      %00111100
image_down:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01111110
         .db      %01111110
         .db      %01111010
         .db      %01101110
         .db      %00100100
image_ghost:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01111110
         .db      %01111010
         .db      %01111110
         .db      %01111110
         .db      %01010100
image_ghost_scared:
         .db      7,7
         .db      %00000000
         .db      %00101000
         .db      %01010100
         .db      %00101010
         .db      %01010100
         .db      %00101010
         .db      %01010100
image_ghost_dead:
         .db      7,4
         .db      %01000100
         .db      %10101010
         .db      %10101010
         .db      %01000100


 ; -------------- LEVEL DATA ------------------------------------------------
level_maps:
         .db      03,21,21,21,17,21,21,17,21,21,21,25
         .db      26,35,21,21,20,17,17,20,21,21,41,26
         .db      26,26,19,21,21,20,20,21,21,25,26,26
         .db      26,26,18,17,17,21,21,17,17,24,26,26
         .db      18,24,26,26,26,19,25,26,26,26,18,24
         .db      26,22,44,26,18,28,22,24,26,38,28,26
         .db      26,19,41,26,18,25,19,24,26,35,25,26
         .db      18,24,26,26,26,22,28,26,26,26,18,24
         .db      26,26,18,20,20,21,21,20,20,24,26,26
         .db      26,26,22,21,21,17,17,21,21,28,26,26
         .db      26,38,21,21,17,20,20,17,21,21,44,26
         .db      22,21,21,21,20,21,21,20,21,21,21,28

         .db      03,21,21,17,17,21,21,17,17,21,21,25
         .db      26,35,21,28,26,19,25,26,22,21,41,26
         .db      26,26,35,17,20,28,22,20,17,41,26,26
         .db      18,28,26,26,19,17,17,25,26,26,22,24
         .db      18,21,24,26,26,10,10,26,26,18,21,24
         .db      26,19,28,18,28,10,10,22,24,22,25,26
         .db      26,22,25,18,25,10,10,19,24,19,28,26
         .db      18,21,24,26,26,10,10,26,26,18,21,24
         .db      18,25,26,26,22,20,20,28,26,26,19,24
         .db      26,26,38,20,17,25,19,17,20,44,26,26
         .db      26,38,21,25,26,22,28,26,19,21,44,26
         .db      22,21,21,20,20,21,21,20,20,21,21,28

         .db      03,21,21,17,17,41,35,17,17,21,21,25
         .db      26,19,21,28,26,26,26,26,22,21,25,26
         .db      26,26,19,21,28,26,26,22,21,25,26,26
         .db      18,28,26,19,21,16,16,21,25,26,22,24
         .db      18,21,28,26,19,24,18,25,26,22,21,24
         .db      38,21,21,24,26,14,14,26,18,21,21,44
         .db      35,21,21,24,26,11,11,26,18,21,21,41
         .db      18,21,25,26,22,24,18,28,26,19,21,24
         .db      18,25,26,22,21,16,16,21,28,26,19,24
         .db      26,26,22,21,25,26,26,19,21,28,26,26
         .db      26,22,21,25,26,26,26,26,19,21,28,26
         .db      22,21,21,20,20,44,38,20,20,21,21,28

         .db      03,21,25,19,21,21,17,21,25,19,21,25
         .db      26,19,20,28,19,21,20,25,22,20,25,26
         .db      22,24,19,21,44,19,25,38,21,25,18,28
         .db      19,44,18,21,17,28,22,17,21,24,38,25
         .db      26,19,24,19,28,19,25,22,25,18,25,26
         .db      18,24,26,26,19,28,22,17,24,26,26,26
         .db      26,26,26,18,20,25,19,28,26,26,18,24
         .db      26,22,24,22,25,22,28,19,28,18,28,26
         .db      22,25,18,21,20,25,19,20,21,24,19,28
         .db      19,24,22,21,25,22,28,19,21,28,18,25
         .db      26,22,17,25,22,17,21,28,19,17,28,26
         .db      38,21,28,22,21,20,21,21,28,22,21,44

         .db      03,21,21,17,21,21,21,21,17,21,21,25
         .db      22,21,25,18,21,25,19,21,24,19,21,28
         .db      19,21,28,22,21,24,18,21,28,22,21,25
         .db      26,19,21,21,17,20,20,17,21,21,25,26
         .db      26,26,19,21,20,21,21,20,21,25,26,26
         .db      22,44,22,21,17,21,21,17,21,28,38,28
         .db      19,41,19,21,20,21,21,20,21,25,35,25
         .db      26,26,22,21,17,21,21,17,21,28,26,26
         .db      26,22,21,21,20,17,17,20,21,21,28,26
         .db      22,21,25,19,21,24,18,21,25,19,21,28
         .db      19,21,28,18,21,28,22,21,24,22,21,25
         .db      22,21,21,20,21,21,21,21,20,21,21,28

         .db      03,21,21,21,21,17,17,21,21,21,21,25
         .db      26,35,17,21,21,28,22,21,21,17,41,26
         .db      26,26,18,21,21,21,21,21,21,24,26,26
         .db      26,26,18,21,17,25,19,17,21,24,26,26
         .db      26,26,26,19,28,26,26,22,25,26,26,26
         .db      18,28,26,26,19,12,06,25,26,26,22,24
         .db      18,25,26,26,22,09,03,28,26,26,19,24
         .db      26,26,26,22,25,26,26,19,28,26,26,26
         .DB      26,26,18,21,20,28,22,20,21,24,26,26
         .db      26,26,18,21,21,21,21,21,21,24,26,26
         .db      26,38,20,21,21,25,19,21,21,20,44,26
         .db      22,21,21,21,21,20,20,21,21,21,21,28

         .db      03,25,19,21,21,21,21,21,21,25,19,25
         .db      26,26,22,21,17,25,19,17,21,28,26,26
         .db      26,22,17,21,44,18,24,38,21,17,28,26
         .db      18,21,16,17,21,28,22,21,17,16,21,24
         .db      18,25,26,26,19,21,21,25,26,26,19,24
         .db      26,26,26,22,20,25,19,20,28,26,26,26
         .db      26,26,26,19,17,28,22,17,25,26,26,26
         .db      18,28,26,26,22,21,21,28,26,26,22,24
         .db      18,21,16,20,21,25,19,21,20,16,21,24
         .db      26,19,20,21,41,18,24,35,21,20,25,26
         .db      26,26,19,21,20,28,22,20,21,25,26,26
         .db      22,28,22,21,21,21,21,21,21,28,22,28

         .db      03,21,21,17,21,21,21,21,17,21,21,25
         .db      26,35,17,20,21,25,19,21,20,17,41,26
         .db      22,28,22,21,21,24,18,21,21,28,22,28
         .db      19,21,21,17,25,26,26,19,17,21,21,25
         .db      18,25,19,24,26,26,26,26,18,25,19,24
         .db      26,26,26,26,26,26,26,26,26,26,26,26
         .db      26,26,26,26,26,18,24,26,26,26,26,26
         .db      18,28,22,24,18,28,22,24,18,28,22,24
         .db      18,21,21,24,22,17,17,28,18,21,21,24
         .db      26,19,41,18,21,28,22,21,24,35,25,26
         .db      26,26,26,22,21,25,19,21,28,26,26,26
         .db      22,28,22,21,21,20,20,21,21,28,22,28

; ------------- TEXT & ENEMY DATA ------------------------------------------

getready:.db      "GET READY!",0
default_enemy_data:
         .db      3,40,40,0,0
easy_enemy_data:
         .DB      3,48,40,0,0
         .DB      3,40,48,0,0
         .DB      3,48,48,0,0       
         .DB      0,00,00,0,0

speedtext_slow:
         .db      "SLOW"
speedtext_fast:
         .db      "FAST"

title:   .db      "PAC-MAN '99 v0.5",0
         .db 0
         .db      "Copyright 1999 by:",0
         .db      "Patrick Davidson",0
         .db      "Sam Heald",0
         .db      "Change Speed ("
speed_text:         .db      "FAST)",0
         .db      "Change # of enemies ("
number_text:  .db "4)",0
         .db      "Start playing Pac-Man!",0

stored_data_start:

; ---------------------- HIGH SCORES ---------------------------------------
hi_score_str:
         .db      "-->Pac-Man 99<--"
         .db      "   You got a    "
         .db      "  high score!   "
         .db      "Enter your name:",0
hstitle: .db      "== HIGHSCORES ==",0
hsdata:  .dw      5000
         .db      "Pac-Man 99!",0
         .dw      4500
         .db      "Pac-Man 99!",0
         .dw      4000
         .db      "Pac-Man 99!",0
         .dw      3500
         .db      "Pac-Man 99!",0
         .dw      3000
         .db      "Pac-Man 99!",0
         .dw      2500
         .db      "Pac-Man 99!",0
lowest   .dw      250
         .db      "Pac-Man 99!",0
chartable:
         .db      ":WRMH."
         .DB      "..0VQLG!..ZUPKFC"
         .DB      "..YTOJEBX.>SNIDA"
         .DB      ".12345.."

pause:   bcall(_clrlcdfull)
         LD       de,0
         ld       hl,paused_msg
         call     DTX

         ld       hl,$b06
         ld       (CURROW),hl
         ld       hl,(score)
         bcall(_disphl)

         ld       hl,$b04
         ld       (CURROW),hl
         ld       a,(lives)
         ld       l,a
         ld       h,0
         bcall(_disphl)

         ld       hl,$b05
         ld       (CURROW),hl
         ld       a,(level)
         ld       l,a
         ld       h,0
         bcall(_disphl)

OTH_PAUSE:
 bcall(_getcsc)
 cp skEnter
 jr nz,OTH_PAUSE
 ret

;ROUTINE ENDS HERE
paused_msg:
         .db      "Pac-Man '99 v0.5"
         .db      "---> PAUSED <---"
         .db      "<ENTER>: Resume "
         .db      "                "
         .db      "LIVES --->      "
         .db      "LEVEL --->      "
         .db      "SCORE --->",0


speed_delay:
         ld       a,(speed)
         or       a
         ret      z
         EI
         halt
         halt
         ret
DTX:
         ld       (CURROW),de
	   bcall(_puts)
         ret
DMX:
         ld       (PENCOL),de
         bcall(_vputs)
         ret
         .end
