;##################################################################
;
;   Phoenix-82 (New game initialization)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated April 5, 2002.
;
;##################################################################     

difficulty_msg:
        .db     "Choose Rank",0
        .db     0
	.db	"1) Super Easy",0
        .db     "2) Beginner",0
        .db     "3) Intermediate",0
        .db     "4) Advanced",0
	.db	"5) Expert",0
        .db     -1

speed_msg:
        .db     "Choose Speed",0
        .db     0
	.db	"1) Super Slow",0
        .db     "2) Slow",0
        .db     "3) Fast",0
	.db	"4) Super Fast",0
	.db	"5) Ultra Fast",0
        .db     -1

;############## Prepare new game

initialize_game:
        ROM_CALL(CLEARLCD)
        ld      hl,difficulty_msg
        call    display_hl_msgs

dsel_loop:
        call    GET_KEY
	cp	KEY_CODE_1
	jr	z,play_spez
        cp      KEY_CODE_2
        jr      z,play_easy
        cp      KEY_CODE_3
        jr      z,play_medium
        cp      KEY_CODE_4
        jr      z,play_hard
	cp	KEY_CODE_5
	jr	z,play_expert
        cp      KEY_CODE_DEL
        jp      z,game_exit
        cp      KEY_CODE_CLEAR
        jp      z,game_exit
        cp      KEY_CODE_MODE
        jr      nz,dsel_loop
        jp      game_exit

play_expert:
	ld	a,10
	ld	de,15000
	jr	install_game_variables
play_hard:
        ld      a,25
        ld      de,10000
        jr      install_game_variables
play_medium:
        ld      a,50
        ld      de,5000
        jr      install_game_variables
play_easy:
        ld      a,100
        ld      de,0
	jr	install_game_variables
play_spez
	ld	a,150
	ld	de,0
install_game_variables:
        push    de
        ld      hl,perm_var_start
        ld      bc,perm_vars_to_zero-1
        call    OTH_CLEAR
        pop     de

        ld      (bonus_score),de
        ld      (difficulty),a

        ld      hl,player_y
        ld      (hl),70         ; Player Y coord = 70
        inc     hl
        ld      (hl),60         ; Player X coord = 60
        inc     hl
        inc     hl
        inc     hl
        ld      (hl),16         ; Status of player's ship

        ld      hl,19000
        ld      (time_score),hl

        ROM_CALL(CLEARLCD)
        ld      hl,speed_msg
        call    display_hl_msgs

ssel_loop:
        call    GET_KEY
#ifdef ENABLE_CHEATS
        cp      KEY_CODE_TAN
        jr      z,play_cheat1
	cp	KEY_CODE_ALPHA
	jr	z,play_cheat2
#endif
	cp	KEY_CODE_1
	jr	z,play_sslow
        cp      KEY_CODE_2
        jr      z,play_slow
        cp      KEY_CODE_3
        jr      z,play_fast
	cp	KEY_CODE_4
	jr	z,play_sfast
	cp	KEY_CODE_5
	jr	z,play_ufast
        cp      KEY_CODE_DEL
        jp      z,game_exit
        cp      KEY_CODE_CLEAR
        jp      z,game_exit
        cp      KEY_CODE_MODE
        jr      nz,ssel_loop
        jp      game_exit

#ifdef ENABLE_CHEATS
play_cheat1:
        ld      a,1
        ld      (weapon_5),a
        ld      a,4
        ld      de,0
        jr      speed_chosen
play_cheat2:
	ld	a,1
	ld	(weapon_5),a
	ld	a,0
	ld	de,0
	jr	speed_chosen
#endif
play_sslow:
	ld	a,4
	ld	de,0
	jr	speed_chosen
play_slow:
        ld      a,3
        ld      de,0
        jr      speed_chosen
play_fast:
        ld      a,2
        ld      de,5000
	jr	speed_chosen
play_sfast:
	ld	a,1
	ld	de,10000
	jr	speed_chosen
play_ufast:
	ld	a,0
	ld	de,15000
speed_chosen:
        ld      (speed),a
        ld      hl,(bonus_score)
        add     hl,de
        ld      (bonus_score),hl

        ld      hl,data_zero_start
        ld      bc,data_zero_end-data_zero_start-1
        jp      OTH_CLEAR
