;##################################################################
;
;   P H O E N I X         F O R        T I - 8 2 / 8 3 / 8 3 +
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 1, 2002.
;
;##################################################################     

main:
        ld      (initsp+1),sp

        ld      a,$c9
        ld      (check_restore),a

        ld      hl,timer_interrupt
#ifdef __MIRAGE__
        ld      (custintaddr),hl
        ld      a,34
        call    setupint
#else
        ld      de,interrupt_entry
        ld      bc,timer_interrupt_end-timer_interrupt
        ldir

        ld      hl,interrupt_table
        ld      (hl),interrupt_byte
        ld      bc,256
        call    OTH_FILL

        ld      a,interrupt_reg
        ld      i,a

        im      2
#endif

        ei
        ld      (iy+13),0

        xor     a
        ld      (ext_level),a
        ld      hl,level_table
        ld      (level_addr),hl

        call    restore_game

no_saved_game:
        call    level_selector
  
;############## Title screen

redraw_title:

        ROM_CALL(CLEARLCD)
        ld      hl,title_main

show_title:
        call    display_hl_msgs

title_loop:
        call    SUPER_GET_KEY
        cp      KEY_CODE_2
        jr      z,show_contact
        cp      KEY_CODE_3
        jr      z,show_instructions
        cp      KEY_CODE_1
        jp      z,start_new_game
        cp      KEY_CODE_CLEAR
        jr      z,game_exit
        cp      KEY_CODE_ALPHA
        jr      z,show_highs
        cp      KEY_CODE_DEL
        jr      nz,title_loop                   

game_exit:
#ifndef __MIRAGE__
        im      1
#endif
initsp: ld      sp,0
        ROM_CALL(CLEARLCD)
check_restore:
        ret
restore_mem:
        ld      de,0
        ld      hl,$f00c
        jp      memory_exchange

show_highs:
        call    no_high_score
        jr      redraw_title

show_contact:
        ld      hl,title_contact
        jr      show_title

show_instructions:
        ld      hl,title_instructions
        jr      show_title

;############## Title screen messages

title_main:
        .db     "  Gold Phoenix  ",0
        .db     " By: Javier H.  ",0
        .db     "  Programmed by",0
        .db     "Patrick Davidson",0
        .db     0
        .db     "1 - Start Game",0
        .db     "2 - Contact Info",0
        .db     "3 - Instructions",0
        .db     -1

title_instructions:
        .db     "Arrows Move Ship",0
        .db     "#s Select Weapon",0
        .db     "2nd Fires Weapon",0
        .db     "MODE Save  Exit",0
        .db     -1

title_contact:
        .db     "E-Mail: Pat     ",0
        .db     "    pad@calc.org",0
        .db     "E-Mail: Javier  ",0
        .db     "   Gokugoten@   ",0
        .db     "     aol.com    ",0
	.db	-1

;############## Initialize a new game

start_new_game:
        call    initialize_game

pre_main_loop:
        
        ld      hl,-6
        add     hl,sp
        ld      (collision_done+1),hl
        
;############## Game main loop
        
main_loop:
        call    frame_init

        call    clear_buffer           ; Prepare main display buffer

        call    init_rand

        call    do_player              ; Move and draw player
        call    do_companion           ; Move and draw companion ship

        call    enemies                ; Move and draw enemies

        call    player_bullets         ; Move and draw player bullets

        call    enemy_bullets          ; Move and draw enemy bullets
        call    hit_player             ; Collisions involving player

        call    prepare_indicator      ; Prepare the shield indicator
        call    synchronize            ; Wait for next 1/30 second cycle
        call    display_screen         ; Copy display buffer to video memory

        call    hit_enemies            ; Collisions btw. bullets  enemies

        call    handle_input           ; Process control keys
        ld      a,(enemies_left)
        or      a
        call    z,load_level
        jr      main_loop

;############## TI-82 library


OTH_CLEAR:
        ld      (hl),0
OTH_FILL:
        ld      d,h
        ld      e,l
        inc     de
        ldir
        ret

OTH_ARROW:
        ld      a,%00111111
        out     (1),a
        push    ix
        pop     ix
        in      a,(1)
        or      %00001111
        ld      b,a
        ld      a,%01111110
        out     (1),a
        push    ix
        pop     ix
        in      a,(1)
        and     b
        ret
