;##################################################################
;
;   Phoenix-82 (Screen display routines)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated November 24, 2001.
;
;##################################################################   

;############## Display -1 terminated list of strings at (HL)

display_hl_msgs:
        ld      de,0
show_loop:
        ld      (CURSOR_ROW),de
        push    de
        ROM_CALL(D_ZT_STR)
        pop     de
        ld      a,(hl)
        inc     a
        ret     z
        inc     e
        jr      show_loop

;############## Prepares on-screen shield indicator

prepare_indicator:
        ld      a,(player_pwr)
        or      a
        ret     z
        ret     m
        ld      b,a
        ld      hl,GFX_AREA+1024-3
        ld      de,-16
loop_ind:
        set     0,(hl)
        add     hl,de
        set     0,(hl)
        add     hl,de
        set     0,(hl)
        add     hl,de
        set     0,(hl)
        add     hl,de
        djnz    loop_ind
        ret

;############## Clears screen buffer

clear_buffer:
        ld      (smc_savesp+1),sp
        ld      hl,0
        ld      sp,GFX_AREA+1024
        ld      b,63
loop_super_clear:
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        djnz    loop_super_clear
smc_savesp:
        ld      sp,0

        ld      hl,GFX_AREA+2
        ld      bc,11
        jp      OTH_CLEAR

;############## Display entire screen from buffer

#define DWAIT in a,($10) \ and %10010000 \ jr nz, $-4

display_screen:
        ld      a,$80
        out     ($10),a
        ld      hl,GFX_AREA+2
        ld      c,$20
dispColumn:
        DWAIT
        ld      a,c
        out     ($10),a
        cp      $2c
        ret     z
        ld      b,64
        ld      de,16
dispByte:
        DWAIT
        ld      a,(hl)
        out     ($11),a
        add     hl,de
        djnz    dispByte
        ld      de,-1023
        add     hl,de
        inc     c
        jr      dispColumn
