; Renegade - External levels for Phoenix 2.0 and up - data file
; This software is in the public domain.  There is no warranty.
; Last updated August 7, 2004.
; Programmed by Andy Kay (andrewrocks2003@yahoo.com)

;------- Identification

        .db     "TRenegad"

;------- Table of levels

level_table:
        .dw     lev1
        .dw     lev3            ; with boss
        .dw     _shop

        .dw     lev1
        .dw     lev4            ; second set of standard enemies
        .dw     lev6            ; with boss
        .dw     _shop

        .dw     lev1
        .dw     lev4            ; second set of standard enemies
        .dw     lev4a           ; third set of standard enemies
        .dw     lev6a           ; with boss
        .dw     _shop

        .dw     lev1
        .dw     lev4            ; second set of standard enemies
        .dw     lev4a           ; third set of standard enemies
        .dw     lev7            ; set of looping enemies 
        .dw     lev9            ; with boss
        .dw     _shop

        .dw     lev1
        .dw     lev4            ; second set of standard enemies
        .dw     lev4a           ; third set of standard enemies
        .dw     lev7            ; set of looping enemies 
        .dw     bounce10        ; bouncing enemies
        .dw     bounceb         ; bouncing enemies with boss
        .dw     _shop

        .dw     lev1
        .dw     lev4            ; second set of standard enemies
        .dw     lev4a           ; third set of standard enemies
        .dw     lev7            ; set of looping enemies 
        .dw     bounce10        ; bouncing enemies
        .dw     lev13           ; first set of spinning enemies 
        .dw     lev15           ; with boss
        .dw     _shop

        .dw     lev1
        .dw     lev4            ; second set of standard enemies
        .dw     lev4a           ; third set of standard enemies
        .dw     lev7            ; set of looping enemies 
        .dw     bounce10        ; bouncing enemies
        .dw     lev13           ; first set of spinning enemies
        .dw     lev13a          ; second set of spinning enemies
        .dw     lev15a          ; with boss 
        .dw     _shop

        .dw     lev1
        .dw     lev4            ; second set of standard enemies
        .dw     lev4a           ; third set of standard enemies
        .dw     lev7            ; set of looping enemies 
        .dw     bounce10        ; bouncing enemies
        .dw     lev13           ; first set of spinning enemies
        .dw     lev13a          ; second set of spinning enemies
        .dw     levo1           ; operator enemies
        .dw     levo3           ; with large boss

        .dw     _over

;------- Level data

_shop:  .db     0
        .db     L_SHOP

_over:  .db     0
        .db     L_GAMEEND

lev1:   .db     18
        .db     L_SET_POWER,6
        .db     L_IMAGE_STILL
        .dw     img_en_1
        .db     L_GOTO
        .dw     lev1x

lev1x:  .db     L_INSTALL_ROW,18,10,6,15
lev1y:  .db     L_INSTALL_ROW,18,0,6,15
lev1z:  .db     L_INSTALL_ROW,18,20,6,15
        .db     L_END

lev2x:  .db     L_INSTALL_ROW,20,10,6,15
        .db     L_GOTO
        .dw     lev1y

lev3:   .db     7
        .db     L_SET_POWER,6
        .db     L_IMAGE_STILL
        .dw     img_en_1
        .db     L_GOTO
        .dw     lev3x

lev3x:  .db     L_INSTALL_ROW,18,20,6,15
lev3y:  .db     L_SET_MOVETYPE,EM_BOSS
        .db     L_SET_POWER,61
        .db     L_SET_MOVEDATA,0,32
        .db     L_IMAGE_STILL
        .dw     img_boss_1
        .db     L_SET_FIRETYPE,FT_PERIODIC
        .db     L_SET_FIRERATE,64
        .db     L_SET_WEAPON,W_BIG
        .db     L_INSTALL_ONE,90,1
        .db     L_END

lev4:   .db     18
        .db     L_SET_POWER,8
        .db     L_IMAGE_STILL
        .dw     img_en_2
        .db     L_GOTO
        .dw     lev1x

lev6:   .db     7
        .db     L_SET_POWER,8
        .db     L_IMAGE_STILL
        .dw     img_en_2
        .db     L_GOTO
        .dw     lev3x

lev4a:  .db     18
        .db     L_SET_POWER,8
        .db     L_IMAGE_STILL
        .dw     img_en_2
        .db     L_INSTALL_ROW,18,0,6,15
        .db     L_SET_POWER,8
        .db     L_IMAGE_STILL
        .dw     img_en_2a
        .db     L_INSTALL_ROW,18,10,6,15
        .db     L_GOTO
        .dw     lev1z

lev6a:  .db     13
        .db     L_SET_POWER,8
        .db     L_IMAGE_STILL
        .dw     img_en_2
        .db     L_INSTALL_ROW,18,15,6,15
        .db     L_SET_POWER,10
        .db     L_IMAGE_STILL
        .dw     img_en_2a
        .db     L_INSTALL_ROW,18,23,6,15

        .db     L_GOTO
        .dw     lev3y

lev7:   .db     14
        .db     L_SET_POWER,14
        .db     L_IMAGE_ANIM
        .dw     img_en_3
        .db     L_SET_MOVETYPE,EM_PATTERNSTART
        .db     L_SET_FIRERATE,4
        .db     L_SET_WEAPON,W_SEMIAIM
        .db     L_SET_MOVEDATA
        .dw     circle_pattern
        .db     L_INSTALL_ROW,14,18,7,27
        .db     L_INSTALL_ROW,29,74,7,27
        .db     L_END

bounce10:
        .db     10
        .db     L_IMAGE_STILL
        .dw     img_boun
        .db     L_SET_MOVETYPE,EM_BOUNCE
        .db     L_SET_POWER,36
        .db     L_SET_MOVEDATA,3,3
        .db     L_SET_FIRERATE,4
        .db     L_SET_WEAPON,W_SEMIAIM
        .db     L_INSTALL_ROW,14,20,10,10
        .db     L_END

bounceb:
        .db     11
        .db     L_IMAGE_STILL
        .dw     img_boun
        .db     L_SET_MOVETYPE,EM_BOUNCE
        .db     L_SET_POWER,36
        .db     L_SET_MOVEDATA,3,3
        .db     L_SET_FIRERATE,4
        .db     L_SET_WEAPON,W_SEMIAIM
        .db     L_INSTALL_ROW,14,20,10,10
        .db     L_GOTO
        .dw     lev3y

lev9:   .db     14
        .db     L_SET_POWER,16
        .db     L_IMAGE_ANIM
        .dw     img_en_3
        .db     L_SET_MOVETYPE,EM_PATTERNSTART
        .db     L_SET_FIRERATE,4
        .db     L_SET_WEAPON,W_SEMIAIM
        .db     L_SET_MOVEDATA
        .dw     oval_pattern
        .db     L_INSTALL_ROW,14,18,13,15
        .db     L_GOTO
        .dw     lev3y

lev10:  .db     18
        .db     L_SET_POWER,17
        .db     L_IMAGE_STILL
        .dw     img_en_4
        .db     L_SET_WEAPON,W_ARROW
        .db     L_GOTO

        .dw     lev2x
lev11:  .db     18
        .db     L_SET_POWER,17
        .db     L_IMAGE_STILL
        .dw     img_en_4
        .db     L_SET_WEAPON,W_ARROW
        .db     L_GOTO
        .dw     lev1x

lev12:  .db     13
        .db     L_SET_POWER,8
        .db     L_IMAGE_STILL
        .dw     img_en_2
        .db     L_INSTALL_ROW,18,12,6,15
        .db     L_INSTALL_ROW,18,21,6,15

lev12x: .db     L_SET_MOVETYPE,EM_BOSS
        .db     L_SET_POWER,101
        .db     L_SET_MOVEDATA,0,31
        .db     L_IMAGE_STILL
        .dw     img_boss_2
        .db     L_SET_FIREPOWER,2
        .db     L_SET_FIRETYPE,FT_PERIODIC
        .db     L_SET_FIRERATE,64
        .db     L_SET_WEAPON,W_HUGE
        .db     L_INSTALL_ONE,90,1
        .db     L_END

lev13:  .db     18
        .db     L_IMAGE_ANIM
        .dw     img_sp_1
        .db     L_SET_POWER,21
lev13x: .db     L_SET_WEAPON,W_SEMIAIM
        .db     L_SET_MOVETYPE,EM_RAMPAGEWAIT
        .db     L_SET_FIRERATE,8
        .db     L_GOTO
        .dw     lev1x

lev15:  .db     14
        .db     L_IMAGE_ANIM
        .dw     img_sp_1
        .db     L_SET_POWER,21
lev15x: .db     L_SET_WEAPON,W_SEMIAIM
        .db     L_SET_MOVETYPE,EM_RAMPAGEWAIT
        .db     L_SET_FIRERATE,8
        .db     L_INSTALL_ROW,16,12,7,15
        .db     L_INSTALL_ROW,22,21,6,15
        .db     L_GOTO
        .dw     lev12x

lev13a: .db     18
        .db     L_IMAGE_ANIM
        .dw     img_sp_2
        .db     L_SET_POWER,31
        .db     L_GOTO
        .dw     lev13x

lev15a: .db     14
        .db     L_IMAGE_ANIM
        .dw     img_sp_2
        .db     L_SET_POWER,31
        .db     L_GOTO
        .dw     lev15x

levo1:  .db     8
        .db     L_SET_MOVETYPE,EM_RAMPAGEINIT  
        .db     L_SET_FIRERATE,4
        .db     L_SET_POWER,41
        .db     L_IMAGE_STILL
        .dw     img_op
        .db     L_SET_WEAPON,W_SEMIAIM
        .db     L_INSTALL_ROW,0,0,8,0
        .db     L_END

levo2:  .db     12
levox:  .db     L_SET_MOVETYPE,EM_RAMPAGEINIT
        .db     L_SET_FIRERATE,4
        .db     L_SET_POWER,41
        .db     L_IMAGE_STILL
        .dw     img_op
        .db     L_SET_WEAPON,W_SEMIAIM
        .db     L_INSTALL_ROW,0,0,12,0
        .db     L_END

levo3:  .db     13
        .db     L_SET_MOVETYPE,EM_BOSS
        .db     L_SET_POWER,151
        .db     L_SET_MOVEDATA,0,31
        .db     L_IMAGE_STILL
        .dw     img_boss_2
        .db     L_SET_FIREPOWER,2
        .db     L_SET_FIRETYPE,FT_PERIODIC
        .db     L_SET_FIRERATE,64
        .db     L_SET_WEAPON,W_HUGE
        .db     L_INSTALL_ONE,90,1
        .db     L_SET_FIREPOWER,1
        .db     L_GOTO
        .dw     levox

;------- Enemy movement patterns

huge_oval_pattern:
        .db     32,0,19
huge_oval_loop:
        .db     64,20,0
        .db     10,16,0
        .db     8,12,-12
        .db     28,0,-12
        .db     8,-12,-12
        .db     10,-16,0
        .db     64,-20,0
        .db     10,-16,0
        .db     8,-12,12
        .db     28,0,12
        .db     8,12,12
        .db     10,16,0
        .db     0
        .dw     huge_oval_loop

;     KKK            EEE
;    L   JJ        DD   F
;   L      JJ    DD      F
;| A         JJDD         G |
;| A         DDJJ         G |
;v A       DD    JJ       G v
;   B    DD        JJ    H
;    BCCC            IIIH

figure_eight_pattern:
        .db     32,0,12
figure_eight_loop:
        .db     12,12,12        ;B
        .db     16,16,0         ;C
        .db     34,16,-12       ;D
        .db     16,15,0         ;E
        .db     12,12,12        ;F
        .db     8,0,12          ;G
        .db     12,-12,12       ;H
        .db     16,-15,0        ;I
        .db     34,-16,-12      ;J
        .db     16,-16,0        ;K
        .db     12,-12,12       ;L
        .db     8,0,12          ;A
        .db     0
        .dw     figure_eight_loop

circle_pattern:
        .db     32,0,14
circle_loop:
        .db     8,12,12
        .db     16,16,0
        .db     8,12,-12
        .db     16,0,-16
        .db     8,-12,-12
        .db     16,-16,0
        .db     8,-12,12
        .db     16,0,16
        .db     0
        .dw     circle_loop

oval_pattern:
        .db     32,0,16
oval_loop:
        .db     4,12,12
        .db     76,16,0
        .db     4,12,-12
        .db     6,0,-16
        .db     4,-12,-12
        .db     76,-16,0
        .db     4,-12,12
        .db     6,0,16
        .db     0
        .dw     oval_loop

;------- Images

img_en_4:
        .db     5,6
        .db     %10101000
        .db     %11111000
        .db     %11111000
        .db     %10101000
        .db     %10101000
        .db     %00100000

img_en_1:
        .db     5,5     
        .db     %01110000     
        .db     %11111000    
        .db     %10101000    
        .DB     %10101000     
        .DB     %00100000     

img_en_2:
        .db     4,4
        .db     %01100000
        .db     %11110000
        .db     %10010000
        .db     %10010000

img_en_2a:
        .db     3,3
        .db     %10100000
        .db     %11100000
        .db     %01000000

img_op:
	.db     4,4
        .db     %01100000
        .db     %10010000
        .db     %10010000
        .db     %01100000

img_sp_1:
        .db     2
        .dw     img_sp_1a
        .db     2
        .dw     img_sp_1b
        .db     2
        .dw     img_sp_1c
        .db     0
        .dw     img_sp_1

img_sp_1a:
        .db     5,5
        .db     %01110000
        .db     %10001000
        .db     %10001000
        .db     %10001000
        .db     %01110000

img_sp_1b:
        .db     5,5
        .db     %01110000
        .db     %11111000
        .db     %11011000
        .db     %11111000
        .db     %01110000

img_sp_1c:
        .db     5,5
        .db     %01110000
        .db     %10001000
        .db     %10101000
        .db     %10001000
        .db     %01110000

img_sp_2:
        .db     2
        .dw     img_sp_2a
        .db     2
        .dw     img_sp_2b
        .db     2
        .dw     img_sp_2c
        .db     0
        .dw     img_sp_2

img_sp_2a:
        .db     5,5
        .db     %01110000
        .db     %11111000
        .db     %11111000
        .db     %11111000
        .db     %01110000

img_sp_2b:
        .db     5,5
        .db     %01110000
        .db     %11111000
        .db     %11011000
        .db     %11111000
        .db     %01110000

img_sp_2c:
        .db     5,5
        .db     %01110000
        .db     %10001000
        .db     %10101000
        .db     %10001000
        .db     %01110000

img_boun:
        .db     4,4
        .db     %00000000
        .db     %00000000
        .db     %00000000
        .db     %00000000

img_en_3:
        .db     4
        .dw     img_en_3a
        .db     4
        .dw     img_en_3b
        .db     0
        .dw     img_en_3

img_en_3a:
        .db     5,5
        .db     %00100000
        .db     %00100000
        .db     %11111000
        .db     %00100000
        .db     %00100000

img_en_3b:
        .db     5,5
        .db     %10001000
        .db     %01010000
        .db     %00100000
        .db     %01010000
        .db     %10001000

;############## Bosses

img_boss_2:
        .db     8,6
        .db     %11100111
        .db     %11111111
        .db     %10100101
        .db     %10100101
        .db     %11111111
        .db     %01000010

img_boss_1:
        .db     8,6
        .db     %10000001
        .db     %11111111
        .db     %10011001
        .db     %10111101
        .db     %11011011
        .db     %01111110

img_boss_3:
        .db     8,6
        .db     %11011011
        .db     %11111111
        .db     %11011011
        .db     %11011011
        .db     %11111111
        .db     %01000010

;############## Swooping enemy

img_swoo:
        .db     2
        .dw     swoop_1
        .db     2
        .dw     swoop_2
        .db     0
        .dw     img_swoo

swoop_1:
        .db     8,6
        .db     %11000011
        .db     %11011011
        .db     %11111111
        .db     %11111111
        .db     %11011011
        .db     %11000011

swoop_2:
        .db     8,6
        .db     %11000011
        .db     %11011011
        .db     %11111111
        .db     %11111111
        .db     %11011011
        .db     %11000011
