
#define	spritex		sram
#define	distance	sram+2
#define	tdistance	sram+3
#define	delays		sram+4
#define	counter		sram+5
#define	tempscore	sram+6

	.nolist
        #include "ion.inc"		
        .list

#ifdef TI83P			
        .org    progstart-2
        .db     $BB,6D
#else				
        .org    progstart
#endif				
        ret				

        jr      nc,begin 		
        .db     "Space Runner",0		
begin: 
        bcall(_clrlcdf)                
        ld      de,2*256+0             
        ld      (currow),de             
        ld      hl,titlestrng             
        bcall(_puts)                    
        ld      bc,0*256+55              
        ld      de,94*256+55            
        bcall(_darkline)                
        ld      de,10*256+1             
        ld      (pencol),de             
        ld      hl,authstrng            
        bcall(_vputs)                   
	ld	hl,playstrng
        ld      de,22*256+4             
        ld      (pencol),de             
        bcall(_vputs)                   
        ld	hl,exitstrng
        ld      de,29*256+4             
        ld      (pencol),de             
        bcall(_vputs)                   
	ld	hl,highstrng
        ld      de,55*256+1             
        ld      (pencol),de             
        bcall(_vputs)                   
        ld      hl,(highscore)          
        bcall(_setxxxxop2)              
        bcall(_op2toop1)                
        ld      a,4                     
        bcall(_dispop1a)
getky:
	bcall(_getcsc)
	cp	sk2nd
	jp	z,initialize
	cp	skdel
	jp	z,exit
	jp	getky
	   
initialize:
	bcall(_grbufclr)
	ld	hl,0
	ld	(tempscore),hl
	ld	a,44
	ld	(spritex),a
	ld	a,35
	ld	(tdistance),a
	ld	(distance),a
	ld	(delays),a	
	ld	a,200
	ld	(counter),a
	call	drawloop	
mainloop:
	ld	hl,(tempscore)
	inc	hl
	ld	(tempscore),hl
	call	delay
	bcall(_getcsc)
	cp	skdel
	jp	z,die
	ld	a,(counter)
	dec	a
	cp	0
	jp	z,rescounter
	ld	(counter),a
mainloop2:
	ld	a,(distance)
	or	a
	call	z,drawloop
	call	scrolldown
	call	drawsprite
	call	ionfastcopy
	call	drawsprite
	jp	crashtest
dinput:
        ld      a,$FF                   
        out     (1),a                   
        ld      a,$FE                   
        out     (1),a                   
        in      a,(1)                   
        bit     1,a                     
        jp      z,moveleft              
        bit     2,a                     
        jp      z,moveright             
	jp	mainloop

die:
        bcall(_clrlcdf)                
        ld      de,2*256+0             
        ld      (currow),de             
        ld      hl,titlestrng             
        bcall(_puts)                    
        ld      bc,0*256+55              
        ld      de,94*256+55            
        bcall(_darkline)                
        ld      de,10*256+1             
        ld      (pencol),de             
        ld      hl,authstrng            
        bcall(_vputs)                   
	ld	hl,youdiedstrng
        ld      de,22*256+4             
        ld      (pencol),de             
        bcall(_vputs)
	ld	hl,scorestrng 
        ld      de,29*256+4
	ld	(pencol),de
	bcall(_vputs)
        ld      hl,(tempscore)          
        bcall(_setxxxxop2)              
        bcall(_op2toop1)                
        ld      a,4                     
        bcall(_dispop1a)
	ld	hl,(tempscore)
	ld	de,(highscore)
	bcall(_cphlde)
	jp	c,finish
	ld	(highscore),hl           
        ld	hl,highscorestrng
        ld      de,36*256+4             
        ld      (pencol),de             
        bcall(_vputs)     	
finish:              
	ld	hl,highstrng
        ld      de,55*256+1             
        ld      (pencol),de             
        bcall(_vputs)                   
        ld      hl,(highscore)          
        bcall(_setxxxxop2)              
        bcall(_op2toop1)                
        ld      a,4                     
        bcall(_dispop1a)
getkyloop:
	bcall(_getcsc)
	cp	sk2nd
	jp	z,begin
	cp	skdel
	jp	z,exit
	jp	getkyloop
moveleft:
	ld	a,(spritex)
	cp	0
	jp	z,mainloop
	sub	2
	ld	(spritex),a
	jp	mainloop
moveright:
	ld	a,(spritex)
	cp	88
	jp	z,mainloop
	add	a,2
	ld	(spritex),a
	jp	mainloop
exit:
	ret

drawsprite:
	ld	ix,shipsprite
	ld	b,8
	ld	a,(spritex)
	ld	l,56
	call	ionputsprite
	ret
scrolldown:
	ld	hl,gbuf+756
	ld	de,gbuf+768
	ld	bc,769
	ld	a,(distance)
	dec	a
	ld	(distance),a
	lddr
	ret

drawloop:
	ld	a,(tdistance)
	ld	(distance),a
	ld	hl,gbuf
	ld	b,12
drawloop2:	
	push	bc
	push	hl
	ld	b,5
	call	ionrandom
	or	a
	jp	nz,drawempty
	ld	b,2
	call	ionrandom
	or	a
	jp	z,smallsprite
	ld	b,8
	ld	de,spritedata
drawblock:
	push	bc
	ld	a,(de)
	ld	(hl),a
	inc	de
	ld	bc,12
	add	hl,bc
	pop	bc
	djnz	drawblock
	pop	hl
	inc	hl
	pop	bc
	djnz	drawloop2
	ret
drawempty:
	pop	hl
	inc	hl
	pop	bc
	dec	b
	ld	a,b
	ret	z
	jp	drawloop2
smallsprite:
	ld	b,8
	ld	de,spritedata+8
	jp	drawblock
delay:
	ld	a,(delays)
	ld	b,a
delay2:
	djnz	delay2
	ret
rescounter:
	ld	a,200
	ld	(counter),a
	ld	a,(tdistance)
	dec	a
	ld	(tdistance),a
	jp	mainloop2
crashtest:
	ld	a,(spritex)	;h=spritex
	ld	b,a		;b=spritex
	ld	c,9
	ld	d,3		;d=ipoint choice (test)
	bcall(_ipoint)
	jp	nz,die
	ld	a,(spritex)	;h=spritex
	add	a,4
	ld	b,a		;b=spritex
	ld	c,9
	ld	d,3		;d=ipoint choice (test)
	bcall(_ipoint)
	jp	nz,die
	ld	a,(spritex)	;h=spritex
	add	a,6	
	ld	b,a	;b=spritex
	ld	c,9
	ld	d,3		;d=ipoint choice (test)
	bcall(_ipoint)
	jp	nz,die
	jp	dinput
	

spritedata:
 .db $3E	;big rock
 .db $41
 .db $89
 .db $91
 .db $A2
 .db $92
 .db $44
 .db $38

 .db $38	;small rock
 .db $7C
 .db $7C
 .db $78
 .db $30
 .db $00
 .db $00
 .db $00

shipsprite:
 .db $18
 .db $BD
 .db $BD
 .db $99
 .db $DB
 .db $FF
 .db $7E
 .db $24

Titlestrng:
	.db	"Space Runner",0
Authstrng:
	.db	"by JB -- United TI",0
playstrng:
	.db	"2nd - Play",0
exitstrng:
	.db	"Del - Exit",0
youdiedstrng:
	.db	"You Crashed!",0
highscorestrng:
	.db	"New High Score!",0
scorestrng:
	.db	"Score: ",0
highstrng:
	.db	"High: ",0
highscore:
	.dw	0





.end
END