;##################################################################
;
;   Phoenix-Z80 (New game initialization)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   Copyright 2004 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated July 6, 2004.
;
;##################################################################     

;############## Main title screen

title_screen:
        call    convert_settings
redraw_title:
        ld      hl,title_main

show_title:
        call    display_hl_msgs
        
title_loop:
        call    scroll_sides
        call    display_sides

        call    synchronize
        call    SUPER_GET_KEY
        sub     K_F5
        jr      z,redraw_title
        dec     a
        jr      z,show_instructions
        dec     a    
        jr      z,show_contact
        dec     a
        jr      z,options_screen
        dec     a
        jp      z,initialize_game
        cp      K_ALPHA-K_F1
        jr      z,show_highs
        cp      K_EXIT-K_F1
        jr      nz,title_loop
        jp      game_exit

show_highs:
        call    no_high_score
        jr      redraw_title

show_contact:
        ld      hl,title_contact
        jr      show_title

show_instructions:
        ld      hl,title_instructions
        jr      show_title

;############## Options screen

options_screen:                         ; initialize options screen
        xor     a
        ld      (option_item),a

option_redraw:                          ; redraw options screen
        call    convert_settings
        ld      hl,options_msg
        call    display_hl_msgs

option_draw:                            ; draw option arrow
        call    option_position
        ld      hl,draw_pointer
        call    D_ZT_STR

options_loop:                           ; option main loop
        call    scroll_sides
        call    display_sides
        call    synchronize
        call    SUPER_GET_KEY
        cp      K_F5
        jr      z,redraw_title
        cp      K_EXIT
        jr      z,redraw_title
        cp      K_UP
        jr      z,options_up
        cp      K_DOWN
        jr      z,options_down
        cp      K_ENTER
        jr      z,item_selected
        cp      K_SECOND
        jr      nz,options_loop

item_selected:
        ld      a,(option_item)         ; dispatch chosen optoin
        and     3
        add     a,a
        ld      (smc_optionjump+1),a

smc_optionjump:
        jr      option_jumptable
option_jumptable:
        jr      option_skill
        jr      option_color
        jr      option_speed
        jp      redraw_title

options_up:                             ; move arrow up
        call    option_erase
        ld      hl,option_item
        dec     (hl)
        jr      option_draw

options_down:                           ; move arrow down
        call    option_erase
        ld      hl,option_item
        inc     (hl)
        jr      option_draw

option_erase:                           ; erase arrow
        call    option_position
        ld      hl,erase_pointer
        jp      D_ZT_STR

option_position:                        ; calculate arrow position
        ld      a,(option_item)
        and     3
        add     a,2
        ld      l,a
        ld      h,2
        ld      (CURSOR_ROW),hl
        ret

erase_pointer:
        .db     "  ",0
draw_pointer:
        .db     " ",$D7,0

option_skill:                           ; change skill
        ld      hl,difficulty
option_common:
        ld      a,(hl)
        inc     a
        cp      3
        jr      c,difficulty_ok
        xor     a
difficulty_ok:
        ld      (hl),a
goto_option_redraw:
        jp      option_redraw
        
option_speed:                           ; change speed
        ld      hl,speed_option
        jr      option_common

option_color:                         ; change color
        ld      hl,invert
        ld      a,(hl)
        cpl
        ld      (hl),a

        ld      c,64
        ld      hl,sidesdata
revo:   ld      b,3
revi:   ld      a,(hl)
        cpl
        ld      (hl),a
        inc     hl
        djnz    revi
        ld      a,(hl)
        cpl
        and     $fc
        ld      (hl),a
        inc     hl
        dec     c
        jr      nz,revo

        jr      goto_option_redraw

;############## Prepare new game

initialize_game:
        ld      hl,data_zero_start
        ld      bc,data_zero_end-data_zero_start-1
        jp      OTH_CLEAR

;############## Load temporary variables from settings

convert_settings:
        ld      a,(speed_option)
        ld      b,a
        add     a,a
        add     a,a
        add     a,a
        add     a,b             ; A = speed * 8
        ld      hl,speed_data
        call    ADD_HL_A
        ld      de,speed_end-7
        ld      bc,6
        ldir
        ld      a,(hl)
        ld      (speed),a
        inc     hl
        call    DO_LD_HL_MHL
        ld      (bonus_score),hl

        ld      a,(difficulty)
        ld      b,a
        add     a,a
        add     a,a
        add     a,a
        add     a,b             ; A = difficulty * 8
        ld      hl,difficulty_data
        call    ADD_HL_A
        ld      de,level_end-7
        ld      bc,6
        ldir
        ld      a,(hl)
        ld      (money_amount),a
        inc     hl
        call    DO_LD_HL_MHL
        ld      de,(bonus_score)
        add     hl,de
        ld      (bonus_score),hl

        ld      a,(invert)
        inc     a               ; 0 = black, 1 = white
        ld      b,a            
        add     a,a
        add     a,a
        add     a,b             ; 0 = black, 5 = white
        ld      hl,terrain_data
        call    ADD_HL_A
        ld      de,terrain_end-6
        ld      bc,5
        ldir
        ret

terrain_data:
        .db     "BLACK"
        .db     "WHITE"
     
speed_data:
        .db     "SLOW  ",6      ; slow (delay 6, bonus 0)
        .dw     0
        .db     "MEDIUM",5      ; medium (delay 5, bonus 1000)
        .dw     1000
        .db     "FAST  ",4      ; fast (delay 4, bonus 5000)
        .dw     5000

difficulty_data:
        .db     "EASY  ",100    ; easy (cash 100, bonus 0)
        .dw     0
        .db     "MEDIUM",50     ; medium (cash 50, bonus 5000)
        .dw     5000
        .db     "HARD  ",25     ; hard (cash 25, bonus 15000)
        .dw     15000
#ifdef  ENABLE_CHEATS
        .db     "CHEAT ",100    ; hard (cash 25, bonus 15000)
        .dw     0
#endif

;############## Title screen messages

title_main:
        .db     " Rogue Squadron ",0
        .db     "       ::       ",0
        .db     " Phoenix Rising ",0
        .db     0
        .db     " 1 - Start Game ",0
        .db     " 2 - Settings   ",0
        .db     " 3 - About      ",0
        .db     " 4 - Instrctions",0
        .db     -1

title_instructions:
        .db     "Arrows Move Ship",0
        .db     "F1-5 Select Wepn",0
        .db     "2nd Fires Weapon",0
        .db     "MODE Saves&Exits",0
        .db     "ENTER Pauses",0
        .db     "+,- Contrast Adj",0
        .db     0
        .db     "5: Main Menu",0
        .db     -1

title_contact:
        .db     "Phoenix mod by: ",0
        .db     "Thomas Dickerson",0
        .db		"(elfprince13    ",0
        .db		"   @gmail.com)  ",0
        .db     "Original By:    ",0
        .db     "Patrick Davidson",0
        .db     0
        .db     "5: Main Menu",0
        .db     -1

options_msg:
        .db     "Use "
        .db		$06
        .db		"/"
        .db		$07
        .db		"/2nd  ",0
        .db     0         
        .db     "   Level ......",0
level_end:
        .db     "   Backgr .....",0
terrain_end:
        .db     "   Speed ......",0
speed_end:
        .db     "   Exit settings",0
        .db     -1
