;##################################################################
;
;   Phoenix for TI-83 Plus - MirageOS version
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   Copyright 2004 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated September 1, 2002.
;
;##################################################################     

#define __TI83__
#define __DCS6__
#define TI83P

#include "ti83plus.inc"
#include "dcs6.inc"
#include "keys.i"

backup_storage  =SavesScreen
#define TEXT_MEM SavesScreen+256
GFX_AREA        =plotsscreen   
GRAPH_MEM       =plotsscreen

D_ZT_STR        =_puts
D_HL_DECI       =_disphl
TX_CHARPUT      =_putc
CLEARLCD        =_ClrLCDFull
CURSOR_ROW      =currow
CURSOR_COL      =curcol
interrupt_entry =$9898
interrupt_byte  =$98
interrupt_table =$9900
interrupt_reg   =$99



#define ROM_CALL(kewl_routinez) bcall(kewl_routinez)

		.org    $9D93
		.db $BB,$6D
		xor d 
		.db $C9 

		jr start 
		.dw $0000
		.db $06,$00 
		.dw Icon 
   		.dw $0000 
   		.dw $0000
Icon: 
        .db     %11111111,%10110111
        .db     %11100111,%01101101
        .db     %11100111,%11111111
        .db     %11100111,%11111111
        .db     %11100111,%01111011
        .db     %11100111,%10111101
        .db     %11111111,%11111111
        .db     %11111111,%11101111
        .db     %01111110,%11011011
        .db		%11100111,%11111111
        .db		%11100111,%11111111
        .db		%11100111,%11111111
        .db		%01100110,%11111111
        .db     %01000010,%11111111
        .db		%00100100,%11111111
        .db		%11011011,%11111111
        

#include "phoenixz.i"


start:  di
        ld      de,backup_storage       ; Save data after GRAPH_MEM
        ld      hl,GFX_AREA+768
        ld      bc,256
        ldir
        call    main
        ld      (iy+13),6
restore_memory:
        ld      hl,backup_storage      ; Restore data after GRAPH_MEM
        ld      de,GFX_AREA+768
        ld      bc,256
        ldir
        ret

GET_KEY:
        bcall(_getcsc)
        ret

;############## Include remainder of game files

#include "main12.asm"
#include "extlev12.asm"
#include "exchange.asm"
#include "lib12.asm"
#include "lib.asm"
#include "title12.asm"
#include "disp12.asm"
#include "drwspr.asm"
#include "player12.asm"
#include "shoot.asm"
#include "bullets.asm"
#include "enemies.asm"
#include "init.asm"
#include "enemyhit.asm"
#include "collide.asm"
#include "ebullets.asm"
#include "hityou.asm"
#include "shop12.asm"
#include "helper.asm"
#include "eshoot.asm"
#include "score12.asm"
#include "emove.asm"
#include "images.asm"
#include "data.asm"
#include "levels.asm"
#include "vars.asm"

        .end
