;##################################################################
;
;   P H O E N I X         F O R        T I - 8 2    ( C r a s h )
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   Copyright 2004 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated May 11, 2004.
;
;##################################################################     

#define __TI82__

        #include    "crash82.inc"

GFX_AREA    =GRAPH_MEM

interrupt_entry =$8282
interrupt_byte  =$82
interrupt_table =$8300
interrupt_reg   =$83

backup_storage  =$8401

#include "phoenixz.i"
#include "keys.i"

        .db     "Rogue Squadron:Phoenix Rising",0

        ld      a,($8D0F)               ; Prevent running from MirageOS
        or      a
        ret     z
        ld      a,(INT_STATE)           ; Make sure no TSR installed
		or      a
       jp      z,main

interrupt_installed:
        ROM_CALL(CLEARLCD)
        ld      (CURSOR_ROW),de
        ld      hl,int_err
        ROM_CALL(TX_CHARPUT)
        jp      CR_KHAND

int_err:
        .db     "ERROR:  You must"
        .db     "remove installed"
        .db     "interrupts.",0

#include "main12.asm"

spaces: .db     "     ",0

;############## Include remainder of game files

#include "extlev12.asm"
#include "exchange.asm"
#include "lib12.asm"
#include "lib.asm"
#include "title12.asm"
#include "disp12.asm"
#include "drwspr.asm"
#include "player12.asm"
#include "shoot.asm"
#include "bullets.asm"
#include "enemies.asm"
#include "init.asm"
#include "enemyhit.asm"
#include "collide.asm"
#include "ebullets.asm"
#include "hityou.asm"
#include "shop12.asm"
#include "helper.asm"
#include "eshoot.asm"
#include "score12.asm"
#include "emove.asm"
#include "images.asm"
#include "data.asm"
#include "levels.asm"
#include "vars.asm"

program_end:
