;##################################################################
;
;   Phoenix-Z80 (Images)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   Copyright 2002 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;                              
;   This file was last updated August 16, 2002.
;
;##################################################################     

;############## Standard enemies

img_enemy_4:
        .db     8,9
        .db     %01000010
        .db     %11000011
        .db     %11100111
        .db     %11011011
        .db     %11011011
        .db     %11111111
        .db     %11011011
        .db     %11011011
        .db     %10000001

img_enemy_1:
        .db     8,8
        .db     %10000001
        .db     %10000001
        .db     %10011001
        .db     %11100111
        .db     %11100111
        .db     %10011001
        .db     %10000001
        .db     %10000001

img_enemy_2:
        .db     8,6
        .db     %01000010
        .db     %10011001
        .db     %11100111
        .db     %11100111
        .db     %10011001
        .db     %01000010

img_enemy_2a:
        .db     8,8
        .db     %00100100
        .db     %01000010
        .db     %10011001
        .db     %11100111
        .db     %11100111
        .db     %10011001
        .db     %01000010
        .db     %00100100
        
img_operator:
        .db     8,6
        .db     %00111100
        .db     %00011000
        .db     %00100100
        .db     %10100101
        .db     %01011010
        .db     %00100100

img_spin1:
        .db     2
        .dw     img_spin_1a
        .db     2
        .dw     img_spin_1b
        .db     2
        .dw     img_spin_1c
        .db     2
        .dw     img_spin_1d
        .db     0
        .dw     img_spin1

img_spin_1a:
        .db     8,6
        .db     %10000000
        .db     %01011001
        .db     %00100110
        .db     %01100100
        .db     %10011010
        .db     %00000001

img_spin_1b:
        .db     8,6
        .db     %00000001
        .db     %10011010
        .db     %01100100
        .db     %00100110
        .db     %01011001
        .db     %10000000

img_spin_1c:
        .db     8,6
        .db     %00000000
        .db     %00011000
        .db     %00100111
        .db     %11100100
        .db     %00011000
        .db		%00000000

img_spin_1d:
        .db     8,6
        .db     %10000001
        .db     %01011010
        .db     %00100100
        .db     %00100100
        .db     %01011010
        .db     %10000001

img_spin2:
        .db     2
        .dw     img_spin_2a
        .db     2
        .dw     img_spin_2b
        .db     2
        .dw     img_spin_2c
        .db     2
        .dw     img_spin_2d
        .db     0
        .dw     img_spin2

img_spin_2a:
        .db     8,5
        .db     %01110000
        .db     %00100000
        .db     %00111100
        .db     %11111111
        .db     %01110000

img_spin_2b:
        .db     8,5
        .db     %01110000
        .db     %00100000
        .db     %00111100
        .db     %11111111
        .db     %01110000

img_spin_2c:
        .db     8,5
        .db     %01110000
        .db     %00100000
        .db     %00111100
        .db     %11111111
        .db     %01110000

img_spin_2d:
        .db     8,5
        .db     %01110000
        .db     %00100000
        .db     %00111100
        .db     %11111111
        .db     %01110000

;############## Special enemies

img_bounce:
        .db     8,8
        .db     %00100100
        .db     %01000010
        .db     %10011001
        .db     %11100111
        .db     %11100111
        .db     %10011001
        .db     %01000010
        .db     %00100100

img_enemy_3:
        .db     4
        .dw     img_enemy_3a
        .db     4
        .dw     img_enemy_3b
        .db     4
        .dw     img_enemy_3c
        .db     4
        .dw     img_enemy_3d
        .db     0
        .dw     img_enemy_3

img_enemy_3a:
        .db     8,8
        .db     %00111100
        .db     %01000010
        .db     %10000001
        .db     %11111111
        .db     %11111111
        .db     %10000001
        .db     %01000010
        .db     %00111100
img_enemy_3b:
        .db     8,8
        .db     %00111100
        .db     %01000110
        .db     %10001111
        .db     %10011101
        .db     %10111001
        .db     %11110001
        .db     %01100010
        .db     %00111100
img_enemy_3c:
        .db     8,8
        .db     %00111100
        .db     %01011010
        .db     %10011001
        .db     %1011001
        .db     %10011001
        .db     %10011001
        .db     %01011010
        .db     %00111100
img_enemy_3d:
        .db     8,8
        .db     %00111100
        .db     %01100010
        .db     %11110001
        .db     %10111001
        .db     %10011101
        .db     %10001111
        .db     %01000110
        .db     %00111100

;############## Bosses

img_boss2:
        .db     16,15
		.db $10,$08,$07,$01,$03,$04,$09,$0A,$0A,$09,$DC,$3B,$10,$08,$08
		.db		8,15
		.db $10,$20,$C0,$80,$C0,$20,$90,$50,$50,$90,$3B,$DC,$08,$10,$10

img_boss:
        .db     15,10
        .db %00100000
        .db $40,$80,$9C,$E2,$E3,$9C,$80,$40
        .db %00100000
        .db     7,10
        .db %00001000
        .db $04,$02,$72,$FE,$FE,$72,$02,$04
        .db %00001000

;############## Swooping enemy

img_swoop:
        .db     2
        .dw     swoop_stage1
        .db     2
        .dw     swoop_stage2
        .db     0
        .dw     img_swoop

swoop_stage1:
        .db     12,18
        .db     %00001111
        .db     %00110000
        .db     %01000000
        .db     %01010001
        .db     %10001010
        .db     %10111111
        .db     %10001010
        .db     %10010001
        .db     %01000000
        .db     %01000000
        .db     %00101111
        .db     %00010000
        .db     %00100001
        .db     %00100111
        .db     %00100011
        .db     %00100010
        .db     %00010000
        .db     %00001111

        .db     4,18
        .db     %00000000
        .db     %11000000
        .db     %00100000
        .db     %00100000
        .db     %00010000
        .db     %10010000
        .db     %00010000
        .db     %00010000
        .db     %10100000
        .db     %00100000
        .db     %01000000
        .db     %10000000
        .db     %01000000
        .db     %01000000
        .db     %01000000
        .db     %01000000
        .db     %10000000


swoop_stage2:
        .db     12,18
        .db     %00001111
        .db     %00110000
        .db     %01000000
        .db     %01010001
        .db     %10001010
        .db     %10111111
        .db     %10001010
        .db     %10010001
        .db     %01000000
        .db     %01001110
        .db     %00110001
        .db     %00100000
        .db     %01001001
        .db     %01000110
        .db     %00101001
        .db     %00010000
        .db     %00001000
        .db     %00000111

        .db     4,18
        .db     %00000000
        .db     %11000000
        .db     %00100000
        .db     %00100000
        .db     %00010000
        .db     %10010000
        .db     %00010000
        .db     %00010000
        .db     %00100000
        .db     %10100000
        .db     %01000000
        .db     %00100000
        .db     %00010000
        .db     %00010000
        .db     %00100000
        .db     %01000000
        .db     %00000000

;############## Players

img_player_ship_normal:
        .db     8,7
        .db		%00011000
        .db		%00011000
        .db		%00011000
        .db		%10011001
        .db     %10111101
        .db		%11011011
        .db		%00100100

img_player_ship_damaged:
        .db     8,7
		.db     %00001000
		.db		%00010000
        .db		%00010000
        .db		%00000001
        .db     %00111001
        .db		%11011010
        .db		%00100100

img_companion:
        .db     6,13     
        .DB     %00011000       
        .DB     %00011000       
        .DB     %00111100       
        .DB     %00111100       
        .DB     %00100100       
        .DB     %00111100     
        .DB     %00011000       
        .DB     %10011001       
        .DB     %11111111       
        .DB     %11000011       
        .DB     %11000011       
        .DB     %11000011       
        .DB     %10000001

;############## Player bullets

img_player_bullet_0:
        .db     2,6
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000

img_player_bullet_1:
        .db     4,8
        .db     %01100000
        .db     %11110000
        .db     %10100000
        .db     %01010000
        .db     %10100000
        .db     %01010000
        .db     %10100000
        .db     %01010000

img_player_bullet_2l:
        .db     3,7
        .db     %00100000
        .db     %01100000
        .db     %11100000
        .db     %11100000
        .db     %11100000
        .db     %11000000
        .db     %10000000

img_player_bullet_2r:
        .db     3,7
        .db     %10000000
        .db     %11000000
        .db     %11100000
        .db     %11100000
        .db     %11100000
        .db     %01100000
        .db     %00100000

img_player_bullet_3:
        .db     4,4
        .db     %01100000
        .db     %11110000
        .db     %11110000
        .db     %01100000

img_player_bullet_5:
        .db     5,7
        .db     %00100000
        .db     %01110000
        .db     %11111000
        .db     %11111000
        .db     %11111000
        .db     %11011000
        .db     %10001000

img_quad_bullet:
        .db     3,5     
        .db     %01000000       
        .db     %11100000       
        .db     %11100000       
        .db     %11100000       
        .DB     %11100000

;############## Dropped items

img_eb_1:
        .db     2,2
        .db     %11000000
        .db     %11000000

img_eb_3:
        .db     3,3
        .db     %01000000
        .db     %11100000
        .db     %01000000

img_eb_2:
        .db     3,7
        .db     %10100000
        .db     %11100000
        .db     %11100000
        .db     %01000000
        .db     %01000000
        .db     %11100000
        .db     %01000000

img_money:
        .db     8,7
        .db     %01111100
        .db     %10010010
        .db     %11111000
        .db     %11111000
        .db     %10010010
        .db     %01010100
        .db     %00111000

img_eb_4:
        .db     5,5
        .db     %01110000
        .db     %11111000
        .db     %11111000
        .db     %11111000
        .db     %01110000

;############## Explosion

explosion_sequence:
        .db     2
        .dw     x1
        .db     2
        .dw     x2
        .db     2
        .dw     x3
        .db     2
        .dw     x4
        .db     2
        .dw     x5
        .db     2
        .dw     x6
        .db     2
        .dw     x7
        .db     2
        .dw     x8
        .db     -1                      ; kill enemy

x1:     .db     8,6
        .db     %00000000       
        .db     %00011100       
        .DB     %00111110       
        .DB     %01010110       
        .DB     %00111000       
        .DB     %00000000

x2:     .db     8,6     
        .db     %00110000       
        .db     %01001110       
        .DB     %10111110       
        .DB     %01001111       
        .DB     %00111000       
        .DB     %00011010

x3:     .db     8,6     
        .db     %11110011       
        .db     %01001110       
        .DB     %10110101       
        .DB     %01000101       
        .DB     %00111110       
        .DB     %11011010

x4:     .db     8,6     
        .db     %11110011       
        .db     %01001110       
        .DB     %10110101       
        .DB     %01000101       
        .DB     %00111110       
        .DB     %11011010

x5:     .db     8,6     
        .db     %01000001       
        .db     %00100110       
        .DB     %00010101       
        .DB     %01000100       
        .DB     %00010010       
        .DB     %10011010

x6:     .db     8,6     
        .db     %01000010       
        .db     %00100000       
        .DB     %00000001       
        .DB     %01000100       
        .DB     %00100010
        .DB     %10001010

x7:     .db     8,6     
        .db     %00001000       
        .db     %11000010       
        .DB     %00000000       
        .db     %00100000       
        .db     %00000001       
        .db     %00110000

x8:     .db     8,6     
        .db     %00000100       
        .DB     %00000000       
        .DB     %01000000       
        .DB     %00000000       
        .db     %00000001       
        .db     %00100100

        .db     -1
