/*	Convert the file TILES.IDX to a file of data and constants */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

void TileGraphic(char *);
void DumpName(char **,int);
void DumpGraphic(int);
void CreateDictionary(char *);

#define NMSIZE	(12)

unsigned char Tiles[2048];
int Count = 0;
int TCount = 0;

void main()
{
	char Line[128];
	FILE *f;
	f = fopen("TILES.BIN","rb");
	fread(Tiles,1,sizeof(Tiles),f);
	fclose(f);
	printf("TileGraphics:\n");
	f = fopen("TILES.IDX","r");
	while (fgets(Line,sizeof(Line),f) != NULL)
	{
		Line[strlen(Line)-1] = '\0';
		if (isdigit(*Line)) TileGraphic(Line);
		if (isalpha(*Line)) CreateDictionary(Line);
	}
	fclose(f);
	printf("PokeCount   .equ %d\n",Count);
	printf("DictGrOffset .equ %d\n",NMSIZE+10);
	printf("DictRecSize .equ %d\n\n",NMSIZE+10+4*8);

	printf("PD_HPBase   .equ %d\n",NMSIZE+1);
	printf("\n");
}

void TileGraphic(char *p)
{
	int Const = atoi(p);
	int Solid = 0;
	strlwr(p);
	while (isdigit(*p) || isspace(*p)) p++;
	if (*p == '*') p++,Solid=0x80;
	printf("tile_");
	DumpName(&p,16);
	printf(".equ 0%02xh\n",TCount+Solid);
	DumpGraphic(Const & 0x7F);
	printf("\n");
	TCount++;
}

void DumpName(char **pp,int w)
{
	while (isalnum(**pp) && w-- > 0) printf("%c",*(*pp)++);
	while (w-- > 0) printf(" ");
}

void DumpGraphic(int n)
{
	int i;
	n = n * 8;
	printf("        .db ");
	for (i = 0;i < 8;i++)
		printf("0%02xh%c",Tiles[n+i],(i == 7) ? ' ':',');
	printf("\n");
}

void CreateDictionary(char *s)
{
	int i;
	if (Count == 0)
		printf("PokeDictionary:\n");
	printf("        .db \"");
	strupr(s);
	DumpName(&s,NMSIZE);
	printf("\"");
	for (i = 0;i < 10;i++)
	{
		while (!isdigit(*s)) s++;
		printf(",%-2d",atoi(s));
		while (isdigit(*s)) s++;
	}
	printf("\n");
	i = (Count % 8) * 2 + (Count/8)*32 + 64;
	DumpGraphic(i);
	DumpGraphic(i+1);
	DumpGraphic(i+16);
	DumpGraphic(i+17);
	printf("\n");
	Count++;
}
