/*

							Simple Tile Editor

 */

#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>
#include <dos.h>

unsigned char Graphics[192*8];				/* Tile Buffer */

void Refresh(int n,int Selected)
{
	int x,x1,y,c,i;
	char Temp[32];
	x = (n % 16) * 24+256;
	y = (n / 16) * 24;
	setfillstyle(SOLID_FILL,Selected ? RED:(n >= 64) ? BROWN:BLUE);
	bar(x,y,x+23,y+23);
	setfillstyle(SOLID_FILL,Selected ? YELLOW:CYAN);
	for (i = 0;i < 8;i++)
	{
		c = Graphics[n*8+i];x1 = x;
		while (c != 0)
		{
			if (c & 0x80) bar(x1,y+i*3,x1+2,y+3*i+2);
			x1 += 3;c = (c << 1) & 0xFF;
		}
	}
	if (Selected != 0)
	{
		setfillstyle(SOLID_FILL,RED);
		bar(12,196,150,214);
		setcolor(WHITE);
		sprintf(Temp,"Graphic %3d $%02x",n,n);
		outtextxy(20,200,Temp);
	}
}


void DrawCursor(int x,int y)
{
	char Demo[256];
	int n = imagesize(0,0,8,8);
	getimage(0,300,7,307,Demo);
	putimage(x-3,y-3,Demo,XOR_PUT);
}

void GetMouse(int *x,int *y)
{
	union REGS r;
	DrawCursor(*x,*y);
	do
	{
		r.x.ax = 0x03;
		int86(0x33,&r,&r);
	} while(r.x.bx != 0);
	do
	{
		r.x.ax = 0x03;
		int86(0x33,&r,&r);
		DrawCursor(*x,*y);DrawCursor(r.x.cx,r.x.dx);
		*x = r.x.cx;*y = r.x.dx;
		delay(80);
	}
	while (r.x.bx == 0);
	DrawCursor(*x,*y);
}

void RefreshPanel(int n)
{
	int c,x,x1,y1,y;
	for (x = 0;x < 8;x++)
		for (y = 0;y < 8;y++)
		{
			c = Graphics[n*8+y] & (128 >> x);
			setfillstyle(SOLID_FILL,(c != 0) ? WHITE:DARKGRAY);
			x1 = x * 24;y1 = y * 24;
			bar(x1,y1,x1+23,y1+23);
		}

}
void main(int argc,char *argv[])
{
	int i,x,y,gMode = VGAMED,gDriver = VGA;
	int Selected = 0;
	FILE *f;
	char *s = "Paul Robson's Quick and Dirty Tile Editor";
	if (argc != 2)
		exit(fprintf(stderr,"TE <FileName>\n"));
	for (i = 0;i < 256*8;i++) Graphics[i] = (i % 8 == 4) ? 8:0;
	f = fopen(argv[1],"rb");
	if (f != NULL)
	{
		fread(Graphics,1,sizeof(Graphics),f);
		fclose(f);
	}
	initgraph(&gDriver,&gMode,".");
	for (i = 0;i < 192;i++) Refresh(i,(i == Selected));
	RefreshPanel(Selected);
	setfillstyle(SOLID_FILL,MAGENTA);
	bar(0,310,639,379);setcolor(WHITE);
	outtextxy(320-textwidth(s)/2,325,s);
	setfillstyle(SOLID_FILL,WHITE);
	bar(0,300,8,308);
	do
	{
		GetMouse(&x,&y);
		if (x < 24*8 && y < 24*8)
		{
			Graphics[Selected*8+(y/24)] ^= (0x80 >> (x/24));
			RefreshPanel(Selected);
			Refresh(Selected,1);
		}
		if (x >= 256 && y < 24*12)
		{
			Refresh(Selected,0);
			Selected = (y/24)*16+(x-256)/24;
			Refresh(Selected,1);
			RefreshPanel(Selected);
		}
	}
	while (y < 310);
	closegraph();
	f = fopen(argv[1],"wb");
	fwrite(Graphics,1,sizeof(Graphics),f);
	fclose(f);
}


