/************************************************************************/
/*																		*/
/*						    The Pokemon project							*/
/*																		*/
/************************************************************************/

#include <stdio.h>
#include <graphics.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>

#define  XSIZE	(64)						/* Map Size */
#define  YSIZE	(56)

unsigned char MapData[XSIZE*YSIZE+XSIZE];	/* This is the map */
#define	 MAP(x,y) MapData[(x)+(y)*XSIZE]

#define	TYPE_MASK	(0x1F)					/* Bits 0-15 are the type */
#define NORTH_BIT	(0x80)					/* Bit set for north move */
#define EAST_BIT	(0x40)					/* Bit set for east move */
#define CHEST_BIT	(0x20)					/* Bit set for chest now */

#define TYPES       (14)					/* There are 14 area types */

char *Names[14] = { "Road_NSEW","Dungeon","Desert","Forest",
					"Swamp","Town","Open","Road_NS","Road_EW",
					"DungeonDn","DesertDn","ForestDn","SwampDn","DungeonUp" };

#define RT_ROADNSEW	(0x00)					/* Road type */
#define RT_DUNGEON	(0x01)					/* Dungeon Type */
#define RT_DESERT	(0x02)					/* Desert type */
#define RT_FOREST	(0x03)					/* Forest type */
#define RT_SWAMP	(0x04)					/* Swamp type */
#define RT_TOWN		(0x05)					/* Town type */
#define	RT_OPEN		(0x06)					/* Open Room Type */
#define RT_ROADNS	(0x07)					/* Roads */
#define RT_ROADEW	(0x08)
#define RT_DUNGEONDN (0x09)					/* Stairs down (in dungeon) */
#define RT_DESERTDN	(0x0A)					/* Stairs down (elsewhere) */
#define RT_FORESTDN	(0x0B)					/* Note correlation with others */
#define RT_SWAMPDN	(0x0C)
#define RT_DUNGEONUP (0x0D)					/* Stairs up (in dungeon) */

/************************************************************************/
/*																		*/
/*          					Draw a Cell								*/
/*																		*/
/************************************************************************/

void DrawCell(int x,int y,int Scale,unsigned int Desc,int Select)
{
	int c = BLACK;
	int Type = Desc & TYPE_MASK;
	setfillstyle(SOLID_FILL,c);				/* Erase background */
	bar(x,y,x+Scale-1,y+Scale);
	switch(Type)							/* Cells colour */
	{
		case RT_DUNGEON:
		case RT_DUNGEONUP:
		case RT_DUNGEONDN:
						c = LIGHTGRAY;break;
		case RT_TOWN:	c = CYAN;break;
		case RT_DESERT:
		case RT_DESERTDN:
						c = YELLOW;break;
		case RT_FOREST:
		case RT_FORESTDN:
						c = GREEN;break;
		case RT_SWAMP:
		case RT_SWAMPDN:
						c = RED;break;
		default:		c = BLACK;break;
	}
	setfillstyle(SOLID_FILL,c);
	bar(x+2,y+3,x+Scale-3,y+Scale-2);
	setfillstyle(SOLID_FILL,CYAN);			/* Chest ? */
	if (Desc & CHEST_BIT)
		bar(x+Scale/2,y,x+Scale,y+Scale/2);

	setfillstyle(SOLID_FILL,LIGHTBLUE);		/* Road ? */
	if (Type == RT_ROADNS || Type == RT_ROADNSEW)
						bar(x+Scale/3,y,x+Scale*2/3,y+Scale);
	if (Type == RT_ROADEW || Type == RT_ROADNSEW)
						bar(x,y+Scale/3,x+Scale,y+Scale*2/3);

	setcolor(WHITE);
	if (Type == RT_DUNGEONUP)				/* Stairs */
				line(x,y+Scale,x+Scale,y);
	if (Type >= RT_DUNGEONDN && Type <= RT_SWAMPDN)
				line(x,y,x+Scale,y+Scale);
	setcolor(Select != 0 ? WHITE:GREEN);	/* Frame */
	line(x,y,x+Scale,y);
	line(x+Scale,y,x+Scale,y+Scale);
	setcolor(BLACK);						/* Doors */
	if (Desc & NORTH_BIT) line(x+Scale/4,y,x+Scale*3/4,y);
	if (Desc & EAST_BIT) line(x+Scale,y+Scale*3/4,x+Scale,y+Scale/4);
}

/************************************************************************/
/*																		*/
/*								Main program							*/
/*																		*/
/************************************************************************/

void main()
{
	FILE *f;
	int i,xs = 0,ys = 0,x,y,s,d;
	char Temp[32],*p;
	int Driver = VGA,Mode = VGAHI;
	initgraph(&Driver,&Mode,"."); 			/* Graphics mode */
	setfillstyle(SOLID_FILL,BLUE);			/* Erase screen */
	bar(0,0,640,480);
	memset(MapData,0,sizeof(MapData));		/* Blank Map Data */
	for (x = 0;x < XSIZE;x++)				/* Blank map */
		for (y = 0;y < YSIZE;y++)
			MAP(x,y) = RT_OPEN+0xC0;
	f = fopen("MAPDATA.BIN","rb");			/* Read map (if exists) */
	if (f != NULL)
	{
		fread(MapData,1,sizeof(MapData),f);
		fclose(f);
	}
	s = 8;
	for (x = 0;x < XSIZE;x++)				/* Draw it */
		for (y = 0;y < YSIZE;y++)
			DrawCell(x*s,y*s,s-1,MAP(x,y),0);
	for (x = 0;x < TYPES;x++)				/* Display legend */
	{
		d = (getmaxy()-32)/TYPES;y = x * d+d/2+32;
		sprintf(Temp,"%c:%s",x+65,Names[x]);
		setcolor(WHITE);outtextxy(640-8*11-4,y-4,Temp);
		DrawCell(520,y-8,16,x,0);
	}
	p = "1] North 2] East 3] Chest";		/* Instructions for toggles */
	setcolor(WHITE);outtextxy(32,getmaxy()-16,p);

	do
	{
		DrawCell(530,0,30,MAP(xs,ys),1);	/* Highlight it */
		DrawCell(xs*s,ys*s,s-1,MAP(xs,ys),1);
		setcolor(GREEN);
		line(0,0,0,YSIZE*s-1);				/* Complete edges don't have */
		line(0,YSIZE*s-1,XSIZE*s-1,YSIZE*s-1);
		setfillstyle(SOLID_FILL,BLUE);		/* Display position */
		bar(570,0,640,30);sprintf(Temp,"(%d,%d)",xs,ys);
		setcolor(WHITE);outtextxy(605-28,11,Temp);
		d = getch();						/* Get key,handle control */
		if (d == 0) d = -getch();
		DrawCell(xs*s,ys*s,					/* Remove highlight */
					s-1,MAP(xs,ys),0);
		if (d == -75 || d == -77)			/* Cursor moves */
					xs = (xs+XSIZE+((d==-75)?-1:1)) % XSIZE;
		if (d == -72 || d == -80)
					ys = (ys+YSIZE+((d==-72)?-1:1)) % YSIZE;
		if (d > 0)							/* Not control */
		{
			if (isalpha(d))					/* Area type key */
				MAP(xs,ys) = (MAP(xs,ys) & 0xE0) | (toupper(d)-'A');
			if (strchr("123",d) != NULL)	/* Toggle key */
				MAP(xs,ys) ^= (0x80 >> (d-'1'));
		}
	} while (d != 27);						/* Exit on ESCAPE */
	f = fopen("MAPDATA.BIN","wb");			/* Write map out */
	fwrite(MapData,1,sizeof(MapData),f);
	fclose(f);
	closegraph();
	f = fopen("Types.Inc","w");
	fprintf(f,"type_count .equ %d\n",TYPES);
	for (i = 0;i < TYPES;i++)
		fprintf(f,"type_%-12s .equ %d\n",Names[i],i);
	fclose(f);
}
