#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

unsigned char Tiles[4096];
int TileCount = 0;

void TileDump(int n)
{
	int i;
	printf("        .db ");
	for (i = 0;i < 8;i++)
		printf("$%02x%s",Tiles[i+n],(i == 7) ? "\n":",");
	TileCount++;
}

void main()
{
int n,i;
char *p,s[128];
FILE *f = fopen("Tiles.Bin","rb");
fread(Tiles,1,4096,f);
fclose(f);
printf("TileTable:\n");
f = fopen("Tiles.Idx","r");
while (fgets(s,128,f) != NULL)
{
	if (isdigit(*s))
	{
		n = atoi(s)*8;
		p = s;while (isdigit(*p)) p++;
		if (*p++ == '.')
		{
			printf("tile_");
			while (isalnum(*p) || *p == '_')
			{
				printf("%c",tolower(*p));
				p++;
			}
			printf(" .equ %d\n",(n/8) > 63 ? TileCount:TileCount);
			if (n/8 == 64)
				printf("tile16x16Base .equ %d\n",TileCount);
		}
		TileDump(n);
		if (n/8 > 63)
		{
			TileDump(n+1*8);
			TileDump(n+16*8);
			TileDump(n+17*8);
		}
	}
}
fclose(f);
}