/*

							Scale the graphics

*/

#include <stdio.h>
#include <graphics.h>

void RefreshGraphic(int n);
void ScaleGraphic(int n);
void Scale(int Src,int Tgt,int Scale);
void GetMask(int ch,int x,int y,int *Mask,int *Addr);

unsigned char Data[192*8];

void main()
{
	int n,x,y;
	FILE *f;
	x = VGA;y = VGALO;initgraph(&x,&y,".");
	setfillstyle(SOLID_FILL,BLUE);bar(0,0,640,350);
	f = fopen("TILES.ORG","rb");
	fread(Data,1,sizeof(Data),f);
	fclose(f);
	for (n = 0;n < 8;n++)
		ScaleGraphic((n&1)*8+(n/2)*32+64);
	for (n = 0;n < 192;n++) RefreshGraphic(n);
	fgetc(stdin);
	f = fopen("TILES.BIN","wb");
	fwrite(Data,1,sizeof(Data),f);
	fclose(f);
	closegraph();
}

void RefreshGraphic(int n)
{
	int x,y,x1,y1;
	x1 = (n % 16) * 8*2+16;y1 = (n/16)*8*2+4;
	for (x = 0;x < 8;x++)
		for (y = 0;y < 8;y++)
		{
			putpixel(x*2+0+x1,y*2+0+y1,(Data[n*8+y] & (128 >> x)) ? WHITE:BLACK);
			putpixel(x*2+1+x1,y*2+0+y1,(Data[n*8+y] & (128 >> x)) ? WHITE:BLACK);
			putpixel(x*2+0+x1,y*2+1+y1,(Data[n*8+y] & (128 >> x)) ? WHITE:BLACK);
			putpixel(x*2+1+x1,y*2+1+y1,(Data[n*8+y] & (128 >> x)) ? WHITE:BLACK);
		}
}

void ScaleGraphic(int n)
{
	Scale(n,n+2,18);
	Scale(n,n+4,13);
	Scale(n,n+6,9);
}

void Scale(int Src,int Tgt,int Scale)
{
	int x,y,x1,y1,Mask,Addr;
	for (x = 0;x <= 7;x++)
		for (y = -7;y <= 7;y++)
		{
			GetMask(Src,x,y,&Mask,&Addr);
			if (Data[Addr] & Mask)
			{
				x1 = (x * Scale+10) / 20;
				y1 = (y * Scale+10) / 20;
				GetMask(Tgt,x1,y1,&Mask,&Addr);
				Data[Addr] |= Mask;
				if (x >= 0)
				{
					GetMask(Tgt,-x1-1,y1,&Mask,&Addr);
					Data[Addr] |= Mask;
				}
			}
		}
}

void GetMask(int ch,int x,int y,int *Mask,int *Addr)
{
	x = x + 8;y = y + 8;
	*Addr = (ch * 8) + (x / 8)*8 + (y % 8);
	if (y >= 8) *Addr = (*Addr) + 16 * 8;
	*Mask = (128 >> (x & 7));
}