/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		PORTIO.C												*/
/*	Project :	Elite type game in 'C'/Z80 Assembly						*/
/*	Author :	Paul Robson												*/
/*	Created :	22nd April 2001											*/
/*	Function :	Hardware I/O. All porting involves changing this		*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "anarchy.h"
#include <time.h>
#include <conio.h>
#include <graphics.h>

static	clock_t StartTime;					/* Start time of running */
static  int IsTI;							/* In TI83 mode ? */

#define MAPTI()	if (IsTI) Colour = ((Colour != 0) ? 0 : 7)

static char Graphics[] = {					/* Graphics */
	0x7F,0x41,0x41,0x41,0x41,0x41,0x7F,0x00,/* 0 */
	0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,/* 1 */
	0x7F,0x01,0x01,0x7F,0x40,0x40,0x7F,0x00,/* 2 */
	0x7F,0x01,0x01,0x7F,0x01,0x01,0x7F,0x00,/* 3 */
	0x41,0x41,0x41,0x7F,0x01,0x01,0x01,0x00,/* 4 */
	0x7F,0x40,0x40,0x7F,0x01,0x01,0x7F,0x00,/* 5 */
	0x7F,0x40,0x40,0x7F,0x41,0x41,0x7F,0x00,/* 6 */
	0x7F,0x01,0x01,0x01,0x01,0x01,0x01,0x00,/* 7 */
	0x7F,0x41,0x41,0x7F,0x41,0x41,0x7F,0x00,/* 8 */
	0x7F,0x41,0x41,0x7F,0x01,0x01,0x7F,0x00,/* 9 */
	0x00,0x3E,0x00,0x3E,0x00,0x3E,0x00,0x00,/* 10 - */
	0x7F,0x41,0x40,0x7F,0x01,0x41,0x7F,0x00,/* 11 Shields */
	0x60,0x40,0x40,0x40,0x40,0x41,0x7F,0x00,/* 12 Lasers */
	0x7F,0x41,0x40,0x7F,0x40,0x41,0x7F,0x00,/* 13 Energy */
	0x7F,0x49,0x49,0x49,0x49,0x49,0x6B,0x00,/* 14 Missiles */
	0x77,0x75,0x25,0x25,0x25,0x25,0x77,0x00,/* 15 Item 0 */
	0x72,0x72,0x22,0x22,0x22,0x22,0x72,0x00,/* 16 Item 1 */
	0x77,0x71,0x21,0x27,0x24,0x24,0x77,0x00,/* 17 Item 2 */
	0x77,0x71,0x21,0x27,0x21,0x21,0x77,0x00,/* 18 Item 3 */
	0x75,0x75,0x25,0x27,0x21,0x21,0x71,0x00,/* 19 Item 4 */
	0x77,0x74,0x24,0x27,0x21,0x21,0x77,0x00,/* 20 Item 5 */
	0x77,0x74,0x24,0x27,0x25,0x25,0x77,0x00,/* 21 Item 6 */
	0x77,0x71,0x21,0x21,0x21,0x21,0x71,0x00,/* 22 Item 7 */
	0x40,0x70,0x7C,0x7F,0x7C,0x70,0x40,0x00,/* 23 Arrow */
	0 };

/************************************************************************/
/*																		*/
/*							Initialise everything						*/
/*																		*/
/************************************************************************/

void IOInitialise(int TI83Mode)
{
	int i;
	FILE *f;
	int GraphDriver = VGA; 					/* Initialise the BGI Driver */
	int GraphMode = VGALO;					/* VGA, 640x200 mode */
	initgraph(&GraphDriver,&GraphMode,"");	/* Start it up */
	StartTime = clock();					/* Initialise the clock */
	IOFlip();								/* Set up visual/active */
	IsTI = TI83Mode;
	f = fopen("TILES.BIN","w");
	fwrite(Graphics,1,sizeof(Graphics),f);
	fclose(f);
}

/************************************************************************/
/*																		*/
/*							Terminate everything						*/
/*																		*/
/************************************************************************/

void IOTerminate(void)
{
	closegraph();							/* Return to DOS Text Mode */
}

/************************************************************************/
/*																		*/
/*						Map Logical to Physical							*/
/*																		*/
/************************************************************************/

static void _IOMap(int *x,int *y)
{
	if (IsTI)
	{
		*x = (*x)*2+224;*y += 68;
	}
	else
	{
		*x = (*x)*6+32;*y = (*y)*3+4;
	}
}

/************************************************************************/
/*																		*/
/*				Line and Dot Primitive (Logical Coordinates)			*/
/*																		*/
/************************************************************************/

void IOLine(int x1,int y1,int x2,int y2,int Colour)
{
	MAPTI();
	setcolor(Colour == 0 ?					/* Fix is for black */
					Colour : Colour+8);
	_IOMap(&x1,&y1);_IOMap(&x2,&y2);
	line(x1,y1,x2,y2);
}

void IOPlot(int x,int y,int Colour)
{
	MAPTI();
	_IOMap(&x,&y);
	putpixel(x,y,(Colour == 0) ?			/* Fix is for black */
						Colour : Colour+8);
}

/************************************************************************/
/*																		*/
/*								Draw character							*/
/*																		*/
/************************************************************************/

void IOChar(int x,int y,int Char,int Colour)
{
	int yOrg,c,xc,yc,x1,y1;
	char s[2];
	MAPTI();
	s[0] = Char & 0x1F;s[1] = '\0';
	yOrg = y;x1 = x + 8;y1 = y+8;
	setcolor(Colour == 0 ?					/* Fix is for black */
					Colour : Colour+8);
	setfillstyle(SOLID_FILL,IsTI ? 8 :BLACK);
	_IOMap(&x1,&y1);_IOMap(&x,&y);x1--;
	bar(x,y,x1,y1);
	setfillstyle(SOLID_FILL,Colour == 0 ?	/* Fix is for black */
								Colour : Colour+8);
	for (yc = 0;yc < 8;yc++)
	{
		c = Graphics[Char*8+yc] & 0xFF;xc=x;
		while (c != 0)
		{
			if (c & 0x80)
			{
				if (IsTI)
					putpixel(xc,y+yc,Colour);
				else bar(xc,y+yc*(y1-y)/8,xc+(x1-x)/8,y+(yc+1)*(y1-y)/8);
			}
			xc = xc + (x1-x)/8;c = (c << 1) & 0xFF;
		}
	}
}

/************************************************************************/
/*																		*/
/*								Page Flipping							*/
/*																		*/
/************************************************************************/

void IOFlip(void)
{
	static int Screen = 0;
	setactivepage(Screen);              	/* Select active page */
	Screen = 1-Screen;						/* Alternate page */
	setvisualpage(Screen);					/* is now the drawing page */
}

/************************************************************************/
/*																		*/
/*							Clear the display							*/
/*																		*/
/************************************************************************/

void IOClear(int Reverse)
{
	setfillstyle(SOLID_FILL,Reverse ? 4:0);	/* Red if reversed */
	bar(0,0,getmaxx(),getmaxy());			/* And clear the screen */
	if (IsTI)
	{
		setfillstyle(SOLID_FILL,8);
		bar(223,67,224+96*2,68+64);
	}
}

/************************************************************************/
/*																		*/
/*  					Read the Millisecond Timer						*/
/*																		*/
/*			It does not need to be this accurate, 10-20Hz will do !		*/
/*																		*/
/************************************************************************/

long IOTimer(void)
{
	return (long)(clock()-StartTime)*55;	/* Accurate to 1/18 second */
}

/************************************************************************/
/*																		*/
/*								Read Joystick							*/
/*																		*/
/************************************************************************/

int IOJoystick(void)
{
	int k;
	static long KeyLastTime = 0;			/* An awful fudge based around */
	static int KeyCurrent = 0;				/* keyboard auto repeat, but it */
	if (IOTimer() > KeyLastTime)			/* will work for now */
						KeyCurrent = 0;
	if (kbhit())
	{
		KeyCurrent = getch();
		KeyCurrent = toupper(KeyCurrent);
		if (KeyCurrent == 0)
				KeyCurrent = -getch();
		KeyLastTime = IOTimer()+500;
	}

	switch(KeyCurrent)						/* Convert to a stick uuugghh */
	{
		case -75:	k = JOY_LEFT;break;
		case -77:	k = JOY_RIGHT;break;
		case -72:	k = JOY_UP;break;
		case -80:	k = JOY_DOWN;break;
		case 'A':	k = JOY_A;break;
		case 'S':	k = JOY_B;break;
		case 'D':	k = JOY_C;break;
		case 27:	k = JOY_EXIT;break;
		default :	k = 0;break;
	}
	return k;
}

