/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		ANARCHY.H												*/
/*	Project :	Elite type game in 'C'/Z80 Assembly						*/
/*	Author :	Paul Robson												*/
/*	Created :	22nd April 2001											*/
/*	Function :	Global Include File										*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include <stdio.h> 							/* Lotsa prototyping */
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <math.h>

#define	 FRAMES_PER_SEC	(20)				/* Manage 16 fps ? */
#define  STAR_COUNT		(16)				/* Starfield size */
#define  MAX_ENERGY		(47*256)
#define  MAX_MISSILES	(4)
#define	 MAX_OBJECTS	(16)
#define  HOLD_SIZE		(32)
#define  COST_ENERGY	(16)
#define  COST_LASER		(400)
#define  COST_SHIELD	(600)
#define  COST_MISSILE	(50)

#define  COL_FUEL		(COL_MAGENTA)		/* Game objects colours */
#define  COL_SCANNER	(COL_BLUE)
#define  COL_MISSILES	(COL_CYAN)
#define  COL_LASER		(COL_WHITE)
#define  COL_SIGHTS		(COL_GREEN)
#define  COL_EXPLODE	(COL_RED)
#define  COL_DOCKING	(COL_YELLOW)

#define  GR_DASH		(10)				/* Graphics */
#define  GR_SHIELD		(11)
#define  GR_LASER		(12)
#define  GR_ENERGY		(13)
#define  GR_MISSILE		(14)
#define  GR_ITEMS		(15)
#define  GR_MARKER		(23)

typedef struct _Object						/* Object in space */
{
	int		InUse;							/* True if object going */
	int		x,y,z;							/* Relative position */
	int		tx,ty,tz;						/* Target position */
	int		Pattern;						/* Movement pattern */
	int		Speed;							/* Speed */
	int		Colour;							/* Object Colour */
	int		Firing;							/* Firing on us */
	int		Friendly;						/* Ship is friendly */
	int		Energy;							/* Ship Energy */
	int		Power;							/* Ship Power (1-8) */
	int		FireRate;						/* Firing Rate */
	int		Pack;							/* Joins in any fight */
	int		Picture;						/* Picture */
} OBJECT;

typedef struct _Game						/* Defines the game */
{
	int		State;							/* Game State */
	int		Anarchy;						/* Anarchy level where you are */
	int		xSector,ySector;				/* Current sector */
	int		dx,dy;							/* Direction of movement */
	int		Energy;							/* Ship energy */
	int		Missiles;						/* Missiles */
	int		Firing;							/* Currently firing ? */
	int		Shield;							/* Shield Level */
	int		Laser;							/* Laser power */
	int		Frame;							/* Frame counter */
	int		Selected;						/* Selected Docking Object */
	int		OneFreeWarp;					/* Get one "free" warp */
	int		GroupsLeft;						/* Groups remaining to dock */
	int		ObjCount;						/* Number of objects originally */
	int		AnyLeft;						/* Any ships left ? */
	int		ExplodeX,ExplodeY,ExplodeZ;		/* Explosion Coordinates */
	int		MissileInFlight;				/* Missile in flight ? */
	OBJECT  Missile;						/* Missile Object */
	int		ExplodeCount;					/* Explode Counter */
	OBJECT	Obj[MAX_OBJECTS];				/* Objects in our area */
	int		Map[8][8];						/* Map (Anarchy levels) */
	int		Hold[8];						/* Objects in the Hold */
	int		Price[8];						/* Object prices this sector */
	int		Cash;							/* Cash held */
} GAME;

void IOInitialise(int);						/* Start system */
void IOTerminate(void);						/* End system */
void IOFlip(void);							/* Double buffer flip */
void IOClear(int Reverse);					/* Clear back display */
int  IOJoystick(void);						/* Read control pad */
long IOTimer(void);							/* Read ms timer */
void IOLine(int,int,int,int,int);			/* Draw horiz,vertical line */
void IOPlot(int,int,int);					/* Plot pixel */
void IOChar(int,int,int,int);				/* Draw text chars */
void STARMove(int,int,int,int);				/* Draw & Animate stars */
void HUDDraw(GAME *s);						/* Draw head up display */
void SHIPMoveDraw(GAME *);					/* Move and Draw ships */
void SHIPDraw(OBJECT *);					/* Draw a game object */
void SHIPCreateGroup(GAME *);				/* Create a ship group */
void SHIPCreate(GAME *,OBJECT *);			/* Create an individual ship */
int  SHIPTranslate(int *,int *,int *);		/* Translate coordinates */
void SHIPExplodeDraw(GAME *g);				/* Explosion Draw */
void SHIPChase(int *,int);					/* One value towards another */
void PLAYERInit(GAME *);					/* Initialise player */
void PLAYERMove(GAME *);					/* Player Move */
void PLAYERNewSector(GAME *g);				/* New sector */
void MISSILEMove(GAME *g);					/* Missile move/draw */
void DOCKSetPrices(GAME *g);				/* Set the prices up */
void DOCKDisplay(GAME *g);					/* Show the display */
void WARPDisplay(GAME *g);					/* Display the galactic map */

#define  RANDBYTE		(rand() & 0xFF)

#define  COL_BLACK		(0)					/* Colours. Similar to IBM */
#define  COL_BLUE		(1)
#define  COL_GREEN		(2)
#define  COL_CYAN		(3)
#define  COL_RED		(4)
#define  COL_MAGENTA	(5)
#define  COL_YELLOW		(6)
#define  COL_WHITE		(7)

#define	 JOY_UP			(0x01)				/* Joystick bits */
#define  JOY_DOWN		(0x02)
#define  JOY_LEFT		(0x04)
#define  JOY_RIGHT		(0x08)
#define  JOY_A			(0x10)
#define  JOY_B			(0x20)
#define  JOY_C			(0x40)
#define  JOY_EXIT		(0x100)

#define  GS_SPACE		(0)					/* In Space */
#define  GS_DOCKING		(1)					/* Docking */
#define  GS_DOCKED		(2)					/* Docked at planet */
#define  GS_DEAD		(3)					/* Been blown up */
#define  GS_WARP		(4)					/* Warping */
#define  GS_MAP			(5)					/* Displaying the map */