/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		WARP.C													*/
/*	Project :	Elite type game in 'C'/Z80 Assembly						*/
/*	Author :	Paul Robson												*/
/*	Created :	8th May 2001											*/
/*	Function :	Galactic Map Code										*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "anarchy.h"

/************************************************************************/
/*																		*/
/*						Display the Galactic Map						*/
/*																		*/
/************************************************************************/

void WARPDisplay(GAME *g)
{
	int x,y;
	for (x = 0;x < 8;x++)				/* Draw it, highlight location */
		for (y = 0;y < 8;y++)
			{
			IOChar(x*8+8,y*8,g->Map[x][y],
					g->xSector == x && g->ySector == y ? COL_YELLOW:COL_RED);
			}
	x = IOJoystick();
	if ((x & JOY_B) != 0)				/* B Exits */
	{
		while ((IOJoystick() & JOY_B) != 0) {}
		g->State = GS_SPACE;
		return;
	}
	if ((x & JOY_A) != 0)				/* A goes to warp */
	{
										/* Select sector */
		if (x & JOY_UP) 	g->ySector--;
		if (x & JOY_DOWN) 	g->ySector++;
		if (x & JOY_LEFT) 	g->xSector--;
		if (x & JOY_RIGHT) 	g->xSector++;
		g->xSector &= 7;
		g->ySector &= 7;
		if ((x & (JOY_UP+JOY_DOWN+JOY_LEFT+JOY_RIGHT)) == 0) return;
		g->State = GS_WARP; 			/* Warp state */
		g->Frame = 0;
		if (g->OneFreeWarp == 0)		/* Starbase freebie ? */
				g->Energy = g->Energy/2;
		g->OneFreeWarp = 0;				/* Not any more :) */
	}

}