/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		STARS.C													*/
/*	Project :	Elite type game in 'C'/Z80 Assembly						*/
/*	Author :	Paul Robson												*/
/*	Created :	22nd April 2001											*/
/*	Function :	Starfield Code											*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "anarchy.h"

/************************************************************************/
/*																		*/
/*							 Draw a Starfield							*/
/*																		*/
/************************************************************************/

struct _Star								/* Star records */
	{ int x,y,xi,yi,Colour; } Star[STAR_COUNT];

void STARMove(int Init,int Rate,int dx,int dy)
{
	int i,n;
	for (i = 0;i < STAR_COUNT;i++)			/* For each star */
	{
		if (Init ||							/* If initialise,off edge */
			Star[i].x > 96*256 || Star[i].y > 56*256 ||
			Star[i].x < 0 || Star[i].y < 0)
		{
			Star[i].x = 48*256;				/* Back to the middle */
			Star[i].y = 32*256;
			Star[i].xi = RANDBYTE;			/* Direction */
			Star[i].yi = 255-RANDBYTE;
			Star[i].xi = Star[i].xi * 3/2;	/* Adjust for 96x64 display */
			Star[i].Colour = RANDBYTE%7+1;
			n = RANDBYTE;					/* dx,dy can be flipped */
			if (n & 1) Star[i].xi = -Star[i].xi;
			if (n & 2) Star[i].yi = -Star[i].yi;
		}
		else								/* Otherwise draw */
			IOPlot(Star[i].x >> 8,Star[i].y >> 8,Star[i].Colour);
		n = Rate;if (Init) n = RANDBYTE;	/* No of moves,many if init */
		while (n-- > 0)						/* Move it n times */
		{									/* Move allowing for ship move */
			Star[i].x += Star[i].xi+(dx << 8);
			Star[i].y += Star[i].yi+(dy << 8);
		}
	}
}


