/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		PLAYER.C												*/
/*	Project :	Elite type game in 'C'/Z80 Assembly						*/
/*	Author :	Paul Robson												*/
/*	Created :	4th May 2001											*/
/*	Function :	Player Ship Handling									*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "anarchy.h"

/************************************************************************/
/*																		*/
/*							Initialise Player							*/
/*																		*/
/************************************************************************/

void PLAYERInit(GAME *g)
{
	int x,y;
	g->Energy = MAX_ENERGY;					/* Initialise the ship */
	g->Missiles = 1;
	g->Shield = 0;g->Laser = 0;
	g->OneFreeWarp = 0;
	g->xSector = g->ySector = 4;			/* Always in sector 04,04 */
	for (x = 0;x < 8;x++)					/* Create the map */
		for (y = 0;y < 8;y++)
			g->Map[x][y] = (RANDBYTE & 7)+1;
	g->Cash = 100;							/* Some money */
	for (x = 0;x < 8;x++) g->Hold[x] = 0;	/* Empty the hold */
	g->Map[4][4] = 1;						/* Nice and easy start */
	PLAYERNewSector(g);						/* Enter a new sector */
	STARMove(1,0,0,0);						/* Initialise the stars */
}

/************************************************************************/
/*																		*/
/*						    Entering a new sector						*/
/*																		*/
/************************************************************************/

void PLAYERNewSector(GAME *g)
{
	int	n;
	g->Anarchy = g->Map[g->xSector]		/* Read Anarchy Level */
								[g->ySector];
	n = 2+(g->Anarchy >> 1);			/* Max groups allowed */
	do
		g->GroupsLeft = RANDBYTE & 7;
	while (g->GroupsLeft > g->Anarchy);
	g->GroupsLeft+=2;
	g->ExplodeCount = 0;					/* No explosions */
	g->MissileInFlight = 0;					/* No missiles */
	SHIPCreateGroup(g);						/* Create a ship group */
	DOCKSetPrices(g);						/* Set Prices */
	g->State = GS_WARP;						/* In space */
	g->Frame = 0;
}

/************************************************************************/
/*																		*/
/*								Move Player								*/
/*																		*/
/************************************************************************/

void PLAYERMove(GAME *g)
{
	int n;                           		/* Read stick */
	n = IOJoystick();
	g->dx = g->dy = 0;						/* Convert to direction */
	if (n & JOY_DOWN) 	g->dy = 1;
	if (n & JOY_UP) 	g->dy = -1;
	if (n & JOY_RIGHT)	g->dx = 1;
	if (n & JOY_LEFT)	g->dx = -1;
	g->Firing = (n & JOY_A);				/* Check firing, change energy */
	g->Energy += (g->Firing) ? -20 : 4;
	if ((n & JOY_B) != 0 &&					/* Launch missile ? */
				g->Missiles > 0 && g->MissileInFlight == 0)
	{
		g->Missiles--;
		g->MissileInFlight = 1;
		g->Missile.x = g->Missile.y = g->Missile.z = 0;
	}
	if (n & JOY_C) g->State = GS_MAP;		/* Switch to Galactic Map */
}