/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		MISSILE.C												*/
/*	Project :	Elite type game in 'C'/Z80 Assembly						*/
/*	Author :	Paul Robson												*/
/*	Created :	4th May 2001											*/
/*	Function :	Missile Code											*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "anarchy.h"

/************************************************************************/
/*																		*/
/*							Move a missile								*/
/*																		*/
/************************************************************************/

void MISSILEMove(GAME *g)
{
	int n,Dist,d,h;
	if (g->MissileInFlight == 0) return;	/* Not happenin' */
	if (g->Missile.z > 40)					/* Gone too far */
				g->MissileInFlight = 0;
	g->Missile.Picture = -1;				/* Set up to draw */
	g->Missile.Colour = COL_MISSILES;
	g->Missile.Firing = 0;
	SHIPDraw(&(g->Missile));
	Dist = 9999;h = -1;						/* Look for nearest ship */
	for (n = 0;n < g->ObjCount;n++)
	{
		d = abs(g->Missile.x-g->Obj[n].x)+
			abs(g->Missile.y-g->Obj[n].y)+
			abs(g->Missile.z-g->Obj[n].z);
		if (d < Dist && g->Obj[n].z < 40 && g->Obj[n].InUse != 0)
		{
			Dist = d;h = n;
		}
	}
	if (h < 0)
		g->Missile.z++;
	else
	{
		SHIPChase(&(g->Missile.x),g->Obj[h].x);	/* Chase that target */
		SHIPChase(&(g->Missile.y),g->Obj[h].y);
		SHIPChase(&(g->Missile.z),g->Obj[h].z);
	}
}
