/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		MAIN.C													*/
/*	Project :	Elite type game in 'C'/Z80 Assembly						*/
/*	Author :	Paul Robson												*/
/*	Created :	4th May 2001											*/
/*	Function :	Main Program											*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "anarchy.h"
#include <time.h>

GAME Game;

void main(int argc,char *argv[])
{
	long t = 0;
	GAME *g = &Game;
	int i,n;
	IOInitialise(argc == 1);				/* Initialise the system */
	randomize();
	PLAYERInit(g);							/* Initialise the game */

	g->State = GS_DOCKED;

	while ((IOJoystick() & JOY_EXIT) == 0)	/* Until we want to exit */
	{
		IOFlip();							/* Double buffer and sync */
		while (IOTimer() < t) {}
		t = IOTimer()+1000/FRAMES_PER_SEC;
		g->Frame++;
		IOClear(0);

		switch(g->State)					/* State dependent.... */
		{
			case GS_SPACE:					/* In space */
					PLAYERMove(g);			/* Move stuff */
					STARMove(0,1,g->dx,g->dy);
					SHIPMoveDraw(g);
					MISSILEMove(g);
					SHIPExplodeDraw(g);
					if (g->Energy <= 0)		/* Ship dead ? */
					{
						g->Frame = 0;
						g->State = GS_DEAD;
					}
					if (g->AnyLeft == 0)	/* New group required ? */
								SHIPCreateGroup(g);
					if (g->GroupsLeft == 0)	/* Reached the end ? */
					{
						g->Frame = 0;		/* Go into the docking state */
						g->State = GS_DOCKING;
					}
					HUDDraw(g);				/* Draw HUD */
					break;

			case GS_DOCKING:				/* Docking */
					if (g->Frame == 64)		/* Completed docking sequence */
								g->State = GS_DOCKED;
					if (g->Frame >= 32)
					{
						n = 3*(8-(g->Frame % 8));
						IOLine(n,n+4,96-n,n+4,COL_DOCKING);
						IOLine(n,56-n+4,96-n,56-n+4,COL_DOCKING);
					}
					else
						STARMove(0,1,0,0);
					HUDDraw(g);
					break;

			case GS_MAP:					/* Warping Sequence */
					WARPDisplay(g);
					break;

			case GS_WARP:					/* In warp mode */
					for (i = 0;i < 128;i++)
					{
						n = i;
						if (n > 64) n = 127-n;
						STARMove(0,1+n/8,0,0);
						IOFlip();
						while (IOTimer() < t) {}
						t = IOTimer()+1000/FRAMES_PER_SEC/4;
						IOClear(0);
					}
					g->State = GS_SPACE;
					break;

			case GS_DOCKED:					/* Docked ? */
					DOCKDisplay(g);			/* Display that display */
					g->OneFreeWarp = 1;		/* Get one "free" warp */
					break;

			case GS_DEAD:
					if (g->Frame < 128)
						STARMove(0,1,rand()%2*4-2,rand()%2*4-2);
					else
					{
						g->Frame = 0;		/* Frame zero for dock */
						g->Shield = 0;		/* Bog standard empty ship */
						g->Laser = 0;
						for (n = 0;n < 8;n++) g->Hold[n] = 0;
						g->Cash = g->Cash/2;/* Lose half your cash & dock */
						g->State = GS_DOCKING;
					}
					break;
		}
	}
	IOTerminate();
}
