/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		HUD.C													*/
/*	Project :	Elite type game in 'C'/Z80 Assembly						*/
/*	Author :	Paul Robson												*/
/*	Created :	22nd April 2001											*/
/*	Function :	Draw Instrumentation									*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "anarchy.h"

/************************************************************************/
/*																		*/
/*						Draw the Head up display						*/
/*																		*/
/************************************************************************/

void HUDDraw(GAME *g)
{
	int x,n;
	if (g->Energy < 0) g->Energy = 0;		/* Energy into range */
	if (g->Energy > MAX_ENERGY) g->Energy = MAX_ENERGY;
	n = g->Energy >> 8;
	if (g->Firing != 0 && (g->Frame & 4))	/* Laser flashes */
	{
		IOLine(8,56,48,32,COL_LASER);
		IOLine(87,56,48,32,COL_LASER);
	}
	IOLine(32,32,39,32,COL_SIGHTS);			/* Draw the sights */
	IOLine(56,32,63,32,COL_SIGHTS);
	IOLine(0,56,n,56,COL_FUEL);				/* Draw the fuel gauge */
	IOLine(0,58,n,58,COL_FUEL);
	IOLine(0,56,0,58,COL_FUEL);
	IOLine(n,56,n,58,COL_FUEL);
	IOLine(80,56,95,56,COL_SCANNER);		/* Frame the scanner */
	IOLine(80,63,95,63,COL_SCANNER);
	IOLine(80,56,80,63,COL_SCANNER);
	IOLine(95,56,95,63,COL_SCANNER);
	for (n = 0;n < g->Missiles;n++)			/* Show available missiles */
		IOChar(n*8+48,56,GR_MISSILE,COL_MISSILES);
}

