/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		DOCK.C													*/
/*	Project :	Elite type game in 'C'/Z80 Assembly						*/
/*	Author :	Paul Robson												*/
/*	Created :	4th May 2001											*/
/*	Function :	Docked at a starbase									*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "anarchy.h"

static void _DOCKWrite(int x,int y,int w,int n,int c);
static void _DOCKEquipCost(int x,int y,int g,int Cost);

/************************************************************************/
/*																		*/
/*				 Set the prices for the current system					*/
/*																		*/
/************************************************************************/

static int BasePrices[8] = { 1,2,2,3,2,14,11,17 };

void DOCKSetPrices(GAME *g)
{
	int i,n;
	for (i = 0;i < 8;i++)
	{
		n = g->Anarchy;if (n > 4) g = g + 2;
		g->Price[i] = BasePrices[i] * n;
		g->Price[i] = g->Price[i] + rand()%6 - 3;
		if (g->Price[i] < 1) g->Price[i] = 1;
		if (rand() % 8 == 0) g->Price[i] = 0;
	}
	g->Selected = 0;						/* Reset selected item */
}

/************************************************************************/
/*																		*/
/*							Display and check keys						*/
/*																		*/
/************************************************************************/

void DOCKDisplay(GAME *g)
{
	int i,x,y;
	_DOCKWrite(56,2,4,g->Cash,COL_YELLOW);	/* Draw the top line */
	_DOCKWrite(8,2,1,g->xSector,COL_YELLOW);
	_DOCKWrite(24,2,1,g->ySector,COL_YELLOW);
	IOChar(16,2,GR_DASH,COL_BLUE);
	IOLine(0,0,95,0,COL_YELLOW);			/* Draw seperator bars */
	IOLine(0,11,95,11,COL_YELLOW);
	for (i = 0;i < 8;i++)					/* Draw Qty,Price,Graphic for items */
	{
		x = (i & 1) * 48;
		y = (i / 2+1)* 8+6;
		IOChar(x+16,y,GR_ITEMS+i,COL_YELLOW);
		IOChar(x+8,y,g->Hold[i],COL_RED);
		_DOCKWrite(x+24,y,3,g->Price[i],COL_GREEN);
	}
	if (g->Energy != MAX_ENERGY)			/* Display Energy if needed */
			_DOCKEquipCost(0,5,GR_ENERGY,COST_ENERGY);
											/* Display Equipment Costs */
	_DOCKEquipCost(6,5,GR_MISSILE,COST_MISSILE);
	_DOCKEquipCost(0,6,GR_SHIELD,COST_SHIELD*(1 << g->Shield));
	_DOCKEquipCost(6,6,GR_LASER, COST_LASER*(1 << g->Laser));

	IOChar((g->Selected%2)*48,				/* Draw selector marker */
				(g->Selected/2+1)*8+6,GR_MARKER,COL_WHITE);

	i = IOJoystick();						/* Read keypad */
	if ((g->Frame & 7) == 0)				/* Every .7 secs or so */
	{
		if (i & (JOY_LEFT+JOY_RIGHT))		/* Left, Right, Up, Down */
							g->Selected ^= 1;
		if ((i & JOY_UP) != 0 && g->Selected > 1) g->Selected-=2;
		if ((i & JOY_DOWN) != 0 && g->Selected < 10)
										g->Selected+=2;
		if (i & JOY_A)						/* Buy */
		{
			switch(g->Selected)				/* See what... */
			{
			case 8:							/* Energy Charge */
				if (g->Cash >= COST_ENERGY && g->Energy < MAX_ENERGY)
				{
					g->Energy = MAX_ENERGY;
					g->Cash -= COST_ENERGY;
				}
				break;
			case 9:							/* Missile */
				if (g->Cash >= COST_MISSILE && g->Missiles < MAX_MISSILES)
				{
					g->Missiles++;
					g->Cash -= COST_MISSILE;
				}
				break;

			case 10:						/* Upgrade Shield,Laser */
			case 11:
				x = (g->Selected == 10);	/* True if shields */
				y = 1 << (x ? g->Shield:g->Laser);
				y = y * (x ? COST_SHIELD:COST_LASER);
				if (g->Cash > y)
				{
					g->Cash -= y;
					if (x) g->Shield++; else g->Laser++;
				}
				break;

			default:						/* Buying commodities */
				y = 0;						/* Count cargo bay slots used */
				for (x = 0;x < 8;x++) y+= g->Hold[x];
				x = g->Selected;
				if (g->Cash >= g->Price[x] &&
					g->Hold[x] < 9 && g->Price[x] != 0 &&
					y < HOLD_SIZE)
				{
					g->Hold[x]++;
					g->Cash -= g->Price[x];
				}
				break;
			}
		}

		if (i & JOY_B)						/* Selling */
		{
			x = g->Selected;
			if (x < 8 && g->Hold[x] > 0)	/* Can't sell upgrades */
			{
				g->Cash += g->Price[x];
				g->Hold[x]--;
			}
		}

		if (i & JOY_C)						/* Exit docking */
		{
			while (IOJoystick() != 0) {}	/* Wait for key release */
			g->State = GS_SPACE;			/* Go to space */
			PLAYERNewSector(g);				/* Enter a new sector */
		}
	}
}

/************************************************************************/
/*																		*/
/*      			Display Equipment Cost line							*/
/*																		*/
/************************************************************************/

static void _DOCKEquipCost(int x,int y,int g,int Cost)
{
	IOChar(x*8+8,y*8+6,g,COL_RED);
	_DOCKWrite(x*8+16,y*8+6,4,Cost,COL_GREEN);
}

/************************************************************************/
/*																		*/
/*							Display an integer							*/
/*																		*/
/************************************************************************/

static void _DOCKWrite(int x,int y,int w,int n,int c)
{
	char _Temp[8];
	int i;
	sprintf(_Temp,"%*d",w,n);
	for (i = 0;i < w;i++)
		if (_Temp[i] != ' ') IOChar(x+i*8,y,_Temp[i] & 15,c);
}

