;--------------= rom calls =------------

#define ldhlind         $4000           ; hl = (hl)
#define cphlde          $4004           ; hl == de
#define shracc          $42A2           ; shift a right 4
#define htimesl         $4382           ; hl = h*l
#define memchk          $441A           ; hl = free memory
#define chkfindsym      $442A           ; find var in sym table
#define createprog      $448A           ; create program (name in op1)
#define delvar          $44AA           ; delete variable
#define putc            $4705           ; display character
#define disphl          $4709           ; display hl
#define puts            $470D           ; display string
#define vputs           $4781           ; display string small font
#define getk            $4A18           ; get key
#define sfontlen        $4A6C           ; c = width of char (hl)
#define grbufclr        $515B           ; clear grbuf


;-----------= ram locations =-----------

#define currow          $800C           ; cursor row
#define curcol          $800D           ; cursor col
#define op1             $8039           ; op1
#define pencol          $8252           ; small font cursor col
#define penrow          $8253           ; small font cursor row
#define apdbuf          $8265           ; apd buffer
#define grbuf           $8E29           ; graph buffer
#define progptr         $9319           ; pointer to prog smybol table
#define usermem         $9327           ; where prog is loaded


;-------------= data types =------------

#define progobj         $05             ; program
#define protprogobj     $06             ; protected program


;---------------= ports =---------------

#define lcdinstport     $10             ; lcd driver


#ifdef  slopes
;---------= slopes lib routines =-------

#define rand            vector0         ; random number
#define detect          vector1         ; detect level
#define decompress      vector2         ; decompress level data
#define hiscr           vector3         ; check high score
#define grbufcpy        vector4         ; copy grbuf to screen


;-------------= slopes vars =-----------

#define curvat          apdbuf          ; 2  bytes - location in vat
#define high            curvat+2        ; 2  bytes - high score
#define highptr         high+2          ; 2  bytes - pointer to high score
#define level           highptr+2       ; 2  bytes - pointer to level data
#define leveldata       level+2         ; 96 bytes - decompresses level data
#define row             leveldata+96    ; 1  byte  - level offset
#define col             row+1           ; 1  byte  - skier position
#define score           col+1           ; 2  bytes - score
#define time            score+2         ; 1  byte  - time
#define life            time+1          ; 1  byte  - life
#define flakes          life+1          ; 30 bytes - snow flake coords (y,x)
#define menusize        flakes+30       ; 1  byte  - number of menu items
#define menuitem        menusize+1      ; 1  byte  - highlighted menu item
#define menutop         menuitem+1      ; 1  byte  - menu drawing offset
#define menustart       menutop+1       ; ?  bytes - begining of menu


#else
;--------= editor lib routines =--------

#define detect          vector0         ; detect level
#define decompress      vector1         ; decompress level data
#define grbufcpy        vector2         ; copy grbuf to screen


;-------------= editor vars =-----------

#define curvat          apdbuf          ; 2  bytes - location in vat
#define name            curvat+2        ; 25 bytes - level name
#define level           name+25         ; 2  bytes - pointer to level data
#define leveldata       level+2         ; 96 bytes - decompressed level data
#define row             leveldata+96    ; 1  byte  - level offset
#define col             row+1           ; 1  byte  - skier position
#define inputdata       col+1           ; 24 bytes - place to store input
#define itemnum         inputdata+24    ; 1  byte  - item number when editing
#define menusize        itemnum+1       ; 1  byte  - number of menu items
#define menuitem        menusize+1      ; 1  byte  - highlighted menu item
#define menutop         menuitem+1      ; 1  byte  - menu drawing offset
#define menustart       menutop+1       ; ?  bytes - begining of menu
#define menuitem1       menustart       ; 2  bytes - first menu item
#define menuitem2       menuitem1+2     ; 2  bytes - second menu item
#define menuitem3       menuitem2+2     ; 2  bytes - third menu item
#endif
