;Kashan A. Shaikh
;7/10/1999
;(help with external levels and compression from Joe Wingbermuehle)
;FIGHTER JETS 83 v2.3
;This program requires ZGFXL, ZLIB, and ZINPT for SOS

.NOLIST

#define equ .EQU
#define EQU .equ
#define end .end

#include "ti83asm.inc"
#include "sos.inc"

#DEFINE mnu	8265h ;menu arrow position
#DEFINE aps	8266h ;previous position of menu arrow
#DEFINE ppos	8267h ;orientation of the player
#DEFINE cpos	8268h ;orientation of the computer
#DEFINE sx	8269h ;sprite x-coordinate
#DEFINE sy	826ah ;sprite y-coordinate
#DEFINE sh	826bh ;sprite height
#DEFINE px	826ch ;player x-coordinate
#DEFINE py	826dh ;player y-coordinate
#DEFINE cx	826eh ;comp x-coordinate
#DEFINE cy	826fh ;comp y-coordinate
#DEFINE psht	8270h ;is the player shooting or not?
#DEFINE pshtpos	8271h ;orientation of player's shot
#DEFINE pshootx	8272h ;player shot x
#DEFINE pshooty	8273h ;player shot y
#DEFINE csht	8274h ;is the computer shooting or not?
#DEFINE cshtpos	8275h ;orientation of the computer's shot
#DEFINE cshootx	8276h ;computer shot x
#DEFINE cshooty	8277h ;computer shot y
#DEFINE plives	8278h ;# of player lives
#DEFINE clives	8279h ;# of computer lives
#DEFINE kflag	827ah ;kill flag (equals 1 when someone gets killed)
#DEFINE diff	827bh ;difficulty level
#DEFINE tsht	827ch ;temporary shooting var
#DEFINE tshootx	827dh ;temp shoot x
#DEFINE tshooty	827eh ;temp shoot y
#DEFINE tx	827fh ;temp x for the one being shot at
#DEFINE ty	8280h ;temp y for the one being shot at
#DEFINE tlives	8281h ;temp # of lives for the shooter
#DEFINE who	8282h ;who is shooting
#DEFINE score	8283h ;the score
#DEFINE sprt	8285h ;sprite location
#DEFINE lvl	8287h ;the current level #
#DEFINE temp	8288h ;temp var
#DEFINE tx2	8289h ;tmp x for the shooter
#DEFINE ty2	828ah ;tmp y for the shooter
#DEFINE tpos	828bh ;tmp position of shooter
#DEFINE tshtpos	828ch ;tmp position of shot
#DEFINE wall	828dh ;is there a wall??
#DEFINE tempDx	828eh ;d of (d mod e) in the x
#DEFINE tempEx	828fh ;e of (d mod e) in the x
#DEFINE tempDy	8290h ;d of (d mod e) in the y
#DEFINE tempEy	8291h ;e of (d mod e) in the y
#DEFINE killed	8292h ;ship killed (1=plyr 2=comp)
#DEFINE speed	8293h ;speed (0=slow 1=fast)
#DEFINE enviro	8294h ;"environment" (day=0 night=1)
#DEFINE level	8295h ;current level address
#define	file		level+2	; 2 bytes  -program data (after detection string)
#define	level_data	level+4	; 2 bytes  -beginning of level data
#define	fat_location	level+6	; 2 bytes
#define	compress_buffer	level+8	; 96 bytes

.LIST

.org     9327h

      	ccf				; SOS program
	jr	z,start_of_program	; not detectable until INSTALL is run
	.dw	libraries-$9327		; libraries
	.dw	title

;-----=====libraries=====-----
libraries:
	.db	"ZGFXL",0,0,0,lib1,vec0		;large sprite
	.db	"ZGFXL",0,0,0,lib2,vec1 	;fastcopy
	.db	"ZLIB",0,0,0,0,libD,vec2	;highscore
	.db	"ZLIB",0,0,0,0,lib6,vec3	;decompress
	.db	"ZLIB",0,0,0,0,lib4,vec4	;detect
	.db	"ZLIB",0,0,0,0,lib1,vec5	;small sprite
	.db	"ZLIB",0,0,0,0,lib2,vec6	;rand
	.db	"ZINPT",0,0,0,lib1,vec8		;waitkey
	.db	"ZINPT",0,0,0,lib2,vec9		;string input
	.db	$FF
	#define decompress	vector3
	#define detect		vector4
	#define waitkey		vector8
	
#define NUM_OF_BLOCKS	10

;-----=====start=====-----
start_of_program:
	call	_grbufclr
	ld	hl,($9319)
	ld	(fat_location),hl
	call	getLevelSet
	ret	nz
	
;-----=====Intro Screen=====----- 
intro:
	call	_GetK
intro1:
	ld	bc,8*256+7
	ld	l,1
	ld	a,21
	ld	ix,title_one		; FIGHTER
	call	vector0
	ld	bc,8*256+4
	ld	l,11
	ld	a,33
	ld	ix,title_two		; JETS
	call	vector0	
	ld	bc,8*256+2
	ld	l,21
	ld	a,41
	ld	ix,title_three		; 83
	call	vector0	
	call	vector1			; copy graph buffer
	xor	a
	ld	(speed),a			; reset the speed (not related to intro)
	ld	(enviro),a
	ld	(px),a
	inc	a
	ld	(ppos),a
	ld	(diff),a
	ld	a,40
	ld	(py),a
	call	showplayer	
	ld	b,48
scrloop:
	push	bc
	call	vector1			; copy graph buffer
	call	showplayer
	ld	hl,px
	inc	(hl)
	call	showplayer
	pop	bc
	djnz	scrloop
	xor	a
	ld	hl,390fh			; (57,16)
	ld	(pencol),hl
	ld	hl,inst5
	call	_vputs
	call	waitkey

;----------==========First Menu==========----------
res_main:
	ld	a,1
	ld	(lvl),a
	ld	(mnu),a
main:
	call	_clrLCDFULL
	call	_grbufclr
	call	_GetK
	call	text_only_ttle
	ld	hl,1416h
	ld	(pencol),hl
	ld	hl,tmode			; mode-levelset
	call	_vputs
	ld	hl,1a16h
	ld	(pencol),hl
	ld	hl,topt			; alpha-options
	call	_vputs
	ld	hl,2016h
	ld	(pencol),hl
	ld	hl,tdel			; del-quit
	call	_vputs	
	ld	hl,3914h
	ld	(pencol),hl
	ld	hl,hscrtext			; High Score:
	call	_vputs
	ld	hl,(file)			; high score
	inc	hl
	push	hl
	call	$4000				; _LdHLind (ti-83 routine)
	call	dispscore
	pop	hl
	inc	hl
	inc	hl
	push	hl
	ld	hl,331bh
	ld	(pencol),hl
	pop	hl
	call	_vputs			; show highscore name
	push	hl
	ld	hl,7*256+1			; (8,1)
	ld	(pencol),hl
	pop	hl
	call	_vputs			; display level set name
	ld	(level_data),hl		; beginning level data

menu:
	call	text_start
	res	textinverse,(iy+textflags)
	call	_getk
	cp	56
	ret	z				; [DEL] (Return to SOS)
	cp	54				; [2ND]
	jp	z,mchoice
	cp	48				; [ALPHA]
	jp	z,options
	cp	55				; [MODE]
	jr	nz,menu

;------
changeLevelSet:				; change level set
	call	getLevelSet	
	jp	z,res_main
	ld	hl,($9319)
	ld	(fat_location),hl
	jr	changeLevelSet

;------
text_start:	
	ld	a,(mnu)
	dec	a
	jr	z,highlighton
	dec	a
	jr	z,midhigh
	ld	a,2
aft_mh:
	ld	(mnu),a
	res	textinverse,(iy+textflags)
	jr	write_start
midhigh:
	inc	a
	jr	aft_mh
highlighton:
	ld	(mnu),a
	set	textinverse,(iy+textflags)
write_start:
	ld	hl,2a1ch
	ld	(pencol),hl
	ld	hl,m1				; start
	call	_vputs
	ret

;------
text_title_name:
	set	textinverse,(iy+textflags)
	ld	hl,3900h			; (57,0)
	ld	(pencol),hl
	ld	hl,menuspaces
	call	_vputs
	ld	hl,author
	call	_vputs
	ld	hl,menuspaces
	call	_vputs
	res	textinverse,(iy+textflags)
text_only_ttle:
	set	textinverse,(iy+textflags)
	ld	hl,0000h			; (0,0)
	ld	(pencol),hl
	ld	hl,menuspaces
	call	_vputs
	ld	hl,title			; Fighter Jets 83 v2.3
	call	_vputs
	ld	hl,menuspaces
	call	_vputs
	res	textinverse,(iy+textflags)
	ret

;------
mchoice:
	res	textinverse,(iy+textflags)
	jp	start

;---------=========Options Menu=========---------
options:
	call	_clrLCDFULL
	call	_grbufclr
	call	_GetK
	call	text_title_name
	ld	hl,1105h			; (17,5)
	ld	(pencol),hl
	ld	hl,tlevnum			; up/down-Level:
	call	_vputs
	call	text_levnum
	ld	hl,1705h			; (23,5)
	ld	(pencol),hl
	ld	hl,tdiff			; alpha-difficulty
	call	_vputs
	call	text_diff
	ld	hl,1d05h			; (29,5)
	ld	(pencol),hl
	ld	hl,tspeed			; X,T,0,n-Speed:
	call	_vputs
	call	text_speed
	ld	hl,2305h			; (34,5)
	ld	(pencol),hl
	ld	hl,tback			; 2nd-back
	call	_vputs

menu2:
	res	textinverse,(iy+textflags)
	call	waitkey
	cp	54				; [2ND]
	jp	z,main
	cp	48				; [ALPHA]
	jr	z,difficulty
	cp	40				; [X,T,0,n]
	jr	z,mspeed
	dec	a				; down arrow
	jr	z,levdec
	dec	a
	dec	a
	dec	a				; up arrow
	jr	nz,menu2

;------
levinc:
	ld	a,(lvl)
	ld	hl,(file)
	cp	(hl)
	call	z,back_lev1			; return to level 1
	inc	a
	ld	(lvl),a
	call	text_levnum	
	jr	menu2
back_lev1:
	ld	a,0
	ret	

;------
levdec:
	ld	a,(lvl)
	dec	a
	call	z,back_levlast		; go to the last level
	ld	(lvl),a
	call	text_levnum
	jr	menu2
back_levlast:
	ld	hl,(file)
	ld	a,(hl)
	ret
	
;------
mspeed:
	ld	a,(speed)			; change the speed
	dec	a
	jr	z,chg_toslow
	ld	a,1
chg_toslow:
	ld	(speed),a
	call	text_speed	
	jr	menu2

;------
difficulty:
	ld	a,(diff)
	dec	a
	jr	z,chg_tohard
	ld	(diff),a
	call	text_easy
	jr	menu2
chg_tohard:
	ld	a,2
	ld	(diff),a
	call	text_hard
	jp	menu2

;------
text_levnum:
	ld	hl,1049h			; (16,73)
	ld	(pencol),hl
	ld	a,(lvl)			; level #
	call	_setxxop1
	ld	a,2
	call	_dispop1a
	jp	_vputblank

;------
text_diff:
	ld	a,(diff)
	dec	a
	jr	nz,text_hard
text_easy:
	ld	hl,1649h			; (22,73)
	ld	(pencol),hl
	ld	hl,teasy			; easy
	jp	_vputs
text_hard:
	ld	hl,1649h			; (22,73)
	ld	(pencol),hl
	ld	hl,thard			; hard
	jp	_vputs

;------
text_speed:
	ld	hl,1c49h			; (28,73)
	ld	(pencol),hl
	ld	a,(speed)
	dec	a
	jr	z,text_speed_fast
	ld	hl,tslow			; slow
	jr	tspd_nxt
text_speed_fast:
	ld	hl,tfast			; fast
tspd_nxt:
	jp	_vputs


;---------========Let's get this game started========---------
start:
	ld	a,10
	ld	(plives),a
	ld	(clives),a
	ld	hl,0
	ld	(score),hl
bef_nxt:
	call	pause
contstart:
	xor	a
	ld	(killed),a
after_kill:
	xor	a
	ld	(psht),a
	ld	(kflag),a
	ld	(tshootx),a
	ld	(tshooty),a
	ld	(wall),a
	ld	a,4
	ld	(ppos),a
	ld	a,3
	ld	(cpos),a
	call	_clrLCDFULL
	call	_grbufclr
	call	loadlvl
	ld	de,24		; not 96!
	add	hl,de
	ld	a,(hl)
	ld	(px),a
	inc	hl
	ld	a,(hl)
	ld	(py),a
	xor	a
	ld	(csht),a
	inc	hl
	ld	a,(hl)
	ld	(cx),a
	inc	hl
	ld	a,(hl)
	ld	(cy),a
	ld	a,(killed)
	dec	a
	jp	z,comp_keep
	dec	a
	jp	z,player_keep
after_keep:
	xor	a
	ld	(killed),a
	call	showplayer
	call	showcomp
	call	_GetK
	ld	hl,$0000
	ld	(level),hl
	call	leveldraw
	ld	a,(enviro)
	dec	a
	call	z,vector7
	
;----------==========-----game loop-----==========----------
game:
	ld	a,(speed)
	or	a				; slow
	call	z,_grbufcpy_v		; TI's graph buffer copy
	dec	a				; fast
	call	z,vector1			; fastcopy (ZGFXL for SOS)
	call	showplayer
	call	showcomp
	ld	a,(kflag)			; did anyone die?
	dec	a
	jp	z,after_kill
	ld	a,0ffh
	out	(1),a
	ld	a,0feh
	out	(1),a
	in	a,(1)
	cp	254
	jp	z,pdown
	cp	253
	jp	z,pleft
	cp	251
	jp	z,pright
	cp	247
	jp	z,pup
	ld	a,0ffh
	out	(1),a
	ld	a,0bfh
	out	(1),a
	in	a,(1)
	cp	223
	jp	z,pshoot
	cp	191
	call	z,pause
	cp	127
	jp	z,plosec
gamec:	
	call	mplyr
gamec2:
	call	mcomp
	ld	a,(psht)
	dec	a
	call	z,pshowshoot
	ld	a,(csht)
	dec	a
	call	z,cshowshoot
	ld	a,(plives)
	or	a
	jp	z,plose
	ld	a,(clives)
	or	a
	jp	z,nextlev
	jp	game

;-----=====keep comp's position after player's death=====-----
comp_keep:
	ld	a,(tx2)
	ld	(cx),a
	ld	a,(ty2)
	ld	(cy),a
	ld	a,(tpos)
	ld	(cpos),a
	jp	after_keep

;-----=====keep player's position=====-----
player_keep:
	ld	a,(tx2)
	ld	(px),a
	ld	a,(ty2)
	ld	(py),a
	ld	a,(tpos)
	ld	(ppos),a
	jp	after_keep

;-----=====increase the level=====-----
nextlev:
	ld	hl,1b11h
	ld	(pencol),hl
	ld	hl,new
	call	_vputs
	call	waitkey
	ld	a,(lvl)
	ld	hl,(file)
	cp	(hl)
	call	z,loop_lev		; return to level 1
	inc	a
	ld	(lvl),a
	call	bonus
	ld	a,10
	ld	(clives),a
	ld	a,(plives)
	inc	a
	ld	(plives),a
	jp	bef_nxt
loop_lev:
	ld	a,0
	ret
	
;-----=====load the level=====-----
loadlvl:
	ld	hl,(level_data)
	ld	a,(lvl)
	dec	a
	ret	z
	ld	b,a
	ld	de,28		; not 101!
loadllp:
	add	hl,de
	djnz	loadllp
	ret

;-----=====draw the level=====-----
leveldraw:
	ld	a,NUM_OF_BLOCKS
	ld	b,a
	call	vector6			; random number
	inc	a			; between 0 and numblocks-1 (so I add 1)
	ld	b,a
	ld	hl,block1-8
	ld	de,8
b1:	add	hl,de
	djnz	b1
	ld	(sprt),hl
	call	loadlvl
	ld	de,compress_buffer
	ld	bc,24*256+3
	call	decompress
	ld	hl,compress_buffer
	ld	(level),hl		; location of current level
	ld	a,8
	ld	(sh),a
	xor	a
	ld	(sx),a
	ld	(sy),a
	ld	b,12
ldraw1:
	ld	a,b
	ld	(temp),a
	ld	hl,(level)
	ld	a,(hl)
	inc	hl
	ld	(level),hl
	dec	a
	call	z,sprite
	ld	c,8
	ld	a,(sx)
	add	a,c
	ld	(sx),a
	ld	a,(temp)
	ld	b,a
	djnz	ldraw1
	xor	a
	ld	(sx),a
	ld	a,(sy)
	ld	c,8
	add	a,c
	ld	(sy),a
	cp	64
	ret	z
	ld	b,12
	jp	ldraw1

;-----=====player dies=====-----
plose:
	call	_clrLCDFULL
	ld	hl,0103h
	ld	(currow),hl
	ld	hl,loser
	call	_puts
	ld	hl,0204h
	ld	(currow),hl
	ld	hl,scrtext
	call	_puts
	call	bigdispscore
plosec:
	jr	checkscore

;-----=====display score (big font)=====-----
bigdispscore:
	ld	a,9
	ld	(curcol),a
	ld	hl,(score)
	call	_disphl
	ret

;-----=====display score (variable font)=====-----
dispscore:
	call	_setxxxxop2
	call	_op2toop1
	ld	a,4
	jp	_dispop1a

;-----=====check for a new high score=====-----
checkscore:
	ld	hl,(file)
	inc	hl
	push	hl
	call	$4000
	ex	de,hl
	ld	hl,(score)
	call	vector2		; check high
	ex	de,hl
	pop	hl
	ld	(hl),e
	inc	hl
	ld	(hl),d
	jr	z,newscore
	call	waitkey
	jp	res_main

;-----=====display text for new high=====-----
newscore:
	call	_clrLCDFULL
	set	textinverse,(iy+textflags)	
	ld	hl,0100h
	ld	(currow),hl
	ld	hl,newhigh
	call	_puts
	res	textinverse,(iy+textflags)
	ld	hl,0201h
	ld	(currow),hl
	ld	hl,scrtext
	call	_puts
	ld	hl,(file)
	inc	hl
	push	hl
	call	$4000
	call	bigdispscore
	ld	hl,0007h
	ld	(currow),hl
	ld	hl,del_text
	call	_puts
	ld	hl,0004h
	ld	(currow),hl
	ld	hl,ntxt
	call	_puts
	pop	hl
	inc	hl
	inc	hl
	ld	a,10
	ld	b,0
	ld	(mnu),hl
	ld	ix,(mnu)				; get hl to ix (mnu is just temporary)
	call	vector9				; get name (string input)
	jp	res_main

;-----====add a bonus for the number of lives left=====-----
bonus:
	ld	hl,(score)
	ld	a,(plives)
	ld	c,a
bonusl1:
	ld	b,a
	ld	de,0
	ld	a,(speed)
	or	a
	jr	z,bonusl1_nxt
	inc	de
bonusl1_nxt:
	inc	de
bonusl:
	add	hl,de
	djnz	bonusl
	dec	c
	ld	a,c
	or	a
	jp	nz,bonusl1
	ld	(score),hl
	ret

;-----=====player presses right=====-----
pright:
	ld	a,1
	ld	(ppos),a
	jp	gamec

;-----=====player presses left=====-----
pleft:
	ld	a,2
	ld	(ppos),a
	jp	gamec

;-----=====player presses down=====-----
pdown:
	ld	a,3
	ld	(ppos),a
	jp	gamec

;-----=====player presses up=====-----
pup:
	ld	a,4
	ld	(ppos),a
	jp	gamec

;-----=====player presses MODE=====-----
pause:
	call	_clrLCDFULL
	call	_GetK
	set	textinverse,(iy+textflags)
	ld	hl,0122h
	ld	(pencol),hl
	ld	hl,levtext
	call	_vputs
	ld	a,(lvl)				; level #
	call	_setxxop1
	ld	a,2
	call	_dispop1a
	res	textinverse,(iy+textflags)
	ld	hl,0f1ch
	ld	(pencol),hl
	ld	hl,pmessage				; game paused
	call	_vputs
	ld	de,2217h
	ld	(pencol),de
	call	_vputs				; pname
	ld	de,2a17h
	ld	(pencol),de
	call	_vputs				; cname
	ld	hl,2232h
	ld	(pencol),hl
	ld	a,(plives)
	call	_SETXXOP1
	ld	a,2
	call	_DISPOP1A
	ld	hl,2a32h
	ld	(pencol),hl
	ld	a,(clives)
	call	_SETXXOP1
	ld	a,2
	call	_DISPOP1A
	ld	hl,3900h
	ld	(pencol),hl
	ld	hl,scrtext
	call	_vputs
	ld	hl,(score)				; score
	call	dispscore
	call	waitkey
	call	_clrLCDFULL
	xor	a
	ret

;-----=====setup the test for a wall (locate ship)=====-----
locate:
	ld	hl,compress_buffer
	ld	a,(ty2)
	call	find
	ld	a,e
	ld	(tempEy),a
	ld	a,d
	ld	b,a
	ld	(tempDy),a
	inc	b
	ld	de,12
	sbc	hl,de
locate_inc_y:
	add	hl,de
	djnz	locate_inc_y
	ld	a,(tx2)
	call	find
	ld	a,e
	ld	(tempEx),a
	ld	a,d
	ld	c,a
	ld	(tempDx),a
	ld	b,0
	add	hl,bc
	ret

;-----=====test for a wall on the right=====-----
testright:
	ld	a,(tempDx)
	cp	11
	jr	z,testr2
	inc	hl
	jr	testx
testr2:
	ld	a,b
	ld	bc,11
	sbc	hl,bc
	ld	b,a
	jr	testx
	
;-----=====test for a wall on the left=====-----
testleft:
	ld	a,(tempDx)
	or	a
	jr	z,testl2
	dec	hl
	jr	testx
testl2:
	ld	a,b
	ld	bc,11
	add	hl,bc
	ld	b,a

;-----=====test for walls in the x direction=====-----
testx:
	ld	a,(tempEx)
	cp	b
	ret	nz
	ld	a,(tempEy)
	ld	b,d
	ld	c,0
testxll:
	cp	c
	jr	z,testx2
	inc	c
	djnz	testxll
	jr	testx1
testx2:	
	ld	a,(hl)
	dec	a
	jr	z,wallyes
	ret
testx1:
	ld	a,(hl)
	dec	a
	jr	z,wallyes
	ld	bc,12
	add	hl,bc
	ld	a,(hl)
	dec	a
	jr	z,wallyes
	ret
	
;-----=====there is a wall=====-----
wallyes:
	ld	a,1		; even though a=0 when called, it only works this way!
	ld	(wall),a	; KEEP THIS AS "ld a,1" (otherwise, the ship passes through walls)
	ret

;-----=====test for a wall below=====-----
testdown:
	ld	a,(tempDy)
	cp	7
	jr	z,td2
	ld	a,b
	ld	bc,12
	add	hl,bc
	ld	b,a
	jr	testy	
td2:
	ld	hl,compress_buffer
	ld	a,(tempDx)
	ld	c,b
	ld	b,a
td2l:
	inc	hl
	djnz	td2l
	ld	b,c
	jr	testy

;-----=====test for a wall up=====-----
testup:
	ld	a,(tempDy)
	or	a
	jr	z,tu1
	ld	a,b
	ld	b,12
testupl:
	dec	hl
	djnz	testupl
	ld	b,a
	jr	testy
tu1:
	ld	a,d
	ld	de,84
	add	hl,de
	ld	d,a

;-----=====test for walls in the y direction=====-----
testy:
	ld	a,(tempEy)
	cp	b
	ret	nz
	ld	a,(tempEx)
	ld	b,d
	ld	c,0
testyll:
	cp	c
	jr	z,testy2
	inc	c
	djnz	testyll
	jp	testy1
testy2:	
	ld	a,(hl)
	dec	a
	jp	z,wallyes
	ret
testy1:
	ld	a,(hl)
	dec	a
	jp	z,wallyes
	inc	hl
	ld	a,(hl)
	dec	a
	jp	z,wallyes
	ret

;-----=====find where the players are (d mod e)=====-----
find:
	ld	c,0
	ld	e,8
findl:
	ld	b,e
	inc	a
findl2:
	cp	b
	jr	z,find3
	djnz	findl2
	dec	a
	sub	e
	inc	c
	jr	findl
find3:
	ld	d,c
	ld	e,a
	dec	e
	ret

;-----=====player presses 2ND ---- draw/erase the fire sprite=====-----
pshoot:
	call	mplyr
	call	strtshoot
	call	pshback
	jp	gamec2

;-----=====start to shoot player's/computer's shot=====-----
strtshoot:
	ld	a,(tsht)
	dec	a
	ret	z
	ld	a,1
	ld	(tsht),a
	ld	a,(tpos)
	dec	a			; 1=right
	call	z,sht_right
	dec	a			; 2=left
	call	z,sht_left
	dec	a			; 3=down
	call	z,sht_down
	dec	a			; 4=up
	call	z,sht_up
	ret	

sht_right:
	call	locate		; find location (finds D mod E)
	ld	b,2
	ld	d,3
	call	testright		; test for a wall
	call	locate
	ld	b,1
	ld	d,3
	call	testright
	call	locate
	ld	b,0
	ld	d,3
	call	testright
	ld	a,(wall)
	dec	a			; 1=wall found
	jp	z,no_sht
	ld	a,1
	ld	(tshtpos),a
	ld	a,(tempDx)
	cp	11
	jp	z,no_sht
	cp	10
	jr	z,sht_r_chk
sht_r_cont:	
	ld	a,(tx2)
	ld	b,8
	add	a,b
	ld	(tshootx),a
	ld	a,(ty2)
	add	a,4
	ld	(tshooty),a
	call	firex
	xor	a
	ret
sht_r_chk:
	ld	a,(tempEx)
	or	a
	jr	z,sht_r_cont
	jp	no_sht

sht_left:
	call	locate
	ld	b,0
	ld	d,3
	call	testleft
	call	locate
	ld	b,1
	ld	d,3
	call	testleft
	call	locate
	ld	b,2
	ld	d,3
	call	testleft
	ld	a,(wall)
	cp	1
	jp	z,no_sht
	ld	a,2
	ld	(tshtpos),a
	ld	a,(tempDx)
	or	a
	jp	z,no_sht
	ld	a,(tx2)
	ld	b,8
	sub	b
	ld	(tshootx),a
	ld	a,(ty2)
	inc	a
	inc	a
	inc	a
	inc	a
	ld	(tshooty),a
	call	firex
	xor	a
	ret

sht_down:
	call	locate
	ld	b,2
	ld	d,3
	call	testdown
	call	locate
	ld	b,1
	ld	d,3
	call	testdown
	call	locate
	ld	b,0
	ld	d,3
	call	testdown
	ld	a,(wall)
	cp	1
	jp	z,no_sht
	ld	a,3
	ld	(tshtpos),a
	ld	a,(tempDy)
	cp	7
	jp	z,no_sht
	cp	6
	jr	z,sht_d_chk
sht_d_cont:
	ld	a,(ty2)
	ld	b,8
	add	a,b
	ld	(tshooty),a
	ld	a,(tx2)	
	add	a,4
	ld	(tshootx),a
	call	firey
	xor	a
	ret
sht_d_chk:
	ld	a,(tempEy)
	or	a
	jr	z,sht_d_cont
	jp	no_sht

sht_up:
	call	locate
	ld	b,0
	ld	d,3
	call	testup
	call	locate
	ld	b,1
	ld	d,3
	call	testup
	call	locate
	ld	b,2
	ld	d,3
	call	testup
	ld	a,(wall)
	dec	a
	jp	z,no_sht
	ld	a,4
	ld	(tshtpos),a
	ld	a,(tempDy)
	or	a
	jp	z,no_sht
	ld	a,(ty2)
	ld	b,8
	sub	b
	ld	(tshooty),a
	ld	a,(tx2)
	add	a,4
	ld	(tshootx),a
	jp	firey

no_sht:
	xor	a
	ld	(tsht),a
	ld	(wall),a
	ret

;-----=====show the player's shot=====-----
pshowshoot:
	call	pshsetup
	ld	a,1
	ld	(who),a
	ld	a,(pshtpos)
	dec	a
	call	z,st1
	dec	a
	call	z,st2
	dec	a
	call	z,st3
	dec	a
	call	z,st4
	
;-----=====return the temporary varibles=====-----
pshback:
	ld	a,(tlives)
	ld	(clives),a
	ld	a,(tsht)
	ld	(psht),a
	ld	a,(tshootx)
	ld	(pshootx),a
	ld	a,(tshooty)
	ld	(pshooty),a
	ld	a,(tx2)
	ld	(px),a
	ld	a,(ty2)
	ld	(py),a
	ld	a,(tshtpos)
	ld	(pshtpos),a
	xor	a
	ld	(tx),a
	ld	(ty),a
	ret

;-----=====setup the variables for the shot=====-----
pshsetup:
	ld	a,(clives)
	ld	(tlives),a
	ld	a,(psht)
	ld	(tsht),a
	ld	a,(pshootx)
	ld	(tshootx),a
	ld	a,(pshooty)
	ld	(tshooty),a
	ld	a,(cx)
	ld	(tx),a
	ld	a,(cy)
	ld	(ty),a
	ld	a,(px)
	ld	(tx2),a
	ld	a,(py)
	ld	(ty2),a
	ld	a,(ppos)
	ld	(tpos),a
	ld	a,(pshtpos)
	ld	(tshtpos),a
	ret

;-----=====show both the player's/computer's shot=====-----
st1:
	call	firex
	call	check
	ld	a,(tsht)
	or	a
	jp	z,stdone
	call	tempset
	call	locate
	ld	b,1
	ld	d,8
	call	testright
	call	locate
	ld	b,2
	ld	d,8
	call	testright
	call	locate
	dec	hl
	ld	b,1
	ld	d,8
	call	testright
	call	locate
	dec	hl
	ld	b,2
	ld	d,8
	call	testright
	call	tempback
	ld	a,(wall)
	cp	1
	jp	z,stdone
	ld	a,(tshootx)
	ld	c,85
	ld	b,8
st1l:
	inc	c
	cp	c
	jp	z,stdone
	djnz	st1l
	inc	a
	inc	a
	ld	(tshootx),a
	call	firex
	xor	a
	ret

st2:
	call	firex
	call	check
	ld	a,(tsht)
	or	a
	jp	z,stdone
	call	tempset
	call	locate
	ld	b,0
	ld	d,8
	call	testleft
	call	locate
	ld	b,1
	ld	d,8
	call	testleft
	call	locate
	inc	hl
	ld	b,0
	ld	d,8
	call	testleft
	call	locate
	inc	hl
	ld	b,1
	ld	d,8
	call	testleft
	call	tempback
	ld	a,(wall)
	dec	a
	jp	z,stdone
	ld	a,(tshootx)
	ld	c,2
	ld	b,c
st2l:
	dec	c
	cp	c
	jp	z,stdone
	djnz	st2l	
	dec	a
	dec	a
	ld	(tshootx),a
	call	firex
	xor	a
	ret	

st3:
	call	firey
	call	check
	ld	a,(tsht)
	or	a
	jp	z,stdone
	call	tempset
	call	locate
	ld	b,1
	ld	d,8
	call	testdown
	call	locate
	ld	b,2
	ld	d,8
	call	testdown
	call	locate
	ld	b,12
s3q:
	dec	hl
	djnz	s3q
	ld	b,1
	ld	d,8
	call	testdown
	call	locate
	ld	b,12
s3q2:
	dec	hl
	djnz	s3q2
	ld	b,2
	ld	d,8
	call	testdown
	call	tempback
	ld	a,(wall)
	dec	a
	jp	z,stdone
	ld	a,(tshooty)
	ld	c,55
	ld	b,8
st3l:
	inc	c
	cp	c
	jp	z,stdone
	djnz	st3l
	inc	a
	inc	a
	ld	(tshooty),a
	call	firey
	xor	a
	ret

st4:
	call	firey
	call	check
	ld	a,(tsht)
	or	a
	jp	z,stdone
	call	tempset
	call	locate
	ld	b,0
	ld	d,8
	call	testup
	call	locate
	ld	b,1
	ld	d,8
	call	testup
	call	locate
	ld	bc,12
	add	hl,bc
	ld	b,0
	ld	d,8
	call	testup
	call	locate
	ld	bc,12
	add	hl,bc
	ld	b,1
	ld	d,8
	call	testup
	call	tempback
	ld	a,(wall)
	dec	a
	jp	z,stdone
	ld	a,(tshooty)
	ld	c,2
	ld	b,c
st4l:
	dec	c
	cp	c
	jp	z,stdone
	djnz	st4l
	dec	a
	dec	a
	ld	(tshooty),a
	call	firey
	xor	a
	ret

tempset:
	ld	a,(tx2)
	ld	(mnu),a
	ld	a,(ty2)
	ld	(aps),a
	ld	a,(tshootx)
	ld	(tx2),a
	ld	a,(tshooty)
	ld	(ty2),a
	ret
tempback:
	ld	a,(mnu)
	ld	(tx2),a
	ld	a,(aps)
	ld	(ty2),a
	ret

;-----=====checks for a direct hit=====-----
check:
	ld	a,(tx)
	ld	c,a
	dec	c
	ld	b,6
	ld	a,(tshootx)
checkll:
	inc	c
	cp	c
	jp	z,check2
	djnz	checkll
	jp	hitdone
check2:
	ld	a,(ty)
	ld	c,a
	dec	c
	ld	b,6
	ld	a,(tshooty)
checkll2:
	inc	c
	cp	c
	jp	z,hit
	djnz	checkll2
	jp	hitdone
hit:
	ld	a,(who)
	dec	a
	call	z,showcomp
	dec	a
	call	z,showplayer
	ld	b,9
	ld	c,2
	ld	a,(ty)
	ld	l,a
	ld	a,(tx)
	ld	ix,explode
	call	vector0
	call	vector1
	call	_GetK
	ld	a,(tlives)
	dec	a
	ld	(tlives),a
	ld	a,1
	ld	(kflag),a
	ld	a,(who)
	dec	a
	call	z,hitc
	dec	a
	call	z,hitp
	call	_vputs
	call	waitkey
	xor	a
	ld	(tsht),a
hitdone:
	ret

hitc:
	ld	a,2
	ld	(killed),a
	ld	a,(diff)		; difficulty level
	dec	a
	call	z,hitc_easy
	dec	a
	call	z,hitc_hard
	ld	hl,(score)
	add	hl,bc
	ld	(score),hl
	ld	hl,1b1ch
	ld	(pencol),hl
	ld	hl,chhtt
	xor	a
	ret
hitc_easy:
	ld	bc,5
	ld	a,(speed)
	or	a
	ld	a,2
	ret	z
	ld	bc,15
	ret
hitc_hard:
	ld	bc,10
	ld	a,(speed)
	dec	a
	ret	nz
	ld	bc,20
	ret

hitp:
	inc	a
	ld	(killed),a
	ld	hl,1b1dh
	ld	(pencol),hl
	ld	hl,phhtt
	ret

;-----=====the shot has ended=====-----
stdone:
	xor	a
	ld	(tsht),a
	ld	(wall),a
	ret	

;-----=====show/take away the shot=====-----
firex:
	ld	a,(tsht)
	or	a
	ret	z
	call	firexy
	ld	a,1
	ld	(sh),a
	ld	hl,sfirex
	ld	(sprt),hl
	jp	sprite

firey:
	ld	a,(tsht)
	or	a
	ret	z
	call	firexy
	ld	a,8
	ld	(sh),a
	ld	hl,sfirey
	ld	(sprt),hl
	jp	sprite
	
firexy:
	ld	a,(tshootx)
	ld	(sx),a
	ld	a,(tshooty)
	ld	(sy),a
	ret	

;-----=====show player=====-----
showplayer:
	ld	a,(px)
	ld	(sx),a
	ld	a,(py)
	ld	(sy),a
	ld	a,(ppos)
	ld	b,a
	ld	hl,spos1-6
	ld	de,6
	ld	a,e
	ld	(sh),a
showploop:
	add	hl,de
	djnz	showploop
	ld	(sprt),hl
	jp	sprite

;-----=====(same as above) show computer=====-----
showcomp:
	ld	a,(cx)
	ld	(sx),a
	ld	a,(cy)
	ld	(sy),a
	ld	a,(cpos)
	ld	b,a
	ld	hl,spos1-6
	ld	de,6
	ld	a,e
	ld	(sh),a
sp1:	add	hl,de
	djnz	sp1
	ld	(sprt),hl
	jp	sprite

;-----=====++-*--SHOW SPRITE--*-++=====-----
sprite:
	ld	a,(sh)
	ld	b,a			; height
	ld	a,(sy)
	ld	l,a			; y-coord
	ld	a,(sx)		; x-coord
	ld	ix,(sprt)
	jp	vector5

;----------==========move the player==========----------
mplyr:
	call	pshsetup
	call	mbegin
	xor	a
	ld	(wall),a
	call	pshback
	jp	showplayer

;--------========move either the player or the computer========--------
mbegin:
	ld	a,(tpos)
	dec	a
	jp	z,mp1
	dec	a
	jp	z,mp2
	dec	a
	jp	z,mp3
	jp	mp4

mp1:
	call	locate
	ld	b,2
	ld	d,3
	call	testright
	ld	a,(wall)
	dec	a
	ret	z
	ld	a,(tx2)
	inc	a
	cp	91
	call	z,rlbt
	ld	(tx2),a
	ret

mp2:
	call	locate
	ld	b,0
	ld	d,3
	call	testleft
	ld	a,(wall)
	dec	a
	ret	z
	ld	a,(tx2)
	or	a
	call	z,ltr
	dec	a
	ld	(tx2),a
	ret

mp3:
	call	locate
	ld	b,2
	ld	d,3
	call	testdown
	ld	a,(wall)
	dec	a
	ret	z
	ld	a,(ty2)
	inc 	a
	cp	59
	call	z,rlbt
	ld	(ty2),a
	ret

mp4:
	call	locate
	ld	b,0
	ld	d,3
	call	testup
	ld	a,(wall)
	dec	a
	ret	z
	ld	a,(ty2)
	or	a
	call	z,ttb
	dec	a
	ld	(ty2),a
	ret

rlbt:
	xor	a
	ret
ltr:
	ld	a,91
	ret
ttb:
	ld	a,59
	ret

;----------==========decide how the computer moves==========----------
mcomp:
	ld	a,(cx)
	ld	c,a
	ld	a,(px)
	ld	b,9
qcl1:
	cp	c
	jp	z,mvca
	djnz	qcl1
	ld	a,(cy)
	ld	c,a
	ld	a,(py)
	ld	b,9
qcl2:
	cp	c
	jp	z,mvcb
	djnz	qcl2
mcomp2:
	call	cshsetup
	call	mbegin
	call	cshback
	ld	a,(wall)
	cp	1
	jp	z,rebound
mcomp2a:	
	xor	a
	ld	(wall),a
	call	showcomp
	ld	a,(who)
	cp	3
	call	z,mvcsht
mcomp4:
	ret

rebound:
	ld	a,(cpos)
	dec	a
	xor	1
	inc	a
	ld	(cpos),a
	xor	a
	ld	(wall),a
	call	cshsetup
	call	mbegin
	call	cshback
	jp	mcomp2a

;-----=====the opponents are lined up x-cordinate wise=====-----
mvca:
	ld	b,31
	ld	a,(diff)
	cp	1
	call	z,mvcaeasy
	ld	a,(py)
mvcal:
	dec	a
	jp	z,mvcatop
	djnz	mvcal
	ld	b,31
	ld	a,(diff)
	dec	a
	call	z,mvcaeasy
	ld	a,(py)
mvcal2:
	inc	a
	cp	56
	jp	z,mvcabot
	djnz	mvcal2
	jp	mvcadone
mvcatop:
	ld	a,4
	ld	(cpos),a
	jp	mvcadone
mvcabot:
	ld	a,3
	ld	(cpos),a
mvcadone:
	ld	a,3
	ld	(who),a
	jp	mcomp2

mvcaeasy:
	ld	b,16
	ret

;-----=====the opponents are lined up y-coordinate wise=====-----
mvcb:
	ld	b,44
	ld	a,(diff)
	dec	a
	call	z,mvcbeasy
	ld	a,(px)
mvcbl:
	dec	a
	jp	z,mvcbleft
	djnz	mvcbl
	ld	b,44
	ld	a,(diff)
	dec	a
	call	z,mvcbeasy
	ld	a,(px)
mvcbl2:
	inc	a
	cp	87
	jp	z,mvcbright
	djnz	mvcbl2
	jp	mvcbdone
mvcbleft:
	ld	a,2
	ld	(cpos),a
	jp	mvcbdone
mvcbright:
	ld	a,1
	ld	(cpos),a
mvcbdone:
	ld	a,3
	ld	(who),a
	jp	mcomp2
		
mvcbeasy:
	ld	b,16
	ret

;-----=====The computer wants to shoot (same code as the player)=====-----
mvcsht:
	ld	a,(csht)
	dec	a
	ret	z
	call	strtshoot
	jp	cshback

;-----=====show the computer's shot=====-----
cshowshoot:
	call	cshsetup
	ld	a,2
	ld	(who),a
	ld	a,(cshtpos)
	dec	a
	call	z,st1
	dec	a
	call	z,st2
	dec	a
	call	z,st3
	dec	a
	call	z,st4

;-----=====return the temporary variables=====-----	
cshback:
	ld	a,(tlives)
	ld	(plives),a
	ld	a,(tsht)
	ld	(csht),a
	ld	a,(tshootx)
	ld	(cshootx),a
	ld	a,(tshooty)
	ld	(cshooty),a
	ld	a,(tx2)
	ld	(cx),a
	ld	a,(ty2)
	ld	(cy),a
	ld	a,(tshtpos)
	ld	(cshtpos),a
	xor	a
	ld	(tx),a
	ld	(ty),a
	ret

;-----=====setup vars for shot=====-----
cshsetup:
	ld	a,(plives)
	ld	(tlives),a
	ld	a,(csht)
	ld	(tsht),a
	ld	a,(cshootx)
	ld	(tshootx),a
	ld	a,(cshooty)
	ld	(tshooty),a
	ld	a,(px)
	ld	(tx),a
	ld	a,(py)
	ld	(ty),a
	ld	a,(cx)
	ld	(tx2),a
	ld	a,(cy)
	ld	(ty2),a
	ld	a,(cpos)
	ld	(tpos),a
	ld	a,(cshtpos)
	ld	(tshtpos),a
	ret

;---------= Get a level set =---------
getLevelSet:
	ld	hl,(fat_location)
	ld	ix,detection_string
	call	detect
	ld	(fat_location),de		; location of level set
	ld	(file),hl
	ret
detection_string:
	.db	"FJets1",0

;-----------==========text==========------------
menuspaces:	.db	"                ",0
title:	.db	" Fighter Jets 83 v2.3",0
author:	.db	"       Kashan A. Shaikh       ",0
tlevnum:	.db	"up/down - Level:",0
tdiff:	.db	"alpha - Difficulty:",0
teasy:	.db	"easy",0
thard:	.db	"hard",0 
tspeed:	.db	"X,T,0,n - Speed:",0
tslow:	.db	"slow",0
tfast:	.db	"fast  ",0
tback:	.db	"2nd-done",0
tmode:	.db	"mode  -  levelset",0
topt:		.db	"alpha  - options",0
tdel:		.db	"del     -     quit",0
m1:		.db	" 2ND to Start",0
inst5:	.db	"any key to continue...",0
pmessage:	.db	"Game Paused",0
pname:	.db	"Player:           lives",0
cname:	.db	"Enemy:            lives",0
levtext:	.db	"   Level ",0
phhtt:	.db	"Death to You!",0
chhtt:	.db	"Enemy is hit!",0
new:		.db	"You beat that level!",0
loser:	.db	"Ship Destroyed",0
hscrtext:	.db	"HighScore:   ",0
scrtext:	.db	"Score:   ",0
newhigh:	.db	"New HighScore!",0
ntxt:		.db	"Name:",0
del_text:	.db	"alpha/del/<-/->",0

;-----=====sprites=====-----
spos1:
	.db	%11000000
	.db	%11101000
	.db	%00111100
	.db	%00111100
	.db	%11101000
	.db	%11000000
spos2:
	.db	%00001100
	.db	%01011100
	.db	%11110000
	.db	%11110000
	.db	%01011100
	.db	%00001100
spos3:
	.db	%11001100
	.db	%11001100
	.db	%01111000
	.db	%00110000
	.db	%01111000
	.db	%00110000
spos4:	
	.db	%00110000
	.db	%01111000
	.db	%00110000
	.db	%01111000
	.db	%11111100
	.db	%11001100
sfirex:
	.db	%11111111	
sfirey:
	.db	%10000000
	.db	%10000000
	.db	%10000000
	.db	%10000000
	.db	%10000000
	.db	%10000000
	.db	%10000000
	.db	%10000000
explode:
	.db	%10010000,%10000000
	.db	%00101010,%00000000
	.db	%01100011,%00000000
	.db	%00001000,%10000000
	.db	%01010101,%00000000
	.db	%10001000,%00000000
	.db	%01100011,%00000000
	.db	%00101010,%00000000
	.db	%10000100,%10000000
block1:
	.db	%11111111
	.db	%10100101
	.db	%11111111
	.db	%10111101
	.db	%10111101
	.db	%11111111
	.db	%10100101
	.db	%11111111
block2:
	.db	%11111111
	.db	%10101011
	.db	%11010101
	.db	%10101011
	.db	%11010101
	.db	%10101011
	.db	%11010101
	.db	%11111111
block3:
	.db	%11111111
	.db	%10000001
	.db	%10111101
	.db	%10100101
	.db	%10100101
	.db	%10111101
	.db	%10000001
	.db	%11111111
block4:
	.db	%11111111
	.db	%11011011
	.db	%10111101
	.db	%11111111
	.db	%11111111
	.db	%10111101
	.db	%11011011
	.db	%11111111
block5:
	.db	%11011011
	.db	%01011010
	.db	%10100101
	.db	%10011001
	.db	%10011001
	.db	%10100101
	.db	%01011010
	.db	%11011011
block6:
	.db	%10111011
	.db	%11101110
	.db	%10111011
	.db	%11101110
	.db	%10111011
	.db	%11101110
	.db	%10111011
	.db	%11101110
block7:
	.db	%01010010
	.db	%11001011
	.db	%00000000
	.db	%10011010
	.db	%01011001
	.db	%00000000
	.db	%11010011
	.db	%01001010
block8:
	.db	%11011011
	.db	%10100101
	.db	%01011010
	.db	%10100101
	.db	%10100101
	.db	%01011010
	.db	%10100101
	.db	%11011011
block9:
	.db	%10101010
	.db	%01010101
	.db	%10101010
	.db	%01010101
	.db	%10101010
	.db	%01010101
	.db	%10101010
	.db	%01010101
block10:
	.db	%11011011
	.db	%00111100
	.db	%01000010
	.db	%10100101
	.db	%10100101
	.db	%01000010
	.db	%00111100
	.db	%11011011

#include "fjttl.asm"

.end
END























