;Start at end of video mem:
SideScrollLeft:
	PUSH	DE		;SAVE DE
	LD	DE,LVLBUFFER	;buffer for the next "block" of level

        ;Start at the defined row. (acutally scrolls from the bottom row to the top row)
        ld      HL, VIDEOMEM + (SCROLLTOROW*COLUMNS) - 1

        ld      C, SCROLLTOROW-SCROLLFROMROW           ;64 lines of video memory to go through!
        ld      B,0                     ;For "wrapping"
sclNextLine:                               ;This is processed every 12 bytes (every line)
#IFDEF WRAP
        ;You can include the following for "wrap around"
        PUSH    HL      ;10
        ;HL = HL - 11   --->
        LD      A,L     ;4
        SUB     11d     ;7               ;**
        LD      L,A     ;4
        LD      A,H     ;4
        SBC     A,B     ;4                ;B is 0 from previous loop!
        LD      H,A     ;4
                        ;---> 27 cycles.
        LD      A,(HL)  ;7
        RLA             ;4                ;**Put this bit into carry read for the next write
        ;Now carry contains the value of bit 7 of the start of line.
        POP     HL      ;10
        ;-----End of wrap around addition (58 cycles in total)

#ELSE
        ;Clear any extraneous Bit from the last pixel shifted (e.g. the one that disappears off the screen)
        OR      A 
	;This clears the carry flag and doesn't affect anything else.
#ENDIF
					; Here we use the level buffer to put in the next block that is already
					; loaded in the level buffer awaiting us.

	LD	A,(DE)			
	RLCA
	LD	(DE),A

   ;Load the pending pixel from the hidden buffer into Carry
	;Save the rotated bit, so the next pixel will be scrolled next time!
	INC	DE	;Get ready for next line!
	LD      B,COLUMNS               ;12 bytes per line (at 96 pixels across the screen)
	
ShiftLine:
   RL      (HL)                    ;Shift everything along one pixel, putting carry into 8th pixel and 1st pixel into carry
   DEC     HL                      ;Get next byte along in video memory!
   DJNZ    ShiftLine
       
   DEC     C
   JP      NZ, sclNextLine
	POP 	DE
   RET

;Initialises the level pointer, sets the floorpos to 48 for the next 6 positions
;Loads FloorCountDn with 6
;
InitLevel:
	;Load in the starting positions for the floor
	ld a,FloorPos
	LD HL,FloorRearY
	LD B,9d
Init_NextFloorByte:
	LD (HL),A
	INC HL
	DJNZ Init_NextFloorByte      

;Set the buffer to zero (white)
	LD B,96d
	LD HL,LVLBUFFER
	XOR A
Init_NextBufferByte:
	LD (HL),A
	INC HL
	DJNZ Init_NextBufferByte

;Set the buffer to zero (white)
	LD B,9d
	LD HL,FloorInfoRear
	XOR A
Init_NextInfoByte:
	LD (HL),A
	INC HL
	DJNZ Init_NextInfoByte

InitTime:
	ld HL,LevelData

	;Load the starting time into Time
	LD	DE,Time
	LD	BC,2
	LDIR

	LD (LevelPtr),HL

	ret 


;This routine loads the appropriate graphics into the level buffer
;It sets the Floor positions according to the new strip being loaded.
LoadBuffer:
;----------Setup buffer pointer
;------------------------------
	LD DE, LVLBUFFER
;------------Set up variables (FillerAmount)
;-------------------------------------
	XOR A
        LD (FillerAmount),A

;----------Access Level Data
;---------------------------
LvlNextByte:
	ld 	HL,(LevelPtr)
	ld 	C,0
	ld 	A,(HL)
	INC 	HL
	LD 	(LevelPtr),HL
	
;----------Process Level Strips
;------------------------------
	;We have the first byte of the strip in A
	;Now process level data, strip by strip.
	or 	a		;Is this end of the strip?
        jp 	z, FinishStrip
	
	INC	A 		;IF A=0FFh then this signals end of level, INC A will set Zero Flag so
	jp 	nz, NextEndTest ;If not zero set then continue else

	;Here we need to handle end of level - scoring etc. 
	call EndLevel		;This sub slows down the bike and prints the new level number....
	jp			LoadBuffer ;Was LvlNextByte

NextEndTest:
	INC	A		;IF A=0FEh this is the end of the game!!! so since A has been inced to FF we will get zero here		
	jp nz,NextPiece

   JP    EndGame

;   CALL  InitTime ;Load the timer for the first level in the game again, and update LevelPtr.
;   jp LoadBuffer  ;Start again on the next line

NextPiece:
	SUB 	3d
	;Else it is a graphic number so fetch the graphics stuff
;-------------Get Pointer to required Graphic Block
;-----------------------------------
#ifdef  DEBUG
	ld HL,GraphTab
;        dec A    ;Because start of table is at offset 0, not offset 2 :+)
	sla A    ;Multiply A by two to access the graphics table
	ADD A,L	 ;Add this offset to the table pointer, to get pointer to graphic
	LD  L,A
        LD A,H
        ADC A,0
        LD H,A
        ;HL points to pointer in GraphTab (e.g. points to Brick)
        ;Now get the required pointer in BC
        LD C,(HL)
	INC HL
        LD B,(HL)
		;Could do perhaps LD L,(HL); LD H,B???
	LD H,B
	LD L,C
#else
	ld HL,Graphics	;NEW was GraphTab not Graphics
;        dec A    ;Because start of table is at offset 0, not offset 2 :+)
	sla A    ;Multiply A by two to access the graphics table
	sla A	 ;Multiply A by four (4 bytes per graphic)		;NEW
	ADD A,L	 ;Add this offset to the table pointer, to get pointer to graphic
	LD  L,A
        LD A,H
        ADC A,0
        LD H,A
#endif
	;DE points to level buffer
;---------------Load Graphic into Strip Buffer
;---------------------------------------------
	LD BC,4	;4 bytes to load
	LDIR	;Let (DE):=(HL), inc DE,HL, until BC=0
	
 ;Update our FillerAmount count 
        LD A,(FillerAmount)
	INC A
        LD (FillerAmount),A
	
	jr LvlNextByte ;Go fetch the next byte of level data
FinishStrip:
	
	;HL = LVLPointer 
	LD A,(HL)		;Read in safety/bounce/bounds information about the block
	INC HL			;Now point to next byte of level
	LD (LevelPtr),HL	;
	;------------------------Do nothing about this stuff for now...
	;-----------Update the block information ----------
	;This is stored in the same way as the floor positions (see below for more info)
	PUSH DE				;Save pointer to level buffer (LVLBUFFER)
	LD	DE,FloorInfoRear
	LD	HL,FloorInfoBack
	LD	BC,7
	LDIR
	LD	(DE),A			;Save the floor info byte
	
	;-----------Update the floor positions-------------
	;Have 8 bytes in memory containing the floor positions for each of the 8 
	;strips under and in the bike's path
	;EndFloorPosY points to the last byte in this array
	;Here we should shift along all the bytes and pop the next one on the end
	;FloorBackY is the 1st byte, FloorFrontY points to the 2nd byte in this 
	;8 byte buffer.

	LD	DE,FloorRearY
	LD	HL,FloorBackY
	LD	BC,7			;9 bytes to shift, the 9th we will fill with the floor position of the strip being copied into the buffer
	LDIR
	
	LD 	A,(FillerAmount)
	LD 	B,A			;Save the block height of the strip
	;Here we have the floorpos and we set the floor position :) 
	OR	A		;Clear carry flag
   	SLA A               ;Multiply A by 4, each block is 4 pixels high
	SLA	A
	LD	C,A
	LD	A,FloorPos
	SUB	C
	;INC	DE
	LD 	(DE),A		;Let EndFloorPosY = FloorPos for this strip
	POP 	DE
	LD	A,B		;Load the block height of the strip
	
	;---------------height is now in A----------------
	SUB 	7	;Maximum height
	JR	Z,NoFill
	NEG 	;Negate A - make positive - so we know how many blocks to fill with 0 (white)...
	LD C,A	;For loop counter
	XOR A

   ;4 Bytes Per Block
FillNextBlock:
	LD B,4
FillNextByte:	
	LD (DE),A
        INC DE
	DJNZ FillNextByte
	DEC C
	JR	NZ, FillNextBlock
NoFill:
	;Reload the ReLoadCounter :)
	LD	A,8d;
	LD	(ReLoadCounter),A	;Voila... ready for next time...

	;Now check to see if level marker has to be added to buffer:
        ;Here it is assumed that DE points to the end of the level buffer
	LD	HL,(LevelPtr)
	LD	A,(HL)
   	CP	0FFh
	;INC	A		;0FFh = end of level marker, so inc FF means Z=1
	JP	NZ,NoMarker

#ifdef DEBUG
	LD	(DebugLoc),A
#endif

LevelMarker:
	LD	HL,LVLBUFFER+24d	;The 6th position up
	LD	DE,Graphics
	LD	C,216d			;55d = LevelEndMarker, 54*4 = 216 (the location in the graphics block)
	LD	B,0
	EX	DE,HL
	ADD	HL,BC
	LD	BC,4
	LDIR			;Load the graphic in at the right spot
NoMarker:
	RET

;---------------------------------Graphics/Sprites & Related information -------------------------------------
;
;Levels have the following format:
; up to 9  bytes:
;88
;7777
;666666	    666
;55555555555555
;44444444444444
;33333333333333
;22222222222222
;11111111111111
;-------------------
;Each strip is 0 terminated
;After each strip there is an extra byte appended indicating:
;-Safe/Unsafe    (So any graphics can be used)
;-Normal/Bouncy  (To implement springs)
;-Square/Rounded (For future use, affects bounds checking)
;
;00000000b
;    ^^^^
;    ||||---Safe to land=0/Unsafe/die = 1
;    |||-------Normal=0/Spring=1
;    ||-----------Square=0/Circle=1
;    |---------------Safe starting point (always advances to one of these when you die
;Safe Starting = 08h

;Each byte has a graphic number: e.g.
;1 = black block
;2 = brick
;3 = dirt
;4= thickbrick
;5= CounterBlock
;6=potholestart	
;7=potholemid
;8=potholeend
;9-16 Bus Graphic
;17-19 Spring Graphic

;Spring is 3x1 (wide,tall)
;Goes from 17-19
;123 or 13 for small springs etc.
;---Bus - 2x4 (wide,tall)
;---So for us that 2x8
;---Bus goes from 9-16
;---12
;---34
;---56
;---78
;Gate goes from 20-35
;arranged horizontall in 4 strips
;[01][02][03][04]
;[05][06][07][08]
;[09][10][11][12]
;[13][14][15][16]
;.db 32,28,24,20,0,1
;.db 33,29,25,21,0,1
;.db 34,30,26,22,0,1
;.db 35,31,27,23,0,1
;
;Tree goes from 36 to 59-----NOT INCLUDED any more....
;like so
;[22][19][16][13][10][07][04][01]
;[23][20][17][14][11][08][05][02]
;[24][21][18][15][12][09][06][03]
;.db 57,54,51,48,45,42,39,36
;.db 58,55,52,49,46,43,40,37
;.db 59,56,53,50,47,44,41,38

;Small tree goes from 36 to 43

;Drum goes from 44-47
;One drum:
;.db 46,44,0,1
;.db 47,45,0,1

;Stacking like so:
;.db 46,44,0,1
;.db 47,45,46,44,0,1
;.db 46,44,47,45,0,1
;.db 47,47,0,1
;This is a stack of two drums on bottom, one on top... 
 
;Ground is 48
;White is 49 (used for pre bus bits...)
;Line ground is 50 
;TopGround = 51
;LeftTopGround = 52
;RightTopGround = 53
;SinglePothole = 54
;EndLevelMarker = 55

Graphics:
;Graphics blocks are 8x4 which means 4 bytes per block
;N.B. Graphics are stored upside down!
BlackBrick:
.db 11111111b
.db 11111111b
.db 11111111b
.db 11111111b 
Brick:
.db 10001000b
.db 11111111b
.db 00100010b
.db 11111111b
Dirt:
.db 01010001b
.db 00100101b
.db 01000100b
.db 10111010b
ThickBrick:
.db 00100010b
.db 11111111b
.db 10010010b
.db 11111111b
CounterBlock:
.db 10000001b
.db 10000001b
.db 10000001b
.db 11111111b
PotholeStart:
.db 01110111b
.db 10101000b
.db 01100000b
.db 11000000b
PotholeMid:
.db 11010101b
.db 10000100b
.db 00000000b
.db 00000000b
PotholeEnd:
.db 11101010b
.db 01011111b
.db 00000110b
.db 00000011b

.INCLUDE "INCLUDE\\GRAPHICS\\BUS.DB"

SpringStart:
.db 00011111b
.db 01110001b
.db 00011100b
.db 11111111b

SpringMid:
.db 00111100b
.db 00111100b
.db 00011000b
.db 11111111b

SpringEnd
.db 11111000b
.db 10001110b
.db 00111000b
.db 11111111b

;Gate graphic is 32x16 pixels
;Means it is 4x4 blocks (wide,tall)
.INCLUDE "INCLUDE\\GRAPHICS\\GATE3.DB"


;OLD Tree graphic is 3x8 blocks (24x32 pixels)
;Tree graphic is 2x8 blocks (16x16 pixels)
.INCLUDE "INCLUDE\\GRAPHICS\\STREE.DB"

;Drum graphic is 2x2 (8x8 pixels)

.INCLUDE "INCLUDE\\GRAPHICS\\DRUM.DB"
;To include a stack do
;

Ground:
.db 11001100b
.db 00110011b
.db 11001100b
.db 00110011b

White:
.db 00000000b
.db 00000000b
.db 00000000b
.db 00000000b

LineGround:
.db 01111011b
.db 11010110b
.db 00000000b
.db 11111111b

TopGround:
.db 11001100b
.db 00110011b
.db 11111111b
.db 11111111b

LeftTopGround:
.db 11001100b
.db 11110011b
.db 11111111b
.db 11111111b

RightTopGround:
.db 11001111b
.db 00110011b
.db 11111111b
.db 11111111b

SinglePothole:
.db 11111111b
.db 11000011b
.db 10000001b
.db 00000000b

EndLevelMarker:
.db 00011000b
.db 00111100b
.db 01111110b
.db 11111111b

EndGameMarker:
.db 00000000b
.db 00000000b
.db 01000100b
.db 11101110b

#ifdef DEBUG
;GraphTab is to be maintained for development stages (make life easier) but then done away with in the release version
GraphTab:
	.dw BlackBrick
	.dw Brick
	.dw Dirt
	.dw ThickBrick
	.dw CounterBlock
	.dw PotholeStart
	.dw PotholeMid
	.dw PotholeEnd
	.dw Bus1
	.dw Bus2
	.dw Bus3
	.dw Bus4
	.dw Bus5
	.dw Bus6
	.dw Bus7
	.dw Bus8
	.dw SpringStart
	.dw SpringMid
	.dw SpringEnd
	.dw Gate1
	.dw Gate2
	.dw Gate3
	.dw Gate4
	.dw Gate5
	.dw Gate6
	.dw Gate7
	.dw Gate8
	.dw Gate9
	.dw Gate10
	.dw Gate11
	.dw Gate12
	.dw Gate13
	.dw Gate14
	.dw Gate15
	.dw Gate16
	.dw Tree1
	.dw Tree2
	.dw Tree3
	.dw Tree4
	.dw Tree5
	.dw Tree6
	.dw Tree7
	.dw Tree8
	.dw Drum1
	.dw Drum2
	.dw Drum3
	.dw Drum4
	.dw Ground
	.dw White
	.dw LineGround
	.dw TopGround
	.dw LeftTopGround
	.dw RightTopGround
	.dw SinglePothole
	.dw EndLevelMarker
        .dw EndGameMarker

#endif

EndFiller:
