;Logic for sprite routine:
;Sprite must have 3 bytes per line, with the 3rd byte being 0
;Row in E
;Column in A
;Sprite address in BC - changing the routine!
;Sprite buffer address (used to shift sprite) in DE
	PUSH	BC	;11

	LD	B,A	;4
	; 12 Bytes per row - so do y*12
	XOR     A   	;4
	LD      D,A 	;4
	LD      H,A 	;4

	LD      A,E 	;4
	RLA             ;4 Carry flag will be clear at this point thanks to XOR A - Row*2
	ADD     A,E     ;4 Row*2+Row = Row*3
	LD      L,A     ;4 store this :-O
	ADD     HL,HL   ;11 Row*3*2
	ADD     HL,HL   ;11 Row*3*2*2=Row*12
	
	;Get the offset for the column
	LD	A,B	;4
	RRA		;4
	RRA		;4
	RRA		;4
	AND 	0Fh	;4 Cut off any of those rotated bits!
			;20 cycles
        
	;Now add the the column offset to the buffer offset
	LD	E,A	;4
	ADD	HL,DE	;11

	;Actually add the buffer address (to get the real buffer offset)
        LD      DE,VIDEOMEM ;10
	ADD     HL,DE	 ;11
	;Save this offset in DE
        LD      D,H	;4
        LD      E,L     ;4

	POP 	HL	;11
        
	;No offset in our custom version so on with the story.
        ;NOW - NOTE: HL = Sprite Buffer Address, DE = Position of sprite in video mem
	LD      C,16d           ; A 16 line sprite!
ILNextLine:
        LD      B,2		; 2 = two bytes to read per sprite line.
ILSprScreen:                      ; Put the sprite on the screen (XOR)
        LD      A,(DE)
        XOR     (HL)            ; XOR with sprite
        LD      (DE),A          ;_Put back to video screen!
        INC	DE
	INC 	HL

        DJNZ ILSprScreen
        ;Jump to the starting position on the next line of the buffer.
        ;So DE + 12-2 (2 is the width of the aligned sprite)
        LD      A,E     ;4
        ADD     A,12-2  ;7
        LD      E,A     ;4
        LD      A,0     ;7
        ADC     A,D     ;4
        LD      D,A     ;4 -- 30 cycles

        DEC     C	;4
	JP	NZ, ILNextLine	; Copy the three bytes to the screen!
