 .nolist
 #include "keys.inc"
 #include "ion.inc"
 .list

#ifdef TI83P                ;If it's an 83+
 .org    progstart-2        ;9D95h - 2, so 9D93h
 .db     $BB,$6D            ;I don't know what this is for...
#else                       ;otherwise
 .org    progstart          ;.org 9327h I believe
#endif                      ;end the if statement
 ret                        ;if it's run from the homescreen, exit.
 jr      nc,begin           ;where to go to start the program
 .db     "prgmBAD",0        ;the title
begin:                      ;this label declares all the variables
a = SafeRAM1+0              ;the first line
b = SafeRam1+1              ;the second line
c = SafeRam1+2              ;the third line
d = SafeRam1+3              ;the fourth line
e = SafeRam1+4              ;the fifth line
f = SafeRam1+5              ;the sixth line
g = SafeRam1+6              ;the seventh line
h = SafeRam1+7              ;the eighth line
i = SafeRam1+8              ;the ninth line
j = SafeRam1+9              ;the tenth line
k = SafeRam1+10             ;the eleventh line
l = SafeRam1+11             ;the twelfth line
m = SafeRam1+12             ;the thirteenth line
x = SafeRam1+103            ;menu variable/player's position
y = SafeRam1+104            ;???
hvar = SafeRam1+106         ;handy variable. used for miscellaneous purposes
var = SafeRam1+107          ;same as above (in case I need two vars at the same time.)
score = SafeRam1+109        ;your score
                            ;space :)
setup:                      ;label setup
 set textwrite,(iy+sgrflags);text on the buffer 
 ld a,17                    ;store seventeen to a
 ld (x),a                   ;17 to x
 bcall(_clrLCDFull)         ;clear the screen
start:                      ;label start
 call disptitle             ;routine that displays the title
 ld b,3
 ld hl,menu1
 call dispmenu
 ld a,39
 ld (penrow),a
 xor a
 ld (pencol),a
 ld hl,high1
 bcall(_vPutS)
 ld hl,(highscore)
 call vardisp

 call bardisp               ;display the bar in the correct spot
 call ionfastcopy           ;copy the graph buffer to the screen
 
;;;;menu keys;;;;
 bcall(_GetCSC)             ;get a key press
 cp skup                    ;Was it the up key?
 call z,up                  ;if it was, call label up
 cp skdown                  ;was it the down key?
 call z,down                ;if so, call label down
 cp skenter                 ;was enter pressed?
 jp z,second                ;then go to label second
 cp sk2nd                   ;was 2nd pressed?
 jp z,second                ;if so, then go to label second
 cp skmode                  ;was mode pressed?
 jp z,quit                  ;if so, go to label quit

 jp start                   ;go to label start

;;;;play the game;;;;
;this section starts off sorta confusing and is hard to explain. It might help you to not
;look at the comments :p lol
play: 
 bcall(_clrLCDFull)         ;clear the screen
 bcall(_GrBufClr)           ;clear the graph buffer
 ld hl,0000h
 ld (score),hl
 ld a,62 
 ld l,a
 ld b,2
 ld a,45                    ;load 45 into a
 ld (x),a                   ;load a into the variable x (the x position of the variable)
 ld ix,ship
 call ionputsprite
setupints:                  ;sets up the variables
 ld hl,(score)
 ld de,(rand)
 ld d,0
 add hl,de
 add hl,de
 ld a,(speed)
 ld b,a
 ld a,50
 sub b
 ld e,a
 ld d,0
 add hl,de
 ld (score),hl

 ld hl,SafeRAM1+0           ;load SafeRAM1 into hl (so we can store hl to SafeRAM1 later)
 xor a                      ;xors a (which sets a to 0)

 ld (y),a                   ;y is how far down from the top the pixel should be placed
 ld a,(rand)
rands:                      ;stores the random number
 ex af,af'
 ld b,94                    ;load 94 into b the limit
 push hl                    ;push hl (put it on the stack)
; can pop it and use it later on)
 call ionrandom             ;gets a random number between 0 and whatever is in b
                            ;then stores it to a
 pop hl                     ;pop hl for the same reason
 inc hl                     ;to load to
 ld (hl),a                  ;load it into the location in hl (saferam1 + xx)
 ex af,af'
 dec a
 jr nz,rands

ready:
 ld hl,SafeRAM1+0           ;load safeRAM1+0 into hl
 ld a,(rand)
disppoints:                 ;this label displays the lines
 ex af,af'
 inc hl
 ld a,(y)                   ;load the variable y (the y-location of the current line)
 ld e,a
 ld a,(hl)
 push hl
 call iongetpixel
 xor (hl)                   ;get the 'xor' of the offset [from the routine]
 ld (hl),a                  ;load the changes and write to the graph buffer
 pop hl
 ex af,af'
 dec a
 jp nz,disppoints
letsgo:                     ;running out of label names... this label displays the sprites and wraps all the previous
                            ;labels together.
 call ionfastcopy           ;display the graph buffer
 ld a,(y)                   ;load y (how far down the line currently is) into a
 inc a                      ;increase a by one
 ld (y),a                   ;load it back into y
 cp 64                      ;does it equal 64?
 jp z,setupints             ;if so, go to label setupints
DI:
 ld a,0ffh                  ;resets the keypad for Direct Input
 out (1),a                  ;I don't know what this does. I think it's something to do with opening the keyboard ports
                            ;or something.
 ld a,Group1                ;Enable group 1. (0FEh)
 out (1),a                  ;Dunno know what this does, either.
 in a,(1)                   ;???
 cp kright                  ;if the right arrow was pressed
 call z,shipright           ;call label shipright
 cp kleft                   ;if the left arrow was pressed
 call z,shipleft            ;call label shipleft
 ld a,0ffh                  ;resets the keypad for Direct Input
 out (1),a                  ;I don't know what this does. I think it's something to do with opening the keyboard ports
                            ;or something.
 ld a,Group7                ;Enable group 7. (0BFh)
 out (1),a                  ;Dunno know what this does, either.
 in a,(1)                   ;???
 cp kmode
 jp z,lose
 call ionfastcopy           ;display the graph buffer
 ld a,(y)
 cp 60
 jp nc,hit
return:
 ld a,(speed)
 ld b,a
delay:
 halt
 djnz delay
 jp ready                   ;go to label ready
shipright:
 ld a,(x)
 cp 93
 ret z
 add a,3
 ld e,62
 call iongetpixel
 and (hl)
 ret nz
 ex af,af'
 ld a,62
 ld l,a
 ld a,(x)
 ld b,2
 ld ix,ship
 call ionputsprite

 ld a,62
 ld l,a
 ld a,(x)
 inc a
 ld (x),a
 ld b,2
 ld ix,ship
 call ionputsprite
 ret
shipleft:
 ld a,(x)
 cp 0
 ret z
 dec a
 ld e,62
 call iongetpixel
 and (hl)
 ret nz

 ld a,62
 ld l,a
 ld a,(x)
 ld b,2
 ld ix,ship
 call ionputsprite

 ld a,62 
 ld l,a
 ld a,(x)
 dec a
 ld (x),a
 ld b,2
 ld ix,ship
 call ionputsprite
 ret
 
hit:                        ;checks if a line is touching your ship
 ld e,62
 ld a,(x)
 call iongetpixel
 and (hl)
 jp nz,lose
 ld e,61
 ld a,(x)
 inc a
 call iongetpixel
 and (hl)
 jp nz,lose
 ld e,62
 ld a,(x)
 add a,2
 call iongetpixel
 and (hl)
 jp nz,lose
 jp return                  ;return to where it was called from
 
;;;;other stuff;;;;
disptitle:                  ;this is the routine that displays the title at the top.
 bcall(_GrBufClr)           ;clear the graph buffer
 ld ix,title                ;load the label that the pic is in into ix
 ld a,10                    ;display it 10 pixels over
 ld hl,0
 ld l,0                     ;display it 0 pixels down (on the top line)
 ld bc,1009h                ;loads 16 to b(10 in hex is 16 in dec) and 9 to c
                            ;b is the height, c is how many bytes wide it is
 call ionlargesprite        ;display the sprite
 ret
options:                    ;this is the options screen
 call disptitle             ;display the title
 ld b,2
 ld hl,menu4
 call dispmenu
; ld a,17                    ;store 17 to a
; ld (penrow),a
; xor a
; ld (pencol),a
; ld hl,menu4                ;load the text in the label menu1 to hl
; bcall(_vputs)              ;display it aligned in the center
; ld a,23                    ;store 29 to a
; ld (penrow),a
; xor a
; ld (pencol),a
; ld hl,menu6                ;load the text in the label menu3 to hl
; bcall(_vputs)              ;display it aligned in the center

 ld hl,1130h                ;load 17 (the numbers are in hex) into h and 76 into l
 ld (pencol),hl             ;load l to (pencol) and h to (penrow) (penrow is
                            ;the next byte after (pencol))
 ld hl,(rand)               ;load the variable speed into l (because it is one byte)
 ld h,0
 call vardisp               ;call the label vardisp (to display it at the coordinates
                            ;in (pencol) and (penrow))
 ld hl,1716h                ;load 29 into h and 60 into l
 ld (pencol),hl             ;load l to (pencol) and h to (penrow) (penrow is the next byte after (pencol))
 ld hl,(speed)              ;load the variable speed into l (because it is one byte)
 ld h,0
 call vardisp               ;display the variable
 call bardisp               ;display the bar that highlites the text
 call ionfastcopy           ;display the buffer


;;;;menu keys;;;;
 bcall(_GetCSC)             ;check if a key was pressed
 cp skup                    ;was it the up key?
 call z,switch              ;if it was, call label switch
 cp skdown                  ;was it the down key?
 call z,switch              ;if it was, call label switch
 cp skright                 ;was it the right key?
 jr z,right                 ;if it was, go to label right
 cp skleft                  ;was it the left key?
 jr z,left                  ;if it was, go to label left
 cp skMode                  ;was it the mode key?
 jp z,start                 ;if it was, go to label start

 jp options                 ;go to label options

right:
 ld a,(x)                   ;load the position of the bar (what choice is selected)
 cp 17                      ;does a = 17 (meaning the bar is highlighting the first choice)
 jr nz,right2               ;if it doesn't, go to the label: right2
 ld a,(rand)                ;load rand (the number of lines coming down) into a
 cp 13                      ;if it equals 13
 jp z,options               ;go to label: options
 inc a                      ;otherwise, increment a
 ld (rand),a                ;and load a back into rand
 jp options
right2:
 ld a,(speed)               ;load speed (obviously, how fast the lines come down) into a
 cp 25                      ;does it equal fifty?
 jp z,options               ;if so, go to label: options (return)
 inc a                      ;else, increment a
 ld (speed),a               ;load a back into speed
 jp options                 ;and jump back to options

left:
 ld a,(x)                   ;load the position of the bar (what choice is selected)
 cp 17
 jr nz,left2
 ld a,(rand)
 cp 3
 jp z,options
 dec a
 ld (rand),a
 jp options
left2:
 ld a,(speed)
 cp 1
 jp z,options
 dec a
 ld (speed),a
 jp options

;;;;sub routines;;;;
bardisp:
 ld a,(x)
 ld l,a
 ld a,0
 ld b,6
 ld c,7
 ld ix,bar
 call ionlargesprite
 ret

vardisp:
 bcall(_setxxxxop2)         ;load hl into op2 (11-bit register)
 bcall(_op2toop1)           ;load op2 into op1
 ld a,5                     ;load 5 into a (a is the maximum amount of numbers to display)
 bcall(_dispop1a)           ;display op1
 ret

;;;;menu subs;;;;
up:
 ld a,(x)
 sub 6
 ld (x),a
 cp 11
 ret nz
 ld a,29
 ld (x),a
 ret

down:
 ld a,(x)
 add a,6
 ld (x),a
 cp 35
 ret nz
 ld a,17
 ld (x),a
 ret

switch:
 ld a,(x)
 cp 17
 jr nz,down2
 ld a,23
 jr return2
down2:
 ld a,17
return2:
 ld (x),a
 ret


second:
 ld a,(x)
 cp 17
 jp z,play
 cp 23
 jp z,options
 jr quit

dispmenu:
 ld de,1100h
loopy:
 ld (pencol),de
 bcall(_vputs)
 ld a,d
 add a,6
 ld d,a
 djnz loopy
 ret

lose:
 bcall(_homeup)
 ld hl,losetxt
 bcall(_putS)

 ld a,0
 ld (curcol),a
 ld a,1
 ld (currow),a
 ld hl,scoretxt
 bcall(_PutS)

 ld a,1
 ld (currow),a
 ld hl,(score)
 bcall(_DispHL)
unneededloop:
 bcall(_GetCSC)
 cp skenter
 jr nz,unneededloop
 or a
 ld hl,(score)
 ld de,(highscore)
 sbc hl,de
 jp nc,high
 jp setup
 
high:
 ld hl,(score)
 ld (highscore),hl
 bcall(_HomeUP)
 bcall(_clrLCDFull)
 ld hl,highscoretxt
 bcall(_PutS)
unneededloop2:
 bcall(_getcsc)
 cp skenter
 jr nz,unneededloop2
 jp setup

quit:
 ret

;;;;Variables that are saved;;;;
speed:      .db 3
howfar:     .db 64
rand:       .db 5
highscore:  .db 0,0
name:       .db 0

;;;;Text;;;;
menu1: .db "New game",0
menu2: .db "Options",0
menu3: .db "Quit",0
menu4: .db "Lines at a time:",0
;menu5: .db "Gameplay mode:",0
menu6: .db "Speed:",0
high1: .db "High1:",0
losetxt: .db "You lose :(",0
scoretxt: .db "SCORE:",0
highscoretxt:
 .db "You got a high  "
 .db "   score!",0
;;;;Sprites;;;;
ship:
.db %01000000
.db %10100000

bar:
.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111

title:
.db %00011111, %11000000, %00000000, %00000000, %00000011, %11111111, %10111111, %11111101, %11111110
.db %00011111, %11100000, %00000000, %00000000, %00000010, %00000000, %10100000, %00000101, %00000001
.db %00011111, %11100000, %00000000, %00000000, %00000010, %00111110, %10100011, %11000101, %00111001
.db %00011100, %11100000, %00000000, %00000000, %00000010, %00111110, %10100111, %11100101, %00111101
.db %00011100, %11100000, %00000000, %00000000, %00000010, %00111110, %10100011, %11000101, %00111101
.db %00011111, %11100000, %00000000, %00000000, %00000010, %00111110, %10100000, %00000101, %00111101
.db %00011111, %11100000, %00000000, %00000000, %00000010, %00000000, %10100000, %00000101, %00111101
.db %00011111, %11000000, %00000111, %10000000, %00000010, %01111111, %10100111, %11100101, %00111101
.db %00011110, %00001101, %11001111, %10110110, %11100010, %00000000, %10100100, %00100101, %00111101
.db %00011110, %00001111, %11101101, %10111111, %11110010, %00111110, %10100100, %00100101, %00111101
.db %00011110, %00001110, %01101111, %10111001, %00110010, %00110110, %10100100, %00100101, %00111101
.db %00011110, %00001100, %00000111, %10110000, %00110010, %00101010, %10100100, %00100101, %00111101
.db %00011110, %00001100, %00000001, %10110000, %00110010, %00110110, %10100100, %00100101, %00111101
.db %00011110, %00001100, %00001101, %10110000, %00110010, %00111110, %10100100, %00100101, %00111001
.db %00011110, %00001100, %00001111, %10110000, %00110010, %00000000, %10100100, %00100101, %00000001
.db %00011110, %00001100, %00000111, %00110000, %00110011, %11111111, %10111100, %00111101, %11111110

.end
end