DrawTopBottom:			; Draws a line of the background to hacked positions
 call FillBackGroundPattern	; Getting the relevant piece of track into BGP
DTB_hackBGP:
 ld de,BackGroundPattern	; BGP+4 for bottom
 ld ix,TrackID			; Finding the ID's of the tiles used
 ld b,7
DTB_FillID:
 ld l,b				; Saving B
 ld h,0
 ld a,8
 sub b
 ld b,a
 ld c,a
 ld a,(de)
DTB_Rot1:
 rla
 djnz DTB_Rot1
 rr h				; ID bit 0 (top left)
 rla
 rr h				; ID bit 1 (top right)
 inc de
 ld a,(de)
 ld b,c
DTB_Rot2:
 rla
 djnz DTB_Rot2
 rr h				; ID bit 2 (bottom left)
 rla
 rr h				; ID bit 3 (bottom right)
 ld (ix),h
 inc ix
 dec de
 ld b,l
 djnz DTB_FillID
 ld ix,TrackID			; Doing the actual drawing
DTB_hackDest:
 ld hl,PLOTSSCREEN		; PS+756 for bottom
 ld a,(CoordY+1)		; Modifying the tile offset
 rrca
 rrca
 rrca
 and 30
 ld (DTB_TileOfs+1),a
 ld a,(CoordX+1)		; Modifying the bit alignment
 cpl
 rrca
 rrca
 rrca
 rrca
 and 7
 ld (DTB_align+1),a
 ld a,(CoordX+1)
 and 128
 ld (DTB_stepFlag),a		; Whether to change to the next tile
 ld b,12
DTB_Main:			; Advancing by 8 pixels
 push bc
 push hl
 push ix
 pop hl
 ld a,(DTB_stepFlag)
 xor 128
 ld (DTB_stepFlag),a
 jp nz,DTB_TileOfs
 inc ix				; Advancing to the next tile (after every other byte)
DTB_TileOfs:			; By now: HL: left ID byte; IX: right ID byte
 ld bc,0			; Offset into actual tile (modified)
 ld l,(hl)
 ld h,b
 add hl,hl
 ld de,RoadElement00		; Offset of actual tile
 add hl,de
 add hl,bc
 ld a,(DTB_stepFlag)
 or a
 jp nz,DTB_noHLinc
 inc hl
DTB_noHLinc:			; Offset of left byte in HL
 ld e,(ix)
 ld d,b
 sla e
 rl d
 ld iy,RoadElement00
 add iy,de
 add iy,bc
 ld a,(DTB_stepFlag)
 or a
 jp z,DTB_noIYinc
 inc iy
DTB_noIYinc:			; Offset of right byte in IY
 ld h,(hl)
 ld l,(iy)
DTB_align:
 jr $				; Jumps according to the proper alignment
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 pop hl
 ld (hl),d			; Final output
 inc hl
 pop bc
 djnz DTB_Main
 ret

DrawRight:			; Draws the 8 right pixel columns of the background
 call FillBackGroundPattern	; Getting the relevant piece of track into BGP
 ld de,BackGroundPattern	; Finding the relevant tile ID's
 ld ix,TrackID
 ld b,5
DLR_FillID:
 ld hl,0
 ld a,(de)
 rrca
 rrca				; Getting right ID
 ld c,a
 rla
 rr h				; ID bit 0 (top left)
 rla
 rr h				; ID bit 1 (top right)
 ld a,c
 rrca				; Getting left ID
 rla
 rr l				; ID bit 0 (top left)
 rla
 rr l				; ID bit 1 (top right)
 inc de
 ld a,(de)
 rrca
 rrca				; Getting right ID
 ld c,a
 rla
 rr h				; ID bit 2 (bottom left)
 rla
 rr h				; ID bit 3 (bottom right)
 ld a,c
 rrca				; Getting left ID
 rla
 rr l				; ID bit 2 (bottom left)
 rla
 rr l				; ID bit 3 (bottom right)
 ld (ix),l
 ld (ix+5),h
 inc ix
 djnz DLR_FillID
 ld ix,TrackID			; Doing the actual drawing
 ld hl,PLOTSSCREEN+11		; Starting at the top right corner
 ld a,(CoordX+1)		; Deciding whether each byte is at a tile boundary or not
 cp 128
 jp c,DLR_diff			; The byte will be taken from two different tiles
 cpl				; Bit align hack
 rrca
 rrca
 rrca
 rrca
 and 7
 ld (DLR_sHackA+1),a
 ld a,(CoordY+1)
 srl a
 srl a
 srl a
 and 30
 ld c,a				; Starting Y offset of first tile
 srl a				; (C will be 0 at the beginning of the following iterations)
 push af
 xor 15
 inc a				; Number of lines to skip at first
 ld b,4
DLR_sameLoop:			; Advancing tile by tile
 push bc
 push ix
 ld e,(ix+5)
 ld d,0
 ld b,d
 sla e
 rl d
 ld ix,RoadElement00
 add ix,de
 add ix,bc			; Source byte pointed by IX (Cth line of Eth tile)
 ld b,a
DLR_sByte:
 ld d,(ix)			; Reading left byte
 inc ix
 ld e,(ix)			; Reading right byte
 inc ix
 ex de,hl
DLR_sHackA:
 jr $
 add hl,hl			; Aligning bits
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 ld (hl),d			; Final byte
 ld de,12
 add hl,de
 djnz DLR_sByte
 ld a,16
 pop ix
 inc ix
 pop bc
DLR_sHackC0:
 ld c,0
 djnz DLR_sameLoop
 pop af
 or a
 jp z,DLR_sEnd
 ld de,((DLR_sEnd-DLR_sHackC0-2)&255)<<8+$18
 ld (DLR_sHackC0),de		; JR DLR_sEnd - jump out when ready
 inc b
 jp DLR_sameLoop
DLR_sEnd:
 ld de,$000e
 ld (DLR_sHackC0),de		; LD C,0
 ret
DLR_diff:
 cpl				; Bit align hack
 rrca
 rrca
 rrca
 rrca
 and 7
 ld (DLR_dHackA+1),a
 ld a,(CoordY+1)
 srl a
 srl a
 srl a
 and 30
 ld c,a
 srl a
 push af
 xor 15
 inc a				; Number of lines to skip for the first tile
 ld b,4
DLR_diffLoop:			; Advancing tile by tile
 push bc
 push ix
 ld e,(ix)
 ld d,0
 ld b,d
 sla e
 rl d
 ld iy,RoadElement00
 add iy,de
 add iy,bc
 inc iy				; Left source byte pointed by IY
 ld e,(ix+5)
 ld d,b
 sla e
 rl d
 ld ix,RoadElement00
 add ix,de
 add ix,bc			; Right source byte pointed by IX
 ld b,a
DLR_dByte:
 ld d,(iy)			; Left byte
 inc iy
 inc iy
 ld e,(ix)			; Right byte
 inc ix
 inc ix
 ex de,hl
DLR_dHackA:
 jr $
 add hl,hl			; Aligning bits
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 ld (hl),d			; Final byte
 ld de,12
 add hl,de
 djnz DLR_dByte
 ld a,16
 pop ix
 inc ix
 pop bc
DLR_dHackC0:
 ld c,0
 djnz DLR_diffLoop
 pop af
 or a
 jp z,DLR_dEnd
 ld de,((DLR_dEnd-DLR_dHackC0-2)&255)<<8+$18
 ld (DLR_dHackC0),de		; JR DLR_dEnd - modifying the load to a jump
 inc b
 jp DLR_diffLoop
DLR_dEnd:
 ld de,$000e
 ld (DLR_dHackC0),de		; LD C,0
 ret

DrawLeft:			; Draws the 8 left pixel columns of the background
 call FillBackGroundPattern	; The same as DrawRight with some minor modifications
 ld de,BackGroundPattern	; (However, there are too many differences to have them
 ld ix,TrackID			; done with one SMC routine.)
 ld b,5
DLL_FillID:
 ld hl,0
 ld a,(de)
 ld c,a
 rla
 rr l
 rla
 rr l
 ld a,c
 rla
 rla
 rr h
 rla
 rr h
 inc de
 ld a,(de)
 ld c,a
 rla
 rr l
 rla
 rr l
 ld a,c
 rla
 rla
 rr h
 rla
 rr h
 ld (ix),l
 ld (ix+5),h
 inc ix
 djnz DLL_FillID
 ld ix,TrackID
 ld hl,PLOTSSCREEN
 ld a,(CoordX+1)
 cp 128
 jp nc,DLL_diff
 cpl
 rrca
 rrca
 rrca
 rrca
 and 7
 ld (DLL_sHackA+1),a
 ld a,(CoordY+1)
 srl a
 srl a
 srl a
 and 30
 ld c,a
 srl a
 push af
 xor 15
 inc a
 ld b,4
DLL_sameLoop:
 push bc
 push ix
 ld e,(ix)
 ld d,0
 ld b,d
 sla e
 rl d
 ld ix,RoadElement00
 add ix,de
 add ix,bc
 ld b,a
DLL_sByte:
 ld d,(ix)
 inc ix
 ld e,(ix)
 inc ix
 ex de,hl
DLL_sHackA:
 jr $
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 ld (hl),d
 ld de,12
 add hl,de
 djnz DLL_sByte
 ld a,16
 pop ix
 inc ix
 pop bc
DLL_sHackC0:
 ld c,0
 djnz DLL_sameLoop
 pop af
 or a
 jp z,DLL_sEnd
 ld de,((DLL_sEnd-DLL_sHackC0-2)&255)<<8+$18
 ld (DLL_sHackC0),de		; JR DLL_sEnd
 inc b
 jp DLL_sameLoop
DLL_sEnd:
 ld de,$000e
 ld (DLL_sHackC0),de		; LD C,0
 ret
DLL_diff:
 cpl
 rrca
 rrca
 rrca
 rrca
 and 7
 ld (DLL_dHackA+1),a
 ld a,(CoordY+1)
 srl a
 srl a
 srl a
 and 30
 ld c,a
 srl a
 push af
 xor 15
 inc a
 ld b,4
DLL_diffLoop:
 push bc
 push ix
 ld e,(ix)
 ld d,0
 ld b,d
 sla e
 rl d
 ld iy,RoadElement00
 add iy,de
 add iy,bc
 inc iy
 ld e,(ix+5)
 ld d,b
 sla e
 rl d
 ld ix,RoadElement00
 add ix,de
 add ix,bc
 ld b,a
DLL_dByte:
 ld d,(iy)
 inc iy
 inc iy
 ld e,(ix)
 inc ix
 inc ix
 ex de,hl
DLL_dHackA:
 jr $
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 ex de,hl
 ld (hl),d
 ld de,12
 add hl,de
 djnz DLL_dByte
 ld a,16
 pop ix
 inc ix
 pop bc
DLL_dHackC0:
 ld c,0
 djnz DLL_diffLoop
 pop af
 or a
 jp z,DLL_dEnd
 ld de,((DLL_dEnd-DLL_dHackC0-2)&255)<<8+$18
 ld (DLL_dHackC0),de		; JR DLL_dEnd
 inc b
 jp DLL_diffLoop
DLL_dEnd:
 ld de,$000e
 ld (DLL_dHackC0),de		; LD C,0
 ret

FillBackGroundPattern:		; Gets an 8x5 pixels big part of the track into BGP
 ld hl,(TrackData)		; The coordinates are given in CoordX and CoordY, in pixels
 ld ix,BackGroundPattern
 ld de,(CoordX)
 ld d,0
 ld a,e
 srl e
 srl e
 srl e
 add hl,de
 and 7				; Number of bits to shift in A
 ex de,hl
 ld hl,(CoordY)
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,hl
 add hl,de			; Byte address of top left pixel in HL
 ld c,6
FBGP_LineLoop:
 ld d,(hl)
 inc hl
 or a
 jr z,FBGP_AlignEnd
 ld e,(hl)
 ld b,a
FBGP_AlignBit:
 sla e
 rl d
 djnz FBGP_AlignBit 
FBGP_AlignEnd:
 ld (ix),d
 inc ix
 ld de,15
 add hl,de
 dec c
 jr nz,FBGP_LineLoop
 ret

CopyBackGround:			; A fast screen copying routine (768 bytes from HL to DE)
 ld bc,$1bff			; This will give 768 by taking into account that LDI also
CBKG_Loop:			; decreases BC
 LDI8
 LDI8
 LDI8
 LDI8
 djnz CBKG_Loop
 ret

DrawPlayerSprite:		; Drawing the players on the road (clipped sprite drawing)
 ld (DPS_hackAngle+1),a		; Sprite frame address: IX; Screen position: B, C; Angle: A
 ld a,c				; Y clipping hacks
 cp 40
 jr c,DPS_noYhack
 or a
 jp m,DPS_topClip
 sub 65				; A=64-A
 cpl
 jr DPS_YhackOK
DPS_topClip:
 add a,24
DPS_topLoop:			; Adjusting the sprite address when clipped at the top
 inc ix
 inc ix
 inc ix
 inc c
 jr nz,DPS_topLoop
 jr DPS_YhackOK
DPS_noYhack:
 ld a,24			; Updating the loop counter init for Y clipping
DPS_YhackOK:
 cp 25
 ret nc				; No sprites bigger than 24 or less than 0 lines are allowed
 or a
 ret z				; No sprite with zero size is allowed
 ld (DPS_lines-1),a
 ld (DPS_alines-1),a
 ld hl,SAVESSCREEN		; We need this value this early
 ld a,$77			; X clipping hacks
 ld (DPS_mask1),a		; Resetting as unclipped (A contains the opcode for "ld (hl),a")
 ld (DPS_mask2),a
 ld (DPS_mask3),a
 ld (DPS_mask4),a
 ld (DPS_byte1),a
 ld (DPS_byte2),a
 ld (DPS_byte3),a
 ld (DPS_byte4),a
 ld (DPS_aByte1),a
 ld (DPS_aByte2),a
 ld (DPS_aByte3),a
 ld a,b
 cp 72
 jr c,DPS_noXhack
 cp -23
 jr nc,DPS_hackLeft
 cp 96
 ret nc				; The sprite is completely outside, so it isn't drawn
 ex af,af'
 xor a				; The opcode for NOP
 ld (DPS_mask4),a
 ld (DPS_byte4),a
 ex af,af'
 cp 80
 jr c,DPS_noXhack
 ex af,af'
 ld (DPS_mask3),a
 ld (DPS_byte3),a
 ld (DPS_aByte3),a
 ex af,af'
 cp 88
 jr c,DPS_noXhack
 ex af,af'
 ld (DPS_mask2),a
 ld (DPS_byte2),a
 ld (DPS_aByte2),a
 jr DPS_noXhack 
DPS_hackLeft:
 ld d,a
 add a,96
 ld b,a
 ld hl,SAVESSCREEN-12		; Very important, compensating for the increased X coordinate
 xor a
 ld (DPS_mask1),a
 ld (DPS_byte1),a
 ld (DPS_aByte1),a
 ld a,d
 cp -8
 jr nc,DPS_noXhack
 ex af,af'
 xor a
 ld (DPS_mask2),a
 ld (DPS_byte2),a
 ld (DPS_aByte2),a
 ex af,af'
 cp -16
 jr nc,DPS_noXhack
 ex af,af'
 ld (DPS_mask3),a
 ld (DPS_byte3),a 
DPS_noXhack:
 ld d,0				; Calculating the starting byte address on the screen
 ld e,c				; HL=screen+C*12+B/8
 sla e				; (IX points to the image, while the mask is at IX+72)
 sla e
 add hl,de
 add hl,de
 add hl,de
 ld e,b
 srl e
 srl e
 srl e
 add hl,de
DPS_hackAngle:
 ld a,0				; Resetting the angle
 add a,4			; Correcting the direction (rounding)
 and $f8			; Frame ID times 8 already
 ld de,18
 push hl
 call Mul_A_DE
 ex de,hl
 pop hl
 add ix,de			; Adding 144*frame ID to IX, thus selecting the appropriate one
 ld a,b
 and 7
 jp z,DPS_aligned		; The sprite is byte aligned
 ld (DPS_sHack1+2),a
 ld (DPS_sHack2+1),a
 ld iyl,24			; Interrupts must be off, since IY is used as line counter
DPS_lines:			; 24x24 pixels, non-aligned
 ld a,(ix+72)			; Retrieving and drawing the mask
 ld e,(ix+73)
 ld d,(ix+74)
DPS_sHack1:
 ld bc,255
DPS_shift1:
 sra a
 rr e
 rr d
 rr c
 djnz DPS_shift1
 and (hl)
DPS_mask1:
 ld (hl),a
 inc hl
 ld a,e
 and (hl)
DPS_mask2:
 ld (hl),a
 inc hl
 ld a,d
 and (hl)
DPS_mask3:
 ld (hl),a
 inc hl
 ld a,c
 and (hl)
DPS_mask4:
 ld (hl),a
 ld c,(ix)			; Drawing the sprite itself
 ld e,(ix+1)
 ld d,(ix+2)
 ld a,0
DPS_sHack2:
 ld b,0
DPS_shift2:
 srl c
 rr e
 rr d
 rr a
 djnz DPS_shift2
 or (hl)
DPS_byte4:
 ld (hl),a
 dec hl
 ld a,d
 or (hl)
DPS_byte3:
 ld (hl),a
 dec hl
 ld a,e
 or (hl)
DPS_byte2:
 ld (hl),a
 dec hl
 ld a,c
 or (hl)
DPS_byte1:
 ld (hl),a
 ld de,12
 add hl,de
 ld e,3
 add ix,de
 dec iyl
 jp nz,DPS_lines
 ret
DPS_aligned:
 ld b,24
DPS_alines:			; 24x24 pixels, aligned
 ld a,(ix+72)			; Retrieving and drawing the masked sprite line
 and (hl)
 or (ix)
DPS_aByte1:
 ld (hl),a
 inc hl
 ld a,(ix+73)
 and (hl)
 or (ix+1)
DPS_aByte2:
 ld (hl),a
 inc hl
 ld a,(ix+74)
 and (hl)
 or (ix+2)
DPS_aByte3:
 ld (hl),a
 ld de,10
 add hl,de
 ld e,3
 add ix,de
 djnz DPS_alines
 ret

DrawHUD:			; Drawing the HUD (surprisingly)
 ld hl,HUD_LapNumPic-6		; Displaying current laps
 push hl
 ld de,(Player_Lap)
 ld d,0
 sla e
 add hl,de
 add hl,de
 add hl,de
 ld de,SAVESSCREEN+11
 ld bc,$0601
 call AlignSprite
 xor a
 ld (de),a
 pop hl
 ld de,(Opponent_Lap)
 ld d,0
 sla e
 add hl,de
 add hl,de
 add hl,de
 ld de,SAVESSCREEN+95
 ld bc,$0601
 call AlignSprite
 ld (de),a
 ld de,SAVESSCREEN+9
 ld hl,HUD_Players
 ld bc,$0e02
 call AlignSprite
 ld a,255
 ld (de),a
 inc de
 ld (de),a
 inc de
 ld (de),a
 ret
