SetupPracticePointers:		; Sets up the pointers for the practice part
 ld hl,SAVESSCREEN		; Setting the destination screen for the polygon drawer
 ld (PolyData+2),hl
 ld hl,(MEMSTART)
 ld (CarSprites),hl		; Allocating 4608 bytes (4.5k) for the sprites of the player
 ld bc,4608
 add hl,bc
 ld (PolyData),hl		; Setting the working screen for the polygon drawer
 ld (TrackData),hl		; Allocating 2048 bytes for the track
 ret

ClearVariables:			; Clears the dynamic variables
 ld hl,DynamicData
 ld de,DynamicData+1
 xor a
 ld (hl),a
 ld bc,EndLabel-DynamicData-1
 ldir
 ret

DrawVectorSprite:		; Draws a sprite consisting of polygons to the coordinates B,C
 ld a,b				; with an angle D (values of 0-256 correspond to 0-360 degrees)
 ld (DVS_addX+1),a		; Only used for precalculating sprites prior to race and in the
 ld a,c				; menu
 ld (DVS_addY+1),a
 ld a,d
 ld (DVS_sinX+1),a
 ld (DVS_sinY+1),a
 add a,64
 ld (DVS_cosX+1),a
 ld (DVS_cosY+1),a
 ld a,12
 ld (DVS_backUp1+2),a
 ld (DVS_backUp2+2),a
 ld b,(hl)
 inc hl
 push hl
DVS_main:
 push bc
 ld ix,PolyData+4
 ld a,(hl)
 inc hl
 ld (ix),a
 inc ix
 ld b,(hl)
 inc hl
 ld (ix),b
 inc ix
 inc b
DVS_dot:
 push bc
 ld b,(hl)
 inc hl
 push hl
DVS_sinY:
 ld de,0
 call Mul_B_sinDE
 ld a,h
 ld (DVS_SY+1),a
DVS_cosY:
 ld de,0
 call Mul_B_sinDE
 ld a,h
 ld (DVS_CY+1),a
 pop hl
 ld b,(hl)
 inc hl
 push hl
DVS_sinX:
 ld de,0
 call Mul_B_sinDE
 ld a,h
 ld (DVS_SX+1),a
DVS_cosX:
 ld de,0
 call Mul_B_sinDE
 ld a,h
 ld (DVS_CX+1),a
 pop hl
DVS_addY:
 ld a,0
DVS_SX:
 add a,0
DVS_CY:
 add a,0
 ld (ix),a
DVS_backUp1:
 ld (ix+12),a
 inc ix
DVS_addX:
 ld a,0
DVS_CX:
 add a,0
DVS_SY:
 sub 0
 ld (ix),a
DVS_backUp2:
 ld (ix+12),a
 inc ix
 pop bc
 djnz DVS_dot
 push hl
 call DrawPolygon
 pop hl
 xor a
 ld (DVS_backUp1+2),a
 ld (DVS_backUp2+2),a
 pop bc
 djnz DVS_main
 pop hl
 inc hl
 ld b,(hl)
 ld hl,PolyBackup
 ld e,(hl)
 inc hl
 ld d,(hl)
 inc hl
 push de
DVS_outLine:
 push bc
 ld a,(hl)
 inc hl
 ld c,(hl)
 inc hl
 push hl
 ld h,c
 ld l,a
 push hl
 ld ix,(PolyData+2)
 call DrawLine
 pop de
 pop hl
 pop bc
 djnz DVS_outLine
 pop hl
 ld ix,(PolyData+2)
 call DrawLine
 ret

PrepareSprites:			; Pregenerating the players' sprites
 ld hl,Cars-1
 call _xlat2
 ld (CarData),hl
 ld (PS_CDhack1+2),hl
 ld (PS_CDhack2+2),hl
 ld (PS_CDhack3+2),hl
 ld b,32
PS_main:
 ld a,b				; Determining the angle
 dec a
 sla a
 sla a
 sla a
 ld (PS_shadeAngle+1),a
 push bc
 ld hl,SAVESSCREEN		; Clearing the working screen
 call ClearScreen
 ld hl,(CarData)		; Drawing the current frame
 ld bc,$0c0c
 ld d,a
 call DrawVectorSprite
 pop bc
 push bc
 ld a,b
 dec a
 ld de,144
 call Mul_A_DE			; Copying it into CarSprites
 ld de,(CarSprites)
 add hl,de
 ex de,hl
 ld hl,SAVESSCREEN
 ld bc,$18ff
PS_line1:
 push bc
 ldi
 ldi
 ldi
 ld bc,9
 add hl,bc
 pop bc
 djnz PS_line1
PS_CDhack1:
 ld de,(0)
 ld (PS_shadeBack+1),de
 ld de,$0801
PS_CDhack2:
 ld (0),de
 ld hl,(CarData)		; Drawing the mask of the current frame
 ld bc,$0c0c
PS_shadeAngle:
 ld d,0
 call DrawVectorSprite
 pop bc
 push bc
 ld a,b
 add a,a
 dec a
 ld de,72
 call Mul_A_DE			; Inverting and copying it into CarSprites
 ld de,(CarSprites)
 add hl,de
 ex de,hl
 ld hl,SAVESSCREEN
 ld bc,$18ff
PS_line2:
 push bc
 ld a,(hl)
 inc hl
 cpl
 ld (de),a
 inc de
 ld a,(hl)
 inc hl
 cpl
 ld (de),a
 inc de
 ld a,(hl)
 inc hl
 cpl
 ld (de),a
 inc de
 ld bc,9
 add hl,bc
 pop bc
 djnz PS_line2
PS_shadeBack:
 ld de,0
PS_CDhack3:
 ld (0),de
 pop bc
 dec b
 jp nz,PS_main
 ld hl,(TrackData)
 ld d,h
 ld e,l
 inc de
 ld (hl),b			; B=0 because of the loop
 ld bc,2047
 ldir
 ret

DrawBackGround:			; Draws a background pattern from 5 bytes of data at BGP
 ld de,BackGroundPattern
 ld b,4
DBG_Major:
 push bc
 push de
 ld a,4
 sub b
 rla
 rla
 rla
 rla
 ld ixl,a
 ld b,6
DBG_Minor:
 push bc
 push de
 ld h,0
 ld a,7
 sub b
 ld b,a
 ld c,a
 dec a
 ld ixh,a
 ld a,(de)
DBG_Rot1:
 rla
 djnz DBG_Rot1
 rr h
 rla
 rr h
 inc de
 ld a,(de)
 ld b,c
DBG_Rot2:
 rla
 djnz DBG_Rot2
 rr h
 rla
 rr h
 ld c,h
 ld b,0
 sla c
 rl b
 ld hl,RoadElement00
 add hl,bc
 ex de,hl
 ld hl,PLOTSSCREEN
 ld b,0
 ld c,ixh
 sla c
 add hl,bc
 ld c,ixl
 ld b,0
 sla c
 sla c
 add hl,bc
 add hl,bc
 add hl,bc
 ld bc,11
 ld ixh,8
DBG_line:
 ld a,(de)
 inc de
 ld (hl),a
 inc hl
 ld a,(de)
 inc de
 ld (hl),a
 add hl,bc
 ld a,(de)
 inc de
 ld (hl),a
 inc hl
 ld a,(de)
 inc de
 ld (hl),a
 add hl,bc
 dec ixh
 jp nz,DBG_line
 pop de
 pop bc
 djnz DBG_Minor
 pop de
 inc de
 pop bc
 djnz DBG_Major
 ret

PrepareTrackData:		; Draws a bitmap of the track from the vector track information
 ld hl,Tracks-1
 call _xlat2
PTD_seek0:
 ld a,(hl)
 inc hl
 or a
 jr nz,PTD_seek0
 ld (TrackPtr),hl		; Saving the pointer to the track data for further use
 inc hl
 ld a,(hl)			; Determines the initial position of the screen
 inc hl
 dec a
 dec a
 ld (CoordY),a
 ld a,(hl)
 dec a
 dec a
 ld (CoordX),a
 dec hl
 dec hl
 push hl
 ld bc,$0000
 call PTD_Sub
 pop hl
 push hl
 ld bc,$0100
 call PTD_Sub
 pop hl
 push hl
 ld bc,$0200
 call PTD_Sub
 pop hl
 push hl
 ld bc,$0001
 call PTD_Sub
 pop hl
 push hl
 ld bc,$0201
 call PTD_Sub
 pop hl
 push hl
 ld bc,$0002
 call PTD_Sub
 pop hl
 push hl
 ld bc,$0102
 call PTD_Sub
 pop hl
 ld bc,$0202
 call PTD_Sub
 ld hl,(TrackData)
 ld bc,2048
PTD_Invert:
 ld a,(hl)
 cpl
 ld (hl),a
 inc hl
 dec bc
 ld a,b
 or c
 jr nz,PTD_Invert
 ret

PTD_Sub:			; Draws a track whose coordinates are found at HL
 ld (PTD_hackBC+1),bc		; Also translates the coordinates with B,C
 ld a,(hl)
 inc hl
 ld e,(hl)
 inc hl
 ld d,(hl)
 inc hl
 ex de,hl
 add hl,bc
 ex de,hl
 ld b,a
 push de
PTD_Lines:
 push bc
 ld a,(hl)
 inc hl
 ld c,(hl)
 inc hl
 push hl
 ld h,c
 ld l,a
PTD_hackBC:
 ld bc,0
 add hl,bc
 push hl
 call DrawTrackLine
 pop de
 pop hl
 pop bc
 djnz PTD_Lines
 pop hl
 call DrawTrackLine
 ret

DrawTrackLine:			; The same line drawing routine as the other, but this one
 ld ix,(TrackData)		; draws on a 128x128 virtual screen (minor modifications)
 ld a,h
 sub d
 jp nc,DTL_okaydx
 ex de,hl
 neg
DTL_okaydx:
 push af
 ld b,0
 ld c,d
 srl c
 srl c
 srl c
 add ix,bc
 ld c,e
 sla c
 rl b
 sla c
 rl b
 sla c
 rl b
 add ix,bc
 add ix,bc
 ld a,d
 ld c,$80
 and 7
 jp z,DTL_okaymask
DTL_calcmask:
 srl c
 dec a
 jp nz,DTL_calcmask
DTL_okaymask:
 ld a,l
 sub e
 ld hl,16
 jp nc,DTL_okaydy
 ld hl,-16
 neg
DTL_okaydy:
 pop de
 ld e,a
 cp d
 jp c,DL_horizontal		; Jumping into the other line routine
 jp DL_vertical
