Menu_Press_Down:		; Advances to the next menu item
 ld a,(MenuItem)
 inc a
 ld hl,MenuItems
 cp (hl)
 jr c,MPD_OK
 xor a
MPD_OK:
 ld (MenuItem),a
 ld hl,PLOTSSCREEN
 jp FlipScreen

Menu_Press_Up:			; Goes back to the previous menu item
 ld a,(MenuItem)
 dec a
 cp -1
 jr nz,MPU_OK
 ld a,(MenuItems)
 dec a
MPU_OK:
 ld (MenuItem),a
 ld hl,PLOTSSCREEN
 jp FlipScreen

InitMenu:			; Draws the menu at HL and prepares it to work
 ld a,(hl)			; Initialising values
 ld c,a
 ld (MenuItems),a
 xor a
 ld (MenuItem),a
 inc hl
 ld (MenuPointer),hl
 ld b,0
 add hl,bc
 add hl,bc
 push hl
 ld hl,PLOTSSCREEN		; Clearing the screen
 ld de,PLOTSSCREEN+1
 ld (hl),255
 ld bc,48
 ldir				; 4 black lines
 ld (hl),0
 ld bc,720
 ldir				; 60 white lines
 ld hl,TitleScreen		; Displaying the title
 ld de,PLOTSSCREEN+48
 ld bc,276
 ldir
 pop hl
 ld de,PLOTSSCREEN+385
 ld a,(MenuItems)
IM_Item:
 ld b,5
 ld c,(hl)
 inc hl
 call AlignSprite
 ld bc,12
 ex de,hl
 add hl,bc
 ex de,hl
 dec a
 jr nz,IM_Item
 ld hl,PLOTSSCREEN
 jp FlipScreen

ShowMenuItem:			; Highlights the current menu item in grayscale
 ld a,(MenuItem)
 add a,a
 ld b,a
 add a,a
 add a,b
 ld c,a
 add a,a
 add a,a
 ld hl,PLOTSSCREEN+372
 ld d,0
 ld e,a
 add hl,de
 add hl,de
 add hl,de			; Now we are at the screen position
 ld a,c
 add a,159
 ld (SMI_hackY+1),a
 out ($10),a
 ld ix,SMI_Mask0+1		; Rotating the mask
 ld a,(ix)
 ld d,(ix+SMI_Mask1-SMI_Mask0)
 ld e,(ix+SMI_Mask2-SMI_Mask0)
 ld (ix),d
 ld (ix+SMI_Mask1-SMI_Mask0),e
 ld (ix+SMI_Mask2-SMI_Mask0),a
 ld (ix+SMI_Mask3-SMI_Mask0),d
 ld a,$20			; Set column command
 ld c,a
SMI_column:
 ld b,2
 inc c
 push hl
 pop hl
 ld de,12
 out ($10),a
SMI_inner:
SMI_Mask0:			; Put gray byte 1-4
 ld a,%11011011
 or (hl)
 add hl,de
 push hl
 pop hl
 out ($11),a
SMI_Mask1:			; Put gray byte 2-5
 ld a,%01101101
 or (hl)
 add hl,de
 push hl
 pop hl
 out ($11),a
SMI_Mask2:			; Put gray byte 3-6
 ld a,%10110110
 or (hl)
 add hl,de
 push hl
 pop hl
 out ($11),a
 djnz SMI_inner
SMI_Mask3:			; Put gray byte 7
 ld a,%11011011
 or (hl)
 add hl,de
 push hl
 pop hl
 out ($11),a
 ld de,-83
 add hl,de
 push hl
 pop hl
SMI_hackY:
 ld a,0
 out ($10),a
 ld a,c
 cp $2c
 jr nz,SMI_column
 ld bc,1000			; Delay to prevent interference
SMI_delay:			; HALT cannot be used due to disabled interrupts
 dec bc
 ld a,b
 or c
 jr nz,SMI_delay
 ret

ExecuteMenuItem:		; Executes a subroutine from the menu jumptable
 ld hl,PLOTSSCREEN		; Deleting the highlight
 call FlipScreen
 ld hl,(MenuPointer)
 ld a,(MenuItem)
 call _xlat2			; HL=(HL+A*2)
 ld de,MenuInit
 push de			; Imitating a call from just before the MenuInit label
 jp (hl)

Credits:			; Displays some data about the program
 ld hl,PLOTSSCREEN+336
 ld de,PLOTSSCREEN+337
 ld (hl),0
 ld bc,431
 ldir
 ld hl,PLOTSSCREEN
 call FlipScreen
 ld hl,Credits1
 call DisplayTextXY
 ld hl,Credits2
 call DisplayTextXY
 ld hl,Credits3
 call DisplayTextXY
 ld hl,Credits4
 call DisplayTextXY
CreditsLoop:
 call ReadKeyboard		; Reading keypresses
 call ValidateKeys		; Preventing repetition
 ld a,(KeyPressed+6)		; MODE
 and 64
 ret z
 jr CreditsLoop

DisplayTextXY:			; Displays text data given pointed by HL
 ld iy,(BackupIY+2)		; Retrieving the system flags' address
 res 7,(iy+20)			; So VPUTSN only writes to the display
 ld c,(hl)			; X coordinate
 inc hl
 ld b,(hl)			; Y coordinate
 inc hl
 ld (PENCOL),bc
 ld b,(hl)			; Length
 inc hl
 bcall(_vputsn)
 di
 ret

Practice:			; Main menu, Practice item
 ld a,1
 ld (TrackChosen),a
 ld (CarChosen),a
 call PractTrk_DrawTrack	; Drawing the first screen before pressing keys
; xor a
; ld (PracticeLoopCar+1),a
PracticeLoopTrk:
 call ReadKeyboard		; Reading keypresses
 call ValidateKeys		; Preventing repetition
 ld a,(ValidKey+6)		; 2nd
 and 32
 jr z,PracticeLoopCar
 ld a,(KeyPressed+6)		; MODE
 and 64
 ret z
 ld a,(ValidKey)
 and 1
 call z,PractTrk_Press_Down
 ld a,(ValidKey)
 and 8
 call z,PractTrk_Press_Up
 jr PracticeLoopTrk
PracticeLoopCar:
; jr $+2				; Dummy jump to be able to skip things
 call DrawCarScreen		; Draws the car selection screen
 call ReadKeyboard		; Reading keypresses
 call ValidateKeys		; Preventing repetition
 ld a,(ValidKey+6)		; 2nd
 and 32
 jp z,Race_P			; Practicing starts
 ld a,(KeyPressed+6)		; MODE
 and 64
 ret z
 ld a,(ValidKey)
 and 1
; call z,PractCar_Press_Down
 call z,MenuIncCar
 ld a,(ValidKey)
 and 8
; call z,PractCar_Press_Up
 call z,MenuDecCar
; ld a,(ValidKey)
; and 2
; jr nz,PractCar_No_Left
; xor a
; ld (PracticeLoopCar+1),a
;PractCar_No_Left:
; ld a,(ValidKey)
; and 4
; jr nz,PracticeLoopCar
; ld a,3
; ld (PracticeLoopCar+1),a
; call DrawInfoScreen
 jr PracticeLoopCar

PractTrk_Press_Down:		; Advances to the next track
 call MenuIncTrack
 jr PractTrk_DrawTrack

PractTrk_Press_Up:		; Goes back to the previous track
 call MenuDecTrack

PractTrk_DrawTrack:
 call DrawTrackMap
 ld hl,PLOTSSCREEN
 call FlipScreen
 ld iy,(BackupIY+2)		; Displaying the name of the track
 res 7,(iy+20)
 ld bc,$0101
 ld (PENCOL),bc
 ld a,(TrackChosen)
 ld hl,Tracks-1
 call _xlat2
 ld b,(hl)			; Length
 inc hl
 bcall(_vputsn)
 di
 ret

;PractCar_Press_Down:		; Advances to the next car
; call MenuIncCar
; ld a,(PracticeLoopCar+1)
; or a
; ret z
; jp DrawInfoScreen

;PractCar_Press_Up:		; Goes back to the previous car
; call MenuDecCar
; ld a,(PracticeLoopCar+1)
; or a
; ret z
; jp DrawInfoScreen

DrawTrackMap:			; Draws the map of the track on the virtual screen
 ld hl,BackGroundPattern
 ld (hl),3
 inc hl
 xor a
 ld (hl),a
 inc hl
 ld (hl),a
 inc hl
 ld (hl),$80
 inc hl
 ld (hl),$e3
 call DrawBackGround
 ld a,(TrackChosen)
 ld hl,Tracks-1
 call _xlat2
DTM_seek0:
 ld a,(hl)
 inc hl
 or a
 jr nz,DTM_seek0
 ld b,(hl)
 inc hl
 ld e,(hl)
 inc hl
 srl e
 ld d,(hl)
 inc hl
 srl d
 push de
DTM_Lines:
 push bc
 ld a,(hl)
 inc hl
 srl a
 ld c,(hl)
 inc hl
 srl c
 push hl
 ld h,c
 ld l,a
 push hl
 ld ix,PLOTSSCREEN+4
 call DrawThickLine
 pop de
 pop hl
 pop bc
 djnz DTM_Lines
 pop hl
 ld ix,PLOTSSCREEN+4
 call DrawThickLine
 ld hl,ArrowUp
 ld de,PLOTSSCREEN+181
 ld bc,$0702
 call AlignSprite
 ld hl,ArrowDown
 ld de,PLOTSSCREEN+517
 ld bc,$0702
 call AlignSprite
 ld hl,ChooseTrkData
 ld de,PLOTSSCREEN+312
 ld bc,$0d04
 call AlignSprite
 ret

DrawThickLine:			; Draws a line with double thickness
 push de \ push hl \ push ix
 call DrawLine
 pop ix \ pop hl \ pop de
 push de \ push hl \ push ix
 inc h \ inc d
 call DrawLine
 pop ix \ pop hl \ pop de
 inc l \ inc e
 push de \ push hl \ push ix
 call DrawLine
 pop ix \ pop hl \ pop de
 inc h \ inc d
 call DrawLine
 ret

DrawCarScreen:			; Draws the car selection screen
 ld hl,SAVESSCREEN		; Setting the working screen for the polygon drawer
 ld (PolyData),hl
 call ClearScreen
 ld hl,PLOTSSCREEN		; Setting the destination screen for the polygon drawer
 ld (PolyData+2),hl
 ld bc,$231c
 ld a,c
 ld (BackGroundPattern),bc
 ld c,b
 ld (BackGroundPattern+2),bc
 ld (BackGroundPattern+4),a
 call DrawBackGround
 ld hl,Cars-1
 ld a,(CarChosen)
 call _xlat2
 push hl
 push hl
 ld a,$27			; SLA A 2nd byte
 call CarMultiply
 pop hl
 ld bc,$4020
 ld a,(Player_Angle)
 add a,2
 ld (Player_Angle),a
 ld d,a
 call DrawVectorSprite
 ld hl,ArrowUp
 ld de,PLOTSSCREEN+24
 ld bc,$0702
 call AlignSprite
 ld de,PLOTSSCREEN+660
 ld bc,$0702
 call AlignSprite
 ld hl,PLOTSSCREEN
 call FlipScreen
 pop hl
 ld a,$2F			; SRA A 2nd byte
 call CarMultiply
 ret

CarMultiply:			; Magnifies or diminuates the picture of a car at HL
 ld (CM_Inner+2),a		; $27 to magnify and $2F to diminuate
 ld b,(hl)
 inc hl
CM_Loop:
 inc hl
 ld c,(hl)
 inc c
 sla c
 inc hl
CM_Inner:
 ld a,(hl)
 sla a				; This must not be changed to ADD A,A due to self-modification
 ld (hl),a
 inc hl
 dec c
 jr nz,CM_Inner
 djnz CM_Loop
 ret

Compete:			; DEBUG code!!!
 ld hl,PLOTSSCREEN+336
 ld de,PLOTSSCREEN+337
 ld (hl),0
 ld bc,431
 ldir
 ld hl,PLOTSSCREEN
 call FlipScreen
 ld hl,Test1
 call DisplayTextXY
 ld hl,Test2
 call DisplayTextXY
 ld hl,Test3
 call DisplayTextXY
 ld hl,Test4
 call DisplayTextXY
 ld a,(HC_collHack1+1)
 srl a
 srl a
 ld bc,$1E2B
 ld (PENCOL),bc
 call CompeteDisp00
 ld a,(HC_collHack3+1)
 srl a
 ld bc,$2636
 ld (PENCOL),bc
 call CompeteDisp00
 ld a,(HO_hackPrecision+1)
 ld bc,$2E2E
 ld (PENCOL),bc
 call CompeteDisp00
 ld a,(HO_hackReaction+1)
 ld bc,$3639
 ld (PENCOL),bc
 call CompeteDisp00
CompeteLoopTrk:
 call ReadKeyboard		; Reading keypresses
 call ValidateKeys		; Preventing repetition
 ld a,(KeyPressed+6)		; MODE
 and 64
 ret z
 ld a,(ValidKey+3)		; (
 and 16
 call z,CompeteDecBump
 ld a,(ValidKey+2)		; )
 and 16
 call z,CompeteIncBump
 ld a,(ValidKey+3)		; 8
 and 8
 call z,CompeteDecBack
 ld a,(ValidKey+2)		; 9
 and 8
 call z,CompeteIncBack
 ld a,(ValidKey+3)		; 5
 and 4
 call z,CompeteDecPrec
 ld a,(ValidKey+2)		; 6
 and 4
 call z,CompeteIncPrec
 ld a,(ValidKey+3)		; 2
 and 2
 call z,CompeteDecResp
 ld a,(ValidKey+2)		; 3
 and 2
 call z,CompeteIncResp
 jr CompeteLoopTrk
 ret

CompeteIncBump:
 ld a,(HC_collHack1+1)
 add a,4
 jr CompeteSetBump

CompeteDecBump:
 ld a,(HC_collHack1+1)
 sub 4
CompeteSetBump:
 and 63
 ld (HC_collHack1+1),a
 ld (HC_collHack2+1),a
 srl a
 srl a
 ld bc,$1E2B
 ld (PENCOL),bc
 jr CompeteDisp00

CompeteIncBack:
 ld a,(HC_collHack3+1)
 add a,2
 jr CompeteSetBack

CompeteDecBack:
 ld a,(HC_collHack3+1)
 sub 2
CompeteSetBack:
 and 31
 ld (HC_collHack3+1),a
 srl a
 ld bc,$2636
 ld (PENCOL),bc
 jr CompeteDisp00

CompeteIncPrec:
 ld a,(HO_hackPrecision+1)
 inc a
 jr CompeteSetPrec

CompeteDecPrec:
 ld a,(HO_hackPrecision+1)
 dec a
CompeteSetPrec:
 and 15
 ld (HO_hackPrecision+1),a
 ld b,a
 add a,a
 inc a
 ld (HO_hackPrecision+3),a
 ld a,b
 ld bc,$2E2E
 ld (PENCOL),bc
 jr CompeteDisp00

CompeteIncResp:
 ld a,(HO_hackReaction+1)
 inc a
 jr CompeteSetResp

CompeteDecResp:
 ld a,(HO_hackReaction+1)
 dec a
CompeteSetResp:
 and 15
 ld (HO_hackReaction+1),a
 ld bc,$3639
 ld (PENCOL),bc
CompeteDisp00:
 ld b,a
 cp 10
 ccf
 ld a,48
 adc a,0
 ld (MenuItem),a
 ld a,b
 daa
 and 15
 add a,48
 ld (MenuItems),a
 ld hl,MenuItem-1
 ld b,2
CompeteDisp:
 ld iy,(BackupIY+2)		; Displaying a string with post deletion
 res 7,(iy+20)
 inc hl
 bcall(_vputsn)
 ld b,20
 ld hl,TestClear
 bcall(_vputsn)
 di
 ret

MenuIncTrack:			; Selecting the next track
 ld a,(TrackChosen)
 inc a
 ld hl,Tracks
 cp (hl)
 jr c,PTPD_OK
 jr z,PTPD_OK
 ld a,1
PTPD_OK:
 ld (TrackChosen),a
 ret

MenuDecTrack:			; Selecting the previous track
 ld a,(TrackChosen)
 dec a
 jr nz,PTPU_OK
 ld a,(Tracks)
PTPU_OK:
 ld (TrackChosen),a
 ret

MenuIncCar:			; Selecting the next car
 ld a,(CarChosen)
 inc a
 ld hl,Cars
 cp (hl)
 jr c,PCPD_OK
 jr z,PCPD_OK
 ld a,1
PCPD_OK:
 ld (CarChosen),a
 ret

MenuDecCar:			; Selecting the previous car
 ld a,(CarChosen)
 dec a
 jr nz,PCPU_OK
 ld a,(Cars)
PCPU_OK:
 ld (CarChosen),a
 ret

Test1:
 .byte 10,30,9,"Bump (/):"
Test2:
 .byte 10,38,12,"Setback 8/9:"
Test3:
 .byte 10,46,10,"Angle 5/6:"
Test4:
 .byte 10,54,13,"Response 2/3:"

TestClear:
 .byte "                    "

ArrowUp:
 .byte %00000000,%10000100
 .byte %00100001,%11000000
 .byte %00000011,%11100000
 .byte %00000111,%01110010
 .byte %00001100,%10011000
 .byte %01010011,%11100100
 .byte %00000111,%01110000

 .byte %01000111,%01110000
 .byte %00010011,%11100100
 .byte %00001100,%10011000
 .byte %01000111,%01110010
 .byte %00000011,%11100000
 .byte %00100001,%11000000
 .byte %00000000,%10000100

ArrowDown:
 .byte %01000111,%01110000
 .byte %10010011,%11100100
 .byte %11001100,%10011000
 .byte %01010111,%01110010
 .byte %11100011,%11100000
 .byte %10111001,%11001000
 .byte %11110100,%10100010

ChooseTrkData:
 .byte %00000000,%00000000,%00000000,%00000000
 .byte %01110110,%11001110,%00111000,%11101111
 .byte %00000000,%11000011,%00001101,%10000000
 .byte %11000111,%11011011,%01101100,%11001110
 .byte %11000110,%11011011,%01101100,%01101100
 .byte %01110110,%11001110,%00111001,%11001111
 .byte %00000000,%00000000,%00000000,%00000000
 .byte %11111101,%11110011,%11100011,%10110011
 .byte %00000000,%00011000,%00110000,%00000011
 .byte %00110001,%10011011,%00110110,%00111110
 .byte %00110001,%10110011,%01110110,%00110011
 .byte %00110001,%10011011,%00110011,%10110011
 .byte %00000000,%00000000,%00000000,%00000000

;ChooseCarData:
; .byte %01111011,%11100111,%11000001,%00000100
; .byte %00000000,%00110000,%01100101,%01001110
; .byte %11000011,%00110110,%01100111,%11011111
; .byte %11000011,%01110110,%11000011,%10010101
; .byte %01111011,%00110110,%01100001,%00000100
; .byte %11011111,%00111101,%11100001,%10001100
; .byte %00000001,%10000000,%00110011,%00000110
; .byte %11011001,%10111011,%00110111,%11011111
; .byte %11011001,%10110011,%00110011,%00000110
; .byte %11011001,%10110001,%11100001,%10001100

MenuItem:			; Current menu item
 .byte 0

MenuItems:			; Number of menu items
 .byte 0

MenuPointer:			; Pointer to current menu jumptable
 .word 0

Menu_Main:
 .byte 4
 .word Practice
 .word Compete
 .word Credits
 .word Exit_With_Wait
 .byte 6
 .byte %11111001,%11110011,%11100011,%11011111,%10110011,%11011111
 .byte %00001100,%00011000,%00110000,%00000000,%00000000,%00000000
 .byte %11001101,%10011011,%00110110,%00000110,%00110110,%00011110
 .byte %11011001,%10110011,%01110110,%00000110,%00110110,%00011000
 .byte %11000001,%10011011,%00110011,%11000110,%00110011,%11011111
 .byte 6
 .byte %01111001,%11100111,%11100111,%11001111,%10111111,%01111100
 .byte %00000000,%00110000,%00110000,%01100000,%00000000,%00000000
 .byte %11000011,%00110110,%10110110,%01101111,%00001100,%01111000
 .byte %11000011,%00110110,%10110110,%11001100,%00001100,%01100000
 .byte %01111001,%11100110,%10110110,%00001111,%10001100,%01111100
 .byte 5
 .byte %01111011,%11100111,%11011111,%00110111,%11101111
 .byte %00000000,%00110000,%00000001,%10000000,%00000000
 .byte %11000011,%00110111,%10011001,%10110001,%10001110
 .byte %11000011,%01100110,%00011001,%10110001,%10000011
 .byte %01111011,%00110111,%11011111,%00110001,%10011110
 .byte 3
 .byte %11111001,%10011011,%01111110
 .byte %00001101,%10011000,%00000000
 .byte %11001101,%10011011,%00011000
 .byte %11001101,%10000011,%00011000
 .byte %01111100,%11111011,%00011000
